package de.jabc.cinco.meta.plugin.primeviewer.tmpl.file

import de.jabc.cinco.meta.core.event.hub.impl.CompositeContext
import de.jabc.cinco.meta.core.event.hub.impl.SimpleSubscriber
import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils
import de.jabc.cinco.meta.plugin.template.FileTemplate
import java.util.ArrayList
import mgl.ModelElement
import mgl.Node
import org.eclipse.core.resources.IFile
import org.eclipse.emf.common.util.TreeIterator
import org.eclipse.emf.common.util.URI
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl
import org.eclipse.jface.viewers.ITreeContentProvider
import org.eclipse.jface.viewers.Viewer

import static extension de.jabc.cinco.meta.core.utils.MGLUtil.getFqn

class ContentProviderTmpl extends FileTemplate {
	
	static extension GeneratorUtils = GeneratorUtils.instance
	
	val Node node
	val ModelElement primeModelElement
	val CharSequence primeTypeName
	var CharSequence _primeFileExtension
	
	new (Node primeNode) {
		this.node = primeNode
		this.primeModelElement = node.retrievePrimeReference.type as ModelElement
		this.primeTypeName = node.primeTypeName
	}
	
	override getTargetFileName() {
		'''«primeTypeName»ContentProvider.java'''
	}
	
	override template() '''
		package «package»;
		
		public class «primeTypeName»ContentProvider implements «ITreeContentProvider.name»{
			
			public static final String PRIMEVIEWER_REFRESH_IDENTIFIER = "primeviewer.refresh.«node.primeFileExtension.toString.replaceAll('''\.''', "_")».«primeModelElement.fqn.replaceAll('''\.''', "_")»";
			
			// Notified by «primeModelElement.packageName».<graph model name>DiagramEditor
			// (which is generated by de.jabc.cinco.meta.core.ge.style.generator.templates.DiagramEditorTmpl)
			private «SimpleSubscriber.name»<«CompositeContext.name»> primeviewerRefreshSubscriber;
			
			private «Viewer.name» viewer;
			
			public «primeTypeName»ContentProvider() {
				this.primeviewerRefreshSubscriber = new «SimpleSubscriber.name»<>(PRIMEVIEWER_REFRESH_IDENTIFIER, this::refresh);
				this.primeviewerRefreshSubscriber.subscribe();
			}
			
			public void refresh(«CompositeContext.name» context) {
				// Ignoring context
				if (viewer != null) {
					viewer.refresh();
				}
			}
			
			@Override
			public void dispose() {
				if (primeviewerRefreshSubscriber != null) {
					primeviewerRefreshSubscriber.unsubscribe();
				}
			}
			
			@Override
			public void inputChanged(«Viewer.name» viewer, «Object.name» oldInput, «Object.name» newInput) {
				this.viewer = viewer;
			}
			
			@Override
			public «Object.name»[] getElements(«Object.name» inputElement) {
				return null;
			}
			
			@Override
			public «Object.name»[] getChildren(«Object.name» parentElement) {
				try {
					if (parentElement instanceof «IFile.name») {
						«IFile.name» file = («IFile.name») parentElement;
						if (file.getName().endsWith("«node.primeFileExtension»")) {
							«URI.name» fileURI = «URI.name».createPlatformResourceURI(file.getFullPath().toString(), true);
							«EObject.name» prime = null;
							«Resource.name» resource = new «ResourceSetImpl.name»().getResource(fileURI, true);
							«ArrayList.name»<«EObject.name»> eObjList = new «ArrayList.name»<>();
							«TreeIterator.name»<«EObject.name»> x = resource.getAllContents();
							while (x.hasNext()) {
								«EObject.name» o = x.next();
								if («primeTypeName»ProviderHelper.isA«primeTypeName»(o)) {
									prime = o;
									eObjList.add(o);
								}
							}
							if (prime == null) {
								return null;
							}
							return eObjList.toArray();
						}
						return null;
					}
					return null;
				}
				catch (Exception e) {
					return null;
				}
			}
			
			@Override
			public «Object.name» getParent(«Object.name» element) {
				return null;
			}
			
			@Override
			public boolean hasChildren(«Object.name» element) {
				try {
					if (element instanceof «IFile.name») {
						«IFile.name» file = («IFile.name») element;
						if (file.getName().endsWith("«node.primeFileExtension»")) {
							«URI.name» fileURI = «URI.name».createPlatformResourceURI(file.getFullPath().toString(), true);
							«Resource.name» resource = new «ResourceSetImpl.name»().getResource(fileURI, true);	        
							return resource.getContents().size() >= 1;
						}
						return false;
					}
				}
				catch («Exception.name» e) {
					return false;
				}
				return false;
			}
		}
	'''
	
	def primeFileExtension(Node node) {
		if (_primeFileExtension === null) {
			_primeFileExtension = node
				?.anyPrimeReference
				?.annotations
				?.findFirst[name == "pvFileExtension"]
				?.value
				?.head
				?: primeTypeName
		}
		return _primeFileExtension
	}
	
}
