package info.scce.dime.graphql.api.api.gratext.scoping

import graphmodel.internal.InternalIdentifiableElement
import info.scce.dime.graphql.api.api.gratext.*

import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EReference
import org.eclipse.xtext.naming.QualifiedName
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider

import static extension org.eclipse.xtext.EcoreUtil2.getRootContainer
import static extension org.eclipse.xtext.scoping.Scopes.scopeFor

/**
 * This class contains custom scoping description.
 */
class APIGratextScopeProvider extends AbstractDeclarativeScopeProvider {
	
	override getScope(EObject context, EReference reference) {
		getScope(context, reference.name) ?: super.getScope(context, reference)
	}
	
	dispatch def IScope getScope(EObject element, String refName) {
		null
	}
	
	dispatch def IScope getScope(^GratextInternalControlFlow element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.graphql.api.api.internal.InternalStartSIB,
				info.scce.dime.graphql.api.api.internal.InternalProcessSIB,
				info.scce.dime.graphql.api.api.internal.InternalErrorSIB,
				info.scce.dime.graphql.api.api.internal.InternalAbstractBranch,
				info.scce.dime.graphql.api.api.internal.InternalBranch,
				info.scce.dime.graphql.api.api.internal.InternalEndSIB
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalComplexDirectDataFlow element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.graphql.api.api.internal.InternalComplexAPIoutput,
				info.scce.dime.graphql.api.api.internal.InternalComplexInputPort,
				info.scce.dime.graphql.api.api.internal.InternalComplexOutputPort,
				info.scce.dime.graphql.api.api.internal.InternalComplexAPIinput
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalPrimitiveDirectDataFlow element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.graphql.api.api.internal.InternalPrimitiveInputPort,
				info.scce.dime.graphql.api.api.internal.InternalPrimitiveAPIoutput,
				info.scce.dime.graphql.api.api.internal.InternalPrimitiveOutputPort,
				info.scce.dime.graphql.api.api.internal.InternalPrimitiveAPIinput
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalBranchConnector element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.graphql.api.api.internal.InternalProcessSIB,
				info.scce.dime.graphql.api.api.internal.InternalAbstractBranch,
				info.scce.dime.graphql.api.api.internal.InternalBranch
				 )
		}
	}
	def scopeForContents(EObject obj, Class<?>... types) {
		obj.rootContainer.contents
			.filter(anyTypeOf(types))
			.filter(InternalIdentifiableElement)
			.toScope
	}
	
	def getContents(EObject obj) {
		val Iterable<EObject> iterable = [obj.eAllContents]
		return iterable
	}
	
	def anyTypeOf(Class<?>... types) {
		[Object obj | types.stream.anyMatch[isInstance(obj)]]
	}
	
	def IScope toScope(Iterable<InternalIdentifiableElement> elements) {
		scopeFor(elements, [QualifiedName::create(id)], IScope.NULLSCOPE)
	}
}
