package info.scce.dime.graphql.api.api.gratext

import graphmodel.internal.InternalGraphModel

import de.jabc.cinco.meta.core.utils.registry.NonEmptyIdentityRegistry
import de.jabc.cinco.meta.plugin.gratext.runtime.resource.GratextResource

import info.scce.dime.graphql.api.api.gratext.generator.APIGratextTransformer

class APIGratextResource extends GratextResource {
	
	public static val transformers = new NonEmptyIdentityRegistry<InternalGraphModel,APIGratextTransformer> [
		new APIGratextTransformer
	]
	
	val lastTransformers = new NonEmptyIdentityRegistry<InternalGraphModel,APIGratextTransformer> [
		new APIGratextTransformer
	]

	override getTransformer(InternalGraphModel model) {
		transformers.get(model)
	}

	override getLastTransformer(InternalGraphModel model) {
		lastTransformers.get(model)
	}

	override removeTransformer(InternalGraphModel model) {
		lastTransformers.put(model, transformers.remove(model))
	}

	override isSortGratext() {
		false
	}
}
