/*-
 * #%L
 * CINCO
 * %%
 * Copyright (C) 2021 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package de.jabc.cinco.meta.core.ge.style.generator.templates

import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils
import de.jabc.cinco.meta.plugin.event.api.util.EventApiExtension
import de.jabc.cinco.meta.plugin.event.api.util.EventEnum
import java.util.Arrays
import mgl.GraphModel
import org.eclipse.core.resources.IContainer
import org.eclipse.core.resources.IProject
import org.eclipse.core.resources.IResource
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.core.runtime.CoreException
import org.eclipse.core.runtime.IPath
import org.eclipse.core.runtime.Path
import org.eclipse.jface.viewers.IStructuredSelection
import org.eclipse.jface.wizard.WizardPage
import org.eclipse.swt.SWT
import org.eclipse.swt.events.KeyEvent
import org.eclipse.swt.events.KeyListener
import org.eclipse.swt.events.SelectionEvent
import org.eclipse.swt.events.SelectionListener
import org.eclipse.swt.layout.GridData
import org.eclipse.swt.layout.GridLayout
import org.eclipse.swt.widgets.Button
import org.eclipse.swt.widgets.Composite
import org.eclipse.swt.widgets.DirectoryDialog
import org.eclipse.swt.widgets.Label
import org.eclipse.swt.widgets.Text

class NewDiagramWizardPageTmpl {
	
	extension GeneratorUtils = GeneratorUtils.instance
	extension EventApiExtension = new EventApiExtension
	
	/**
	 * Generates the {@link WizardPage} class for the {@link GraphModel}
	 * 
	 * @param The processed {@link graphmodel.GraphModel}
	 */
	def generateNewDiagramWizardPage(GraphModel gm) '''
		// Generated by «this.class.name»
		
		package «gm.packageName».wizard;
		
		public class «gm.fuName»DiagramWizardPage extends «WizardPage.name» {
			
			public static «String.name» FILE_EXTENSION = "«gm.fileExtension»";
			
			private «IContainer.name» container;
			private «Text.name» directoryText;
			private «Text.name» fileNameText;
			private «Button.name» browseButton;
			
			public «gm.fuName»DiagramWizardPage(«String.name» pageName) {
				super(pageName);
				setTitle("Create new «gm.fuName» diagram");
				setMessage("Choose a directory and a file name for the new «gm.fuName» diagram");
			}
			
			public «String.name» getDirectory() {
				return directoryText.getText();
			}
			
			private void setDirectory(«String.name» newValue) {
				directoryText.setText(newValue);
			}
			
			public «String.name» getFileName() {
				return fileNameText.getText();
			}
			
			@Override
			public void createControl(«Composite.name» parent) {
				«Composite.name» composite = new «Composite.name»(parent, «SWT.name».NONE);
				«GridLayout.name» layout = new «GridLayout.name»(3, false);
				composite.setLayout(layout);
				
				«Label.name» directoryLabel = new «Label.name»(composite, «SWT.name».NONE);
				directoryLabel.setLayoutData(new «GridData.name»(«SWT.name».LEFT, «SWT.name».CENTER, false, false));
				directoryLabel.setText("Di&rectory: ");
				
				directoryText = new «Text.name»(composite, «SWT.name».BORDER);
				directoryText.setLayoutData(new «GridData.name»(«SWT.name».FILL, «SWT.name».CENTER, true, false));
				directoryText.setEditable(false);
				
				browseButton = new «Button.name»(composite, «SWT.name».PUSH);
				browseButton.setText("Brows&e...");
				browseButton.setLayoutData(new «GridData.name»(«SWT.name».CENTER, «SWT.name».CENTER, false, false));
				
				«Label.name» fileNameLabel = new «Label.name»(composite, «SWT.name».NONE);
				fileNameLabel.setLayoutData(new «GridData.name»(«SWT.name».LEFT, «SWT.name».CENTER, false, false));
				fileNameLabel.setText("Fi&le name: ");
				
				fileNameText = new «Text.name»(composite, «SWT.name».BORDER);
				fileNameText.setLayoutData(new «GridData.name»(«SWT.name».FILL, «SWT.name».CENTER, true, false));
				fileNameText.setText("");
				
				«Text.name» extensionText = new «Text.name»(composite, «SWT.name».BORDER);
				extensionText.setLayoutData(new «GridData.name»(«SWT.name».FILL, «SWT.name».CENTER, false, false));
				extensionText.setText("." + FILE_EXTENSION);
				extensionText.setEditable(false);
				
				directoryText.addKeyListener(textKeyListener);
				fileNameText.addKeyListener(textKeyListener);
				browseButton.addSelectionListener(buttonListener);
				
				«IStructuredSelection.name» selection = null; 
				if (getWizard() instanceof «gm.packageName».wizard.«gm.fuName»DiagramWizard) {
					selection = ((«gm.packageName».wizard.«gm.fuName»DiagramWizard) getWizard()).getSelection();
				}
				
				if (selection != null && selection.getFirstElement() instanceof «IContainer.name») {
					container = («IContainer.name») selection.getFirstElement();
					directoryText.setText(container.getLocation().toOSString());
				}
				
				setPageComplete(false);
				setControl(composite);
			}
			
			private void dialogChanged() {
				«String.name» directoryError = validateDirectory();
				if (directoryError != null) {
					updateStatus(directoryError);
					return;
				}
				«String.name» fileNameError = validateFileName();
				if (fileNameError != null) {
					updateStatus(fileNameError);
					return;
				}
				«IF gm.isEventEnabled»
					«String.name» canCreate«gm.fuName»Error = validateCanCreate«gm.fuName»();
					if (canCreate«gm.fuName»Error != null) {
						updateStatus(canCreate«gm.fuName»Error);
						return;
					}
				«ENDIF»
				«String.name» fileExistsError = validateFileExists();
				if (fileExistsError != null) {
					updateStatus(fileExistsError);
					return;
				}
				updateStatus(null);
			}
			
			private «String.name» validateDirectory() {
				«String.name» directory = getDirectory();
				if (directory.isEmpty()) {
					return "Select existing directory";
				}
				«IProject.name»[] projects = «ResourcesPlugin.name».getWorkspace().getRoot().getProjects();
				boolean isProject = «Arrays.name».stream(projects).anyMatch((«IProject.name» project) -> {
					«IPath.name» projectPath = project.getLocation();
					«IPath.name» directoryPath = new «Path.name»(directory);
					return projectPath.isPrefixOf(directoryPath);
				});
				if (!isProject) {
					return "The directory must be inside a project form your workspace";
				}
				return null;
			}
			
			private «String.name» validateFileName() {
				«String.name» fileName = getFileName();
				if (fileName.isEmpty()) {
					return "Enter a file name";
				}
				return null;
			}
			«IF gm.isEventEnabled»
				
				private «String.name» validateCanCreate«gm.fuName»() {
					«IPath.name» filePath = new «Path.name»(getDirectory()).append(getFileName()).addFileExtension(FILE_EXTENSION);
					«EventEnum.CAN_CREATE_GRAPH_MODEL.getNotifyCallJava('''canCreate«gm.fuName»Error''', gm, '''«gm.fqBeanName».class''', 'getFileName()', 'filePath')»
					return canCreate«gm.fuName»Error;
				}
			«ENDIF»
			
			private «String.name» validateFileExists() {
				«String.name» fileName = getFileName() + "." + FILE_EXTENSION;
				try {
					if (container == null) {
						return null;
					}
					for («IResource.name» res: container.members()) {
						if (res.getName().equals(fileName)) {
							return "File already exists";
						}
					}
				}
				catch («CoreException.name» e) {
					e.printStackTrace();
				}
				return null;
			}
			
			private void updateStatus(«String.name» errorMessage) {
				setErrorMessage(errorMessage);
				if (getContainer().getCurrentPage() != null) {
					getWizard().getContainer().updateMessage();
					getWizard().getContainer().updateButtons();
				}
				setPageComplete(errorMessage == null);
			}
			
			private «SelectionListener.name» buttonListener = new «SelectionListener.name»() {
				
				@Override
				public void widgetSelected(«SelectionEvent.name» e) {
					«DirectoryDialog.name» dialog = new «DirectoryDialog.name»(getShell());
					dialog.setText("Select a directory");
					«String.name» rootLocation = «ResourcesPlugin.name».getWorkspace().getRoot().getLocation().toOSString();
					dialog.setFilterPath(rootLocation);
					«String.name» directory = dialog.open();
					if (directory != null) {
						setDirectory(directory);
					}
					dialogChanged();
				}
				
				@Override
				public void widgetDefaultSelected(«SelectionEvent.name» e) {
					// Intentionally left blank
				}
				
			};
			
			private «KeyListener.name» textKeyListener = new «KeyListener.name»() {
				
				@Override
				public void keyReleased(«KeyEvent.name» e) {
					dialogChanged();
				}
				
				@Override
				public void keyPressed(«KeyEvent.name» e) {
					// Intentionally left blank
				}
				
			};
			
		}
	'''
	
}
