/*-
 * #%L
 * CINCO
 * %%
 * Copyright (C) 2021 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package de.jabc.cinco.meta.core.ge.style.generator.templates

import de.jabc.cinco.meta.core.event.util.EventCoreExtension
import de.jabc.cinco.meta.core.ge.style.generator.runtime.editor.CincoDiagramEditor
import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.Highlighter
import de.jabc.cinco.meta.core.utils.CincoUtil
import de.jabc.cinco.meta.core.utils.MGLUtil
import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils
import mgl.GraphModel
import mgl.UserDefinedType
import org.eclipse.core.runtime.IProgressMonitor
import org.eclipse.emf.common.util.TreeIterator
import org.eclipse.emf.ecore.EObject
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm
import org.eclipse.graphiti.mm.pictograms.Shape
import org.eclipse.graphiti.ui.editor.DiagramEditor

class DiagramEditorTmpl {
	
	extension GeneratorUtils = GeneratorUtils.instance
	
	/**
	 * Generates the {@link DiagramEditor} for the {@link GraphModel}
	 * 
	 * @param gm The processed {@link GraphModel}
	 */
	 // TODO: @Dawid check if GraphModel/MGLModel is used correctly
	def generateDiagramEditor(GraphModel gm) {
		val highlightContainmentEnabled = !CincoUtil.isHighlightContainmentDisabled(gm)
		val preSave  = gm.booleanWriteMethodCallPreSave
		val postSave = gm.booleanWriteMethodCallPostSave
		val primeviewer = allMGLs.flatMap[graphModels].flatMap[annotations].exists[name == "primeviewer"]
		'''
		// Generated by «this.class.name»
		package «gm.packageName»;
		
		public class «gm.fuName»DiagramEditor extends «CincoDiagramEditor.name» {
			«IF primeviewer»
				
				public static final String PRIMEVIEWER_REFRESH_IDENTIFIER = "primeviewer.refresh.«gm.fileExtension.replaceAll('''\.''', "_")».*";
				
				private final «EventCoreExtension.name» eventCoreExtension = new «EventCoreExtension.name»();
			«ENDIF»
			
			@Override
			public void initializeGraphicalViewer() {
				super.initializeGraphicalViewer();
				«EObject.name» bo = getDiagramTypeProvider().getDiagram().getLink().getBusinessObjects().get(0);
				«TreeIterator.name»<«EObject.name»> eContents = bo.eAllContents();
				eContents.forEachRemaining(it -> {	
					«FOR type : MGLUtil.types(gm).filter(UserDefinedType)»
						if (it instanceof «type.fqInternalBeanName») {
							if (it.eAdapters().stream().filter(a -> a instanceof «type.packageNameEContentAdapter».«type.fuName»EContentAdapter).count() == 0) {
								it.eAdapters().add(new «type.packageNameEContentAdapter».«type.fuName»EContentAdapter());
							}
						}
					«ENDFOR»
				});
				«IF highlightContainmentEnabled»
					«Highlighter.name».INSTANCE.get().listenToDiagramDrag(this, getGraphicalControl());
				«ENDIF»
			}
			«IF highlightContainmentEnabled»
				
				@Override
				public void onPaletteViewerCreated(org.eclipse.gef.ui.palette.PaletteViewer pViewer) {
					«Highlighter.name».INSTANCE.get().listenToPaletteDrag(pViewer);
				}
			«ENDIF»
			«IF preSave»
				
				@Override
				public void preSave() {
					«gm.fqBeanName» graph = getGraph();
					if (graph != null) graph.preSave();
				}
			«ENDIF»
			«IF postSave || primeviewer»
				
				@Override
				public void postSave() {
					«IF postSave»
						«gm.fqBeanName» graph = getGraph();
						if (graph != null) graph.postSave();
					«ENDIF»
					«IF primeviewer»
						// Notifies <main project name>.primeviewer.«gm.name.toLowerCase».<node name>ContentProvider
						// (which is generated by de.jabc.cinco.meta.plugin.primeviewer.tmpl.file.ContentProviderTmpl)
						eventCoreExtension.notify(PRIMEVIEWER_REFRESH_IDENTIFIER);
					«ENDIF»
				}
			«ENDIF»
			«IF preSave || postSave || primeviewer»
				
				@Override
				public void doSave(«IProgressMonitor.name» monitor) {
					«IF preSave»
						preSave();
					«ENDIF»
					super.doSave(monitor);
					«IF postSave || primeviewer»
						postSave();
					«ENDIF»
				}
			«ENDIF»
			«IF postSave || primeviewer»
				
				@Override
				public void handleSaved() {
					super.handleSaved();
					postSave();
				}
			«ENDIF»
			
			protected «ResizeShapeContext.name» createContext(«Shape.name» child) {
				«GraphicsAlgorithm.name» ga = child.getGraphicsAlgorithm();
				«ResizeShapeContext.name» context = new «ResizeShapeContext.name»(child);
				context.setSize(ga.getWidth(), ga.getHeight());
				context.setLocation(ga.getX(), ga.getY());
				return context;
			}
			«IF preSave || postSave»
				
				private «gm.fqBeanName» getGraph() {
					«EObject.name» obj = getDiagramTypeProvider().getDiagram().eResource().getContents().get(1);
					if (obj instanceof «gm.fqInternalBeanName») {
						«gm.fqInternalBeanName» internalGraph = («gm.fqInternalBeanName») obj;
						return («gm.fqBeanName») internalGraph.getElement();
					}
					return null;
				}
			«ENDIF»
			
		}
		'''
	}
	
}
