/*-
 * #%L
 * CINCO
 * %%
 * Copyright (C) 2021 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package de.jabc.cinco.meta.core.ge.style.generator.api.templates

import de.jabc.cinco.meta.core.ge.style.generator.runtime.api.CModelElement
import de.jabc.cinco.meta.core.ge.style.generator.runtime.api.CNode
import de.jabc.cinco.meta.core.ge.style.generator.runtime.features.CincoGraphitiCopier
import de.jabc.cinco.meta.core.ge.style.generator.runtime.features.CincoResizeFeature
import de.jabc.cinco.meta.core.ge.style.generator.runtime.provider.CincoFeatureProvider
import de.jabc.cinco.meta.core.ge.style.generator.templates.util.APIUtils
import de.jabc.cinco.meta.core.utils.MGLUtil
import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils
import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension
import graphmodel.Edge
import graphmodel.IdentifiableElement
import graphmodel.ModelElementContainer
import graphmodel.internal.InternalEdge
import graphmodel.internal.InternalModelElement
import graphmodel.internal.InternalNode
import java.util.ArrayList
import java.util.List
import mgl.MGLModel
import mgl.Node
import mgl.NodeContainer
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.util.EcoreUtil
import org.eclipse.graphiti.features.IFeatureProvider
import org.eclipse.graphiti.features.IMoveShapeFeature
import org.eclipse.graphiti.features.context.impl.AddContext
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext
import org.eclipse.graphiti.features.context.impl.CreateContext
import org.eclipse.graphiti.features.context.impl.MoveShapeContext
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext
import org.eclipse.graphiti.features.impl.DefaultMoveShapeFeature
import org.eclipse.graphiti.mm.pictograms.AnchorContainer
import org.eclipse.graphiti.mm.pictograms.ContainerShape
import org.eclipse.graphiti.mm.pictograms.Diagram
import org.eclipse.graphiti.mm.pictograms.PictogramElement
import org.eclipse.graphiti.mm.pictograms.Shape
import org.eclipse.graphiti.ui.services.GraphitiUi

import static extension de.jabc.cinco.meta.core.utils.MGLUtil.*
import mgl.ReferencedModelElement

class CNodeTmpl extends APIUtils {

	extension CModelElementTmpl = new CModelElementTmpl
	extension GeneratorUtils = GeneratorUtils.instance


	def doGenerateImpl(Node me)'''
		package «me.mglModel.packageNameAPI»;
		
		import de.jabc.cinco.meta.core.ge.style.generator.runtime.api.CGraphModel;
		«FOR e : MGLUtil::getOutgoingConnectingEdges(me as Node).filter[!isIsAbstract]»
			«IF !MGLUtil::equalMGLModels(e.eContainer as MGLModel, me.eContainer as MGLModel)»
				import «e.fqCName»;
			«ENDIF»
		«ENDFOR»
		
		public «IF me.isIsAbstract»abstract «ENDIF»class «me.fuCName» extends «me.fqBeanImplName» implements «CNode.name»
			«IF !me.allSuperTypes.empty», «FOR st: me.allSuperTypes SEPARATOR ","» «st.fqBeanName» «ENDFOR» «ENDIF» {
			
			private «PictogramElement.name» pe;
			
			«me.constructor»
			
			public «me.pictogramElementReturnType» getPictogramElement() {
				if (pe == null) {
					Object root = null;
					try {
						root = getRootElement();
					} catch (NullPointerException ignore) {}
					if (root != null) {
						«FOR gm : me.mglModel.graphModels.filter[!isAbstract]»
							if (root instanceof «gm.fqCName»)
								this.pe = ((«gm.fqCName») root).fetchPictogramElement(this);
						«ENDFOR»
					}
				}
				return («me.pictogramElementReturnType») this.pe;
			}
			
			public void setPictogramElement(«PictogramElement.name» pe) {
				this.pe = pe;
			}
			
			«FOR e : MGLUtil::getOutgoingConnectingEdges(me as Node).filter[!isIsAbstract].removeDuplicateModelElements»
				«FOR target : (e as mgl.Edge).possibleTargets»
					
					@Override
					public «e.fqBeanName» new«e.fuName»(«target.fqBeanName» target, «String.name» id) {
						«e.fqBeanName» obj = new«e.fuName»(target);
						obj.transact("SetId",() -> {«EcoreUtil.name».setID(obj, id);});
						return obj;
					}
					
					@Override
					public «e.fqBeanName» new«e.fuName»(«target.fqBeanName» target) {
						if (!(target instanceof «target.fqBeanName»))
							throw new «RuntimeException.name»(
								«String.name».format("Parameter \"target\" of wrong type: Expected type: %s, given type %s", 
								«target.fqBeanName».class, target.getClass()));
						«CreateConnectionContext.name» cc = new «CreateConnectionContext.name»();
						cc.setSourcePictogramElement(getPictogramElement());
						cc.setTargetPictogramElement(((«CModelElement.name») target).getPictogramElement());
						
						cc.setSourceAnchor(this.getAnchor());
						cc.setTargetAnchor(((«CNode.name»)target).getAnchor());
						
						«IFeatureProvider.name» fp = getFeatureProvider();
						«e.fqCreateFeatureName» cf = new «e.fqCreateFeatureName»(fp);
						if (fp instanceof «CincoFeatureProvider.name») {
							Object[] retVal = ((«CincoFeatureProvider.name») fp).executeFeature(cf, cc);
							if (retVal[0] == null) return null;
							«e.fuCName» tmp = («e.fuCName») retVal[0];
							return tmp;
						}
						return null;
					}
					
				«ENDFOR»
			«ENDFOR»
			
			«FOR cont : MGLUtil::getPossibleContainers(me as Node)»
				@Override
				public void s_moveTo(«cont.fqBeanName» target, int x, int y) {
					if (!canMoveTo(target)) return;
					«MoveShapeContext.name» mc = new «MoveShapeContext.name»((«Shape.name») getPictogramElement());
					mc.setTargetContainer((«ContainerShape.name») ((«CModelElement.name») target).getPictogramElement());
					mc.setSourceContainer((«ContainerShape.name») ((«CModelElement.name») this.getContainer()).getPictogramElement());
					
					mc.setX(x);
					mc.setY(y);
					
					«IFeatureProvider.name» fp = getFeatureProvider();
					«IMoveShapeFeature.name» mf = new «DefaultMoveShapeFeature.name»(fp); 
					if (fp instanceof «CincoFeatureProvider.name») {
						((«CincoFeatureProvider.name») fp).executeFeature(mf, mc);
					}
				}
			«ENDFOR»
			
			@Override
			public void s_moveTo(«ModelElementContainer.name» target, int x, int y) {
				if (!canMoveTo(target)) return;
				«MoveShapeContext.name» mc = new «MoveShapeContext.name»((«Shape.name») getPictogramElement());
				mc.setTargetContainer((«ContainerShape.name») ((«CModelElement.name») target).getPictogramElement());
				mc.setSourceContainer((«ContainerShape.name») ((«CModelElement.name») this.getContainer()).getPictogramElement());
				
				mc.setX(x);
				mc.setY(y);
				
				«IFeatureProvider.name» fp = getFeatureProvider();
				«IMoveShapeFeature.name» mf = new «DefaultMoveShapeFeature.name»(fp); 
				if (fp instanceof «CincoFeatureProvider.name») {
					((«CincoFeatureProvider.name») fp).executeFeature(mf, mc);
				}
			}
			
			
			@Override
			public void resize(int width, int height) {
				resize(width, height, getX(), getY());
			}
			
			@Override
			public void resize(int width, int height, int x, int y) {
				«ResizeShapeContext.name» rc = new «ResizeShapeContext.name»(getPictogramElement());
				«CincoResizeFeature.name» rf = new «CincoResizeFeature.name»(getFeatureProvider());
				
				rc.setSize(width, height);	
				rc.setLocation(x, y);
				rf.activateApiCall(true);		
				
				«IFeatureProvider.name» fp = getFeatureProvider();
				if (rf.canResizeShape(rc))
					if (fp instanceof «CincoFeatureProvider.name»)
						((«CincoFeatureProvider.name») fp).executeFeature(rf, rc);
				
				super.resize(width, height, x, y);
			}
			
			@Override
			public void move(int x, int y) {
				«MoveShapeContext.name» mc = new «MoveShapeContext.name»((«Shape.name») this.pe);
				
				mc.setTargetContainer((«ContainerShape.name») this.getPictogramElement().eContainer());
				mc.setSourceContainer((«ContainerShape.name») this.getPictogramElement().eContainer());
				
				mc.setX(x);
				mc.setY(y);
				
				«IFeatureProvider.name» fp = getFeatureProvider();
				«IMoveShapeFeature.name» mf = new «DefaultMoveShapeFeature.name»(fp);
				if (fp instanceof «CincoFeatureProvider.name») {
					((«CincoFeatureProvider.name») fp).executeFeature(mf, mc);
					super.move(x, y);
				}
			}
			
			private «IFeatureProvider.name» getFeatureProvider() {
				CGraphModel model = (CGraphModel) getRootElement();
				return (model != null) ? model.getFeatureProvider() : null;
			}
			
			@Override
			public «Diagram.name» getDiagram() {
				«Diagram.name» d = new «WorkbenchExtension.name»().getDiagram(this);
				if (d == null) {
					d = «GraphitiUi.name».getPeService().getDiagramForPictogramElement(this.pe);
				}
				if (d == null) {
					Object root = null;
					try {
						root = getRootElement();
					} catch(NullPointerException ignore) {}
					if (root != null) 
						d = ((«me.fqCName») root).getDiagram();
				}
				return d;
			}
			
			private «ContainerShape.name» getPictogramElement(«IdentifiableElement.name» target) {
				«FOR st : me.allSuperTypes»
					if («st.instanceofCheck("target")»)
						return ((«st.fqCName») target).getPictogramElement();
				«ENDFOR»
				
				return null;
			}
			
			«IF me instanceof NodeContainer»
				«FOR containableNode : MGLUtil::getContainableNodes(me).filter[!isIsAbstract && !isPrime]»
					@Override
					public «containableNode.fqBeanName» new«containableNode.fuName»(«String.name» id, int x, int y, int width, int height) {
						«containableNode.fqBeanName» obj = new«containableNode.fuName»(x, y, width, height);
						obj.transact("SetId",() -> {«EcoreUtil.name».setID(obj, id);});
						return obj;
					}
					
					@Override
					public «containableNode.fqBeanName» new«containableNode.fuName»(int x, int y, int width, int height) {
						«CreateContext.name» cc = new «CreateContext.name»();
						cc.setLocation(10, 10);
						cc.setTargetContainer((«ContainerShape.name») getPictogramElement());
						
						cc.setLocation(x,y);
						cc.setSize(width,height);
						
						«IFeatureProvider.name» fp = getFeatureProvider();
						«containableNode.fqCreateFeatureName» cf = new «containableNode.fqCreateFeatureName»(fp);
						if (fp instanceof «CincoFeatureProvider.name») {
							Object[] retVal = ((«CincoFeatureProvider.name») fp).executeFeature(cf, cc);
							if (retVal[0] == null) return null;
							«containableNode.packageNameAPI».«containableNode.fuCName» tmp = («containableNode.packageNameAPI».«containableNode.fuCName») retVal[0];
							tmp.setPictogramElement((«containableNode.pictogramElementReturnType») retVal[1]);
							return tmp;
						}
						return null;
					}
				«ENDFOR»
				
				«FOR n : MGLUtil::getContainableNodes(me).filter[isPrime]»
					@Override
					public «n.fqBeanName» new«n.fuName»(«EObject.name» «n.retrievePrimeReference.name», int x, int y) {
						return new«n.fuName»(«n.retrievePrimeReference.name»,x,y,-1,-1);
					}
					
					@Override
					public «n.fqBeanName» new«n.fuName»(«EObject.name» «n.retrievePrimeReference.name», int x, int y, int width, int height) {
						«AddContext.name» ac = new «AddContext.name»();
						ac.setLocation(10, 10);
						ac.setTargetContainer((«ContainerShape.name») getPictogramElement());
						
						ac.setLocation(x,y);
						ac.setSize(width,height);
						
						«IF n.retrievePrimeReference instanceof ReferencedModelElement»
						ac.setNewObject(((«IdentifiableElement.name») «n.retrievePrimeReference.name»).getInternalElement_());
						«ELSE»
						ac.setNewObject(«n.retrievePrimeReference.name»);
						«ENDIF»
						
						«IFeatureProvider.name» fp = getFeatureProvider();
						«n.fqPrimeAddFeatureName» af = new «n.fqPrimeAddFeatureName»(fp);
						if (fp instanceof «CincoFeatureProvider.name») {
							Object[] retVal = ((«CincoFeatureProvider.name») fp).executeFeature(af, ac);
							if (retVal[0] == null) return null;
							«n.fuCName» tmp = («n.fuCName») retVal[0];
							tmp.setPictogramElement((«n.pictogramElementReturnType») retVal[1]);
							return tmp;
						}
						return null;
					}
				«ENDFOR»
			«ENDIF»
			
			/**
			* This method will create a copy of the calling element.*ATTENTION* The cloned element's id will be the
			* same as the one of the caller!
			*
			*/
			@Override
			public <T extends «graphmodel.Node.name»> T clone(«ModelElementContainer.name» targetContainer) {
				«CincoGraphitiCopier.name» copier = new «CincoGraphitiCopier.name»();
				«Shape.name» clonePE = copier.copy(this.getPictogramElement());
				«graphmodel.Node.name» bo = («graphmodel.Node.name») clonePE.getLink().getBusinessObjects().get(0);
				((«CNode.name») bo).setPictogramElement(clonePE);
				«EcoreUtil.name».setID(bo.getInternalElement_(), getInternalElement_().getId());
				«EcoreUtil.name».setID(bo, getId());
				«ContainerShape.name» parentContainerShape = null;
				if (targetContainer instanceof «CModelElement.name») {
					parentContainerShape = ((«CModelElement.name») targetContainer).getPictogramElement();
					parentContainerShape.getChildren().add((«Shape.name») clonePE);
					targetContainer.getInternalContainerElement().getModelElements().add(bo.getInternalElement_());
					((«CModelElement.name») targetContainer).addLinksToDiagram(clonePE);
				}
				if (bo instanceof «ModelElementContainer.name») {
					«List.name»<«InternalModelElement.name»> remove = new «ArrayList.name»<>();
					remove.addAll(((«ModelElementContainer.name») bo).getInternalContainerElement().getModelElements());
					remove.stream().filter(me -> me instanceof «InternalEdge.name»).forEach(e -> ((«Edge.name»)e.getElement()).delete());
					remove.stream().filter(me -> me instanceof «InternalNode.name»).forEach(e -> ((«graphmodel.Node.name»)e.getElement()).delete());
				}
				
				return (T) bo;
			}
			
			@Override
			public «me.fqBeanName» copy(«ModelElementContainer.name» targetContainer) {
				«me.fqBeanName» copy = («me.fqBeanName») this.clone(targetContainer);
				«EcoreUtil.name».setID(copy, «EcoreUtil.name».generateUUID());
				return copy;
			}
			
			@Override
			public void setX(final int x) {
				super.setX(x);
				transact("Set X", () -> getPictogramElement().getGraphicsAlgorithm().setX(x));
			}
			
			@Override
			public void setY(int y) {
				super.setY(y);
				transact("Set Y", () -> getPictogramElement().getGraphicsAlgorithm().setY(y));
			}
			
			@Override
			public void setWidth(final int width) {
				super.setWidth(width);
				transact("Set Width", () -> getPictogramElement().getGraphicsAlgorithm().setWidth(width));
			}
			
			@Override
			public void setHeight(int height) {
				super.setHeight(height);
				transact("Set Height", () -> getPictogramElement().getGraphicsAlgorithm().setHeight(height));
			}
			
			@Override
			public int getLayer() {
				return ((«ContainerShape.name») pe).getContainer().getChildren().indexOf(pe);
			}
			
			«me.updateContent»
			
			«me.deleteContent»
			
			«me.getHighlightContent»
		}
	'''
		
		
	def doGenerateView(Node me)'''
		package «me.packageNameAPI»;
		
		public class «me.fuCViewName» extends «me.fqBeanViewName» {
			
		}

	'''
} 
