package info.scce.dime.util;

import java.util.Date;

public class FileReference {

    private final DomainFile delegate;

    public FileReference(final DomainFile delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Not allowed to wrap null, use null directly");
        }
        this.delegate = delegate;
    }

    public DomainFile getDelegate() {
        return this.delegate;
    }

    public long getDywaId() {
        return this.delegate.getDywaId();
    }

    public String getContentType() {
        return this.delegate.getContentType();
    }

    public String getFileName() {
        return this.delegate.getFileName();
    }

    public Date getCreatedAt() {
        return this.delegate.getCreatedAt();
    }
}

