package info.scce.dime.auth;

import junit.framework.TestCase;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.BufferedReader;
import java.security.Principal;
import java.util.*;


public class CSRFGuardTest extends TestCase {

    private final Cookie[] cookiesValid = new Cookie[1];
    private final Cookie[] cookiesEmpty = new Cookie[0];
    private final Cookie[] cookiesCookieEmpty = new Cookie[1];
    private final Cookie[] cookiesCookieNull = new Cookie[1];
    private final Map<String, String> headersValid = new HashMap<>();
    private final Map<String, String> headersValueDifferent = new HashMap<>();
    private final Map<String, String> headersEmpty = new HashMap<>();
    private final Map<String, String> headersHeaderEmpty = new HashMap<>();
    private final Map<String, String> headersHeaderNull = new HashMap<>();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.cookiesValid[0] = new Cookie(CSRFCookie.CSRF_COOKIE_NAME, "foo");
        this.cookiesCookieEmpty[0] = new Cookie(CSRFCookie.CSRF_COOKIE_NAME, "");
        this.cookiesCookieNull[0] = new Cookie(CSRFCookie.CSRF_COOKIE_NAME, null);
        this.headersValid.put(CSRFGuard.CSRF_TOKEN_NAME, "foo");
        this.headersHeaderEmpty.put(CSRFGuard.CSRF_TOKEN_NAME, "");
        this.headersHeaderNull.put(CSRFGuard.CSRF_TOKEN_NAME, null);
        this.headersValueDifferent.put(CSRFGuard.CSRF_TOKEN_NAME, "bar");
    }

    public void testIsProtectedCookieAndHeaderEqual() {
        //then
        assertFalse(
                CSRFGuard
                        //when
                        .create(
                                //given
                                new FakeHttpServletRequest(
                                        cookiesValid,
                                        headersValid
                                )
                        ).isNotProtected()
        );
    }

    public void testIsProtectedCookieAndHeaderNotEqual() {
        //then
        assertTrue(
                CSRFGuard
                        //when
                        .create(
                                //given
                                new FakeHttpServletRequest(
                                        cookiesValid,
                                        headersValueDifferent
                                )
                        ).isNotProtected()
        );
    }

    public void testIsProtectedEmptyCookieArray() {
        //then
        assertTrue(
                CSRFGuard
                        //when
                        .create(
                                //given
                                new FakeHttpServletRequest(
                                        cookiesEmpty,
                                        headersValid
                                )
                        ).isNotProtected()
        );
    }

    public void testIsProtectedEmptyHeaders() {
        //then
        assertTrue(
                CSRFGuard
                        //when
                        .create(
                                //given
                                new FakeHttpServletRequest(
                                        cookiesValid,
                                        headersEmpty
                                )
                        ).isNotProtected()
        );
    }

    public void testIsProtectedEmptyCookie() {
        //then
        assertTrue(
                CSRFGuard
                        //when
                        .create(
                                //given
                                new FakeHttpServletRequest(
                                        cookiesCookieEmpty,
                                        headersValid
                                )
                        ).isNotProtected()
        );
    }

    public void testIsProtectedEmptyHeader() {
        //then
        assertTrue(
                CSRFGuard
                        //when
                        .create(
                                //given
                                new FakeHttpServletRequest(
                                        cookiesValid,
                                        headersHeaderEmpty
                                )
                        ).isNotProtected()
        );
    }

    public void testIsProtectedNullCookie() {
        //then
        assertTrue(
                CSRFGuard
                        //when
                        .create(
                                //given
                                new FakeHttpServletRequest(
                                        cookiesCookieNull,
                                        headersEmpty
                                )
                        ).isNotProtected()
        );
    }

    public void testIsProtectedNullHeader() {
        //then
        assertTrue(
                CSRFGuard
                        //when
                        .create(
                                //given
                                new FakeHttpServletRequest(
                                        cookiesValid,
                                        headersHeaderNull
                                )
                        ).isNotProtected()
        );
    }

    public void testIsProtectedCookiesNull() {
        //then
        assertTrue(
                CSRFGuard
                        //when
                        .create(
                                //given
                                new FakeHttpServletRequest(
                                        null,
                                        headersHeaderNull
                                )
                        ).isNotProtected()
        );
    }
}

class FakeHttpServletRequest implements HttpServletRequest {

    private final Cookie[] cookies;
    private final Map<String, String> headers;

    FakeHttpServletRequest(Cookie[] cookies, Map<String, String> headers) {
        this.cookies = cookies;
        this.headers = headers;
    }

    @Override
    public String getAuthType() {
        return null;
    }

    @Override
    public Cookie[] getCookies() {
        return this.cookies;
    }

    @Override
    public long getDateHeader(String s) {
        return 0;
    }

    @Override
    public String getHeader(String s) {
        return this.headers.get(s);
    }

    @Override
    public Enumeration<String> getHeaders(String s) {
        return null;
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return null;
    }

    @Override
    public int getIntHeader(String s) {
        return 0;
    }

    @Override
    public String getMethod() {
        return null;
    }

    @Override
    public String getPathInfo() {
        return null;
    }

    @Override
    public String getPathTranslated() {
        return null;
    }

    @Override
    public String getContextPath() {
        return null;
    }

    @Override
    public String getQueryString() {
        return null;
    }

    @Override
    public String getRemoteUser() {
        return null;
    }

    @Override
    public boolean isUserInRole(String s) {
        return false;
    }

    @Override
    public Principal getUserPrincipal() {
        return null;
    }

    @Override
    public String getRequestedSessionId() {
        return null;
    }

    @Override
    public String getRequestURI() {
        return null;
    }

    @Override
    public StringBuffer getRequestURL() {
        return null;
    }

    @Override
    public String getServletPath() {
        return null;
    }

    @Override
    public HttpSession getSession(boolean b) {
        return null;
    }

    @Override
    public HttpSession getSession() {
        return null;
    }

    @Override
    public String changeSessionId() {
        return null;
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        return false;
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    @Override
    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    @Override
    public boolean authenticate(HttpServletResponse httpServletResponse) {
        return false;
    }

    @Override
    public void login(String s, String s1) {

    }

    @Override
    public void logout() {

    }

    @Override
    public Collection<Part> getParts() {
        return null;
    }

    @Override
    public Part getPart(String s) {
        return null;
    }

    @Override
    public <T extends HttpUpgradeHandler> T upgrade(Class<T> aClass) {
        return null;
    }

    @Override
    public Object getAttribute(String s) {
        return null;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return null;
    }

    @Override
    public String getCharacterEncoding() {
        return null;
    }

    @Override
    public void setCharacterEncoding(String s) {

    }

    @Override
    public int getContentLength() {
        return 0;
    }

    @Override
    public long getContentLengthLong() {
        return 0;
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public ServletInputStream getInputStream() {
        return null;
    }

    @Override
    public String getParameter(String s) {
        return null;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return null;
    }

    @Override
    public String[] getParameterValues(String s) {
        return new String[0];
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return null;
    }

    @Override
    public String getProtocol() {
        return null;
    }

    @Override
    public String getScheme() {
        return null;
    }

    @Override
    public String getServerName() {
        return null;
    }

    @Override
    public int getServerPort() {
        return 0;
    }

    @Override
    public BufferedReader getReader() {
        return null;
    }

    @Override
    public String getRemoteAddr() {
        return null;
    }

    @Override
    public String getRemoteHost() {
        return null;
    }

    @Override
    public void setAttribute(String s, Object o) {

    }

    @Override
    public void removeAttribute(String s) {

    }

    @Override
    public Locale getLocale() {
        return null;
    }

    @Override
    public Enumeration<Locale> getLocales() {
        return null;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String s) {
        return null;
    }

    @Override
    public String getRealPath(String s) {
        return null;
    }

    @Override
    public int getRemotePort() {
        return 0;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public String getLocalAddr() {
        return null;
    }

    @Override
    public int getLocalPort() {
        return 0;
    }

    @Override
    public ServletContext getServletContext() {
        return null;
    }

    @Override
    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    @Override
    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    @Override
    public boolean isAsyncStarted() {
        return false;
    }

    @Override
    public boolean isAsyncSupported() {
        return false;
    }

    @Override
    public AsyncContext getAsyncContext() {
        return null;
    }

    @Override
    public DispatcherType getDispatcherType() {
        return null;
    }
}