/// Defines the interface to validate string values.
///
/// It is used by guards and validators. Guards make sure encapsulated
/// validators will be protected of being called by wrong types and values.
/// Validators perform the actual validation of the passed value.
abstract class AbstractValidatedString {
  Map<String, dynamic> validated(String value);
}
