/*-
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.generator.scheme

import de.ls5.dywa.entities.object.DBField
import de.ls5.dywa.entities.object.DBType
import de.ls5.dywa.entities.property.PropertyType
import info.scce.dime.data.data.ExtensionAttribute
import java.util.Collection
import java.util.List
import java.util.Map

/**
 * Generated entity classes
 */
class ModelGenerator {
	val String packageName
	val Map<DBType, List<DBType>> inheritance
	val Map<String, List<ExtensionAttribute>> extensionAttributes
	val extension ModelExtensions modelExtensions
	val extension RenderExtensions renderExtensions;

	new(String packageName, Map<DBType, List<DBType>> iMap, Map<String, List<ExtensionAttribute>> extensionAttributes) {
		this(packageName, iMap, extensionAttributes, new ModelExtensions(packageName, iMap))
	}

	new(String packageName, Map<DBType, List<DBType>> iMap, Map<String, List<ExtensionAttribute>> extensionAttributes, ModelExtensions modelExtensions) {
    		this.packageName = packageName;
    		this.inheritance = iMap;
    		this.extensionAttributes = extensionAttributes;
    		this.modelExtensions = modelExtensions;
    		this.renderExtensions = new RenderExtensions(packageName);
    	}


	def String generateInterface(DBType type) '''
		/* generated by «this.getClass().getName()» */
		package «type.renderFullPackageName("entity")»;
		«IF type.isAbstractType»//Abstract Type«ENDIF»
		@de.ls5.dywa.annotations.IdRef(id = «type.getId»L)
		@de.ls5.dywa.annotations.OriginalName(name = "«type.getName»")
		@de.ls5.dywa.annotations.ShortDescription(description = "«type.getShortDescription»")
		@de.ls5.dywa.annotations.LongDescription(description = "«type.getLongDescription»")
		public interface «type.renderClassName» extends «type.renderInterfaceExtensions» {
			«FOR field : type.getFields»
				«IF !field.isDeleted»
				«field.renderGetterAndSetterSignature»
				
				«ENDIF»
			«ENDFOR»

			// EXTENSION ATTRIBUTES
			«type.renderExtensionAttributeDeclaration(this.extensionAttributes)»

			// CUSTOM LIST IMPL
			«type.renderCustomListImpl»

			default «type.renderClassName» casted(){
				return this;
			}
		}
	'''

	def String generateIdentifiable() '''
		package «packageName».util;
				
		public interface Identifiable {

			long getDywaId();

			long getDywaVersion();
			void setDywaVersion(final long version);

			java.lang.String getDywaName();
			void setDywaName(final java.lang.String name);
		}
	'''

	/**
	 * Generates model for a given DBType
	 */
	def String generateModel(DBType type, Collection<DBField> implicitFields, Collection<DBType> additionalTypes) '''
		/* generated by «this.getClass().getName()» */
		package «type.renderFullPackageName("entity")»;
		«IF type.isAbstractType»//Abstract Type«ENDIF»
		@javax.persistence.Entity
		@javax.persistence.Cacheable
		@org.hibernate.annotations.Cache(usage = org.hibernate.annotations.CacheConcurrencyStrategy.READ_WRITE)
		@javax.persistence.Table(name = "«type.renderTableName»", indexes={@javax.persistence.Index(columnList="meta_inheritance")})
		@de.ls5.dywa.annotations.IdRef(id = «type.getId()»L)
		public class «type.renderFullClassName» implements «type.renderClassName» {
			@javax.persistence.Id
			@javax.persistence.GeneratedValue(strategy = javax.persistence.GenerationType.SEQUENCE)
			@javax.persistence.Column(name = "meta_id")
			private long id_;
			
			/* DYWA METADATA START */
			@javax.persistence.Column(name = "meta_name")
			private java.lang.String name_;
			
			@javax.persistence.Column(name = "meta_version")
			private long version_;
			
			@javax.persistence.Column(name = "meta_inheritance")
			private boolean inheritance_ = false;

			«IF  type.getTransitiveSubTypes.filter[!isDeleted].filter[!equals(type)].size > 0»

			// Save information of inheritor
			@org.hibernate.annotations.Any(metaColumn = @javax.persistence.Column(name = "meta_inheritor_type"))
			@org.hibernate.annotations.AnyMetaDef(
			idType = "long", metaType = "string",
			metaValues = {
				«FOR inheritor : type.getTransitiveSubTypes.filter[!isEnumerable].filter[!isDeleted].filter[!equals(type)] SEPARATOR ', '»
						@org.hibernate.annotations.MetaValue(targetEntity=«inheritor.renderFullCanonicalClassName("entity")».class, value="«inheritor.cincoId»")
				«ENDFOR»
					}
			)
			@javax.persistence.JoinColumn(name = "meta_inheritor")
			private «type.renderClassName» inheritor_;
			«ENDIF»

			«IF !type.fields.filter[isBidirectional].isEmpty»
			@javax.persistence.Transient
			private boolean bidirectionalDirtyFlag;
			«ENDIF»
			/* DYWA METADATA END */

			
			/* MAIN ATTRIBUTES START */
			«FOR field : type.getFields»
				«IF !field.isDeleted»
				«field.renderAttribute»
				
				«ENDIF»
			«ENDFOR»
			/* MAIN ATTRIBUTES END */
			
			/* IMPLICIT ATTRIBUTES START */
			«FOR field : implicitFields»
			«field.renderAttribute(type)»
			
			«ENDFOR»
			/* IMPLICIT ATTRIBUTES END */
			
			/* INHERITED MODELS START */
			«FOR superType : inheritance.get(type).filter[!abstractType]»
				@javax.persistence.OneToOne(optional = true, cascade = javax.persistence.CascadeType.ALL)
				@javax.persistence.JoinColumn(name = "«NameGenerator.prepareIdentifierName("inherited",superType.cincoId,superType.name)»")
				private «superType.renderFullCanonicalClassName("entity")» inherited«superType.renderClassName»_;
			«ENDFOR»
			/* INHERITED MODELS END */

			/* INHERITED ABSTRACT MODELS START */
			«FOR superType : inheritance.get(type).filter[abstractType]»
				@javax.persistence.OneToOne(optional = true, cascade = javax.persistence.CascadeType.ALL)
				@javax.persistence.JoinColumn(name = "«NameGenerator.prepareIdentifierName("abstractinherited",superType.cincoId,superType.name)»")
				private «superType.renderFullCanonicalClassName("entity")» abstractInherited«superType.renderClassName»_;
			«ENDFOR»
			/* INHERITED ABSTRACT MODELS END */
			
			/* ADDITIONAL INHERITED MODELS START */
			«FOR superType : additionalTypes»
			@javax.persistence.OneToOne(optional = true, cascade = javax.persistence.CascadeType.ALL)
			@javax.persistence.JoinColumn(name = "NameGenerator.prepareIdentifierName("inherited",superType.cincoId,superType.name)»")
			private «superType.renderFullCanonicalClassName("entity")» inherited«superType.renderClassName»_;
			
			«ENDFOR»
			/* ADDITIONAL INHERITED MODELS END */
			
			// Constructors
			«IF type.isAbstractType»private«ELSE»public«ENDIF» «type.renderFullClassName»() {
			«FOR superType : inheritance.get(type).filter[!abstractType]»
				inherited«superType.renderClassName»_ = new «superType.renderFullCanonicalClassName("entity")»(true,this);
			«ENDFOR»
			«FOR superType : inheritance.get(type).filter[abstractType]»
				abstractInherited«superType.renderClassName»_ = new «superType.renderFullCanonicalClassName("entity")»(true,this);
			«ENDFOR»
			}


			«IF  type.getTransitiveSubTypes.filter[!isDeleted].filter[!equals(type)].size > 0»
			// Internal Constructor
			public «type.renderFullClassName»(boolean inheritance_, «type.renderClassName» inheritor_ ) {
			«FOR superType : inheritance.get(type).filter[!abstractType]»
				inherited«superType.renderClassName»_ = new «superType.renderFullCanonicalClassName("entity")»(true,inheritor_);
			«ENDFOR»
			«FOR superType : inheritance.get(type).filter[abstractType]»
				abstractInherited«superType.renderClassName»_ = new «superType.renderFullCanonicalClassName("entity")»(true,inheritor_);
			«ENDFOR»
				this.inheritance_ = inheritance_;
				this.inheritor_ = inheritor_;
			}
			«ENDIF»

			// EXTENSION ATTRIBUTES
			«type.renderExtensionAttributeImplementation(this.extensionAttributes, false)»

			public long getId_() {
				return this.id_;
			}

			public void setId_(final long id) {
				this.id_ = id;
			}

			@java.lang.Override
			public java.lang.String getDywaName() {
				return this.name_;
			}

			@java.lang.Override
			public void setDywaName(final java.lang.String name) {
				this.name_ = name;
			}

			// return existing id on runtime
			@java.lang.Override
			public long getDywaId() {
				return this.id_;
			}

			@java.lang.Override
			public long getDywaVersion() {
				return this.version_;
			}

			@java.lang.Override
			public void setDywaVersion(final long version) {
				this.version_ = version;
			}
			
			«FOR field : type.getFields»
				«IF !field.isDeleted»
				«field.renderGetterAndSetter(type)»
				
				«ENDIF»									
			«ENDFOR»
			«FOR field : type.getActiveSuperFields(false)»
				«IF inheritance.get(type).stream.anyMatch[t | t.getFullActiveFields.contains(field)]»
				«field.renderInheritedGetterAndSetter(type)»
				
				«ELSEIF additionalTypes.stream.anyMatch[t | t.getFullActiveFields.contains(field)]»
				«field.renderAdditionalGetterAndSetter(additionalTypes.stream.filter[t | t.getFullActiveFields.contains(field)].findAny.get)»
				
				«ELSEIF type.getFields.stream.noneMatch[f | f.id === field.id]»
				«field.renderGetterAndSetter(type)»
				
				«ENDIF»
			«ENDFOR»
			@java.lang.Override
			public String toString() {
				return "«type.getName»[id: " + this.id_ + ", name: " + this.name_ + "]";
			}
			«IF  type.getTransitiveSubTypes.filter[!isDeleted].filter[!equals(type)].size > 0»
			
			@Override
			@javax.persistence.Transient
			public «type.renderClassName» casted() {
				return this.inheritance_ ? inheritor_.casted() : «type.renderClassName».super.casted();
			}
			«ENDIF»
		}
		
	'''

	/**
	 * Generates model for a given DBType
	 */
	def String generateSearchObject(DBType type, Collection<DBField> implicitFields, Collection<DBType> additionalTypes) '''
		/* generated by «this.getClass().getName()» */
		package «type.renderFullPackageName("entity")»;

		public class «type.renderClassName»Search implements «type.renderClassName» {
			private static final com.google.common.collect.BiMap<Long, String> dywaIdToJpqlAttr = com.google.common.collect.HashBiMap.create();
			private final java.util.Map<String, Object> attributeMap = new java.util.HashMap<>();
			private final java.util.Map<String, java.util.List> listAttributeMap = new java.util.HashMap<>();
			private java.lang.String searchObjectName;

			/**XXX: remove after benchmark is done*/
			private final boolean fromSuper;
			
			static {
				java.lang.Class<?> targetClass = «type.renderFullClassName».class;
				
				// Scan attributes directly declared as fields
				for (java.lang.reflect.Field field : targetClass.getDeclaredFields()) {
					if (field.isAnnotationPresent(de.ls5.dywa.annotations.IdRef.class)) {
						dywaIdToJpqlAttr.put(field.getDeclaredAnnotation(de.ls5.dywa.annotations.IdRef.class).id(), field.getName());
					}
				}
				
				// Scan delegated attributes
				for (java.lang.reflect.Method method : targetClass.getDeclaredMethods()) {
					if (method.isAnnotationPresent(info.scce.dime.util.Delegation.class)) {
						info.scce.dime.util.Delegation annotation = method.getDeclaredAnnotation(info.scce.dime.util.Delegation.class);
						java.lang.StringBuilder builder = new java.lang.StringBuilder(annotation.attributeName());
						Long fieldId = method.getDeclaredAnnotation(de.ls5.dywa.annotations.IdRef.class).id();
						boolean inheritanceAvailable;
						do {
							java.lang.Class<?> currentClass = annotation.attributeClass();
							try {
								java.lang.reflect.Method targetMethod = currentClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
								if (inheritanceAvailable = targetMethod.isAnnotationPresent(info.scce.dime.util.Delegation.class)) {
									annotation = targetMethod.getDeclaredAnnotation(info.scce.dime.util.Delegation.class);
									builder.append('.').append(annotation.attributeName());
								} else { // declared in field: end of iterative search
									for (java.lang.reflect.Field field2 : currentClass.getDeclaredFields()) {
										if (field2.isAnnotationPresent(de.ls5.dywa.annotations.IdRef.class) && field2.getDeclaredAnnotation(de.ls5.dywa.annotations.IdRef.class).id() == fieldId) {
											builder.append('.').append(field2.getName());
											break;
										}
									}
								}
							} catch (java.lang.NoSuchMethodException e) {
								e.printStackTrace();
								break;
							}
						} while(inheritanceAvailable);
						
						dywaIdToJpqlAttr.put(method.getDeclaredAnnotation(de.ls5.dywa.annotations.IdRef.class).id(), builder.toString());
					}
					else if(targetClass.isInterface()){
						dywaIdToJpqlAttr.putIfAbsent(method.getDeclaredAnnotation(de.ls5.dywa.annotations.IdRef.class).id(), method.getDeclaredAnnotation(de.ls5.dywa.annotations.OriginalName.class).name());
					}
				}
			}
			«FOR superType: type.getSuperTypes»
			«IF !superType.isDeleted»
			public «type.renderClassName»Search(«superType.renderCanonicalClassName("entity")»Search superSearch){
				superSearch.queryAttributes().forEach((key, val) -> {
					this.attributeMap.put(dywaIdToJpqlAttr.get(superSearch.getMappedIdFromKey(key)), val);
				});
				superSearch.queryListAttributes().forEach((key, val) -> {
					this.listAttributeMap.put(dywaIdToJpqlAttr.get(superSearch.getMappedIdFromKey(key)), val);
				});
				this.fromSuper = true;
				this.searchObjectName = superSearch.getSearchObjectName_();
			}
			«ENDIF»
			«ENDFOR»
			public «type.renderClassName»Search() {
				this((java.lang.String  )null);
			}
			
			public «type.renderClassName»Search(java.lang.String name) {
				this.searchObjectName = name;
				this.fromSuper = false;
			}

			public final boolean isFromSuper(){
				return this.fromSuper;
			}
			
			public java.lang.String getSearchObjectName_() {
				return this.searchObjectName;
			}
			
			public void setSearchObjectName_(java.lang.String name) {
				this.searchObjectName = name;
			}

			public java.lang.String getDywaName() {
				return (java.lang.String) this.attributeMap.get("name_");
			}

			public void setDywaName(java.lang.String name) {
				this.attributeMap.put("name_", name);
			}

			public long getDywaId() {
				return (long) this.attributeMap.get("dywaId_");
			}

			public long getDywaVersion() {
				return (long) this.attributeMap.get("version");
			}

			public void setDywaVersion(long version) {
				this.attributeMap.put("version_", version);
			}

			«FOR field : type.getFullActiveFields»
				«var methSfx = field.renderMethodSuffix»
				«var nameSfx = field.renderMethodPropertyName(true)»
				«var nameNoSfx = field.renderMethodPropertyName(false)»
				@java.lang.Override
				public «nameNoSfx» get«methSfx»() {
					«IF field.getPropertyType.equals(PropertyType.FILE)»
					return new info.scce.dime.util.FileReference((info.scce.dime.util.DomainFile) this.attributeMap.get(dywaIdToJpqlAttr.get(«field.getId»L)));
					«ELSEIF field.getPropertyType.equals(PropertyType.FILE_LIST)»
					java.util.List objs = this.listAttributeMap.get(dywaIdToJpqlAttr.get(«field.getId»L));
					if (objs != null) {
						«nameNoSfx» result = new java.util.ArrayList<>(objs.size());
						for (Object df : objs) {
							result.add(new info.scce.dime.util.FileReference((info.scce.dime.util.DomainFile) df));
						}
						return result;
					}
					return null;
					«ELSEIF field.getPropertyType.equals(PropertyType.OBJECT) && field.getTypeConstraint.isEnumerable»
					return «field.getTypeConstraint.renderCanonicalClassName("entity")».forId(((«field.getTypeConstraint.renderFullCanonicalClassName("entity")») this.attributeMap.get(dywaIdToJpqlAttr.get(«field.getId»L))).getDywaId());
					«ELSEIF field.getPropertyType.equals(PropertyType.OBJECT_LIST) && field.getTypeConstraint.isEnumerable»
					return («nameNoSfx») ((«nameSfx») this.listAttributeMap.get(dywaIdToJpqlAttr.get(«field.getId»L))).stream().map(o -> «field.getTypeConstraint.renderCanonicalClassName("entity")».forId(o.getDywaId())).collect(java.util.stream.Collectors.toList());
					«ELSEIF !field.getPropertyType.list»
					return («nameNoSfx») this.attributeMap.get(dywaIdToJpqlAttr.get(«field.getId»L));
					«ELSE»
					return («nameNoSfx») this.listAttributeMap.get(dywaIdToJpqlAttr.get(«field.getId»L));
					«ENDIF»
				}
				«IF field.overriddenField === null»
				«field.renderGet(field)»
				«ELSE»
				 «field.overriddenField.renderGet(field)»
				«ENDIF»
			«ENDFOR»

			// EXTENSION ATTRIBUTES
			«type.renderExtensionAttributeImplementation(this.extensionAttributes, true)»

			public java.util.Map<String, Object> queryAttributes() {
				return this.attributeMap;
			}
			
			public java.util.Map<String, java.util.List> queryListAttributes() {
				return this.listAttributeMap;
			}
			public Long getMappedIdFromKey(String key){
				 return dywaIdToJpqlAttr.inverse().get(key);
			}
		}
	'''
	
	def CharSequence renderGet(DBField field, DBField origin) '''
		«IF field !== null»
		public void «field.renderSetter»(«field.renderFieldTypeName» object) {
				«IF origin.isDisabled»
				 	throw new java.lang.IllegalStateException("Field is disabled");
				«ELSE»
				
					«IF field.isList»
					for(«field.renderInnerFieldTypeName» p: object){
						 if (! (p instanceof «origin.renderInnerFieldTypeName»)) {
								throw new java.lang.RuntimeException("Wrong type");
					}
					}
					«ELSE»
					if (! (object instanceof «origin.renderInnerFieldTypeName»)) {
								throw new java.lang.RuntimeException("Wrong type");
					}
					«ENDIF»
				«IF field.getPropertyType.equals(PropertyType.FILE)»
					this.attributeMap.put(dywaIdToJpqlAttr.get(«field.getId»L), object != null ? object.getDelegate() : null);
					«ELSEIF field.getPropertyType.equals(PropertyType.FILE_LIST)»
					this.listAttributeMap.put(dywaIdToJpqlAttr.get(«field.getId»L), object != null ? object.stream().map(f -> f.getDelegate()).collect(java.util.stream.Collectors.toList()) : null);
					«ELSEIF field.getPropertyType.equals(PropertyType.OBJECT) && field.getTypeConstraint.isEnumerable»
					this.attributeMap.put(dywaIdToJpqlAttr.get(«field.getId»L), object != null ? object.getEntityAs(«field.getTypeConstraint.renderFullClassName».class)/*1*/ : null);
					«ELSEIF field.getPropertyType.equals(PropertyType.OBJECT_LIST) && field.getTypeConstraint.isEnumerable»
					this.listAttributeMap.put(dywaIdToJpqlAttr.get(«field.getId»L), object != null ? object.stream().map(o -> o.getEntityAs(«field.renderInnerFieldTypeName»Entity.class)/*2*/).collect(java.util.stream.Collectors.toList()) : null);
					«ELSEIF !field.getPropertyType.list»
					this.attributeMap.put(dywaIdToJpqlAttr.get(«field.getId»L), object);
					«ELSE»
					this.listAttributeMap.put(dywaIdToJpqlAttr.get(«field.getId»L), object);
					«ENDIF»
					«ENDIF»
		}
		«renderGet(field.overriddenField, origin)»
		«ENDIF»
	'''
	private def renderCustomListImpl(DBType type) '''
		static class CustomListImpl<T extends info.scce.dime.util.Identifiable> extends java.util.AbstractList<«type.renderFQTypeName»> {

			private final java.util.List<«type.renderFQTypeName»> delegate;
			private final BiDirectionalHelper<T> bidirectionalHelper;
			private boolean bidirectionalDirtyFlag;

			public CustomListImpl(final java.util.List<«type.renderFQTypeName»> delegate) {
				this(delegate, null);
			}

			public CustomListImpl(final java.util.List<«type.renderFQTypeName»> delegate, final BiDirectionalHelper<T> bidirectionalHelper) {
				this.delegate = delegate;
				this.bidirectionalHelper = bidirectionalHelper;
			}

			@java.lang.Override
			public int size() {
				return this.delegate.size();
			}

			@java.lang.Override
			public «type.renderFQTypeName» get(int index) {
					return this.delegate.get(index);
			}

			@java.lang.Override
			public «type.renderFQTypeName» set(int index, «type.renderFQTypeName» element) {

				final «type.renderFQTypeName» replaced = this.delegate.set(index, element);

				if (element.equals(replaced)) {
					return element;
				}

				if (this.bidirectionalHelper != null) {
					this.bidirectionalHelper.clearReference(element);
					this.bidirectionalHelper.setReference(replaced);
				}

				return replaced;
			}

			@java.lang.Override
			public void add(int index, «type.renderFQTypeName» element) {

				if (!this.bidirectionalDirtyFlag) {

					this.bidirectionalDirtyFlag = true;

					this.delegate.add(index, element);

					if (this.bidirectionalHelper != null) {
						bidirectionalHelper.setReference(element);
					}

					this.bidirectionalDirtyFlag = false;
				}
			}

			@java.lang.Override
			public «type.renderFQTypeName» remove(int index) {

				if (!this.bidirectionalDirtyFlag) {

					this.bidirectionalDirtyFlag = true;
					final «type.renderFQTypeName» result = this.delegate.remove(index);

					if (this.bidirectionalHelper != null) {
						this.bidirectionalHelper.clearReference(result);
					}

					this.bidirectionalDirtyFlag = false;
					return result;
				}

				return null;
			}
		}

		static class BiDirectionalHelper<T extends info.scce.dime.util.Identifiable> {

			final java.util.function.BiConsumer<«type.renderFQTypeName», T> setter;
			final java.util.function.Function<«type.renderFQTypeName», java.util.List<T>> getter;
			final T owner;

			public BiDirectionalHelper(
					java.util.function.BiConsumer<«type.renderFQTypeName», T> setter,
					T owner) {

				this.setter = setter;
				this.getter = null;
				this.owner = owner;
			}

			public BiDirectionalHelper(
					java.util.function.Function<«type.renderFQTypeName», java.util.List<T>> getter,
					T owner) {

				this.setter = null;
				this.getter = getter;
				this.owner = owner;
			}

			public void setReference(final «type.renderFQTypeName» p) {

				// list mode
				if (this.getter != null) {
					getter.apply(p).add(owner);
				}
				// single mode
				else {
					setter.accept(p, owner);
				}
			}

			public void clearReference(final «type.renderFQTypeName» p) {

				// list mode
				if (this.getter != null) {
					getter.apply(p).remove(owner);
				}
				// single mode
				else {
					setter.accept(p, null);
				}
			}
		}
	'''
}
