/*-
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.generator.rest

import info.scce.dime.dad.dad.SystemUser
import info.scce.dime.data.data.ConcreteType
import info.scce.dime.data.data.Type
import info.scce.dime.data.data.UserType
import info.scce.dime.generator.dad.DataPreprocessing
import info.scce.dime.generator.dad.GenerationContext
import info.scce.dime.generator.gui.rest.DyWASelectiveDartGenerator
import info.scce.dime.generator.gui.rest.model.ComplexTypeView
import info.scce.dime.generator.gui.rest.model.GUICompoundView
import info.scce.dime.generator.process.BackendProcessGeneratorUtil
import java.nio.file.Path
import java.util.Collections
import java.util.List
import java.util.Map
import java.util.Optional
import java.util.Set

import static extension info.scce.dime.generator.rest.DyWAAbstractGenerator.*
import static extension info.scce.dime.generator.util.JavaIdentifierUtils.*

class SelectiveUserGenerator extends BackendProcessGeneratorUtil {
	
	var GenerationContext genctx
	
	def generate(GenerationContext genctx, Path targetDir) {
		this.genctx = genctx
		val systemUser = genctx.dad.systemUsers.head?.systemUser
		val viewMap = genctx.compoundViews.map[compounds].flatten.filter(ComplexTypeView).fetchTypeViewsDeeply.groupBy[type.originalType]
		
		val packageName = "de.ls5.dywa.generated"	
		val content = generate(systemUser, genctx.userTypes, viewMap, packageName)
		
		val package = packageName + ".rest.user."
		val fileName = "CurrentUserController.java"
		val target = targetDir.resolve("app-business/target/generated-sources")
		DyWAAbstractGenerator.generate(content.toString, package, fileName, target, 0)
	}
	
	private def generate(UserType subject, Set<ConcreteType> userTypes, Map<Type, List<ComplexTypeView>> viewMapping, String packageName) '''
		// generated by «class.name»
		package «packageName».rest.user;
		
		@javax.transaction.Transactional
		@javax.ws.rs.Path("/user/current")
		public class CurrentUserController {
			
			«IF subject != null»
				@javax.inject.Inject
				private «subject.controllerTypeName» subjectController;

				@javax.inject.Inject
				private info.scce.dime.rest.ObjectCache objectCache;
				
				«FOR u : userTypes»
					«val views = viewMapping.getOrDefault(u, Collections.emptyList())»
					«val viewGroups = views.groupBy[it | genctx.selectiveCache.getRepresentative(it)]»
					«FOR viewGroup : viewGroups.entrySet»
						«val rep = viewGroup.key»
						«val tvs= viewGroup.value»
						@javax.ws.rs.GET
						@javax.ws.rs.Path("«u.name.escapeJava»/«IF tvs.size > 1»{a:«ENDIF»" +
							«tvs.join('"', '|" +\n"', '" +\n')[it | DyWASelectiveDartGenerator.getSelectiveNameJava(it)]»
							"«IF tvs.size > 1»}«ENDIF»/private")
						@javax.ws.rs.Produces(javax.ws.rs.core.MediaType.APPLICATION_JSON)
						public «generateInnerBasicTOName(rep, packageName)» get«DyWASelectiveDartGenerator.getSelectiveNameJava(rep)»() {
							final «subject.typeName» subject = subjectController.read((Long)org.apache.shiro.SecurityUtils.getSubject().getPrincipal());

							for (final «subject.concreteUserType.typeName» concreteUser: subject.get«subject.nameOfUserAssocAccessor»()) {
								if («u.typeName».class.isInstance(concreteUser)) {
									final «u.typeName» origUser = («u.typeName») concreteUser;
									final Object switchedToUser = origUser.get«DataPreprocessing.SWITCHED_TO_ATTR»();
									«u.typeName» currentUser = origUser;
									if («u.typeName».class.isInstance(switchedToUser)) {
										currentUser = («u.typeName») switchedToUser;
									} else if (switchedToUser != null) {
										throw new IllegalStateException("Type of switched user '" + switchedToUser.getClass() + "' does not match expected type of current user '" + «u.typeName».class + "'");
									}
									«rep.renderCacheLookup("currentUser", "result")»

									return result;
								}
							}
							throw new IllegalStateException("Did not find concrete user of type '" + «u.typeName».class + "'");
						}
					«ENDFOR»
				«ENDFOR»
				
				public <T> T getCurrentUser(final Class<T> userType) {
					final «subject.typeName» subject = subjectController.read((Long)org.apache.shiro.SecurityUtils.getSubject().getPrincipal());

					for (final «subject.concreteUserType.typeName» concreteUser: subject.get«subject.nameOfUserAssocAccessor»()) {
						if (userType.isAssignableFrom(concreteUser.getClass())) {
							return (T)concreteUser;
						}
					}
					throw new IllegalStateException("Did not find concrete user of type '" + userType.getSimpleName() + "'");
				}
			«ENDIF»
		}
	'''
}
