/*-
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.generator.rest

import info.scce.dime.data.data.AbstractType
import info.scce.dime.data.data.EnumType
import info.scce.dime.data.data.PrimitiveType
import info.scce.dime.data.data.Type
import info.scce.dime.generator.dad.GenerationContext
import info.scce.dime.generator.gui.rest.DyWASelectiveDartGenerator
import info.scce.dime.generator.gui.rest.model.ComplexFieldView
import info.scce.dime.generator.gui.rest.model.ComplexTypeView
import info.scce.dime.generator.gui.rest.model.FieldView
import java.nio.file.Path
import java.util.Collections

import static info.scce.dime.generator.util.DyWAExtension.*

import static extension info.scce.dime.generator.gui.data.SelectiveExtension.*
import static extension info.scce.dime.generator.gui.rest.DyWASelectiveDartGenerator.*
import static extension info.scce.dime.generator.util.JavaIdentifierUtils.*

class SelectiveControllerGenerator extends DyWAAbstractGenerator {
	
	var SelectiveCache selectiveCache
	
	def generate(GenerationContext genctx, Path outlet) {
		selectiveCache = genctx.selectiveCache
		val targetDir = outlet.resolve("app-business/target/generated-sources")
		
		val cviews = genctx.collectComplexTypeViews;
		val uniqueCTVs = cviews.map[it | selectiveCache.getRepresentative(it)].toSet
		
		val toOriginalTypeMap = uniqueCTVs.groupBy[DyWASelectiveDartGenerator.dataModelType(data).originalType];
		genctx.usedDatas.flatMap[types].map[originalType].toSet.forEach[t |
			debug("generate for type: " + t?.name + " -> " + t)
			generate(t, toOriginalTypeMap.getOrDefault(t, Collections.emptyList), dywaPkg, targetDir)
		]
	}
	
	def generate(Type type, Iterable<ComplexTypeView> tvs, String packageName, Path targetDir) {
		val content = generate(type, tvs)
		val package = packageName + ".rest.controller."
		val fileName = type.RESTControllerSimpleName + ".java"
		DyWAAbstractGenerator.generate(content.toString, package, fileName, targetDir, 0)
	}
	
	private def generate(Type type, Iterable<ComplexTypeView> views) '''
		«val typeName = type.RESTTOName»
		«val blankSelective = type.buildBlankTypeView»
		// generated by «class.name»
		package «dywaPkg».rest.controller;
		
		@javax.transaction.Transactional
		@javax.enterprise.context.RequestScoped
		public class «type.RESTControllerSimpleName» {
			
			@javax.inject.Inject
			private info.scce.dime.rest.ObjectCache objectCache;
			@javax.inject.Inject
			private info.scce.dime.util.DomainFileController DomainFileController;
			
			«val displayedTypes = views.flatMap[displayedFields].filter(ComplexFieldView).map[field.originalAttribute.dataModelType]»
			«val referencedTypes = type.inheritedAttributes.filter[isComplex].map[it.originalAttribute.dataModelType]»
			«val types = (#[type.originalType] + displayedTypes + referencedTypes).toSet»
			
			«FOR datatype : types»
				@javax.inject.Inject
				private «datatype.RESTControllerName» «datatype.RESTControllerSimpleName»;
				@javax.inject.Inject
				private «datatype.controllerTypeName» «datatype.controllerSimpleName»;
			«ENDFOR»
			
			«IF !(type instanceof EnumType) && !(type instanceof AbstractType)»
				public long create(final java.lang.String name) {
					final «type.dyWATypeName» obj = this.«type.name.escapeJava»Controller.create(name);
					return obj.getDywaId();
				}
			«ENDIF»
			
			«FOR view : views»
				public «generateInnerBasicTOName(view, dywaPkg)» read_«DyWASelectiveDartGenerator.getSelectiveNameJava(view)»(final long id) {
					
					final «generateInnerDywaTOName(view, dywaPkg)» obj = this.«DyWASelectiveDartGenerator.dataModelType(view.data).name.escapeJava»Controller.read(id);
					
					if (obj == null) {
						return null;
					}
					
					«view.renderCacheLookup("obj", "result")»
					
					return result;
				}
				
				public «generateInnerBasicTOName(view, dywaPkg)» readTransient_«DyWASelectiveDartGenerator.getSelectiveNameJava(view)»(final «typeName» obj) {
					
					final «generateInnerBasicTOName(view, dywaPkg)» result;
					
					if (this.objectCache.containsSelective(obj, "«view.getSelectiveNameJava»")) {
						return obj;
					}
					else {
						result = obj;
						this.objectCache.putSelective(obj, "«view.getSelectiveNameJava»");
					}
					
					// Update references to persistent objects
					«FOR field: view.displayedFields.filter(ComplexFieldView)»
						{
							«val needRuntimeCheck = view.needRuntimeCheck(field)»
							«val ctv = field.view as ComplexTypeView»
							«val rep = selectiveCache.getRepresentative(ctv)»
							«IF needRuntimeCheck»
								«val destType = view.renderDeclaringRestType(field)»
								if (obj instanceof «destType» && result instanceof «destType») {
									final «destType» effectiveObj = («destType») obj;
									final «destType» effectiveResult = («destType») result;
							«ELSE»
								{
									final «typeName» effectiveObj = obj;
									final «typeName» effectiveResult = result;
							«ENDIF»
							if (effectiveObj.is«field.field.nameOfAccessor»Set()) {
								final «field.generateBasicTOName(dywaPkg)» existing = effectiveObj.get«field.field.nameOfAccessor»();
								«field.generateBasicTOName(dywaPkg)» newValue;
								
								«IF field.isList»
									newValue = new java.util.ArrayList<>(existing.size());
									«field.renderReadTransientList("existing", "newValue")»
								«ELSE»
									if (existing.getDywaId() > 0) {
										// read_«DyWASelectiveDartGenerator.getSelectiveNameJava(ctv)»
										newValue = this.«DyWASelectiveDartGenerator.dataModelType(field.view.data).name.escapeJava»REST.read_«DyWASelectiveDartGenerator.getSelectiveNameJava(rep)»(existing.getDywaId());
									}
									else {
										// readTransient_«DyWASelectiveDartGenerator.getSelectiveNameJava(ctv)»
										newValue = this.«DyWASelectiveDartGenerator.dataModelType(field.view.data).name.escapeJava»REST.readTransient_«DyWASelectiveDartGenerator.getSelectiveNameJava(rep)»(existing);
									}
								«ENDIF»
								
								effectiveResult.set«field.field.nameOfAccessor»(newValue);
								}
							}
						}
					«ENDFOR»
					
					return result;
				}
			«ENDFOR»
			
			«FOR view : views»
				public java.util.Set<«generateInnerBasicTOName(view, dywaPkg)»> readAll_«DyWASelectiveDartGenerator.getSelectiveNameJava(view)»() {
					
					final java.util.Set<«generateInnerDywaTOName(view, dywaPkg)»> objs =
					«IF type instanceof EnumType»
					new java.util.HashSet<>(java.util.Arrays.asList(«generateInnerDywaTOName(view, dywaPkg)».values()));
					«ELSEIF type instanceof AbstractType»
					this.«DyWASelectiveDartGenerator.dataModelType(view.data).name.escapeJava»Controller.fetchWithSubtypes();
					«ELSE»
					this.«DyWASelectiveDartGenerator.dataModelType(view.data).name.escapeJava»Controller.fetch();
					«ENDIF»
			
					final java.util.Set<«generateInnerBasicTOName(view, dywaPkg)»> result = new java.util.HashSet<>();

					for (final «generateInnerDywaTOName(view, dywaPkg)» s : objs) {
						«view.renderCacheLookup("s", "cached")»

						result.add(cached);
					}
					
					return result;
				}
			«ENDFOR»
		
		
			«FOR view : views + #[blankSelective]»
				public void update_«view.getSelectiveNameJava»(final «typeName» value) {

					final «generateInnerDywaTOName(view, dywaPkg)» obj = this.«DyWASelectiveDartGenerator.dataModelType(view.data).name.escapeJava»Controller.read(value.getDywaId());
					
					this.update_«view.getSelectiveNameJava»(value, obj);
				}

				public void update_«view.getSelectiveNameJava»(final «typeName» value, final «view.generateInnerDywaTOName(dywaPkg)» obj) {

					// for updates, consider a special selective so we don't clash with read-operations
					if (this.objectCache.containsSelective(obj, "«view.getSelectiveNameJava»")) {
						// We are already getting updated by someone else
						return;
					}
					else {
						// we don't care for the actual value. key alone is sufficient enough for detection of cycles
						this.objectCache.putSelective(obj, "«view.getSelectiveNameJava»");
					}

					«renderCopyDyWAAttributes»

				«FOR field: view.displayedFields»
					«view.renderCopyEffectiveAttributes(field, typeName)»

					// If values were not specified, ignore them
					if (effectiveValue.is«field.field.nameOfAccessor»Set()) {
						«renderVersionCheck»
						«IF field.list»
							final «generateDywaTOName(field, dywaPkg)» source = effectiveObj.get«field.field.nameOfAccessor»();
							final «field.generateBasicTOName(dywaPkg)» actual = java.util.Optional.ofNullable(effectiveValue.get«field.field.nameOfAccessor»()).orElseGet(java.util.Collections::emptyList);
							
							source.clear();
							
							«IF field instanceof ComplexFieldView»
								for (final «field.generateInnerBasicTOName(dywaPkg)» item : actual) {
									
									final «generateInnerDywaTOName(field, dywaPkg)» entity;

									«field.renderReadObject»

									if (entity != null) {
										source.add(entity);
									}
								}
							«ELSE»
								«IF field.field.originalAttribute.primitiveDataType == PrimitiveType.FILE»
									for (final «generateRestTOName(field, dywaPkg,false)» item : actual) {
										source.add(DomainFileController.getFileReference(item.getDywaId()));
									}
								«ELSE»
									for (final «generateInnerRestTOName(field, dywaPkg)» item : actual) {
										source.add(item);
									}
								«ENDIF»
							«ENDIF»
						«ELSE»
							«field.renderCopySingleAttributes»
						«ENDIF»
					}
				}
				«ENDFOR»
				}
			«ENDFOR»

			«IF !(type instanceof EnumType) && !(type instanceof AbstractType)»
			public «blankSelective.generateInnerDywaTOName(dywaPkg)» copyToTransient(final «typeName» value) {

				final «blankSelective.generateInnerDywaTOName(dywaPkg)» obj;

				if (this.objectCache.containsTransient(value)) {
					return this.objectCache.getTransient(value);
				}
				else {
					final java.lang.String name;
					if (value.getDywaName() == null || value.getDywaName().isEmpty()) {
						name = "«type.name.escapeJava»_transient";
					} else {
						name = value.getDywaName();
					}
					obj = «type.controllerSimpleName».createTransient(name);
					this.objectCache.putTransient(value, obj);
				}

				«renderCopyDyWAAttributes»

				«FOR field: blankSelective.displayedFields»
					«blankSelective.renderCopyEffectiveAttributes(field, typeName)»

					// If values were not specified, ignore them
					if (effectiveValue.is«field.field.nameOfAccessor»Set()) {
						«renderVersionCheck»
						«IF field.list»

							final «generateDywaTOName(field, dywaPkg)» source = effectiveObj.get«field.field.nameOfAccessor»();
							final «field.generateBasicTOName(dywaPkg)» actual = java.util.Optional.ofNullable(effectiveValue.get«field.field.nameOfAccessor»()).orElseGet(java.util.Collections::emptyList);

							«IF field instanceof ComplexFieldView»
								for (final «field.generateInnerBasicTOName(dywaPkg)» item : actual) {

									final «generateInnerDywaTOName(field, dywaPkg)» entity;

									«field.renderReadObject»

									if (entity != null) {
										source.add(entity);
									}
								}
							«ELSE»
								«IF field.field.originalAttribute.primitiveDataType == PrimitiveType.FILE»
									for (final «generateRestTOName(field, dywaPkg,false)» item : actual) {
										source.add(DomainFileController.getFileReference(item.getDywaId()));
									}
								«ELSE»
									for (final «generateInnerRestTOName(field, dywaPkg)» item : actual) {
										source.add(item);
									}
								«ENDIF»
							«ENDIF»
						«ELSE»
							«field.renderCopySingleAttributes»
						«ENDIF»
					}
				}
				«ENDFOR»

				return obj;
			}

			public void delete(final long id) {
				final «type.dyWATypeName» obj = this.«type.name.escapeJava»Controller.read(id);
				this.«type.name.escapeJava»Controller.delete(obj);
			}
			«ENDIF»

			private void checkVersion(final «type.RESTTOName» value, final «type.dyWATypeName» obj) {
				if (value.isDywaVersionSet() && value.getDywaVersion() != obj.getDywaVersion()) {
					throw new javax.persistence.OptimisticLockException(obj.getDywaName() + '[' + obj.getDywaId() + "] has been updated by other transaction");
				}
			}
		}
	'''

	private def renderCopyDyWAAttributes()
	'''
		if (value.isDywaNameSet()) {
			obj.setDywaName(value.getDywaName());
		}
	'''

	private def renderVersionCheck() '''checkVersion(value, obj);'''

	private def renderCopyEffectiveAttributes(ComplexTypeView view, FieldView field, CharSequence typeName)
	'''
		«val needRuntimeCheck = view.needRuntimeCheck(field)»
		«IF needRuntimeCheck»
			«val sourceType = view.renderDeclaringRestType(field)»
			«val destType = view.renderDeclaringDywaType(field)»
			if (value instanceof «sourceType» && obj instanceof «destType») {
				final «sourceType» effectiveValue = («sourceType») value;
				final «destType» effectiveObj = («destType») obj;
		«ELSE»
			{
				final «typeName» effectiveValue = value;
				final «view.generateInnerDywaTOName(dywaPkg)» effectiveObj = obj;
		«ENDIF»
	'''

	private def renderCopySingleAttributes(FieldView field)
	'''
		«IF field instanceof ComplexFieldView»
			if (effectiveValue.get«field.field.nameOfAccessor»() == null) {
				effectiveObj.set«field.field.nameOfAccessor»(null);
			}
			else {
				final «generateDywaTOName(field, dywaPkg)» entity;
				final «generateRestTOName(field, dywaPkg)» item = effectiveValue.get«field.field.nameOfAccessor»();

				«field.renderReadObject»

				effectiveObj.set«field.field.nameOfAccessor»(entity);

			}
		«ELSE»
			«IF field.field.originalAttribute.primitiveDataType == PrimitiveType.FILE»
				if (effectiveValue.get«field.field.nameOfAccessor»() == null) {
					effectiveObj.set«field.field.nameOfAccessor»(null);
				}
				else {
					effectiveObj.set«field.field.nameOfAccessor»(DomainFileController.getFileReference(effectiveValue.get«field.field.nameOfAccessor»().getDywaId()));
				}
			«ELSE»
				effectiveObj.set«field.field.nameOfAccessor»(effectiveValue.get«field.field.nameOfAccessor»());
			«ENDIF»
		«ENDIF»
	'''

	private def renderReadObject(ComplexFieldView field)
	'''
		«val isEnum = (((field as ComplexFieldView).view as ComplexTypeView).type.originalType instanceof EnumType)»
		«val isAbstract = (((field as ComplexFieldView).view as ComplexTypeView).type.originalType instanceof AbstractType)»
		«val ctv = field.view as ComplexTypeView»
		«val rep = selectiveCache.getRepresentative(ctv)»
		«IF !isEnum»
		// create new
		if (item.getDywaId() == info.scce.dime.util.Constants.DYWA_ID_CREATE_NEW) {
			«IF isAbstract»
				throw new java.lang.IllegalArgumentException("Cannot instantiate abstract type");
			«ELSE»
				if (! (item instanceof «field.generateInnerBasicTOName(dywaPkg)»)) {
					throw new java.lang.IllegalArgumentException("Runtime type does not match model type");
				}

				final java.lang.String dywaName;
				if (item.getDywaName() == null || item.getDywaName().isEmpty()) {
					dywaName = "«field.field.name.escapeJava»";
				} else {
					dywaName = item.getDywaName();
				}

				final long id = «DyWASelectiveDartGenerator.dataModelType(field.view.data).name.escapeJava»REST.create(dywaName);
				item.setDywaId(id);

				//update_«DyWASelectiveDartGenerator.getSelectiveNameJava(ctv)»
				this.«DyWASelectiveDartGenerator.dataModelType(field.view.data).name.escapeJava»REST.update_«DyWASelectiveDartGenerator.getSelectiveNameJava(rep)»(item);
				entity = this.«DyWASelectiveDartGenerator.dataModelType(field.view.data).name.escapeJava»Controller.read(item.getDywaId());
			«ENDIF»
		}
		// create transient
		else if (item.getDywaId() == info.scce.dime.util.Constants.DYWA_ID_TRANSIENT) {
			«IF isAbstract»
				throw new java.lang.IllegalArgumentException("Cannot instantiate abstract type");
			«ELSE»
				if (! (item instanceof «field.generateInnerBasicTOName(dywaPkg)»)) {
					throw new java.lang.IllegalArgumentException("Runtime type does not match model type");
				}

				entity = this.«DyWASelectiveDartGenerator.dataModelType(field.view.data).name.escapeJava»REST.copyToTransient(item);
			«ENDIF»
		}
		// lookup regular object
		else {
			//update_«DyWASelectiveDartGenerator.getSelectiveNameJava(ctv)»
			this.«DyWASelectiveDartGenerator.dataModelType(field.view.data).name.escapeJava»REST.update_«DyWASelectiveDartGenerator.getSelectiveNameJava(rep)»(item);
			entity = this.«DyWASelectiveDartGenerator.dataModelType(field.view.data).name.escapeJava»Controller.read(item.getDywaId());
		}
		«ELSE»
			//update_«DyWASelectiveDartGenerator.getSelectiveNameJava(ctv)»
			this.«DyWASelectiveDartGenerator.dataModelType(field.view.data).name.escapeJava»REST.update_«DyWASelectiveDartGenerator.getSelectiveNameJava(rep)»(item);

			entity = this.«DyWASelectiveDartGenerator.dataModelType(field.view.data).name.escapeJava»Controller.read(item.getDywaId());
		«ENDIF»
	'''
	
	private def renderReadTransientList(ComplexFieldView field, String sourceVariable, String targetVariable) {
		val ctv = field.view as ComplexTypeView
		val rep = selectiveCache.getRepresentative(ctv)
		'''
			for (final «field.generateInnerBasicTOName(dywaPkg)» e: «sourceVariable») {
				final «field.generateInnerBasicTOName(dywaPkg)» fetchedValue;

				if (e.getDywaId() > 0) {
					// read_«DyWASelectiveDartGenerator.getSelectiveNameJava(ctv)»
					fetchedValue = this.«DyWASelectiveDartGenerator.dataModelType(field.view.data).name.escapeJava»REST.read_«DyWASelectiveDartGenerator.getSelectiveNameJava(rep)»(e.getDywaId());
				}
				else {
					// readTransient_«DyWASelectiveDartGenerator.getSelectiveNameJava(ctv)»
					fetchedValue = this.«DyWASelectiveDartGenerator.dataModelType(field.view.data).name.escapeJava»REST.readTransient_«DyWASelectiveDartGenerator.getSelectiveNameJava(rep)»(e);
				}

				«targetVariable».add(fetchedValue);
			}
		'''
	}
		
	private def debug(String msg) {
//		println('''[«class.simpleName»] «msg»''')
	}
}
