/*-
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.generator.process

import info.scce.dime.dad.dad.DAD
import info.scce.dime.data.data.UserType
import info.scce.dime.process.process.GuardContainer
import java.util.List

import static info.scce.dime.generator.util.DyWAExtension.*

import static extension info.scce.dime.generator.util.JavaIdentifierUtils.*

class TODOListGeneratorHelper extends BackendProcessGeneratorUtil {
	
	def generate(DAD dad, UserType subject, List<GuardContainer> guardContainers) '''
		package info.scce.dime.process;
		
		import javax.inject.Inject;
		import javax.ws.rs.Path;
		import javax.ws.rs.GET;
		import javax.ws.rs.QueryParam;
		import javax.ws.rs.Produces;
		import static javax.ws.rs.core.MediaType.APPLICATION_JSON;
		import java.util.Collections;
		import java.util.List;
		import java.util.Set;
		import java.util.stream.Stream;
		import java.util.LinkedList;
		import java.util.ArrayList;
		import java.util.stream.Collectors;
		import org.apache.shiro.SecurityUtils;
		import org.apache.shiro.subject.Subject;
		import javax.enterprise.inject.spi.BeanManager;
		import javax.enterprise.inject.spi.Bean;
		import javax.enterprise.context.spi.CreationalContext;
		import javax.inject.Inject;

		/**
		 * Generated by TODOListGenerator.
		 */
		@javax.transaction.Transactional
		@Path("/todos")
		public class TODOList«dad.appName.toFirstUpper.escapeJava» {
				@Inject
				 «"InteractionController".processContextsControllerName» interactionController;
				
				«FOR guardContainer: guardContainers»
					@Inject
					«guardContainer.interactionControllerTypeName» «guardContainer.id.escapeJava»;
				«ENDFOR»
				
				«FOR process: guardContainers.map[rootElement].toSet»
					@Inject
					«process.typeName» «process.id.escapeJava»;
				«ENDFOR»

				@Inject
				private «subject.controllerTypeName» subjectController;
				
				/**
				 * Retrieves all todos (sleeping lifecycle processes) matching the given includes and
				 * the current use may execute.
				 * 
				 * @param includes the ids of guard containers of todos that should be shown.
				 * 
				 * @returns the list of todos or an empty list if the current user is not authenticated.
				 */
				@Path("/including")
				@GET
				@Produces(APPLICATION_JSON)
				public List<Object> retrieveTODOsIncluding(@QueryParam("includes") List<String> includes) {
					«subject.build»
					
					// retrieve all interactions matching the included ids.
					final List<«"Interaction".processContextsTypeName»> interactions = new LinkedList<>();
					
					for(final String guardContainerId: includes) {
						switch (guardContainerId) {
							«FOR guardContainer: guardContainers»
								case "«guardContainer.id»":
									interactions.addAll(«guardContainer.id.escapeJava».fetch«guardContainer.interactionTypeName»WithSubtypes());
									break;
							«ENDFOR»
						}
					}
					
					interactions.sort((o1, o2) -> Long.compare(o1.getDywaId(), o2.getDywaId()));
					
					«buildRetrieveTODOs(subject, guardContainers)»
				}
				
				/**
				 * Retrieves all todos (sleeping lifecycle processes) <strong>not</strong> matching the given excludes and
				 * the current use may execute.
				 * 
				 * @param excludes the ids of guard containers of todos that should <strong>not</strong> be shown.
				 * 
				 * @returns the list of todos or an empty list if the current user is not authenticated.
				 */
				@Path("/excluding")
				@GET
				@Produces(APPLICATION_JSON)
				public List<Object> retrieveTODOsExcluding(@QueryParam("excludes") List<String> excludes) {
					«subject.build»
					
					// retrieve all interactions
					final List<«"Interaction".processContextsTypeName»> allInteractions = new ArrayList<>(interactionController.fetchInteractionWithSubtypes());
					
					// filter all interactions *not* matching the excludes
					Stream<«"Interaction".processContextsTypeName»> stream = allInteractions.stream();
					«FOR guardContainer: guardContainers»
						if (excludes.contains("«guardContainer.id»")) {
							stream = stream.filter(i -> !(i instanceof «guardContainer.interactionTypeName.processContextsTypeName»));
						}
					«ENDFOR»
					
					final List<«"Interaction".processContextsTypeName»> interactions = stream.collect(Collectors.toList());
					interactions.sort((o1, o2) -> Long.compare(o1.getDywaId(), o2.getDywaId()));
					
					«buildRetrieveTODOs(subject, guardContainers)»
				}
			
				/**
				 * Retrieves all todos (sleeping lifecycle processes) the current use may execute.
				 * 
				 * @returns the list of todos or an empty list if the current user is not authenticated.
				 */
				@Path("/all")
				@GET
				@Produces(APPLICATION_JSON)
				public List<Object> retrieveTODOsAll() {
					«subject.build»
					
					// retrieve all interactions
					final List<«"Interaction".processContextsTypeName»> interactions = new ArrayList<>(interactionController.fetchInteractionWithSubtypes());
					interactions.sort((o1, o2) -> Long.compare(o1.getDywaId(), o2.getDywaId()));
					
					«buildRetrieveTODOs(subject, guardContainers)»
				}
		}
	'''
	
	def generateDartClass(List<GuardContainer> guardContainers) '''
		«val interactions = guardContainers.map[guardedProcessSIBs.get(0).proMod].toSet»
		«FOR interaction: interactions»
		import 'InteractionWrapper«interaction.modelName.escapeDart»«interaction.id.escapeDart».dart';
		«ENDFOR»
		import 'dart:convert';

		class Todos {
			
			static fromJSON(String json) {
				return fromJSOG(jsonDecode(json));
			}
			
			static fromJSOG(jsog) {
				List todos = new List();
				var cache;
				
				for (var iter in jsog) {
					switch (iter["name"]) {
						«FOR interaction: interactions»
						case 'InteractionWrapper«interaction.modelName.escapeJava»«interaction.id.escapeJava»':
							todos.add(new InteractionWrapper«interaction.modelName.escapeDart»«interaction.id.escapeDart»(iter));
							break;
						«ENDFOR»
					}
				}
				
				return todos;
			}
		}
	'''
	
	def build(UserType subject) '''
		final Subject shiroSubj = SecurityUtils.getSubject();
		if (!shiroSubj.isAuthenticated()) {
			return Collections.emptyList();
		}
	'''
	
	def buildRetrieveTODOs(UserType subject, List<GuardContainer> guardContainers) '''
		// create a container for all interactions the current user is allowed to do.
		final List<Object> allowedInteractions = new ArrayList<>(interactions.size());
		
		// filter allowed interactions.
		for (final «"Interaction".processContextsTypeName» interaction: interactions) {
			«FOR guardContainer: guardContainers»
				if (interaction instanceof «guardContainer.interactionTypeName.processContextsTypeName») {
					final «guardContainer.interactionTypeName.processContextsTypeName» currInteraction = («guardContainer.interactionTypeName.processContextsTypeName»)interaction;
					
					// TODO: Use correct interaction inputs
					if («guardContainer.rootElement.id.escapeJava».checkInteraction«guardContainer.id.escapeJava»(currInteraction, currInteraction.getinteractionInputs())) {
						allowedInteractions.add(
							new «restTypePkg».«guardContainer.subProcess.localPkg».InteractionWrapper«guardContainer.subProcess.modelName.escapeJava»(currInteraction)
						);
					}
				}
			«ENDFOR»
		}
		
		return allowedInteractions;
	'''
	

}
