/*-
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.generator.gui.rest

import graphmodel.ModelElementContainer
import info.scce.dime.data.data.Data
import info.scce.dime.data.data.PrimitiveType
import info.scce.dime.data.data.Type
import info.scce.dime.generator.dad.GenerationContext
import info.scce.dime.generator.gui.dart.functionality.FrontEndProcessExtension
import info.scce.dime.generator.gui.data.SelectiveExtension
import info.scce.dime.generator.gui.rest.model.ComplexTypeView
import info.scce.dime.generator.gui.rest.model.GUICompoundView
import info.scce.dime.generator.gui.rest.model.Parent
import info.scce.dime.generator.gui.rest.model.PrimitiveTypeView
import info.scce.dime.generator.gui.rest.model.TypeView
import info.scce.dime.generator.process.BackendProcessGeneratorUtil
import info.scce.dime.gui.gui.GUI
import info.scce.dime.gui.helper.ComplexGUIBranchPort
import info.scce.dime.gui.helper.GUIBranchPort
import info.scce.dime.gui.helper.GUIExtension
import info.scce.dime.gui.helper.PrimitiveGUIBranchPort
import info.scce.dime.process.process.ComplexOutputPort
import info.scce.dime.process.process.GUISIB
import info.scce.dime.process.process.LinkProcessSIB
import info.scce.dime.process.process.NativeFrontendSIBReference
import info.scce.dime.process.process.OutputPort
import info.scce.dime.process.process.PrimitiveOutputPort
import info.scce.dime.process.process.Process
import java.util.HashSet
import java.util.LinkedList
import java.util.List
import java.util.Set

import static extension info.scce.dime.generator.util.JavaIdentifierUtils.*

class DartTOGeneratorHelper extends BackendProcessGeneratorUtil {
	
	protected extension SelectiveExtension
	protected extension DyWASelectiveDartGenerator = new DyWASelectiveDartGenerator
	protected extension FrontEndProcessExtension = new FrontEndProcessExtension
	protected extension GUIExtension _guiExtension;
	GenerationContext genctx;
	
	new() {
		this.genctx = GenerationContext.instance;
		_guiExtension = genctx.guiExtension
		_selectiveExtension = new SelectiveExtension(genctx)
	}
	
	def generateFrontEndInputDeserializer(Process p) {
		val sibs = p.findFrontEndSibs(genctx, new HashSet)
		val guardContainer = p.findGuardContainersSibs(genctx, new HashSet)
		val List<ModelElementContainer> elements = new LinkedList
		elements.addAll(sibs.filter(GUISIB).map[gui].toSet)
		elements.addAll(sibs.filter(NativeFrontendSIBReference).map[referencedSib].toSet)
		elements.addAll(sibs.filter(LinkProcessSIB).map[getModel].toSet)
		//look for deeper embedded GUIs
		
		'''
		import 'package:app/src/core/dime_process_service.dart';
		«elements.map['''
		import 'package:app/src/rest/«it.generateElementImport»Input.dart';
		'''].join»
		
		class UserInteraction«p.simpleTypeNameDart»ResponseDeserializer extends UserInteractionResponseDeserializer {
			UserInteractionResponse deserialize(String sibId,Map<String,dynamic> map, Map<String,dynamic> cache) {
				«FOR sib: (sibs+guardContainer) BEFORE '''switch(sibId){''' AFTER '''}'''»
				«sib.generateElementDeserializer»
				«ENDFOR»
				throw new Exception("Exhaustive if for: ${sibId}");
			}
		}
		'''
	}
	
	
	
	def generateGUIInputsDart(GUI gui,GUICompoundView gcv,Set<Data> datas) {
		val events = gui.listenerContexts.map[events].flatten
		val inputs = gcv.compounds.filter(Parent).filter[isInput]
		
		'''
			// generated by «class.name»#generateGUIInputsDart

			import 'dart:convert';
			import 'package:app/src/models/Selectives.dart';
			import 'package:app/src/models/FileReference.dart';
			import 'package:app/src/core/dime_process_service.dart';
			«FOR data:datas»
			import 'package:app/src/data/«data.modelName.escapeDart».dart' as «DyWASelectiveDartGenerator.prefix(data)»;
			«ENDFOR»
			import 'package:app/src/models/FileReference.dart';
			
			class «gui.simpleTypeNameDart»Input extends UserInteractionResponse {
				
				«inputs.selectiveDeclaration»
				«FOR event:events»
				Event«event.name.escapeDart» event_«event.name.escapeDart»;
				«ENDFOR»
				
				«gui.simpleTypeNameDart»Input(Map<String,dynamic> map, Map<String,dynamic> cache)
				{
					 Map<String,dynamic> inputPorts = map['inputs'];
					«IF !events.isEmpty»
					if(map.containsKey('event')&&map['event']!=null) {
						var eventName = map['event']['name'];
						«FOR event:events»
						if(eventName=='«event.name.escapeString»') {
							/// parse «event.name.escapeString»event inputs
							event_«event.name.escapeDart» = map['event']['inputs']==null?null:new Event«event.name.escapeDart»(map['event']['inputs'],cache);
						}
						«ENDFOR»					
					}
					«ENDIF»
					«inputs.selectiveFromJSOG("inputPorts")»
				}
				
				@override
				bool startedByEvent() {
				    return «FOR event:events»event_«event.name.escapeDart» != null || «ENDFOR»false;
				}
				
				bool inpusChanged(«gui.simpleTypeNameDart»Input input) {
					return «inputs.selectiveCheckChanges("input")»;
				}
			}
			«FOR event:events»
			«{
				val ports = event.outputPorts
				'''
				class Event«event.name.escapeDart» extends GUIEvent {
					«ports.portDeclaration»
					
					Event«event.name.escapeDart»(Map jsog,Map cache)
					{ 
						«ports.portFromJSOG("jsog")»
						
					}
				}
				'''
			}»
			
			«ENDFOR»
		'''
	}
	def generateSecurityProcessInputsDart(Process p,Set<Data> datas) '''
		import 'dart:convert';
		import 'package:app/src/models/Selectives.dart';
		import 'package:app/src/models/FileReference.dart';
		import 'package:app/src/core/dime_process_service.dart';
		«FOR data:datas»
		import 'package:app/src/data/«data.modelName.escapeDart».dart' as «DyWASelectiveDartGenerator.prefix(data)»;
		«ENDFOR»
		import 'package:app/src/models/FileReference.dart';
		
		class «p.simpleTypeNameDart»Input extends RootProcessInput {
			
			«FOR port:p.startSIB.outputPorts»
			«{
					val portName = port.name
					val portList = port.isIsList
					
					
					'''
						«IF port instanceof ComplexOutputPort»
							«{
								val complex = port.dataType
								'''«portList.complexPortDeclaration(complex.name,DyWASelectiveDartGenerator.prefix(complex.rootElement))» «portName.escapeDart» = «portList.complexDefault»;'''
							}»
						«ELSE»
							«{
								val primitive = port.primitiveType
								'''«portList.primitiveDeclaration(primitiveType(primitive))» «portName.escapeDart» = «defaultValue(primitive)»;'''
							}»
						«ENDIF»
					'''
			}»
			«ENDFOR»
			
			
			String toJSON() {
				return jsonEncode(toJSOG());
			}
				
			Map<String,dynamic> toJSOG()
			{
				Map<String,dynamic> jsonObj = new Map();
				Map<String,dynamic> cache = new Map();
				«FOR port:p.startSIB.outputPorts»
				«{
					val portName = port.name.escapeDart
					val portList = port.isIsList
					val jsog = '''jsonObj["«portName.escapeString»"]'''
					val isTimeStamp = if(port instanceof PrimitiveOutputPort) {port.primitiveType==PrimitiveType.TIMESTAMP} else false
					val isEncoding = if(port instanceof PrimitiveOutputPort) {port.primitiveType==PrimitiveType.FILE} else true
					toJSOG(portName,portList,isTimeStamp,isEncoding,jsog)
				}»
				«ENDFOR»
				return jsonObj;
			}
		}
	'''
	
	def generateRootProcessInputsDart(Process p,GUIExtension guiex) '''
		import 'dart:convert';
		import 'package:app/src/models/Selectives.dart';
		import 'package:app/src/models/FileReference.dart';
		import 'package:app/src/core/dime_process_service.dart';
		
		class «p.simpleTypeNameDart»LinkSIBInput extends UserInteractionResponse {
			
			«FOR port:p.startSIB.outputPorts»
			«{
					val portName = port.name
					val portList = port.isIsList
					
					'''
						«IF port instanceof ComplexOutputPort»
							«{
								'''«portList.primitiveDeclaration(guiex.primitiveType(PrimitiveType.INTEGER))» «portName.escapeDart» = «guiex.defaultValue(PrimitiveType.INTEGER,port.isIsList)»;'''
							}»
						«ELSE»
							«{
								val primitive = port.primitiveType
								'''«portList.primitiveDeclaration(guiex.primitiveType(primitive))» «portName.escapeDart» = «guiex.defaultValue(primitive,port.isIsList)»;'''
							}»
						«ENDIF»
					'''
			}»
			«ENDFOR»

			
			«p.simpleTypeNameDart»LinkSIBInput(Map<String,dynamic> map, Map<String,dynamic> cache)
			{
				 Map<String,dynamic> inputPorts = map['inputs'];
				«p.startSIB.outputPorts.routeFromJSOG("inputPorts")»
				
			}
			
			@override
			bool startedByEvent() {
			    return false;
			}
			
		}
	'''
		
	def generateNativeFrontEndSIBInputsDart(NativeFrontendSIBReference nfSIB,Iterable<Parent> selectives,Set<Data> datas,GUIExtension guiex) '''
		import 'dart:convert';
		import 'package:app/src/models/Selectives.dart';
		import 'package:app/src/core/dime_process_service.dart';
		«FOR data:datas»
		import 'package:app/src/data/«data.modelName.escapeDart».dart' as «DyWASelectiveDartGenerator.prefix(data)»;
		«ENDFOR»
		import 'package:app/src/models/FileReference.dart';
		
		class «nfSIB.simpleTypeNameDart»Input extends UserInteractionResponse {
			
			«selectives.selectiveDeclaration»
			
			«nfSIB.simpleTypeNameDart»Response(Map<String,dynamic> map, Map<String,dynamic> cache)
			{
				 Map<String,dynamic> inputPorts = map['inputs'];
				«selectives.selectiveFromJSOG("inputPorts")»
			}
			
			
		}
	'''
	
	def generateNativeFrontEndSIBOutputsDart(NativeFrontendSIBReference nfSIB,Set<Data> datas,GUIExtension guiex) '''
		import 'dart:convert';
		import 'package:app/src/models/Selectives.dart';
		«FOR data:datas»
		import 'package:app/src/data/«data.modelName.escapeDart».dart' as «DyWASelectiveDartGenerator.prefix(data)»;
		«ENDFOR»
		import 'package:app/src/models/FileReference.dart';
		import 'package:app/src/core/dime_process_service.dart';
		
		class «nfSIB.simpleTypeNameDart»Branch extends ContinueProcessRequest {
			
			«FOR branch: nfSIB.branchSuccessors»
				«branch.name.escapeDart.toFirstUpper» branch_«branch.name.escapeDart»;
				
				«process.simpleTypeNameDart»Request.for«branch.name.escapeDart»Branch(
					String this.longRunningProcessId
					«FOR port:branch.outputPorts BEFORE ",{" SEPARATOR "," AFTER "}"»
					«{
							val portName = port.name.escapeDart
							val portList = port.isIsList
							
							'''
							«IF GUIBranchPort.isComplex(port)»
								«{
									val complex = GUIBranchPort.getComplexType(port)
									'''«portList.complexPortDeclaration(complex.name,DyWASelectiveDartGenerator.prefix(complex.rootElement))» «portName»:«portList.complexParameterDefault»'''
								}»
							«ELSE»
								«{
									val primitive = GUIBranchPort.getPrimitiveType(port)
									'''«portList.primitiveDeclaration(guiex.primitiveType(primitive))» «portName»:«guiex.defaultValue(primitive)»'''
								}»
							«ENDIF»
							'''
					}»
					«ENDFOR»
				) {
				
					this.branchName = "«branch.name.escapeString»";
					branch_«branch.name.escapeDart» = new «branch.name.escapeDart.toFirstUpper»();
					«FOR port:branch.outputPorts»
						«IF port.isList»
						«port.name.escapeDart» = «port.name.escapeDart» == null?new DIMEList():«port.name.escapeDart»;
						«ENDIF»
						branch_«branch.name.escapeDart».«port.name.escapeDart» = «port.name.escapeDart»;
					«ENDFOR»
				}
			«ENDFOR»
			String toJSON() {
				return jsonEncode(toJSOG());
			}
				
			Map<String,dynamic> toJSOG()
			{
				Map<String,dynamic> jsonObj = new Map();
				jsonObj['branchName'] = branchName;
				«FOR branchName: nfSIB.branchSuccessors.map[name]»
				if(branch_«branchName.escapeDart»!=null) {
					return branch_«branchName.escapeDart».toJSOG();
				}
				«ENDFOR»
				throw new Exception("Exhaustive IF «nfSIB.simpleTypeNameDart»Branch.dart");
			}
			
			
		}
		«FOR branch: nfSIB.branchSuccessors»
		class «branch.name.escapeDart.toFirstUpper» {
			
			«FOR port:branch.outputPorts»
			«{
					val portName = '''port_«port.name.escapeDart»'''
					val portList = port.isIsList
					
					'''
						«IF GUIBranchPort.isComplex(port)»
							«{
								val complex = GUIBranchPort.getComplexType(port)	
								'''«portList.complexPortDeclaration(complex.name,DyWASelectiveDartGenerator.prefix(complex.rootElement))» «portName» = «portList.complexDefault»;'''
							}»
						«ELSE»
							«{
								val primitive = GUIBranchPort.getPrimitiveType(port)
								'''«portList.primitiveDeclaration(guiex.primitiveType(primitive))» «portName» = «guiex.defaultValue(primitive)»;'''
							}»
						«ENDIF»
					'''
			}»
			«ENDFOR»

			Map<String,dynamic> toJSOG()
			{
				Map<String,dynamic> cache = new Map();
				Map<String,dynamic> jsonObj = new Map();
						«FOR port:branch.outputPorts.sortBy[name]»
						«{
							val portName = '''port_«port.name.escapeDart»'''
							val portList = port.isIsList
							val jsog = '''jsonObj["«port.name.escapeJava»"]'''
							val isTimeStamp = if(port instanceof PrimitiveOutputPort) {port.primitiveType==PrimitiveType.TIMESTAMP} else false
							val isEncoding = if(port instanceof PrimitiveOutputPort) {port.primitiveType==PrimitiveType.FILE} else true
							toJSOG(portName,portList,isTimeStamp,isEncoding,jsog)
						}»
						«ENDFOR»
						
				return jsonObj;
			}
			
			String toJSON()
			{
				return jsonEncode(toJSOG());
			}
			
			
		}
	«ENDFOR»
	'''
	
	private def toJSOG(String portName,boolean portList,boolean isTimeStamp,boolean isEncoding,String jsog)
	'''
	«IF portList»
		if(this.«portName».isEmpty){
			«jsog» = [];
		}
		else{
			«jsog» = 
			«IF isTimeStamp»
			this.«portName».map((n)=>DateConverter.toJSON(n)).toList();
			«ELSE»
			this.«portName»«IF isEncoding».map((n)=>n.toJSOG(cache)).toList()«ENDIF»;
			«ENDIF»
		}
	«ELSE»
		«IF isEncoding»
		if(this.«portName» != null){
			«jsog» = this.«portName».toJSOG(cache);
		}
		else{
			«jsog» = null;
		}
		«ELSE»
			«IF isTimeStamp»
				if(this.«portName» != null){
					«jsog» = DateConverter.toJSON(this.«portName»);
				} else {
					«jsog» = null;
				}
			«ELSE»
				«jsog» = this.«portName»;
			«ENDIF»
		«ENDIF»
	«ENDIF»
	'''
	
	private def selectiveFromJSOG(Iterable<Parent> selectives,String map)
	'''
	«FOR selective:selectives.sortBy[name]»
	«{
			val portName = selective.name
			val portList = selective.list
			val jsog = '''«map»['«portName.escapeJava»']'''
			
			'''
			if(«map».containsKey('«portName.escapeJava»')) {
				«IF portList»
				for(var entry in «jsog») {
					«portName.escapeDart».add(
						«selective.fromJSOG("entry")»
					);
				}
				«ELSE»
				if(«jsog»!=null){
					«portName.escapeDart» = «selective.fromJSOG(jsog)»;
				}
				«ENDIF»
			}
			'''
	}»
	«ENDFOR»
	'''
	
	private def portFromJSOG(Iterable<info.scce.dime.gui.gui.OutputPort> ports,String map)
	'''
	«FOR port:ports.sortBy[name]»
	«{
			val portName = port.name
			val portList = port.isList
			val jsog = '''«map»['«portName.escapeJava»']'''
			
			'''
			if(«map».containsKey('«portName.escapeJava»')) {
				«IF portList»
				for(var entry in «jsog») {
					«portName.escapeDart».add(
						«port.portJSOG("entry")»
					);
				}
				«ELSE»
				if(«jsog»!=null){
					«portName.escapeDart» = «port.portJSOG(jsog)»;
				}
				«ENDIF»
			}
			'''
	}»
	«ENDFOR»
	'''
	
	private def routeFromJSOG(Iterable<OutputPort> outputs,String map)
	'''
	«FOR output:outputs.sortBy[name]»
	«{
			val portName = output.name
			val portList = output.isList
			val jsog = '''«map»['«portName.escapeJava»']'''
			var type = PrimitiveType.INTEGER;
			if(output instanceof PrimitiveOutputPort) {
				type = output.dataType.toData
			}
			
			'''
			if(«map».containsKey('«portName.escapeJava»')«IF portList»&&«jsog»!=null«ENDIF») {
				«IF portList»
				for(var a in «jsog») {
					«portName.escapeDart».add(«'''a'''.routeParser(type)»);
				}
				«ELSE»
					«portName.escapeDart» = «jsog.routeParser(type)»;
				«ENDIF»
			}
			'''
	}»
	«ENDFOR»
	'''
	
	private def routeParser(CharSequence s,PrimitiveType pt) {
		return switch(pt) {
			case BOOLEAN: '''(«s».toString()=='true')'''
			case FILE: '''int.parse(«s».toString())'''
			case INTEGER: '''int.parse(«s».toString())'''
			case REAL: '''double.parse(«s».toString())'''
			case TEXT: '''«s».toString()'''
			case TIMESTAMP: '''DateConverter.fromJSON(«s».toString())'''
		}
	}
	
	private def portDeclaration(Iterable<info.scce.dime.gui.gui.OutputPort> ports)
	'''
	«FOR input:ports.sortBy[name]»
		«{
				val portName = input.name
				val portList = input.isIsList
				
				
				'''
				«IF !(input instanceof info.scce.dime.gui.gui.PrimitiveOutputPort)»
					«{
						val complex = (input as info.scce.dime.gui.gui.ComplexOutputPort).dataType
						'''«portList.complexPortDeclaration(complex)» «portName.escapeDart» = «IF portList» new «portList.complexPortDeclaration(complex)»()«ELSE»«portList.complexDefault»«ENDIF»;'''
					}»
				«ELSE»
					«{
						val primitive = toData((input as info.scce.dime.gui.gui.PrimitiveOutputPort).dataType)
						'''«portList.primitiveDeclaration(primitiveType(primitive))» «portName.escapeDart» = «defaultValue(primitive, portList)»;'''
					}»
				«ENDIF»
				'''
		}»
	«ENDFOR»
	'''
	
	private def selectiveDeclaration(Iterable<Parent> views)
	'''
		«FOR it : views»
			«variableDeclaration»
		«ENDFOR»
	'''
	
	private def selectiveCheckChanges(Iterable<Parent> views, CharSequence check)
	'''«IF views.empty»false«ELSE»«views.map[variableCheckChanges(check)].join(''' || ''')»«ENDIF»'''
	
	private def variableDeclaration(Parent view) {
		val typeName = getTypeName(view.toTypeView as TypeView)
		val valueDecl = getDefaultValue(view.toTypeView as TypeView)
		'''«typeName» «view.name.escapeDart» = «valueDecl»;'''
	}
	
	private def variableCheckChanges(Parent view, CharSequence check) {
		'''«view.name.escapeDart» != «check».«view.name.escapeDart»'''
	}
	
	private dispatch def getTypeName(PrimitiveTypeView ptv) {
		val typeName = primitiveType(ptv.primitiveType)
		if (ptv.isList)
			'''DIMEList<«typeName»>'''
		else typeName
	}
	
	private dispatch def getTypeName(ComplexTypeView ctv) {
		val typeName = '''«DyWASelectiveDartGenerator.prefix(ctv.type.rootElement)».«ctv.type.name.escapeDart»'''
		if (ctv.isList)
			'''DIMEList<«typeName»>'''
		else typeName
	}
	
	private dispatch def getDefaultValue(PrimitiveTypeView ptv) {
		defaultValue(ptv.primitiveType, ptv.isList)
	}
	
	private dispatch def getDefaultValue(ComplexTypeView ctv) {
		if (ctv.isList)
			'''new «getTypeName(ctv)»()'''
		else "null"
	}
	
	private def fromJSOG(Parent selective,String jsog) {
		if(!selective.primitive){
			val complex = (selective.toTypeView as ComplexTypeView)
			return '''«false.complexSelectiveDeclaration(complex)».fromJSOG(jsog:«jsog»,cache:cache)'''
		}
		
		val primitive = (selective.toTypeView as PrimitiveTypeView).primitiveType
		return switch(primitive){
			case BOOLEAN: '''«jsog».toString()=="true"'''
			case INTEGER: '''int.parse(«jsog».toString())'''
			case REAL: '''double.parse(«jsog».toString())'''
			case TIMESTAMP: '''DateConverter.fromJSON(«jsog».toString())'''
			case FILE: '''new FileReference(jsog:«jsog»)'''
			default: '''«jsog».toString()'''
		}
	}
	
	private def portJSOG(info.scce.dime.gui.gui.OutputPort port,String jsog) {
		if(!(port instanceof info.scce.dime.gui.gui.PrimitiveOutputPort)){
			val complex = (port as info.scce.dime.gui.gui.ComplexOutputPort).dataType
			return '''«false.complexPortDeclaration(complex)».fromJSOG(jsog:«jsog»,cache:cache)'''
		}
		
		val primitive = (port as info.scce.dime.gui.gui.PrimitiveOutputPort).dataType.toData
		return switch(primitive){
			case BOOLEAN:  '''«jsog».toString()=="true"'''
			case INTEGER: '''int.parse(«jsog».toString())'''
			case REAL: '''double.parse(«jsog».toString())'''
			case TIMESTAMP: '''DateConverter.fromJSON(«jsog».toString())'''
			case FILE: '''new FileReference(jsog:«jsog»)'''
			default: '''«jsog».toString()'''
		}
	}
	
	private def complexPortDeclaration(boolean isList, String typeName,String modelName) '''«IF isList»DIMEList<«ENDIF»«modelName».«typeName.escapeDart»«IF isList»>«ENDIF»'''
	private def complexDefault(boolean isList) '''«IF isList»new DIMEList()«ELSE»null«ENDIF»'''
	private def complexParameterDefault(boolean isList) '''null'''
	
	private def complexPortDeclaration(boolean isList, Type t) '''«IF isList»DIMEList<«ENDIF»«DyWASelectiveDartGenerator.prefix(t)».«t.name.escapeDart»«IF isList»>«ENDIF»'''
	
	
	private def complexSelectiveDeclaration(boolean isList, ComplexTypeView ctv) '''«IF isList»DIMEList<«ENDIF»«DyWASelectiveDartGenerator.prefix(ctv.type.rootElement)».«ctv.type.name.escapeDart»«IF isList»>«ENDIF»'''
	private def primitiveDeclaration(boolean isList, String typeName) '''«IF isList»DIMEList<«ENDIF»«typeName»«IF isList»>«ENDIF»'''
	
	def generateGUIOutputsDart(GUI gui,GUICompoundView gcv,Set<Data> datas,GUIExtension guiex)
	{
		val branches = gui.GUIBranchesMerged
		return '''
		// generated by «class.name»#generateGUIOutputsDart
		
		import 'dart:convert';
		import 'package:app/src/models/Selectives.dart';
		«FOR data:datas»
		import 'package:app/src/data/«data.modelName.escapeDart».dart' as «DyWASelectiveDartGenerator.prefix(data)»;
		«ENDFOR»
		import 'package:app/src/models/FileReference.dart';
		import 'package:app/src/core/dime_process_service.dart';
		
		class «gui.simpleTypeNameDart»Branch extends ContinueProcessRequest {
			
			
			«FOR branch: branches»
				«branch.name.escapeDart.toFirstUpper» branch_«branch.name.escapeDart»;
				
				«gui.simpleTypeNameDart»Branch.for«branch.name.escapeDart»Branch(
					«FOR port:guiex.notEquallyNamedPorts(branch.ports) BEFORE "{" SEPARATOR "," AFTER "}"»
					«{
						
						val portName = port.name
						val portList = port.isList
						'''
						«IF port instanceof ComplexGUIBranchPort»
							«{
								val complex = port.type.originalType
								'''«portList.complexPortDeclaration(complex.name,DyWASelectiveDartGenerator.prefix(complex.rootElement))» «portName.escapeDart»:«portList.complexParameterDefault»'''
							}»
						«ELSE»
							«{
								val primitive = (port as PrimitiveGUIBranchPort).type
								if (primitive === null) {
									System.err.println("PrimitiveType null for port: " + port)
									System.err.println("  portNode: " + port?.portNode)
								}
								'''«portList.primitiveDeclaration(guiex.primitiveType(primitive))» «portName.escapeDart»:«IF portList»null«ELSE»«guiex.defaultValue(primitive)»«ENDIF»'''
							}»
						«ENDIF»
						'''
					}»
					«ENDFOR»
				) {
					branch_«branch.name.escapeDart» = new «branch.name.escapeDart.toFirstUpper»();
					«FOR port:guiex.notEquallyNamedPorts(branch.ports)»
						«val portName = port.name»
						«IF port.isList»
						«portName.escapeDart» = «portName.escapeDart»==null?new DIMEList():«portName.escapeDart»;
						«ENDIF»
						branch_«branch.name.escapeDart».port_«portName.escapeDart» = «portName.escapeDart»;
					«ENDFOR»
				}
			«ENDFOR»

			String toJSON() {
				return jsonEncode(toJSOG());
			}
				
			Map<String,dynamic> toJSOG()
			{
				Map<String,dynamic> jsonObj = new Map();
				
				«FOR branch: branches»
				if(branch_«branch.name.escapeDart»!=null) {
					return branch_«branch.name.escapeDart».toJSOG();
				}
				«ENDFOR»
				throw new Exception("Exhaustive IF «gui.simpleTypeNameDart»Branch.dart");
			}
		}
			
			«FOR branch: branches»
				class «branch.name.escapeDart.toFirstUpper» {
					
					«FOR port:guiex.notEquallyNamedPorts(branch.ports)»
					«{
						val portName = '''port_«port.name.escapeDart»'''
						val portList = port.isList

						'''
						«IF port instanceof ComplexGUIBranchPort»
							«{
								val complex = port.type.originalType
								'''«portList.complexPortDeclaration(complex.name,DyWASelectiveDartGenerator.prefix(complex.rootElement))» «portName» = «portList.complexDefault»;'''
								
							}»
						«ELSE»
							«{
								val primitive = (port as PrimitiveGUIBranchPort).type
								'''«portList.primitiveDeclaration(guiex.primitiveType(primitive))» «portName» = «guiex.defaultValue(primitive,portList)»;'''
							}»
						«ENDIF»
						'''
						
					}»
					«ENDFOR»

					Map<String,dynamic> toJSOG()
					{
						
						Map<String,dynamic> jsonObj = new Map();
						«FOR port:guiex.notEquallyNamedPorts(branch.ports) BEFORE '''Map<Object,dynamic> cache = new Map();'''»
						«{
							val portName = '''port_«port.name.escapeDart»'''
							val portList = port.isList
							val portIsPrimitive = port instanceof PrimitiveGUIBranchPort
							val portType = if (port instanceof PrimitiveGUIBranchPort) (port as PrimitiveGUIBranchPort).type
							val jsog = '''jsonObj["«port.name»"]'''
							val isTimeStamp = (portIsPrimitive && portType == PrimitiveType.TIMESTAMP)
							var isEncoding = (!portIsPrimitive || portType == PrimitiveType.FILE)
							toJSOG(portName,portList,isTimeStamp,isEncoding,jsog)
						}»
						«ENDFOR»
								
						return jsonObj;
					}
					
				}
			«ENDFOR»
	'''
	}
	
}
