/*-
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.generator.gui.dart.component

import info.scce.dime.generator.gui.html.HTMLFileTemplate
import info.scce.dime.generator.gui.rest.DartFileGuardGenerator
import info.scce.dime.generator.gui.rest.model.GUICompoundView
import info.scce.dime.gui.gui.File
import info.scce.dime.gui.gui.GUI
import info.scce.dime.gui.gui.GuardSIB
import info.scce.dime.gui.gui.Image
import info.scce.dime.gui.gui.InputPort
import info.scce.dime.gui.gui.MovableContainer
import info.scce.dime.process.process.Process
import info.scce.dime.process.process.ProcessType

/**
 * Template to generate statically helper methods for every Angular Dart component class
 * to handle files
 */
class DartHTMLFileTemplate extends HTMLFileTemplate{
	
	/**
	 * Generates statically helper methods for file handling
	 */
	def createMethods(GUI gui,GUICompoundView gcv)
	'''
	
	
	«FOR fileComponent : gui.find(File)»
	/// starts the file download for a file component
	void download«fileComponent.id.escapeDart»File(«fileComponent.parameterNames.join(",")»,dynamic event)
	{
		«createGuardedFileAccess(fileComponent,gui,gcv,true)»
	}
	«ENDFOR»
	
	«FOR imageComponent : gui.find(Image)»
	/// loads an image file download for an image component	
	String load«imageComponent.id.escapeDart»Image(«imageComponent.parameterNames.join(",")»)
	{
		«createGuardedFileAccess(imageComponent,gui,gcv,false)»
	}
	«ENDFOR»
	'''
	
	
	/**
	 * Generates the guarded file rest call method for the given component,
	 * placed in the given GUI model.
	 * The download flag decides, if the file should be download to the client or returned to
	 * the caller
	 */
	def createGuardedFileAccess(MovableContainer container,GUI gui,GUICompoundView gcv,boolean download)
	{
		val guards = container.allNodes.filter(GuardSIB).filter[isSecurity]
		val fetch = container.allNodes.filter(GuardSIB).filter[isFileFetch]
		val dfgg = new DartFileGuardGenerator()
		return 
		'''
		//prepare guard compound
		«dfgg.getGuardCompoundName(container)» guardContainer = new «dfgg.getGuardCompoundName(container)»();
		«IF fetch.empty»
			guardContainer.context = fileRef;
		«ELSE»
			«FOR input:fetch.get(0).allNodes.filter[n|n instanceof InputPort].map[n|n as InputPort]»
				guardContainer.context.«input.name.escapeDart» = «input.parameterName»;
			«ENDFOR»
		«ENDIF»
		
		«FOR guard:guards»
			«FOR input:guard.allNodes.filter(InputPort)»
				guardContainer.securityInputs.«dfgg.getGuardName(guard)».«input.name.escapeDart» = «input.parameterName»;
			«ENDFOR»
		«ENDFOR»
		// private interactable
		String guardData = guardContainer.toQueryParams();
		«IF download»
		downloadURI('${getRestBaseUrl()}/«new DartFileGuardGenerator().getImageURL(container)»${guardData}');
		«ELSE»
		return guardData;
		«ENDIF»
		
		'''
	}
	
	static def Boolean getIsSecurity(GuardSIB sib){
		return ((sib as GuardSIB).process as Process).processType == ProcessType.SECURITY;
	}
	
	static def Boolean getIsFileFetch(GuardSIB sib){
		return ((sib as GuardSIB).process as Process).processType == ProcessType.FILE_DOWNLOAD_SECURITY;
	}
}
