/*-
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.generator.gui.dart.component

import graphmodel.Node
import info.scce.dime.data.data.PrimitiveType
import info.scce.dime.generator.gui.utils.helper.ConventionHelper
import info.scce.dime.generator.gui.enums.DataAccessType
import info.scce.dime.generator.gui.enums.MODE
import info.scce.dime.generator.gui.rest.model.GUICompoundView
import info.scce.dime.generator.gui.utils.GUIGenerator
import info.scce.dime.gui.gui.Attribute
import info.scce.dime.gui.gui.ComplexAttribute
import info.scce.dime.gui.gui.ComplexAttributeConnector
import info.scce.dime.gui.gui.ComplexListAttribute
import info.scce.dime.gui.gui.ComplexListAttributeConnector
import info.scce.dime.gui.gui.ComplexListAttributeName
import info.scce.dime.gui.gui.ComplexVariable
import info.scce.dime.gui.gui.DataBinding
import info.scce.dime.gui.gui.DataTarget
import info.scce.dime.gui.gui.GUI
import info.scce.dime.gui.gui.PrimitiveAttribute
import info.scce.dime.gui.gui.PrimitiveListAttribute
import info.scce.dime.gui.gui.Table
import info.scce.dime.gui.gui.TableChoice
import info.scce.dime.gui.gui.TableColumnLoad
import info.scce.dime.gui.gui.TableEntry
import info.scce.dime.gui.gui.TableEntryDefaultSort
import info.scce.dime.gui.gui.TableLoad
import info.scce.dime.gui.gui.Variable
import info.scce.dime.gui.helper.ElementCollector
import java.util.ArrayList
import java.util.Iterator
import java.util.LinkedList
import java.util.List
import info.scce.dime.gui.gui.PrimitiveVariable
import info.scce.dime.gui.gui.PrimitiveListAttributeName
import de.jabc.cinco.meta.core.referenceregistry.ReferenceRegistry
import info.scce.dime.gui.gui.PrimitiveExtensionAttribute
import info.scce.dime.gui.gui.ComplexExtensionAttribute
import info.scce.dime.generator.gui.utils.helper.DataDartHelper
import info.scce.dime.generator.gui.dart.base.AngularDartCommonImports
import info.scce.dime.generator.gui.dart.functionality.AngularAttributeTemplate
import info.scce.dime.generator.gui.dart.functionality.AngularDartEventTemplate

/**
 * Template for the generation of Angular Dart component class files for table
 * components.
 */
class AngularDartTableTemplate extends GUIGenerator {
	
	CharSequence boundDataTypeName
	
	/**
	 * Returns the table Angular Dart component file and class name
	 */
	def getTableName(Table table,GUI gui)
	'''Table«ConventionHelper.cincoID(table)»«gui.title.escapeDart.toFirstUpper»'''
	
	
	def create(Table table, GUI gui, GUICompoundView gcv) {
		boundDataTypeName = DataDartHelper.getVariableDataType(table.getIncoming(DataBinding).get(0).sourceElement as Variable, true, gcv, _selectiveExtension)
		'''
			// generated by «class.name»#create
			// table in GUI model «gui.title»
			// with columns «table.tableEntrys.map[n|n.label].join(" ")»
			import 'dart:js' as js;
			import 'package:app/src/core/AbstractRoutes.dart';
			import 'package:app/src/services/TableDndService.dart';
			
			«new AngularDartCommonImports().createImports(true,gui,gcv)»
			«new AngularCommonComponentTemplate().imports(table,gui,gcv)»
			
			@Component(
			  selector: 'table-«ConventionHelper.cincoID(table)»-«gui.title.escapeDart.toFirstLower»',
			  «new AngularCommonComponentTemplate().otherSpecifications(table,gui)»
			  templateUrl: '«getTableName(table,gui)».html',
			  styles: const [
			  	«IF table.reSortable»
			  	'.table-reSortable .draggable .drag-handle {cursor: grab}',
			  	'.table-reSortable .draggable.dragging {box-shadow: 0px 1px 4px rgba(0,0,0,.75)}',
			  	'.table-reSortable .draggable.dragging .drag-handle {cursor: grabbing}',
			  	'.drop-placeholder {border-radius: 0; margin-top: -20px; display: table; width: 100%; padding: .5rem 1rem;}'
			  	«ENDIF»
			  ]
			)
			class «getTableName(table,gui)» extends dime.DIMEComponent implements OnInit, AfterViewChecked {
				
				«new AngularCommonComponentTemplate().declaration(table,gui,gcv)»
				
				@Input()
				«boundDataTypeName» source«table.id.escapeDart»;
				
				@Output('source_update') Stream<dynamic> get source_update => _source_update.stream;
				StreamController<dynamic> _source_update = new StreamController();
				
				«IF !table.autoSorted»
				// table is not auto sorted, sorts only on action
				bool reSortTable = true;
				«boundDataTypeName» cached_source«table.id.escapeDart» = new DIMEList();
				«ENDIF»
				
				ElementRef elementRef;
				TableDndService dndService;
				html.Element dragHandle;
				
				//Global Scope
				 «new AngularAttributeTemplate().createAttributeDeclaration(gui,gcv,true)»
			
				//Extra input variables
				«FOR node : table.inputsVariables»
					«IF node instanceof Variable»
						@Input()
						«DataDartHelper.getVariableDataType(node,true,gcv, _selectiveExtension)» «DataDartHelper.getComponentInputName(node)»;
					«ELSEIF node instanceof Attribute»
						@Input()
						«DataDartHelper.getAttributeDataType(node as Attribute,gcv, _selectiveExtension)» «DataDartHelper.getComponentInputName(node)»;
						«ENDIF»
					«ENDFOR»
					«createTableDeclaration(table)»
					«IF table.choices == TableChoice.SINGLE»
						@Output('dime_single_choice')
						Stream<dynamic> get evt_dime_single_choice => dime_single_choice.stream;
						final StreamController<dynamic> dime_single_choice = new StreamController<dynamic>();
					«ENDIF»
					
					«getTableName(table,gui)»(DIMEProcessService this.processService, TableDndService this.dndService, ElementRef this.elementRef, Router this.router,DomSanitizationService this.domSanitizationService,AbstractRoutes routes«new AngularDartCommonImports().createConstructorParameters(gui,gcv)») : super(domSanitizationService,processService,routes)
					{
						restartComponent();
					}
					
					
					void restartComponent() {
						
						«new AngularCommonComponentTemplate().constructor(table)»
						«new AngularCommonComponentTemplate().restart(table,gui,gcv)»
						«createTableRestart(table)»
					}
													
					void ngOnInit()
					{
						«new AngularCommonComponentTemplate().onInit(table)»
						
						«FOR tableEntry:table.tableEntrys.filter[n|n.defaultSorting!=TableEntryDefaultSort.NONE]»
							// sorting enabled for «tableEntry.label»
							«IF tableEntry.defaultSorting==TableEntryDefaultSort.ASC»
								this.sortColumn«ConventionHelper.cincoID(tableEntry)»Direction = true;
							«ENDIF»
							this.table«ConventionHelper.cincoID(tableEntry)»Sort(null);
						«ENDFOR»
						
						«IF table.choices == TableChoice.SINGLE»
							// table rows can be selected
							// the first row is auto selected
							if(!this.source«table.id.escapeDart».isEmpty)
							{
								this.«DataDartHelper.getBindedDataName(table,DataAccessType.CHOICE,MODE.SET_INIT,DataTarget)»(table«ConventionHelper.cincoID(table)»getElements(this.source«table.id.escapeDart»).first);
								this.dime_single_choice.add(this.«DataDartHelper.getBindedDataName(table,DataAccessType.CHOICE,MODE.GET,DataTarget)»);
							}
						«ENDIF»
					}
					
					«IF table.reSortable»
					html.Element getTableEl() {
						return this.elementRef.nativeElement.querySelector('table');
					}
						
					void handleMousedown(dynamic event) {
						dragHandle = null;
						if (event.target.classes.contains('drag-handle')) {
							dragHandle = event.target;
						}
					}
					
					void handleDragstart(dynamic item, dynamic event) {
						if (event.target.querySelector('.drag-handle') != dragHandle) {
							event.preventDefault();
						} else {
							getDraggableRow(event).classes.add('dragging');
						  	event.dataTransfer.setData('text', '«table.id.escapeDart»');
						  	
						  	var dropListener = dndService.setItem(new TableDndItem(getTableEl(), item));
						  	dropListener.listen((_) {
						  		source«table.id.escapeDart».remove(item);
						  	 	_source_update.add(source«table.id.escapeDart»);
						  	});
						}
					}
					
					bool handleDragover(dynamic event) {
						event.preventDefault();
						return false;
					}
					
					void handleDragenter(dynamic event) {
						event.preventDefault();
					}
					
					void handleDragleave(dynamic event) {
						event.preventDefault();
					}
					
					void handleDragend() {
						elementRef.nativeElement.querySelectorAll('.draggable').forEach((el) {
							el.classes.remove('dragging');
						});
					}
					
					void handleDrop(int index, dynamic event) {
						«isDropTargetTemplate()»
						
						if ((fromTableId != '«table.id.escapeDart»') || (fromTableId == '«table.id.escapeDart»' && dndItem.tableEl != getTableEl())) {
							// from another table
							source«table.id.escapeDart».insert(index, item);
							this.dndService.drop();		  	    
						} else {
							// within this list
							var indexInList = source«table.id.escapeDart».indexOf(item);
							if (indexInList != index) {
								source«table.id.escapeDart».removeAt(indexInList);
								source«table.id.escapeDart».insert(index, item);	
							}
							dndService.clear();
						}
						
						_source_update.add(source«table.id.escapeDart»);
						handleDragend();
					}
					
					void handleDropFromPlaceholder(dynamic event) {
						«isDropTargetTemplate()»
						
						source«table.id.escapeDart».add(item);
						dndService.drop();	
						_source_update.add(source«table.id.escapeDart»);	  	    
					}
					
					bool canDropFromTable(html.Element table, String fromTableId) {					
						String tableId = '«table.id.escapeDart»';
					
						«IF table.dropTargets.exists[tableID == table.id]»
							if (fromTableId == tableId) return true;
						«ELSE»
							if (fromTableId == tableId && table == getTableEl()) return true;
						«ENDIF»
						
						«FOR t: ReferenceRegistry.instance.lookup(info.scce.dime.gui.gui.Table).filter[id != table.id]»
							«FOR dt: t.dropTargets»
								«IF dt.tableID == table.id»
									if (fromTableId == '«t.id.escapeDart»') return true;
								«ENDIF»
							«ENDFOR»
						«ENDFOR»
						return false;
					}
					
					html.Element getDraggableRow(dynamic event) {
					    var el = event.target;
					    while (el.getAttribute('draggable') == null) {
					      el = el.parent;
					    }
					    return el;
					}
				«ENDIF»
				
				void ngAfterViewChecked() {
					if(html.querySelector("#table${this.hashCode}")!=null) {
						«FOR tableEntry:table.tableEntrys.filter[fullTextSearch].filter[!getIncoming(TableColumnLoad).empty].filter[AngularTableHTMLTemplate.getIsDate(getIncoming(TableColumnLoad).get(0).sourceElement)]»
							js.context.callMethod('showPicker',["month","hour","yyyy-mm-dd hh:ii",cb_«tableEntry.id.escapeDart»_from,'[data-date-column="«ConventionHelper.cincoID(tableEntry)»_from"]']);
							js.context.callMethod('showPicker',["month","hour","yyyy-mm-dd hh:ii",cb_«tableEntry.id.escapeDart»_to,'[data-date-column="«ConventionHelper.cincoID(tableEntry)»_to"]']);
						«ENDFOR»
					}
				}
				
				«new AngularDartEventTemplate().createUpdateMethod(gui,table,gcv,'''''')»
				«new AngularCommonComponentTemplate().methods(table,gui,gcv)»
				«createTableMethod(table)»
				}
		'''
	}
	
	private def isDropTargetTemplate() {
		'''
			var dndItem = dndService.getItem();
			
			var fromTableId = event.dataTransfer.getData('text');
						if (fromTableId == null || fromTableId.trim() == '' || !canDropFromTable(dndItem.tableEl, fromTableId)) {
							event.preventDefault();
							return;
						}
			
			var item = dndItem.item;
		'''
	}
	
	def isDropTarget(Table table) {
		for (t: ReferenceRegistry.instance.lookup(info.scce.dime.gui.gui.Table)) {
			for (dt: t.dropTargets) {
				if (dt.tableID == table.id) {
					return true;
				}
			}
		}
		return false;
	}
	
	/**
	 * Generates the import statement for the Angular Dart table component
	 */
	def createImports(Table table, GUI gui)
	'''
		import 'package:app/src/tables/«gui.title.escapeDart.toFirstUpper»/Table«ConventionHelper.cincoID(table)»«gui.title.escapeDart.toFirstUpper».dart' as «table.id.escapeDart»;
	'''
	
	/**
	 * Generates the methods for the Angular Dart table component 
	 */
	def createTableMethod(Table table)
	'''
		«tableFunctions(table)»
		
		«IF table.choices != TableChoice.NONE»
			/// the callback if a table row is selected
			void choiceClicked(dynamic value)
			{
				«IF table.choices == TableChoice.MULTIPLE»
					// multiple rows can be selected
					// they are identifiable to their index
					int index = this.«DataDartHelper.getBindedDataName(table,DataAccessType.CHOICE,MODE.GET_INIT,DataTarget)».indexOf(value);
					if (index > -1) {
						this.«DataDartHelper.getBindedDataName(table,DataAccessType.CHOICE,MODE.GET_INIT,DataTarget)».removeAt(index);
					}
					else {
						this.«DataDartHelper.getBindedDataName(table,DataAccessType.CHOICE,MODE.GET_INIT,DataTarget)».add(value);
					}
				«ELSE»
					// only one row can be selected
					this.«DataDartHelper.getBindedDataName(table,DataAccessType.CHOICE,MODE.SET_INIT,DataTarget)»(value);
					this.dime_single_choice.add(this.«DataDartHelper.getBindedDataName(table,DataAccessType.CHOICE,MODE.GET,DataTarget)»);
				«ENDIF»
			}
		«ENDIF»
		
		«FOR TableEntry entry:table.allNodes.filter[n|n instanceof TableEntry].map[n|n as TableEntry]»
			«valueProvider(entry)»
		«ENDFOR»
	'''
	
	/**
	 * Generates the getter for the value of one row in a column for the given object
	 */
	def valueProvider(TableEntry cte)
	'''
		/// getter for the value of the «cte.label» column
		String tableValue«ConventionHelper.cincoID(cte)»Provider(dynamic value) {
			if(value==null)return "";
			«IF cte.getIncoming(TableColumnLoad).empty»
				return "";
			«ELSE»
				String strValue = value«cte.buildFilterAccess»;
				if(strValue == null)return "";
				return strValue;
			«ENDIF»
		}
	'''

	/**
	 * Generates the needed table component methods placed in the Angular Dart class.
	 * The methods realize sorting and filtering functionalities
	 */
	private def tableFunctions(Table table)
	'''
		// returns the filtered and sorted list of objects
		DIMEList table«ConventionHelper.cincoID(table)»getElements(DIMEList source) {
			«IF table.reSortable»
				return source;
			«ELSE»
				«IF !table.isAutoSorted»
					if(!reSortTable && source?.length==cached_source«table.id.escapeDart».length) {
						bool changes = false;
						«boundDataTypeName» l = new DIMEList();
						for(var c in cached_source«table.id.escapeDart») {
							var found = source.where((s)=>s==c);
							if(found.isEmpty) {
								changes = true;
								break;
							}
							l.add(found.first);
						}
						if(!changes) {
							return l;
						} else {
							//reset filter
							«FOR node:ElementCollector.getElementsH(new ArrayList<Node>(table.allNodes)).filter[n|n instanceof TableEntry].map[n|n as TableEntry]»
								// column «node.label»
								«IF node.fullTextSearch»
									«IF AngularTableHTMLTemplate.getIsNumber(node.getIncoming(TableColumnLoad).get(0).sourceElement)»
										filter«ConventionHelper.cincoID(node)»ColumnTo = "";
										filter«ConventionHelper.cincoID(node)»ColumnFrom = "";
									«ELSEIF AngularTableHTMLTemplate.getIsDate(node.getIncoming(TableColumnLoad).get(0).sourceElement)»
										filter«ConventionHelper.cincoID(node)»ColumnTo = "";
										filter«ConventionHelper.cincoID(node)»ColumnFrom = "";
									«ELSE»
										filter«ConventionHelper.cincoID(node)»Column = "";
									«ENDIF»
								«ENDIF»
								«IF node.sortable»
									sortColumn«ConventionHelper.cincoID(node)»Direction = false;
								«ENDIF»
							«ENDFOR»
							//set default sorting
							«FOR tableEntry:table.tableEntrys.filter[n|n.defaultSorting!=TableEntryDefaultSort.NONE]»
								«IF tableEntry.defaultSorting==TableEntryDefaultSort.ASC»
									this.sortColumn«ConventionHelper.cincoID(tableEntry)»Direction = true;
								«ENDIF»
								this.table«ConventionHelper.cincoID(tableEntry)»Sort(null);
							«ENDFOR»
						}
					}
					reSortTable = false;
				«ENDIF»
				«boundDataTypeName» table«ConventionHelper.cincoID(table)»Source = new DIMEList();
				if(source==null) {
					return table«ConventionHelper.cincoID(table)»Source;
				}
				table«ConventionHelper.cincoID(table)»Source.addAll(source.where((element) {
				          return (
				          «FOR  node:ElementCollector.getElementsH(new ArrayList<Node>(table.allNodes)).filter[n|n instanceof TableEntry && (n as TableEntry).fullTextSearch]»
					// filterable column «(node as TableEntry).label»
					«IF AngularTableHTMLTemplate.getIsNumber(node.getIncoming(TableColumnLoad).get(0).sourceElement)»
						this.filterNumeric«ConventionHelper.cincoID(node)»Value(this.tableValue«ConventionHelper.cincoID(node)»Provider(element)) &&
					«ELSEIF AngularTableHTMLTemplate.getIsDate(node.getIncoming(TableColumnLoad).get(0).sourceElement)»
						this.filterDate«ConventionHelper.cincoID(node)»Value(this.tableValue«ConventionHelper.cincoID(node)»Provider(element)) &&
					«ELSE»
						this.tableValue«ConventionHelper.cincoID(node)»Provider(element).toLowerCase().replaceAll(' ','').contains(this.filter«ConventionHelper.cincoID(node)»Column.toLowerCase().replaceAll(' ','')) &&
					«ENDIF»
				«ENDFOR»
				true);
				     }));
				     «FOR node:ElementCollector.getElementsH(new ArrayList<Node>(table.allNodes)).filter[n|n instanceof TableEntry].map[n|n as TableEntry].filter[n|n.sortable]»
				     // column «node.label» is sortable
				     if (this.current«ConventionHelper.cincoID(table)»SortCol == "colId«ConventionHelper.cincoID(node)»") {
				     	table«ConventionHelper.cincoID(table)»Source.sort(table«ConventionHelper.cincoID(node)»SortFun);
				     }
					«ENDFOR»
					«IF table.pagination > 0»
						this.table«ConventionHelper.cincoID(table)»_size = table«ConventionHelper.cincoID(table)»Source.length;
						// pagination with up to «table.pagination» entries per page
						   var from = (this.table«ConventionHelper.cincoID(table)»CurrentPage) * «table.pagination»;
						   var to = from + «table.pagination»;
						   if (to > table«ConventionHelper.cincoID(table)»Source.length) to = table«ConventionHelper.cincoID(table)»Source.length;
						   if (this.table«ConventionHelper.cincoID(table)»CurrentPage > to) this.table«ConventionHelper.cincoID(table)»CurrentPage = to;
						   if(table«ConventionHelper.cincoID(table)»Source.length>=from && table«ConventionHelper.cincoID(table)»Source.length >= to) {
						   		return table«ConventionHelper.cincoID(table)»Source.subDIMEList(from, to);
						   }
						«ENDIF»
						«IF !table.isAutoSorted»
							cached_source«table.id.escapeDart» = table«ConventionHelper.cincoID(table)»Source;
						«ENDIF»
						return table«ConventionHelper.cincoID(table)»Source;
					«ENDIF»
				}
				
				«IF table.pagination > 0»
					/// creates the pagination bar entries
					List<int> table«ConventionHelper.cincoID(table)»getPageCount(int size) {
					    var page_array = new List<int>();
					    int bound = (size / «table.pagination»).ceil();
					    for (var i = 0; i < bound; i++) {
					        page_array.add(i);
					    }
					    return page_array;
					}
					
					/// callback, if the another page is selected
					///
					/// changes the current page of the table
					void table«ConventionHelper.cincoID(table)»changePage(int targetPage,dynamic event) {
						«IF !table.isAutoSorted»
							reSortTable = true;
						«ENDIF»
						int bound = (this.source«table.id.escapeDart».length / «table.pagination»).ceil();
						if (targetPage >= 0 && targetPage < bound) {
						       this.table«ConventionHelper.cincoID(table)»CurrentPage = targetPage;
						   }
						   event.preventDefault();
						   
					}
				«ENDIF»
				
				/// determines if and in which order the given column is sorted
				String table«ConventionHelper.cincoID(table)»IsSorted(String colId) {
					String cssClass = "glyphicon glyphicon-chevron-";
					      «FOR node:ElementCollector.getElementsH(new ArrayList<Node>(table.allNodes)).filter[n|n instanceof TableEntry].map[n|n as TableEntry].filter[n|n.sortable]»
						// column «node.label» is sortable
						if (this.current«ConventionHelper.cincoID(table)»SortCol == colId && colId == "colId«ConventionHelper.cincoID(node)»") {
						    if (this.sortColumn«ConventionHelper.cincoID(node)»Direction) {
						        return cssClass += "down";
						    }
						    return cssClass += "up";
						}
						«ENDFOR»
						return "";
					}
					«FOR node:ElementCollector.getElementsH(new ArrayList<Node>(table.allNodes)).filter[n|n instanceof TableEntry].map[n|n as TableEntry]»
						«IF node.fullTextSearch && !node.getIncoming(TableColumnLoad).empty»
							/// callback, if the filter has changed for column «node.label»
							«IF AngularTableHTMLTemplate.getIsNumber(node.getIncoming(TableColumnLoad).get(0).sourceElement)»
								bool filterNumeric«ConventionHelper.cincoID(node)»Value(String value) {
									«IF !table.isAutoSorted»
										reSortTable = true;
									«ENDIF»
									bool result = true;
									if(value.isNotEmpty) {
										num v = num.parse(value);
										if(this.filter«ConventionHelper.cincoID(node)»ColumnFrom.isNotEmpty){
											num from = num.parse(this.filter«ConventionHelper.cincoID(node)»ColumnFrom);
											result = from <= v;
										}
										if(this.filter«ConventionHelper.cincoID(node)»ColumnTo.isNotEmpty){
											num to = num.parse(this.filter«ConventionHelper.cincoID(node)»ColumnTo);
											result = v <= to && result;
										}
									}
									return result;
								}
								void columnFilter«ConventionHelper.cincoID(node)»SubmitFrom(String value) {
									«IF !table.isAutoSorted»
										reSortTable = true;
									«ENDIF»
									   this.filter«ConventionHelper.cincoID(node)»ColumnFrom = value;
								}
								void columnFilter«ConventionHelper.cincoID(node)»SubmitTo(String value) {
									«IF! table.isAutoSorted»
										reSortTable = true;
									«ENDIF»
									   this.filter«ConventionHelper.cincoID(node)»ColumnTo = value;
								}
							«ELSEIF AngularTableHTMLTemplate.getIsDate(node.getIncoming(TableColumnLoad).get(0).sourceElement)»
								void cb_«node.id.escapeDart»_from(String d) {
									columnFilter«ConventionHelper.cincoID(node)»SubmitFrom(d);
								}
								void cb_«node.id.escapeDart»_to(String d) {
									columnFilter«ConventionHelper.cincoID(node)»SubmitTo(d);
								}
								bool filterDate«ConventionHelper.cincoID(node)»Value(String value) {
									«IF !table.isAutoSorted»
										reSortTable = true;
									«ENDIF»
									bool result = true;
									if(value.isNotEmpty) {
										try {
											var v = DateTime.parse(value);
											if(this.filter«ConventionHelper.cincoID(node)»ColumnFrom.isNotEmpty){
												var from = DateTime.parse(this.filter«ConventionHelper.cincoID(node)»ColumnFrom);
												result = from.isBefore(v.add(new Duration(days: 1)));
											}
											if(this.filter«ConventionHelper.cincoID(node)»ColumnTo.isNotEmpty){
												var to = DateTime.parse(this.filter«ConventionHelper.cincoID(node)»ColumnTo);
												result = v.subtract(new Duration(days: 1)).isBefore(to) && result;
											}
										} catch (e) {
											return true;
										}
									}
									return result;
								}
								void columnFilter«ConventionHelper.cincoID(node)»SubmitFrom(String value) {
									«IF !table.isAutoSorted»
										reSortTable = true;
									«ENDIF»
									   this.filter«ConventionHelper.cincoID(node)»ColumnFrom = value;
								}
								void columnFilter«ConventionHelper.cincoID(node)»SubmitTo(String value) {
									«IF !table.isAutoSorted»
										reSortTable = true;
									«ENDIF»
									   this.filter«ConventionHelper.cincoID(node)»ColumnTo = value;
								}
							«ELSE»
								void columnFilter«ConventionHelper.cincoID(node)»Submit(String value) {
									«IF !table.isAutoSorted»
										reSortTable = true;
									«ENDIF»
									   this.filter«ConventionHelper.cincoID(node)»Column = value;
								}
							«ENDIF»
						«ENDIF»
						«IF node.sortable && !node.getIncoming(TableColumnLoad).empty»
							/// callback, if the sorting has changed for column «node.label»
							void table«ConventionHelper.cincoID(node)»Sort(dynamic event) {
								«IF !table.isAutoSorted»
									reSortTable = true;
								«ENDIF» 
								this.sortColumn«ConventionHelper.cincoID(node)»Direction = ! this.sortColumn«ConventionHelper.cincoID(node)»Direction;
								this.current«ConventionHelper.cincoID(table)»SortCol = "colId«ConventionHelper.cincoID(node)»";
								if(event!=null){
									event.preventDefault();
								}
							}
							/// callback, if the sorting has changed for column «node.label»
							int table«ConventionHelper.cincoID(node)»SortFun(n1,n2) {
								dynamic c1 = n1«node.buildSortAccess()»;
								dynamic c2 = n2«node.buildSortAccess()»;
		«««						«val n1 = DataDartHelper.getTableColumnDataName("n1",node)»
«»					if (c1 == null)
								return 1;
							if (c2 == null)
								return -1;
							if(«node.parseSorter("c1")»?.compareTo(«node.parseSorter("c2")») > 0) {
								return this.sortColumn«ConventionHelper.cincoID(node)»Direction?-1:1;
							}
							if(«node.parseSorter("c1")»?.compareTo(«node.parseSorter("c2")») < 0) {
								return this.sortColumn«ConventionHelper.cincoID(node)»Direction?1:-1;
							}
							return 0;
							}
						«ENDIF»
					«ENDFOR»
				'''
	
	def parseSorter(TableEntry node,String variable)
	'''
		«IF node.isFile»
			«variable».filename
		«ELSEIF node.isDate»
			DateTime.parse(«variable»)
		«ELSEIF node.isNumeric»
			num.parse(«variable»)
		«ELSE»
			«variable»
		«ENDIF»
	'''
	
	/**
	 * Generates the variable declaration needed to enable the table sorting and filtering
	 */
	def createTableDeclaration(Table table)
	'''
		//TABLE SORTING
		String current«ConventionHelper.cincoID(table)»SortCol = "";
		«IF table.pagination > 0»
			// table pagination activated
			int table«ConventionHelper.cincoID(table)»CurrentPage = 0;
			int table«ConventionHelper.cincoID(table)»_size = 0;
		«ENDIF»
		
		«FOR node:ElementCollector.getElementsH(new ArrayList<Node>(table.allNodes)).filter[n|n instanceof TableEntry].map[n|n as TableEntry]»
			// column «node.label»
			«IF node.fullTextSearch»
				«IF AngularTableHTMLTemplate.getIsNumber(node.getIncoming(TableColumnLoad).get(0).sourceElement)»
					String filter«ConventionHelper.cincoID(node)»ColumnTo = "";
					String filter«ConventionHelper.cincoID(node)»ColumnFrom = "";
				«ELSEIF AngularTableHTMLTemplate.getIsDate(node.getIncoming(TableColumnLoad).get(0).sourceElement)»
					String filter«ConventionHelper.cincoID(node)»ColumnTo = "";
					String filter«ConventionHelper.cincoID(node)»ColumnFrom = "";
				«ELSE»
					String filter«ConventionHelper.cincoID(node)»Column = "";
				«ENDIF»
			«ENDIF»
			«IF node.sortable»
				bool sortColumn«ConventionHelper.cincoID(node)»Direction = false;
			«ENDIF»
		«ENDFOR»
	'''
	
	/**
	 * Generates the variable declaration needed to enable the table sorting and filtering
	 */
	def createTableRestart(Table table)
	'''
		//TABLE SORTING
		current«ConventionHelper.cincoID(table)»SortCol = "";
		«IF table.pagination > 0»
			// table pagination activated
			table«ConventionHelper.cincoID(table)»CurrentPage = 0;
			table«ConventionHelper.cincoID(table)»_size = 0;
		«ENDIF»
		
		«FOR node:ElementCollector.getElementsH(new ArrayList<Node>(table.allNodes)).filter[n|n instanceof TableEntry].map[n|n as TableEntry]»
			// column «node.label»
			«IF node.fullTextSearch»
				«IF AngularTableHTMLTemplate.getIsNumber(node.getIncoming(TableColumnLoad).get(0).sourceElement)»
					filter«ConventionHelper.cincoID(node)»ColumnTo = "";
					filter«ConventionHelper.cincoID(node)»ColumnFrom = "";
				«ELSEIF AngularTableHTMLTemplate.getIsDate(node.getIncoming(TableColumnLoad).get(0).sourceElement)»
					filter«ConventionHelper.cincoID(node)»ColumnTo = "";
					filter«ConventionHelper.cincoID(node)»ColumnFrom = "";
				«ELSE»
					filter«ConventionHelper.cincoID(node)»Column = "";
				«ENDIF»
			«ENDIF»
			«IF node.sortable»
				sortColumn«ConventionHelper.cincoID(node)»Direction = false;
			«ENDIF»
		«ENDFOR»
	'''
	
	/**
	 * Helper methods which checks if the connected variable or attribute is
	 * a primitive file
	 */
	private def boolean isFile(TableEntry cte)
	{
		for(cpa :cte.getIncoming(TableColumnLoad).map[sourceElement])
		{
			if(cpa instanceof PrimitiveAttribute) {
				return cpa.attribute.dataType == PrimitiveType.FILE;				
			}
			if(cpa instanceof PrimitiveVariable) {
				return cpa.dataType.toData == PrimitiveType.FILE;
			}
		}
		false
	}
	
	/**
	 * Helper methods which checks if the connected variable or attribute is
	 * a primitive file
	 */
	private def boolean isDate(TableEntry cte)
	{
		for(cpa :cte.getIncoming(TableColumnLoad).map[sourceElement])
		{
			if(cpa instanceof PrimitiveAttribute) {
				return cpa.attribute.dataType == PrimitiveType.TIMESTAMP;				
			}
			if(cpa instanceof PrimitiveVariable) {
				return cpa.dataType.toData == PrimitiveType.TIMESTAMP;
			}
		}
		false
	}
	
	/**
	 * Helper methods which checks if the connected variable or attribute is
	 * a primitive file
	 */
	private def boolean isNumeric(TableEntry cte)
	{
		for(cpa :cte.getIncoming(TableColumnLoad).map[sourceElement])
		{
			if(cpa instanceof PrimitiveAttribute) {
				return cpa.attribute.dataType == PrimitiveType.INTEGER;				
			}
			if(cpa instanceof PrimitiveVariable) {
				return cpa.dataType.toData == PrimitiveType.INTEGER;
			}
			if(cpa instanceof PrimitiveListAttribute) {
				return cpa.attributeName == PrimitiveListAttributeName.SIZE;
			}
		}
		false
	}
	
	private def String buildSortAccess(TableEntry cte){
		cte.buildAccess
	}
	
	private def String buildFilterAccess(TableEntry cte){
		cte.buildAccess
	}
	
	private def String buildAccess(TableEntry cte){
		val table = cte.container as Table;
		val tableSource = table.getIncoming(TableLoad).get(0).sourceElement as ComplexVariable;
		val columnSource = cte.getIncoming(TableColumnLoad).get(0).sourceElement
		val tableIterator = tableSource.getOutgoing(ComplexListAttributeConnector).findFirst[attributeName==ComplexListAttributeName.CURRENT]
		if(tableIterator!=null){
			val wayToTableColumnLoad = columnSource.wayToTableSource(tableIterator.targetElement,new LinkedList).reverse
			return wayToTableColumnLoad.iterator.getRenderFlatMap(null)
		}
	}
	def String getRenderFlatMap(Iterator<Node> iterator){
		iterator.getRenderFlatMap(null)
	}
	
	def String getRenderFlatMap(Iterator<Node> iterator,ComplexVariable preVar){
		if(!iterator.hasNext)return '''?.toString()'''
		val node = iterator.next
		if(node instanceof ComplexVariable){
			if(node.isIsList){
				//expand
				return '''?.«node.name.escapeDart»«iterator.getRenderFlatMap(node)»'''
			}
			if(!node.getIncoming(ComplexListAttributeConnector).empty) {
				//iterator variable
				val connector = node.getIncoming(ComplexListAttributeConnector).findFirst[sourceElement.equals(preVar)]
				if(connector.attributeName==ComplexListAttributeName.CURRENT){
					return '''?.map((«node.name.escapeDart»)=>«node.name.escapeDart»«iterator.renderFlatMap»)?.toList()?.join("")'''
				}
				return '''?.«node.name.escapeDart»()«iterator.renderFlatMap»'''
			}
			if(!node.getIncoming(ComplexAttributeConnector).empty) {
				//complex expanded attribute variable
				return '''?.«node.name.escapeDart»«iterator.renderFlatMap»'''
			}
		}
		if(node instanceof PrimitiveAttribute){
			return '''?.«(node as PrimitiveAttribute).attribute.name.escapeDart»?.toString()'''
		}
		if(node instanceof PrimitiveExtensionAttribute){
			return '''?.«(node as PrimitiveExtensionAttribute).attribute.name.escapeDart»?.toString()'''
		}
		if(node instanceof ComplexListAttribute){
			return '''?.«node.attributeName.literal»?.toString()'''
		}
		if(node instanceof PrimitiveListAttribute){
			return '''?.«node.attributeName.literal»?.toString()'''
		}
		if(node instanceof ComplexAttribute){
			return '''?.«(node as ComplexAttribute).attribute.name.escapeDart»?.toString()'''
		}
		if(node instanceof ComplexExtensionAttribute){
			return '''?.«(node as ComplexExtensionAttribute).attribute.name.escapeDart»?.toString()'''
		}
	}
	
	def dispatch List<Node> wayToTableSource(Attribute node, ComplexVariable variable,List<Node> list){
		list+=node
		return (node.container as Node).wayToTableSource(variable,list)
	}
	
	def dispatch List<Node> wayToTableSource(ComplexVariable node, ComplexVariable variable,List<Node> list){
		if(node.id.equals(variable.id)){
			return list
		}
		list+=node
		if(!node.getIncoming(ComplexListAttributeConnector).empty) {
			return node.getIncoming(ComplexListAttributeConnector).get(0).sourceElement.wayToTableSource(variable,list)
		}
		if(!node.getIncoming(ComplexAttributeConnector).empty) {
			return node.getIncoming(ComplexAttributeConnector).get(0).sourceElement.wayToTableSource(variable,list)
		}
		throw new IllegalStateException("No way to table root found")
	}
}
