/*-
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.generator.data

import info.scce.dime.dad.dad.DAD
import info.scce.dime.data.data.BidirectionalAttribute
import info.scce.dime.data.data.Data
import info.scce.dime.data.data.Type
import java.util.List

import static extension info.scce.dime.generator.util.JavaIdentifierUtils.*

class DataModelsGeneratorHelper extends DataGeneratorHelper {
	def generate(DAD dad, List<Data> models) '''
		package info.scce.dime.data;

		import de.ls5.dywa.connect.DyWAConnector;
		import de.ls5.dywa.connect.DyWADataHelper;
		import de.ls5.dywa.entities.property.PropertyType;

		import javax.enterprise.context.RequestScoped;
		import javax.inject.Inject;
		import javax.inject.Named;
		import java.nio.file.Path;
		import java.io.IOException;
		import java.util.List;
		import java.util.LinkedList;
		import de.ls5.dywa.annotations.ExecutionPriority;
		
		/**
		 * Generated by {@code DataModelsGenerator}.
		 */
		@Named
		@RequestScoped
		@ExecutionPriority(3)
		public class DIMEDataConnector«dad.appName.escapeJava.toFirstUpper» implements DyWAConnector {
			@Inject
			private DyWADataHelper data;
			
			@Override
			public void interactWithDyWA() {
				data.load("DyWADataModel: «dad.appName»");

				final List<DataConnector> dataConnectors = new LinkedList<>();
				«FOR model: models»
					dataConnectors.add(new DataConnector«model.modelName.toFirstUpper.escapeJava»(data));
				«ENDFOR»
				
				dataConnectors.forEach(DataConnector::createTypes);
				dataConnectors.forEach(DataConnector::configInheritance);
				dataConnectors.forEach(DataConnector::createFields);
				dataConnectors.forEach(DataConnector::configOverridingFields);
				dataConnectors.forEach(DataConnector::configBidirectionalMappings);
				
				data.cleanupDataModel();
				data.store();
			}
			
			private interface DataConnector {
				void createTypes();
				void configInheritance();
				void createFields();
				void configOverridingFields();
				void configBidirectionalMappings();
			}
			
			«FOR model: models»
				«doSwitch(model)»
			«ENDFOR»
		}
	'''
	
	override caseData(Data model) '''
		private static class DataConnector«model.modelName.toFirstUpper.escapeJava» implements DataConnector {
			private DyWADataHelper data;
			
			public DataConnector«model.modelName.toFirstUpper.escapeJava»(DyWADataHelper data) {
				this.data = data;
			}
			
			@Override
			public void createTypes() {
				«FOR type: model.filterOriginalTypes»
					«doSwitch(type)»
				«ENDFOR»
			}
			
			@Override
			public void configInheritance() {
				«FOR type: model.filterOriginalTypes.filter(x | x.directSuperTypes.size > 0)»
					// Add super types for '«type.name»'.
					 «FOR superType: type.directSuperTypes»
					 	// Add super type '«superType.name»'. 
					 	data.addSuperType("«type.id»", "«superType.id»");
					 	
					 «ENDFOR»
				«ENDFOR»
			}
			
			@Override
			public void createFields() {
				«FOR type: model.filterOriginalTypes.filter[nonOverridingAttributes.size > 0]»
					{
						
						// Add fields for '«type.name»'.
						«FOR attribute: type.nonOverridingAttributes»
							«doSwitch(attribute, type)»
						«ENDFOR»
					}
				«ENDFOR»
				
				data.initializeProperties();
				data.migrateListToSingle();
				data.migrateSingleToList();
			}
			
			@Override
			public void configOverridingFields() {
				«FOR type: model.filterOriginalTypes.filter[overridingPrimitiveAttributes.size + overridingComplexAttributes.size > 0]»
					// Override fields for '«type.name»'.
					«FOR attribute: type.overridingComplexAttributes»
						// Override complex field '«attribute.superAttr.originalAttribute.name»' of type '«(attribute.superAttr.container as Type).name»'.
						«overridingComplexAttribute(attribute, type)»
					«ENDFOR»
					«FOR attribute: type.overridingPrimitiveAttributes»
						// Override primitive field '«attribute.superAttr.originalAttribute.name»' of type '«attribute.superAttr.dataType.getName()»'.
						«overridingPrimitiveAttribute(attribute, type)»
					«ENDFOR»
				«ENDFOR»
			}
			
			@Override
			public void configBidirectionalMappings() {
				«FOR type: model.filterOriginalTypes.filter[!originalAttributes.filter(BidirectionalAttribute).empty]»
					// Add bidirectional mappings for '«type.name»'.
					«FOR attribute: type.originalAttributes.filter(BidirectionalAttribute)»
						// Map '«attribute.name»' to '«attribute.oppositeAttribute.name»'.
						data.markAsBidirectionalAssociation("«attribute.id»", "«attribute.oppositeAttribute.id»");
					«ENDFOR»
					
				«ENDFOR»
			}
		}
	'''
}
