/*-
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
 
package info.scce.dime.generator.dad

import de.jabc.cinco.meta.plugin.dsl.ProjectDescriptionLanguage
import info.scce.dime.generator.util.DimeIOExtension
import info.scce.dime.dad.dad.DAD
import java.nio.file.Path

/**
 * Generator for the shiro.ini file.
 */
class ShiroIniGenerator {
	
	protected extension ProjectDescriptionLanguage = new ProjectDescriptionLanguage
	protected extension DimeIOExtension = new DimeIOExtension
	
	def generate(DAD dad, Path outlet) {
		outlet
			.resolve("dywa-app")
			.resolve("app-presentation")
			.resolve("src")
			.resolve("main")
			.resolve("webapp")
			.resolve("WEB-INF")
			.createDirectories()
			.resolve("shiro.ini")
			.writeString(dad.template)
	}
	
	def template(DAD dad) '''
		[main]
		dimeRealm = info.scce.dime.auth.DIMERealm
		securityManager.realms = $dimeRealm
		securityManager.subjectDAO.sessionStorageEvaluator.sessionStorageEnabled = false
		
		jwtAuthenticator = info.scce.dime.auth.JWTAuthenticationFilter
		
		[urls]
		«IF !dad.graphQLComponents.empty»
			/graphql/** = jwtAuthenticator
		«ENDIF»
		/rest/**/public = jwtAuthenticator
		/rest/health = anon
		/rest/** = jwtAuthenticator
		/** = anon
	'''
	
}
