package info.scce.dime.gui.gui.gratext.scoping

import graphmodel.internal.InternalIdentifiableElement
import info.scce.dime.gui.gui.gratext.*

import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EReference
import org.eclipse.xtext.naming.QualifiedName
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider

import static extension org.eclipse.xtext.EcoreUtil2.getRootContainer
import static extension org.eclipse.xtext.scoping.Scopes.scopeFor

/**
 * This class contains custom scoping description.
 */
class GUIGratextScopeProvider extends AbstractDeclarativeScopeProvider {
	
	override getScope(EObject context, EReference reference) {
		getScope(context, reference.name) ?: super.getScope(context, reference)
	}
	
	dispatch def IScope getScope(EObject element, String refName) {
		null
	}
	
	dispatch def IScope getScope(^GratextInternalComplexWrite element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalComplexOutputPort,
				info.scce.dime.gui.gui.internal.InternalComplexVariable,
				info.scce.dime.gui.gui.internal.InternalComplexAttribute
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalPrimitiveWrite element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalPrimitiveOutputPort,
				info.scce.dime.gui.gui.internal.InternalPrimitiveVariable,
				info.scce.dime.gui.gui.internal.InternalPrimitiveAttribute
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalFOR element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalField,
				info.scce.dime.gui.gui.internal.InternalBottomNavBar,
				info.scce.dime.gui.gui.internal.InternalFORSIB,
				info.scce.dime.gui.gui.internal.InternalSpecialElement,
				info.scce.dime.gui.gui.internal.InternalTable,
				info.scce.dime.gui.gui.internal.InternalTableEntry,
				info.scce.dime.gui.gui.internal.InternalCol,
				info.scce.dime.gui.gui.internal.InternalTopNavBar,
				info.scce.dime.gui.gui.internal.InternalBadge,
				info.scce.dime.gui.gui.internal.InternalComplexVariable,
				info.scce.dime.gui.gui.internal.InternalBox,
				info.scce.dime.gui.gui.internal.InternalArgument,
				info.scce.dime.gui.gui.internal.InternalLinkProcessSIB,
				info.scce.dime.gui.gui.internal.InternalFormEntry,
				info.scce.dime.gui.gui.internal.InternalForm,
				info.scce.dime.gui.gui.internal.InternalDropdown,
				info.scce.dime.gui.gui.internal.InternalButtonToolbar,
				info.scce.dime.gui.gui.internal.InternalCheckbox,
				info.scce.dime.gui.gui.internal.InternalProgressBar,
				info.scce.dime.gui.gui.internal.InternalGUIPlugin,
				info.scce.dime.gui.gui.internal.InternalEmbedded,
				info.scce.dime.gui.gui.internal.InternalPlaceholder,
				info.scce.dime.gui.gui.internal.InternalTODOList,
				info.scce.dime.gui.gui.internal.InternalText,
				info.scce.dime.gui.gui.internal.InternalButton,
				info.scce.dime.gui.gui.internal.InternalListentry,
				info.scce.dime.gui.gui.internal.InternalBaseElement,
				info.scce.dime.gui.gui.internal.InternalInput,
				info.scce.dime.gui.gui.internal.InternalRadio,
				info.scce.dime.gui.gui.internal.InternalGUISIB,
				info.scce.dime.gui.gui.internal.InternalRow,
				info.scce.dime.gui.gui.internal.InternalDescription,
				info.scce.dime.gui.gui.internal.InternalPageUp,
				info.scce.dime.gui.gui.internal.InternalBar,
				info.scce.dime.gui.gui.internal.InternalJumbotron,
				info.scce.dime.gui.gui.internal.InternalFile,
				info.scce.dime.gui.gui.internal.InternalIFSIB,
				info.scce.dime.gui.gui.internal.InternalRightNavBarPart,
				info.scce.dime.gui.gui.internal.InternalThumbnail,
				info.scce.dime.gui.gui.internal.InternalListing,
				info.scce.dime.gui.gui.internal.InternalDispatchedGUISIB,
				info.scce.dime.gui.gui.internal.InternalHeadline,
				info.scce.dime.gui.gui.internal.InternalDescriptionentry,
				info.scce.dime.gui.gui.internal.InternalButtonGroup,
				info.scce.dime.gui.gui.internal.InternalLinkSIB,
				info.scce.dime.gui.gui.internal.InternalTab,
				info.scce.dime.gui.gui.internal.InternalTabbing,
				info.scce.dime.gui.gui.internal.InternalSecuritySIB,
				info.scce.dime.gui.gui.internal.InternalControlSIB,
				info.scce.dime.gui.gui.internal.InternalLeftNavBarPart,
				info.scce.dime.gui.gui.internal.InternalImage,
				info.scce.dime.gui.gui.internal.InternalProcessSIB,
				info.scce.dime.gui.gui.internal.InternalSelect,
				info.scce.dime.gui.gui.internal.InternalCombobox,
				info.scce.dime.gui.gui.internal.InternalGuardSIB,
				info.scce.dime.gui.gui.internal.InternalISSIB,
				info.scce.dime.gui.gui.internal.InternalPanel,
				info.scce.dime.gui.gui.internal.InternalSIB,
				info.scce.dime.gui.gui.internal.InternalAlert
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalPrimitiveChoiceData element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalCheckbox,
				info.scce.dime.gui.gui.internal.InternalPrimitiveVariable,
				info.scce.dime.gui.gui.internal.InternalRadio,
				info.scce.dime.gui.gui.internal.InternalPrimitiveAttribute,
				info.scce.dime.gui.gui.internal.InternalPrimitiveExtensionAttribute,
				info.scce.dime.gui.gui.internal.InternalSelect,
				info.scce.dime.gui.gui.internal.InternalCombobox
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalPrimitiveFOR element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalField,
				info.scce.dime.gui.gui.internal.InternalBottomNavBar,
				info.scce.dime.gui.gui.internal.InternalFORSIB,
				info.scce.dime.gui.gui.internal.InternalSpecialElement,
				info.scce.dime.gui.gui.internal.InternalTable,
				info.scce.dime.gui.gui.internal.InternalTableEntry,
				info.scce.dime.gui.gui.internal.InternalCol,
				info.scce.dime.gui.gui.internal.InternalTopNavBar,
				info.scce.dime.gui.gui.internal.InternalBadge,
				info.scce.dime.gui.gui.internal.InternalBox,
				info.scce.dime.gui.gui.internal.InternalArgument,
				info.scce.dime.gui.gui.internal.InternalLinkProcessSIB,
				info.scce.dime.gui.gui.internal.InternalFormEntry,
				info.scce.dime.gui.gui.internal.InternalForm,
				info.scce.dime.gui.gui.internal.InternalDropdown,
				info.scce.dime.gui.gui.internal.InternalButtonToolbar,
				info.scce.dime.gui.gui.internal.InternalCheckbox,
				info.scce.dime.gui.gui.internal.InternalProgressBar,
				info.scce.dime.gui.gui.internal.InternalGUIPlugin,
				info.scce.dime.gui.gui.internal.InternalEmbedded,
				info.scce.dime.gui.gui.internal.InternalPlaceholder,
				info.scce.dime.gui.gui.internal.InternalTODOList,
				info.scce.dime.gui.gui.internal.InternalPrimitiveVariable,
				info.scce.dime.gui.gui.internal.InternalText,
				info.scce.dime.gui.gui.internal.InternalButton,
				info.scce.dime.gui.gui.internal.InternalListentry,
				info.scce.dime.gui.gui.internal.InternalBaseElement,
				info.scce.dime.gui.gui.internal.InternalInput,
				info.scce.dime.gui.gui.internal.InternalRadio,
				info.scce.dime.gui.gui.internal.InternalGUISIB,
				info.scce.dime.gui.gui.internal.InternalRow,
				info.scce.dime.gui.gui.internal.InternalDescription,
				info.scce.dime.gui.gui.internal.InternalPageUp,
				info.scce.dime.gui.gui.internal.InternalBar,
				info.scce.dime.gui.gui.internal.InternalJumbotron,
				info.scce.dime.gui.gui.internal.InternalPrimitiveAttribute,
				info.scce.dime.gui.gui.internal.InternalPrimitiveExtensionAttribute,
				info.scce.dime.gui.gui.internal.InternalFile,
				info.scce.dime.gui.gui.internal.InternalIFSIB,
				info.scce.dime.gui.gui.internal.InternalRightNavBarPart,
				info.scce.dime.gui.gui.internal.InternalThumbnail,
				info.scce.dime.gui.gui.internal.InternalListing,
				info.scce.dime.gui.gui.internal.InternalDispatchedGUISIB,
				info.scce.dime.gui.gui.internal.InternalHeadline,
				info.scce.dime.gui.gui.internal.InternalDescriptionentry,
				info.scce.dime.gui.gui.internal.InternalButtonGroup,
				info.scce.dime.gui.gui.internal.InternalLinkSIB,
				info.scce.dime.gui.gui.internal.InternalTab,
				info.scce.dime.gui.gui.internal.InternalTabbing,
				info.scce.dime.gui.gui.internal.InternalSecuritySIB,
				info.scce.dime.gui.gui.internal.InternalControlSIB,
				info.scce.dime.gui.gui.internal.InternalLeftNavBarPart,
				info.scce.dime.gui.gui.internal.InternalImage,
				info.scce.dime.gui.gui.internal.InternalProcessSIB,
				info.scce.dime.gui.gui.internal.InternalSelect,
				info.scce.dime.gui.gui.internal.InternalCombobox,
				info.scce.dime.gui.gui.internal.InternalGuardSIB,
				info.scce.dime.gui.gui.internal.InternalISSIB,
				info.scce.dime.gui.gui.internal.InternalPanel,
				info.scce.dime.gui.gui.internal.InternalSIB,
				info.scce.dime.gui.gui.internal.InternalAlert
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalComplexListAttributeConnector element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalComplexVariable
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalFormLoadSubmit element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalField,
				info.scce.dime.gui.gui.internal.InternalComplexVariable,
				info.scce.dime.gui.gui.internal.InternalComplexAttribute,
				info.scce.dime.gui.gui.internal.InternalForm,
				info.scce.dime.gui.gui.internal.InternalCheckbox,
				info.scce.dime.gui.gui.internal.InternalPrimitiveVariable,
				info.scce.dime.gui.gui.internal.InternalRadio,
				info.scce.dime.gui.gui.internal.InternalPrimitiveAttribute,
				info.scce.dime.gui.gui.internal.InternalSelect,
				info.scce.dime.gui.gui.internal.InternalCombobox
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalComplexDataTarget element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalTable,
				info.scce.dime.gui.gui.internal.InternalComplexVariable,
				info.scce.dime.gui.gui.internal.InternalComplexAttribute
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalDisplay element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalComplexVariable,
				info.scce.dime.gui.gui.internal.InternalCheckbox,
				info.scce.dime.gui.gui.internal.InternalProgressBar,
				info.scce.dime.gui.gui.internal.InternalPrimitiveVariable,
				info.scce.dime.gui.gui.internal.InternalRadio,
				info.scce.dime.gui.gui.internal.InternalPrimitiveAttribute,
				info.scce.dime.gui.gui.internal.InternalPrimitiveExtensionAttribute,
				info.scce.dime.gui.gui.internal.InternalSelect,
				info.scce.dime.gui.gui.internal.InternalCombobox,
				info.scce.dime.gui.gui.internal.InternalPanel
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalTableLoad element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalTable,
				info.scce.dime.gui.gui.internal.InternalComplexVariable,
				info.scce.dime.gui.gui.internal.InternalPrimitiveAttribute,
				info.scce.dime.gui.gui.internal.InternalPrimitiveExtensionAttribute
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalFormSubmit element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalField,
				info.scce.dime.gui.gui.internal.InternalComplexVariable,
				info.scce.dime.gui.gui.internal.InternalComplexAttribute,
				info.scce.dime.gui.gui.internal.InternalForm,
				info.scce.dime.gui.gui.internal.InternalCheckbox,
				info.scce.dime.gui.gui.internal.InternalPrimitiveVariable,
				info.scce.dime.gui.gui.internal.InternalRadio,
				info.scce.dime.gui.gui.internal.InternalPrimitiveAttribute,
				info.scce.dime.gui.gui.internal.InternalSelect,
				info.scce.dime.gui.gui.internal.InternalCombobox
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalIS element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalField,
				info.scce.dime.gui.gui.internal.InternalBottomNavBar,
				info.scce.dime.gui.gui.internal.InternalComplexExtensionAttribute,
				info.scce.dime.gui.gui.internal.InternalFORSIB,
				info.scce.dime.gui.gui.internal.InternalSpecialElement,
				info.scce.dime.gui.gui.internal.InternalTable,
				info.scce.dime.gui.gui.internal.InternalTableEntry,
				info.scce.dime.gui.gui.internal.InternalCol,
				info.scce.dime.gui.gui.internal.InternalTopNavBar,
				info.scce.dime.gui.gui.internal.InternalBadge,
				info.scce.dime.gui.gui.internal.InternalComplexVariable,
				info.scce.dime.gui.gui.internal.InternalBox,
				info.scce.dime.gui.gui.internal.InternalComplexAttribute,
				info.scce.dime.gui.gui.internal.InternalArgument,
				info.scce.dime.gui.gui.internal.InternalLinkProcessSIB,
				info.scce.dime.gui.gui.internal.InternalFormEntry,
				info.scce.dime.gui.gui.internal.InternalForm,
				info.scce.dime.gui.gui.internal.InternalDropdown,
				info.scce.dime.gui.gui.internal.InternalButtonToolbar,
				info.scce.dime.gui.gui.internal.InternalCheckbox,
				info.scce.dime.gui.gui.internal.InternalProgressBar,
				info.scce.dime.gui.gui.internal.InternalGUIPlugin,
				info.scce.dime.gui.gui.internal.InternalEmbedded,
				info.scce.dime.gui.gui.internal.InternalPlaceholder,
				info.scce.dime.gui.gui.internal.InternalTODOList,
				info.scce.dime.gui.gui.internal.InternalText,
				info.scce.dime.gui.gui.internal.InternalButton,
				info.scce.dime.gui.gui.internal.InternalListentry,
				info.scce.dime.gui.gui.internal.InternalBaseElement,
				info.scce.dime.gui.gui.internal.InternalInput,
				info.scce.dime.gui.gui.internal.InternalRadio,
				info.scce.dime.gui.gui.internal.InternalGUISIB,
				info.scce.dime.gui.gui.internal.InternalRow,
				info.scce.dime.gui.gui.internal.InternalDescription,
				info.scce.dime.gui.gui.internal.InternalPageUp,
				info.scce.dime.gui.gui.internal.InternalBar,
				info.scce.dime.gui.gui.internal.InternalJumbotron,
				info.scce.dime.gui.gui.internal.InternalFile,
				info.scce.dime.gui.gui.internal.InternalIFSIB,
				info.scce.dime.gui.gui.internal.InternalRightNavBarPart,
				info.scce.dime.gui.gui.internal.InternalThumbnail,
				info.scce.dime.gui.gui.internal.InternalListing,
				info.scce.dime.gui.gui.internal.InternalDispatchedGUISIB,
				info.scce.dime.gui.gui.internal.InternalHeadline,
				info.scce.dime.gui.gui.internal.InternalDescriptionentry,
				info.scce.dime.gui.gui.internal.InternalButtonGroup,
				info.scce.dime.gui.gui.internal.InternalLinkSIB,
				info.scce.dime.gui.gui.internal.InternalTab,
				info.scce.dime.gui.gui.internal.InternalTabbing,
				info.scce.dime.gui.gui.internal.InternalSecuritySIB,
				info.scce.dime.gui.gui.internal.InternalControlSIB,
				info.scce.dime.gui.gui.internal.InternalLeftNavBarPart,
				info.scce.dime.gui.gui.internal.InternalImage,
				info.scce.dime.gui.gui.internal.InternalProcessSIB,
				info.scce.dime.gui.gui.internal.InternalSelect,
				info.scce.dime.gui.gui.internal.InternalCombobox,
				info.scce.dime.gui.gui.internal.InternalGuardSIB,
				info.scce.dime.gui.gui.internal.InternalISSIB,
				info.scce.dime.gui.gui.internal.InternalPanel,
				info.scce.dime.gui.gui.internal.InternalSIB,
				info.scce.dime.gui.gui.internal.InternalAlert
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalAddPrimitiveToSubmission element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalPrimitiveVariable,
				info.scce.dime.gui.gui.internal.InternalButton,
				info.scce.dime.gui.gui.internal.InternalPrimitiveAttribute,
				info.scce.dime.gui.gui.internal.InternalPrimitiveExtensionAttribute,
				info.scce.dime.gui.gui.internal.InternalPrimitiveListAttribute
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalPrimitiveRead element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalPrimitiveVariable,
				info.scce.dime.gui.gui.internal.InternalPrimitiveInputPort,
				info.scce.dime.gui.gui.internal.InternalPrimitiveAttribute,
				info.scce.dime.gui.gui.internal.InternalPrimitiveExtensionAttribute,
				info.scce.dime.gui.gui.internal.InternalPrimitiveListAttribute
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalComplexChoiceData element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalComplexExtensionAttribute,
				info.scce.dime.gui.gui.internal.InternalComplexVariable,
				info.scce.dime.gui.gui.internal.InternalComplexAttribute,
				info.scce.dime.gui.gui.internal.InternalCheckbox,
				info.scce.dime.gui.gui.internal.InternalRadio,
				info.scce.dime.gui.gui.internal.InternalSelect,
				info.scce.dime.gui.gui.internal.InternalCombobox
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalRegistration element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalEvent,
				info.scce.dime.gui.gui.internal.InternalEventListener
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalPrimitivDataTarget element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalTable,
				info.scce.dime.gui.gui.internal.InternalPrimitiveVariable,
				info.scce.dime.gui.gui.internal.InternalPrimitiveAttribute
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalSetGenericType element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalOutputGeneric,
				info.scce.dime.gui.gui.internal.InternalComplexVariable,
				info.scce.dime.gui.gui.internal.InternalComplexAttribute,
				info.scce.dime.gui.gui.internal.InternalInputGeneric
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalComplexRead element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalComplexExtensionAttribute,
				info.scce.dime.gui.gui.internal.InternalComplexVariable,
				info.scce.dime.gui.gui.internal.InternalComplexAttribute,
				info.scce.dime.gui.gui.internal.InternalComplexInputPort
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalComplexAttributeConnector element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalComplexVariable
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalIF element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalField,
				info.scce.dime.gui.gui.internal.InternalBottomNavBar,
				info.scce.dime.gui.gui.internal.InternalComplexExtensionAttribute,
				info.scce.dime.gui.gui.internal.InternalFORSIB,
				info.scce.dime.gui.gui.internal.InternalSpecialElement,
				info.scce.dime.gui.gui.internal.InternalTable,
				info.scce.dime.gui.gui.internal.InternalTableEntry,
				info.scce.dime.gui.gui.internal.InternalCol,
				info.scce.dime.gui.gui.internal.InternalTopNavBar,
				info.scce.dime.gui.gui.internal.InternalBadge,
				info.scce.dime.gui.gui.internal.InternalComplexVariable,
				info.scce.dime.gui.gui.internal.InternalBox,
				info.scce.dime.gui.gui.internal.InternalComplexAttribute,
				info.scce.dime.gui.gui.internal.InternalArgument,
				info.scce.dime.gui.gui.internal.InternalLinkProcessSIB,
				info.scce.dime.gui.gui.internal.InternalFormEntry,
				info.scce.dime.gui.gui.internal.InternalForm,
				info.scce.dime.gui.gui.internal.InternalDropdown,
				info.scce.dime.gui.gui.internal.InternalButtonToolbar,
				info.scce.dime.gui.gui.internal.InternalCheckbox,
				info.scce.dime.gui.gui.internal.InternalProgressBar,
				info.scce.dime.gui.gui.internal.InternalGUIPlugin,
				info.scce.dime.gui.gui.internal.InternalEmbedded,
				info.scce.dime.gui.gui.internal.InternalPlaceholder,
				info.scce.dime.gui.gui.internal.InternalTODOList,
				info.scce.dime.gui.gui.internal.InternalPrimitiveVariable,
				info.scce.dime.gui.gui.internal.InternalText,
				info.scce.dime.gui.gui.internal.InternalButton,
				info.scce.dime.gui.gui.internal.InternalListentry,
				info.scce.dime.gui.gui.internal.InternalBaseElement,
				info.scce.dime.gui.gui.internal.InternalInput,
				info.scce.dime.gui.gui.internal.InternalRadio,
				info.scce.dime.gui.gui.internal.InternalGUISIB,
				info.scce.dime.gui.gui.internal.InternalRow,
				info.scce.dime.gui.gui.internal.InternalDescription,
				info.scce.dime.gui.gui.internal.InternalPageUp,
				info.scce.dime.gui.gui.internal.InternalBar,
				info.scce.dime.gui.gui.internal.InternalJumbotron,
				info.scce.dime.gui.gui.internal.InternalPrimitiveAttribute,
				info.scce.dime.gui.gui.internal.InternalPrimitiveExtensionAttribute,
				info.scce.dime.gui.gui.internal.InternalFile,
				info.scce.dime.gui.gui.internal.InternalPrimitiveListAttribute,
				info.scce.dime.gui.gui.internal.InternalIFSIB,
				info.scce.dime.gui.gui.internal.InternalRightNavBarPart,
				info.scce.dime.gui.gui.internal.InternalThumbnail,
				info.scce.dime.gui.gui.internal.InternalListing,
				info.scce.dime.gui.gui.internal.InternalDispatchedGUISIB,
				info.scce.dime.gui.gui.internal.InternalHeadline,
				info.scce.dime.gui.gui.internal.InternalDescriptionentry,
				info.scce.dime.gui.gui.internal.InternalButtonGroup,
				info.scce.dime.gui.gui.internal.InternalLinkSIB,
				info.scce.dime.gui.gui.internal.InternalTab,
				info.scce.dime.gui.gui.internal.InternalTabbing,
				info.scce.dime.gui.gui.internal.InternalSecuritySIB,
				info.scce.dime.gui.gui.internal.InternalControlSIB,
				info.scce.dime.gui.gui.internal.InternalLeftNavBarPart,
				info.scce.dime.gui.gui.internal.InternalImage,
				info.scce.dime.gui.gui.internal.InternalProcessSIB,
				info.scce.dime.gui.gui.internal.InternalSelect,
				info.scce.dime.gui.gui.internal.InternalCombobox,
				info.scce.dime.gui.gui.internal.InternalGuardSIB,
				info.scce.dime.gui.gui.internal.InternalISSIB,
				info.scce.dime.gui.gui.internal.InternalPanel,
				info.scce.dime.gui.gui.internal.InternalSIB,
				info.scce.dime.gui.gui.internal.InternalAlert
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalAddComplexToSubmission element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalComplexVariable,
				info.scce.dime.gui.gui.internal.InternalButton
				 )
		}
	}
	
	dispatch def IScope getScope(^GratextInternalTableColumnLoad element, String refName) {
		switch refName {
			case "_targetElement": element.scopeForContents(
				info.scce.dime.gui.gui.internal.InternalComplexExtensionAttribute,
				info.scce.dime.gui.gui.internal.InternalTableEntry,
				info.scce.dime.gui.gui.internal.InternalComplexVariable,
				info.scce.dime.gui.gui.internal.InternalComplexAttribute,
				info.scce.dime.gui.gui.internal.InternalPrimitiveAttribute,
				info.scce.dime.gui.gui.internal.InternalPrimitiveExtensionAttribute,
				info.scce.dime.gui.gui.internal.InternalPrimitiveListAttribute
				 )
		}
	}
	def scopeForContents(EObject obj, Class<?>... types) {
		obj.rootContainer.contents
			.filter(anyTypeOf(types))
			.filter(InternalIdentifiableElement)
			.toScope
	}
	
	def getContents(EObject obj) {
		val Iterable<EObject> iterable = [obj.eAllContents]
		return iterable
	}
	
	def anyTypeOf(Class<?>... types) {
		[Object obj | types.stream.anyMatch[isInstance(obj)]]
	}
	
	def IScope toScope(Iterable<InternalIdentifiableElement> elements) {
		scopeFor(elements, [QualifiedName::create(id)], IScope.NULLSCOPE)
	}
}
