package info.scce.dime.dad.dad.gratext

import graphmodel.internal.InternalGraphModel

import de.jabc.cinco.meta.core.utils.registry.NonEmptyIdentityRegistry
import de.jabc.cinco.meta.plugin.gratext.runtime.resource.GratextResource

import info.scce.dime.dad.dad.gratext.generator.DADGratextTransformer

class DADGratextResource extends GratextResource {
	
	public static val transformers = new NonEmptyIdentityRegistry<InternalGraphModel,DADGratextTransformer> [
		new DADGratextTransformer
	]
	
	val lastTransformers = new NonEmptyIdentityRegistry<InternalGraphModel,DADGratextTransformer> [
		new DADGratextTransformer
	]

	override getTransformer(InternalGraphModel model) {
		transformers.get(model)
	}

	override getLastTransformer(InternalGraphModel model) {
		lastTransformers.get(model)
	}

	override removeTransformer(InternalGraphModel model) {
		lastTransformers.put(model, transformers.remove(model))
	}

	override isSortGratext() {
		false
	}
}
