package info.scce.dime.search.factory;

import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import graphmodel.Type;
import graphmodel.internal.InternalEdge;
import graphmodel.internal.InternalGraphModel;
import graphmodel.internal.InternalIdentifiableElement;
import graphmodel.internal.InternalModelElement;
import graphmodel.internal.InternalModelElementContainer;
import graphmodel.internal.InternalNode;
import graphmodel.internal.InternalType;
import info.scce.dime.search.adapter.AndOperatorEContentAdapter;
import info.scce.dime.search.adapter.BooleanCompareOperatorEContentAdapter;
import info.scce.dime.search.adapter.ComplexOutputParameterEContentAdapter;
import info.scce.dime.search.adapter.ConditionEdgeEContentAdapter;
import info.scce.dime.search.adapter.DataContextEContentAdapter;
import info.scce.dime.search.adapter.DataEdgeEContentAdapter;
import info.scce.dime.search.adapter.IntegerCompareOperatorEContentAdapter;
import info.scce.dime.search.adapter.OrOperatorEContentAdapter;
import info.scce.dime.search.adapter.PrimitiveInputParameterEContentAdapter;
import info.scce.dime.search.adapter.PrimitiveVariableEContentAdapter;
import info.scce.dime.search.adapter.RealCompareOperatorEContentAdapter;
import info.scce.dime.search.adapter.SearchConditionalEContentAdapter;
import info.scce.dime.search.adapter.SearchEContentAdapter;
import info.scce.dime.search.adapter.SearchInterfaceEContentAdapter;
import info.scce.dime.search.adapter.TextCompareOperatorEContentAdapter;
import info.scce.dime.search.adapter.TimestampCompareOperatorEContentAdapter;
import info.scce.dime.search.hooks.ParameterPostCreate;
import info.scce.dime.search.hooks.SearchConditionalPostCreate;
import info.scce.dime.search.hooks.SearchInit;
import info.scce.dime.search.search.AndOperator;
import info.scce.dime.search.search.BooleanCompareOperator;
import info.scce.dime.search.search.ComplexOutputParameter;
import info.scce.dime.search.search.ConditionEdge;
import info.scce.dime.search.search.DataContext;
import info.scce.dime.search.search.DataEdge;
import info.scce.dime.search.search.IntegerCompareOperator;
import info.scce.dime.search.search.OrOperator;
import info.scce.dime.search.search.PrimitiveInputParameter;
import info.scce.dime.search.search.PrimitiveVariable;
import info.scce.dime.search.search.RealCompareOperator;
import info.scce.dime.search.search.Search;
import info.scce.dime.search.search.SearchConditional;
import info.scce.dime.search.search.SearchInterface;
import info.scce.dime.search.search.SearchPackage;
import info.scce.dime.search.search.TextCompareOperator;
import info.scce.dime.search.search.TimestampCompareOperator;
import info.scce.dime.search.search.impl.SearchFactoryImpl;
import info.scce.dime.search.search.internal.InternalAndOperator;
import info.scce.dime.search.search.internal.InternalBooleanCompareOperator;
import info.scce.dime.search.search.internal.InternalComplexOutputParameter;
import info.scce.dime.search.search.internal.InternalConditionEdge;
import info.scce.dime.search.search.internal.InternalDataContext;
import info.scce.dime.search.search.internal.InternalDataEdge;
import info.scce.dime.search.search.internal.InternalFactory;
import info.scce.dime.search.search.internal.InternalIntegerCompareOperator;
import info.scce.dime.search.search.internal.InternalOrOperator;
import info.scce.dime.search.search.internal.InternalPrimitiveInputParameter;
import info.scce.dime.search.search.internal.InternalPrimitiveVariable;
import info.scce.dime.search.search.internal.InternalRealCompareOperator;
import info.scce.dime.search.search.internal.InternalSearch;
import info.scce.dime.search.search.internal.InternalSearchConditional;
import info.scce.dime.search.search.internal.InternalSearchInterface;
import info.scce.dime.search.search.internal.InternalTextCompareOperator;
import info.scce.dime.search.search.internal.InternalTimestampCompareOperator;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class SearchFactory extends SearchFactoryImpl {
  @Extension
  private final InternalFactory _internalFactory = InternalFactory.eINSTANCE;
  
  public static SearchFactory eINSTANCE = SearchFactory.init();
  
  @Extension
  private WorkbenchExtension _workbenchExtension = new WorkbenchExtension();
  
  public static SearchFactory init() {
    SearchFactory _xblockexpression = null;
    {
      try {
        EFactory _eFactory = EPackage.Registry.INSTANCE.getEFactory(SearchPackage.eNS_URI);
        final SearchFactory fct = ((SearchFactory) _eFactory);
        if ((fct != null)) {
          return ((SearchFactory) fct);
        }
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception exception = (Exception)_t;
          EcorePlugin.INSTANCE.log(exception);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
      _xblockexpression = new SearchFactory();
    }
    return _xblockexpression;
  }
  
  /**
   * This method creates an Search with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public Search createSearch(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    Search _createSearch = super.createSearch();
    final Procedure1<Search> _function = new Procedure1<Search>() {
      @Override
      public void apply(final Search it) {
        EcoreUtil.setID(it, ID);
        InternalIdentifiableElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalSearch _createInternalSearch = SearchFactory.this._internalFactory.createInternalSearch();
          _elvis = _createInternalSearch;
        }
        final Procedure1<InternalIdentifiableElement> _function = new Procedure1<InternalIdentifiableElement>() {
          @Override
          public void apply(final InternalIdentifiableElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            SearchEContentAdapter _searchEContentAdapter = new SearchEContentAdapter();
            _eAdapters.add(_searchEContentAdapter);
          }
        };
        InternalIdentifiableElement _doubleArrow = ObjectExtensions.<InternalIdentifiableElement>operator_doubleArrow(_elvis, _function);
        SearchFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          SearchFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<Search>operator_doubleArrow(_createSearch, _function);
  }
  
  /**
   * This method creates an Search with the given id. Post create hook won't be triggered.
   */
  public Search createSearch(final String ID) {
    return this.createSearch(ID, null, null, false);
  }
  
  /**
   * This method creates an Search with the given id. Post create hook will be triggered.
   */
  public Search createSearch(final InternalModelElementContainer parent) {
    return this.createSearch(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an Search with the given id. Post create hook will be triggered.
   */
  public Search createSearch(final String ID, final InternalModelElementContainer parent) {
    return this.createSearch(ID, null, parent, true);
  }
  
  public Search createSearch(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createSearch(ID, ime, parent, true);
  }
  
  /**
   * This method creates an Search with the given id. Post create hook won't be triggered.
   */
  public Search createSearch(final InternalModelElement ime) {
    return this.createSearch(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public Search createSearch() {
    return this.createSearch(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an OrOperator with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public OrOperator createOrOperator(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    OrOperator _createOrOperator = super.createOrOperator();
    final Procedure1<OrOperator> _function = new Procedure1<OrOperator>() {
      @Override
      public void apply(final OrOperator it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalOrOperator _createInternalOrOperator = SearchFactory.this._internalFactory.createInternalOrOperator();
          _elvis = _createInternalOrOperator;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            OrOperatorEContentAdapter _orOperatorEContentAdapter = new OrOperatorEContentAdapter();
            _eAdapters.add(_orOperatorEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        SearchFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<OrOperator>operator_doubleArrow(_createOrOperator, _function);
  }
  
  /**
   * This method creates an OrOperator with the given id. Post create hook won't be triggered.
   */
  public OrOperator createOrOperator(final String ID) {
    return this.createOrOperator(ID, null, null, false);
  }
  
  /**
   * This method creates an OrOperator with the given id. Post create hook will be triggered.
   */
  public OrOperator createOrOperator(final InternalModelElementContainer parent) {
    return this.createOrOperator(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an OrOperator with the given id. Post create hook will be triggered.
   */
  public OrOperator createOrOperator(final String ID, final InternalModelElementContainer parent) {
    return this.createOrOperator(ID, null, parent, true);
  }
  
  public OrOperator createOrOperator(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createOrOperator(ID, ime, parent, true);
  }
  
  /**
   * This method creates an OrOperator with the given id. Post create hook won't be triggered.
   */
  public OrOperator createOrOperator(final InternalModelElement ime) {
    return this.createOrOperator(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public OrOperator createOrOperator() {
    return this.createOrOperator(EcoreUtil.generateUUID());
  }
  
  public ConditionEdge createConditionEdge(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    ConditionEdge _createConditionEdge = super.createConditionEdge();
    final Procedure1<ConditionEdge> _function = new Procedure1<ConditionEdge>() {
      @Override
      public void apply(final ConditionEdge it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalConditionEdge _createInternalConditionEdge = SearchFactory.this._internalFactory.createInternalConditionEdge();
          _elvis = _createInternalConditionEdge;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            ConditionEdgeEContentAdapter _conditionEdgeEContentAdapter = new ConditionEdgeEContentAdapter();
            _eAdapters.add(_conditionEdgeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        SearchFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ConditionEdge>operator_doubleArrow(_createConditionEdge, _function);
  }
  
  /**
   * This method creates an ConditionEdge with the given id. Post create hook will be triggered.
   */
  public ConditionEdge createConditionEdge(final String ID, final InternalNode source, final InternalNode target) {
    return this.createConditionEdge(ID, null, source, target, true);
  }
  
  /**
   * This method creates an ConditionEdge with generated id. Post create hook will be triggered.
   */
  public ConditionEdge createConditionEdge(final InternalNode source, final InternalNode target) {
    return this.createConditionEdge(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an ConditionEdge with the given id. Post create hook won't be triggered.
   */
  public ConditionEdge createConditionEdge(final String ID) {
    return this.createConditionEdge(ID, null, null, null, false);
  }
  
  /**
   * This method creates an ConditionEdge with a generated id. Post create hook won't be triggered.
   */
  @Override
  public ConditionEdge createConditionEdge() {
    return this.createConditionEdge(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an BooleanCompareOperator with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public BooleanCompareOperator createBooleanCompareOperator(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    BooleanCompareOperator _createBooleanCompareOperator = super.createBooleanCompareOperator();
    final Procedure1<BooleanCompareOperator> _function = new Procedure1<BooleanCompareOperator>() {
      @Override
      public void apply(final BooleanCompareOperator it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalBooleanCompareOperator _createInternalBooleanCompareOperator = SearchFactory.this._internalFactory.createInternalBooleanCompareOperator();
          _elvis = _createInternalBooleanCompareOperator;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            BooleanCompareOperatorEContentAdapter _booleanCompareOperatorEContentAdapter = new BooleanCompareOperatorEContentAdapter();
            _eAdapters.add(_booleanCompareOperatorEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        SearchFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<BooleanCompareOperator>operator_doubleArrow(_createBooleanCompareOperator, _function);
  }
  
  /**
   * This method creates an BooleanCompareOperator with the given id. Post create hook won't be triggered.
   */
  public BooleanCompareOperator createBooleanCompareOperator(final String ID) {
    return this.createBooleanCompareOperator(ID, null, null, false);
  }
  
  /**
   * This method creates an BooleanCompareOperator with the given id. Post create hook will be triggered.
   */
  public BooleanCompareOperator createBooleanCompareOperator(final InternalModelElementContainer parent) {
    return this.createBooleanCompareOperator(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an BooleanCompareOperator with the given id. Post create hook will be triggered.
   */
  public BooleanCompareOperator createBooleanCompareOperator(final String ID, final InternalModelElementContainer parent) {
    return this.createBooleanCompareOperator(ID, null, parent, true);
  }
  
  public BooleanCompareOperator createBooleanCompareOperator(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createBooleanCompareOperator(ID, ime, parent, true);
  }
  
  /**
   * This method creates an BooleanCompareOperator with the given id. Post create hook won't be triggered.
   */
  public BooleanCompareOperator createBooleanCompareOperator(final InternalModelElement ime) {
    return this.createBooleanCompareOperator(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public BooleanCompareOperator createBooleanCompareOperator() {
    return this.createBooleanCompareOperator(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an AndOperator with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public AndOperator createAndOperator(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    AndOperator _createAndOperator = super.createAndOperator();
    final Procedure1<AndOperator> _function = new Procedure1<AndOperator>() {
      @Override
      public void apply(final AndOperator it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalAndOperator _createInternalAndOperator = SearchFactory.this._internalFactory.createInternalAndOperator();
          _elvis = _createInternalAndOperator;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            AndOperatorEContentAdapter _andOperatorEContentAdapter = new AndOperatorEContentAdapter();
            _eAdapters.add(_andOperatorEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        SearchFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<AndOperator>operator_doubleArrow(_createAndOperator, _function);
  }
  
  /**
   * This method creates an AndOperator with the given id. Post create hook won't be triggered.
   */
  public AndOperator createAndOperator(final String ID) {
    return this.createAndOperator(ID, null, null, false);
  }
  
  /**
   * This method creates an AndOperator with the given id. Post create hook will be triggered.
   */
  public AndOperator createAndOperator(final InternalModelElementContainer parent) {
    return this.createAndOperator(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an AndOperator with the given id. Post create hook will be triggered.
   */
  public AndOperator createAndOperator(final String ID, final InternalModelElementContainer parent) {
    return this.createAndOperator(ID, null, parent, true);
  }
  
  public AndOperator createAndOperator(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createAndOperator(ID, ime, parent, true);
  }
  
  /**
   * This method creates an AndOperator with the given id. Post create hook won't be triggered.
   */
  public AndOperator createAndOperator(final InternalModelElement ime) {
    return this.createAndOperator(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public AndOperator createAndOperator() {
    return this.createAndOperator(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveVariable with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveVariable createPrimitiveVariable(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveVariable _createPrimitiveVariable = super.createPrimitiveVariable();
    final Procedure1<PrimitiveVariable> _function = new Procedure1<PrimitiveVariable>() {
      @Override
      public void apply(final PrimitiveVariable it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveVariable _createInternalPrimitiveVariable = SearchFactory.this._internalFactory.createInternalPrimitiveVariable();
          _elvis = _createInternalPrimitiveVariable;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveVariableEContentAdapter _primitiveVariableEContentAdapter = new PrimitiveVariableEContentAdapter();
            _eAdapters.add(_primitiveVariableEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        SearchFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<PrimitiveVariable>operator_doubleArrow(_createPrimitiveVariable, _function);
  }
  
  /**
   * This method creates an PrimitiveVariable with the given id. Post create hook won't be triggered.
   */
  public PrimitiveVariable createPrimitiveVariable(final String ID) {
    return this.createPrimitiveVariable(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveVariable with the given id. Post create hook will be triggered.
   */
  public PrimitiveVariable createPrimitiveVariable(final InternalModelElementContainer parent) {
    return this.createPrimitiveVariable(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveVariable with the given id. Post create hook will be triggered.
   */
  public PrimitiveVariable createPrimitiveVariable(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveVariable(ID, null, parent, true);
  }
  
  public PrimitiveVariable createPrimitiveVariable(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveVariable(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveVariable with the given id. Post create hook won't be triggered.
   */
  public PrimitiveVariable createPrimitiveVariable(final InternalModelElement ime) {
    return this.createPrimitiveVariable(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveVariable createPrimitiveVariable() {
    return this.createPrimitiveVariable(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an SearchConditional with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public SearchConditional createSearchConditional(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    SearchConditional _createSearchConditional = super.createSearchConditional();
    final Procedure1<SearchConditional> _function = new Procedure1<SearchConditional>() {
      @Override
      public void apply(final SearchConditional it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalSearchConditional _createInternalSearchConditional = SearchFactory.this._internalFactory.createInternalSearchConditional();
          _elvis = _createInternalSearchConditional;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            SearchConditionalEContentAdapter _searchConditionalEContentAdapter = new SearchConditionalEContentAdapter();
            _eAdapters.add(_searchConditionalEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        SearchFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          SearchFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<SearchConditional>operator_doubleArrow(_createSearchConditional, _function);
  }
  
  /**
   * This method creates an SearchConditional with the given id. Post create hook won't be triggered.
   */
  public SearchConditional createSearchConditional(final String ID) {
    return this.createSearchConditional(ID, null, null, false);
  }
  
  /**
   * This method creates an SearchConditional with the given id. Post create hook will be triggered.
   */
  public SearchConditional createSearchConditional(final InternalModelElementContainer parent) {
    return this.createSearchConditional(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an SearchConditional with the given id. Post create hook will be triggered.
   */
  public SearchConditional createSearchConditional(final String ID, final InternalModelElementContainer parent) {
    return this.createSearchConditional(ID, null, parent, true);
  }
  
  public SearchConditional createSearchConditional(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createSearchConditional(ID, ime, parent, true);
  }
  
  /**
   * This method creates an SearchConditional with the given id. Post create hook won't be triggered.
   */
  public SearchConditional createSearchConditional(final InternalModelElement ime) {
    return this.createSearchConditional(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public SearchConditional createSearchConditional() {
    return this.createSearchConditional(EcoreUtil.generateUUID());
  }
  
  public DataEdge createDataEdge(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    DataEdge _createDataEdge = super.createDataEdge();
    final Procedure1<DataEdge> _function = new Procedure1<DataEdge>() {
      @Override
      public void apply(final DataEdge it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalDataEdge _createInternalDataEdge = SearchFactory.this._internalFactory.createInternalDataEdge();
          _elvis = _createInternalDataEdge;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            DataEdgeEContentAdapter _dataEdgeEContentAdapter = new DataEdgeEContentAdapter();
            _eAdapters.add(_dataEdgeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        SearchFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<DataEdge>operator_doubleArrow(_createDataEdge, _function);
  }
  
  /**
   * This method creates an DataEdge with the given id. Post create hook will be triggered.
   */
  public DataEdge createDataEdge(final String ID, final InternalNode source, final InternalNode target) {
    return this.createDataEdge(ID, null, source, target, true);
  }
  
  /**
   * This method creates an DataEdge with generated id. Post create hook will be triggered.
   */
  public DataEdge createDataEdge(final InternalNode source, final InternalNode target) {
    return this.createDataEdge(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an DataEdge with the given id. Post create hook won't be triggered.
   */
  public DataEdge createDataEdge(final String ID) {
    return this.createDataEdge(ID, null, null, null, false);
  }
  
  /**
   * This method creates an DataEdge with a generated id. Post create hook won't be triggered.
   */
  @Override
  public DataEdge createDataEdge() {
    return this.createDataEdge(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an DataContext with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public DataContext createDataContext(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    DataContext _createDataContext = super.createDataContext();
    final Procedure1<DataContext> _function = new Procedure1<DataContext>() {
      @Override
      public void apply(final DataContext it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalDataContext _createInternalDataContext = SearchFactory.this._internalFactory.createInternalDataContext();
          _elvis = _createInternalDataContext;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            DataContextEContentAdapter _dataContextEContentAdapter = new DataContextEContentAdapter();
            _eAdapters.add(_dataContextEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        SearchFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<DataContext>operator_doubleArrow(_createDataContext, _function);
  }
  
  /**
   * This method creates an DataContext with the given id. Post create hook won't be triggered.
   */
  public DataContext createDataContext(final String ID) {
    return this.createDataContext(ID, null, null, false);
  }
  
  /**
   * This method creates an DataContext with the given id. Post create hook will be triggered.
   */
  public DataContext createDataContext(final InternalModelElementContainer parent) {
    return this.createDataContext(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an DataContext with the given id. Post create hook will be triggered.
   */
  public DataContext createDataContext(final String ID, final InternalModelElementContainer parent) {
    return this.createDataContext(ID, null, parent, true);
  }
  
  public DataContext createDataContext(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createDataContext(ID, ime, parent, true);
  }
  
  /**
   * This method creates an DataContext with the given id. Post create hook won't be triggered.
   */
  public DataContext createDataContext(final InternalModelElement ime) {
    return this.createDataContext(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public DataContext createDataContext() {
    return this.createDataContext(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an RealCompareOperator with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public RealCompareOperator createRealCompareOperator(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    RealCompareOperator _createRealCompareOperator = super.createRealCompareOperator();
    final Procedure1<RealCompareOperator> _function = new Procedure1<RealCompareOperator>() {
      @Override
      public void apply(final RealCompareOperator it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalRealCompareOperator _createInternalRealCompareOperator = SearchFactory.this._internalFactory.createInternalRealCompareOperator();
          _elvis = _createInternalRealCompareOperator;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            RealCompareOperatorEContentAdapter _realCompareOperatorEContentAdapter = new RealCompareOperatorEContentAdapter();
            _eAdapters.add(_realCompareOperatorEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        SearchFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<RealCompareOperator>operator_doubleArrow(_createRealCompareOperator, _function);
  }
  
  /**
   * This method creates an RealCompareOperator with the given id. Post create hook won't be triggered.
   */
  public RealCompareOperator createRealCompareOperator(final String ID) {
    return this.createRealCompareOperator(ID, null, null, false);
  }
  
  /**
   * This method creates an RealCompareOperator with the given id. Post create hook will be triggered.
   */
  public RealCompareOperator createRealCompareOperator(final InternalModelElementContainer parent) {
    return this.createRealCompareOperator(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an RealCompareOperator with the given id. Post create hook will be triggered.
   */
  public RealCompareOperator createRealCompareOperator(final String ID, final InternalModelElementContainer parent) {
    return this.createRealCompareOperator(ID, null, parent, true);
  }
  
  public RealCompareOperator createRealCompareOperator(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createRealCompareOperator(ID, ime, parent, true);
  }
  
  /**
   * This method creates an RealCompareOperator with the given id. Post create hook won't be triggered.
   */
  public RealCompareOperator createRealCompareOperator(final InternalModelElement ime) {
    return this.createRealCompareOperator(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public RealCompareOperator createRealCompareOperator() {
    return this.createRealCompareOperator(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an IntegerCompareOperator with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public IntegerCompareOperator createIntegerCompareOperator(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    IntegerCompareOperator _createIntegerCompareOperator = super.createIntegerCompareOperator();
    final Procedure1<IntegerCompareOperator> _function = new Procedure1<IntegerCompareOperator>() {
      @Override
      public void apply(final IntegerCompareOperator it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalIntegerCompareOperator _createInternalIntegerCompareOperator = SearchFactory.this._internalFactory.createInternalIntegerCompareOperator();
          _elvis = _createInternalIntegerCompareOperator;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            IntegerCompareOperatorEContentAdapter _integerCompareOperatorEContentAdapter = new IntegerCompareOperatorEContentAdapter();
            _eAdapters.add(_integerCompareOperatorEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        SearchFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<IntegerCompareOperator>operator_doubleArrow(_createIntegerCompareOperator, _function);
  }
  
  /**
   * This method creates an IntegerCompareOperator with the given id. Post create hook won't be triggered.
   */
  public IntegerCompareOperator createIntegerCompareOperator(final String ID) {
    return this.createIntegerCompareOperator(ID, null, null, false);
  }
  
  /**
   * This method creates an IntegerCompareOperator with the given id. Post create hook will be triggered.
   */
  public IntegerCompareOperator createIntegerCompareOperator(final InternalModelElementContainer parent) {
    return this.createIntegerCompareOperator(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an IntegerCompareOperator with the given id. Post create hook will be triggered.
   */
  public IntegerCompareOperator createIntegerCompareOperator(final String ID, final InternalModelElementContainer parent) {
    return this.createIntegerCompareOperator(ID, null, parent, true);
  }
  
  public IntegerCompareOperator createIntegerCompareOperator(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createIntegerCompareOperator(ID, ime, parent, true);
  }
  
  /**
   * This method creates an IntegerCompareOperator with the given id. Post create hook won't be triggered.
   */
  public IntegerCompareOperator createIntegerCompareOperator(final InternalModelElement ime) {
    return this.createIntegerCompareOperator(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public IntegerCompareOperator createIntegerCompareOperator() {
    return this.createIntegerCompareOperator(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an SearchInterface with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public SearchInterface createSearchInterface(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    SearchInterface _createSearchInterface = super.createSearchInterface();
    final Procedure1<SearchInterface> _function = new Procedure1<SearchInterface>() {
      @Override
      public void apply(final SearchInterface it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalSearchInterface _createInternalSearchInterface = SearchFactory.this._internalFactory.createInternalSearchInterface();
          _elvis = _createInternalSearchInterface;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            SearchInterfaceEContentAdapter _searchInterfaceEContentAdapter = new SearchInterfaceEContentAdapter();
            _eAdapters.add(_searchInterfaceEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        SearchFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<SearchInterface>operator_doubleArrow(_createSearchInterface, _function);
  }
  
  /**
   * This method creates an SearchInterface with the given id. Post create hook won't be triggered.
   */
  public SearchInterface createSearchInterface(final String ID) {
    return this.createSearchInterface(ID, null, null, false);
  }
  
  /**
   * This method creates an SearchInterface with the given id. Post create hook will be triggered.
   */
  public SearchInterface createSearchInterface(final InternalModelElementContainer parent) {
    return this.createSearchInterface(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an SearchInterface with the given id. Post create hook will be triggered.
   */
  public SearchInterface createSearchInterface(final String ID, final InternalModelElementContainer parent) {
    return this.createSearchInterface(ID, null, parent, true);
  }
  
  public SearchInterface createSearchInterface(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createSearchInterface(ID, ime, parent, true);
  }
  
  /**
   * This method creates an SearchInterface with the given id. Post create hook won't be triggered.
   */
  public SearchInterface createSearchInterface(final InternalModelElement ime) {
    return this.createSearchInterface(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public SearchInterface createSearchInterface() {
    return this.createSearchInterface(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveInputParameter with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveInputParameter createPrimitiveInputParameter(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveInputParameter _createPrimitiveInputParameter = super.createPrimitiveInputParameter();
    final Procedure1<PrimitiveInputParameter> _function = new Procedure1<PrimitiveInputParameter>() {
      @Override
      public void apply(final PrimitiveInputParameter it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveInputParameter _createInternalPrimitiveInputParameter = SearchFactory.this._internalFactory.createInternalPrimitiveInputParameter();
          _elvis = _createInternalPrimitiveInputParameter;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveInputParameterEContentAdapter _primitiveInputParameterEContentAdapter = new PrimitiveInputParameterEContentAdapter();
            _eAdapters.add(_primitiveInputParameterEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        SearchFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          SearchFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<PrimitiveInputParameter>operator_doubleArrow(_createPrimitiveInputParameter, _function);
  }
  
  /**
   * This method creates an PrimitiveInputParameter with the given id. Post create hook won't be triggered.
   */
  public PrimitiveInputParameter createPrimitiveInputParameter(final String ID) {
    return this.createPrimitiveInputParameter(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveInputParameter with the given id. Post create hook will be triggered.
   */
  public PrimitiveInputParameter createPrimitiveInputParameter(final InternalModelElementContainer parent) {
    return this.createPrimitiveInputParameter(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveInputParameter with the given id. Post create hook will be triggered.
   */
  public PrimitiveInputParameter createPrimitiveInputParameter(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveInputParameter(ID, null, parent, true);
  }
  
  public PrimitiveInputParameter createPrimitiveInputParameter(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveInputParameter(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveInputParameter with the given id. Post create hook won't be triggered.
   */
  public PrimitiveInputParameter createPrimitiveInputParameter(final InternalModelElement ime) {
    return this.createPrimitiveInputParameter(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveInputParameter createPrimitiveInputParameter() {
    return this.createPrimitiveInputParameter(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an TimestampCompareOperator with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public TimestampCompareOperator createTimestampCompareOperator(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    TimestampCompareOperator _createTimestampCompareOperator = super.createTimestampCompareOperator();
    final Procedure1<TimestampCompareOperator> _function = new Procedure1<TimestampCompareOperator>() {
      @Override
      public void apply(final TimestampCompareOperator it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalTimestampCompareOperator _createInternalTimestampCompareOperator = SearchFactory.this._internalFactory.createInternalTimestampCompareOperator();
          _elvis = _createInternalTimestampCompareOperator;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            TimestampCompareOperatorEContentAdapter _timestampCompareOperatorEContentAdapter = new TimestampCompareOperatorEContentAdapter();
            _eAdapters.add(_timestampCompareOperatorEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        SearchFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<TimestampCompareOperator>operator_doubleArrow(_createTimestampCompareOperator, _function);
  }
  
  /**
   * This method creates an TimestampCompareOperator with the given id. Post create hook won't be triggered.
   */
  public TimestampCompareOperator createTimestampCompareOperator(final String ID) {
    return this.createTimestampCompareOperator(ID, null, null, false);
  }
  
  /**
   * This method creates an TimestampCompareOperator with the given id. Post create hook will be triggered.
   */
  public TimestampCompareOperator createTimestampCompareOperator(final InternalModelElementContainer parent) {
    return this.createTimestampCompareOperator(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an TimestampCompareOperator with the given id. Post create hook will be triggered.
   */
  public TimestampCompareOperator createTimestampCompareOperator(final String ID, final InternalModelElementContainer parent) {
    return this.createTimestampCompareOperator(ID, null, parent, true);
  }
  
  public TimestampCompareOperator createTimestampCompareOperator(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createTimestampCompareOperator(ID, ime, parent, true);
  }
  
  /**
   * This method creates an TimestampCompareOperator with the given id. Post create hook won't be triggered.
   */
  public TimestampCompareOperator createTimestampCompareOperator(final InternalModelElement ime) {
    return this.createTimestampCompareOperator(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public TimestampCompareOperator createTimestampCompareOperator() {
    return this.createTimestampCompareOperator(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an TextCompareOperator with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public TextCompareOperator createTextCompareOperator(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    TextCompareOperator _createTextCompareOperator = super.createTextCompareOperator();
    final Procedure1<TextCompareOperator> _function = new Procedure1<TextCompareOperator>() {
      @Override
      public void apply(final TextCompareOperator it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalTextCompareOperator _createInternalTextCompareOperator = SearchFactory.this._internalFactory.createInternalTextCompareOperator();
          _elvis = _createInternalTextCompareOperator;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            TextCompareOperatorEContentAdapter _textCompareOperatorEContentAdapter = new TextCompareOperatorEContentAdapter();
            _eAdapters.add(_textCompareOperatorEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        SearchFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<TextCompareOperator>operator_doubleArrow(_createTextCompareOperator, _function);
  }
  
  /**
   * This method creates an TextCompareOperator with the given id. Post create hook won't be triggered.
   */
  public TextCompareOperator createTextCompareOperator(final String ID) {
    return this.createTextCompareOperator(ID, null, null, false);
  }
  
  /**
   * This method creates an TextCompareOperator with the given id. Post create hook will be triggered.
   */
  public TextCompareOperator createTextCompareOperator(final InternalModelElementContainer parent) {
    return this.createTextCompareOperator(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an TextCompareOperator with the given id. Post create hook will be triggered.
   */
  public TextCompareOperator createTextCompareOperator(final String ID, final InternalModelElementContainer parent) {
    return this.createTextCompareOperator(ID, null, parent, true);
  }
  
  public TextCompareOperator createTextCompareOperator(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createTextCompareOperator(ID, ime, parent, true);
  }
  
  /**
   * This method creates an TextCompareOperator with the given id. Post create hook won't be triggered.
   */
  public TextCompareOperator createTextCompareOperator(final InternalModelElement ime) {
    return this.createTextCompareOperator(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public TextCompareOperator createTextCompareOperator() {
    return this.createTextCompareOperator(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexOutputParameter with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexOutputParameter createComplexOutputParameter(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexOutputParameter _createComplexOutputParameter = super.createComplexOutputParameter();
    final Procedure1<ComplexOutputParameter> _function = new Procedure1<ComplexOutputParameter>() {
      @Override
      public void apply(final ComplexOutputParameter it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexOutputParameter _createInternalComplexOutputParameter = SearchFactory.this._internalFactory.createInternalComplexOutputParameter();
          _elvis = _createInternalComplexOutputParameter;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexOutputParameterEContentAdapter _complexOutputParameterEContentAdapter = new ComplexOutputParameterEContentAdapter();
            _eAdapters.add(_complexOutputParameterEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        SearchFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          SearchFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ComplexOutputParameter>operator_doubleArrow(_createComplexOutputParameter, _function);
  }
  
  /**
   * This method creates an ComplexOutputParameter with the given id. Post create hook won't be triggered.
   */
  public ComplexOutputParameter createComplexOutputParameter(final String ID) {
    return this.createComplexOutputParameter(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexOutputParameter with the given id. Post create hook will be triggered.
   */
  public ComplexOutputParameter createComplexOutputParameter(final InternalModelElementContainer parent) {
    return this.createComplexOutputParameter(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexOutputParameter with the given id. Post create hook will be triggered.
   */
  public ComplexOutputParameter createComplexOutputParameter(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexOutputParameter(ID, null, parent, true);
  }
  
  public ComplexOutputParameter createComplexOutputParameter(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexOutputParameter(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexOutputParameter with the given id. Post create hook won't be triggered.
   */
  public ComplexOutputParameter createComplexOutputParameter(final InternalModelElement ime) {
    return this.createComplexOutputParameter(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexOutputParameter createComplexOutputParameter() {
    return this.createComplexOutputParameter(EcoreUtil.generateUUID());
  }
  
  private <T extends IdentifiableElement> T setInternal(final T elm, final InternalIdentifiableElement internal) {
    final Procedure1<T> _function = new Procedure1<T>() {
      @Override
      public void apply(final T it) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(it.getId());
        if (_isNullOrEmpty) {
          EcoreUtil.setID(it, EcoreUtil.generateUUID());
        }
        boolean _matched = false;
        if (elm instanceof GraphModel) {
          _matched=true;
          ((GraphModel)elm).setInternalElement_(((InternalGraphModel) internal));
        }
        if (!_matched) {
          if (elm instanceof ModelElement) {
            _matched=true;
            ((ModelElement)elm).setInternalElement_(((InternalModelElement) internal));
          }
        }
        if (!_matched) {
          if (elm instanceof Type) {
            _matched=true;
            ((Type)elm).setInternalElement_(((InternalType) internal));
          }
        }
      }
    };
    return ObjectExtensions.<T>operator_doubleArrow(elm, _function);
  }
  
  /**
   * This method creates a new Search object with an underlying org.eclipse.emf.ecore.resource.Resource. Thus you can
   * simply call the Search's save method to save your changes.
   */
  public Search createSearch(final String path, final String fileName) {
    IPath filePath = new Path(path).append(fileName).addFileExtension("search");
    URI uri = URI.createPlatformResourceURI(filePath.toOSString(), true);
    Resource res = new ResourceSetImpl().createResource(uri);
    Search graph = SearchFactory.eINSTANCE.createSearch();
    EcoreUtil.setID(graph, EcoreUtil.generateUUID());
    res.getContents().add(graph.getInternalElement_());
    this.postCreates(graph);
    try {
      res.save(null);
    } catch (final Throwable _t) {
      if (_t instanceof IOException) {
        final IOException e = (IOException)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    return graph;
  }
  
  public void postCreates(final SearchConditional me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new SearchConditionalPostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ComplexOutputParameter me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ParameterPostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final PrimitiveInputParameter me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ParameterPostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final Search me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new SearchInit().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
}
