/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.property;

import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Paths;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class DimeProperties extends Properties {
  public static final String CONFIG_FOLDER = ".dime";
  
  public static final String PROPERTIES_FILE_NAME = "dime.properties";
  
  private static final Pair<String, Object> FRONTEND_PORT = Pair.<String, Object>of("frontendPort", ((Object)ObjectExtensions.<Object>operator_elvis(System.getenv("DIME_FRONTEND_PORT"), Integer.valueOf(8080))));
  
  private static final Pair<String, String> APP_URL = Pair.<String, String>of("appURL", ("http://localhost:" + DimeProperties.getFrontendPort()));
  
  private DimeProperties() {
  }
  
  private static DimeProperties INSTANCE;
  
  public static DimeProperties newInstance() {
    DimeProperties _dimeProperties = new DimeProperties();
    final Procedure1<DimeProperties> _function = new Procedure1<DimeProperties>() {
      @Override
      public void apply(final DimeProperties it) {
        it.load();
      }
    };
    DimeProperties _doubleArrow = ObjectExtensions.<DimeProperties>operator_doubleArrow(_dimeProperties, _function);
    return DimeProperties.INSTANCE = _doubleArrow;
  }
  
  public static DimeProperties getInstance() {
    DimeProperties _elvis = null;
    if (DimeProperties.INSTANCE != null) {
      _elvis = DimeProperties.INSTANCE;
    } else {
      DimeProperties _newInstance = DimeProperties.newInstance();
      _elvis = _newInstance;
    }
    return _elvis;
  }
  
  /**
   * Convenient Getters
   */
  public static Integer getFrontendPort() {
    return DimeProperties.getIntValue(DimeProperties.FRONTEND_PORT);
  }
  
  public static String getAppURL() {
    return DimeProperties.getStrValue(DimeProperties.APP_URL);
  }
  
  /**
   * Load Dime properties from user home
   */
  public void load() {
    final String home = System.getProperty("user.home");
    if ((home != null)) {
      try {
        final File file = Paths.get(home).resolve(DimeProperties.CONFIG_FOLDER).resolve(DimeProperties.PROPERTIES_FILE_NAME).toFile();
        boolean _exists = file.exists();
        if (_exists) {
          FileInputStream _fileInputStream = new FileInputStream(file);
          this.load(_fileInputStream);
        }
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception e = (Exception)_t;
          e.printStackTrace();
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
  }
  
  /**
   * Load properties from properties file in the specified project.
   */
  public String load(final IProject project) {
    try {
      String _xblockexpression = null;
      {
        InputOutput.<String>println("Loading DIME Properties...");
        final IFile file = project.getFile(DimeProperties.PROPERTIES_FILE_NAME);
        boolean _exists = file.exists();
        if (_exists) {
          super.load(file.getContents());
        }
        _xblockexpression = InputOutput.<String>println(("DIME properties: " + this));
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  private static String getStrValue(final Pair<String, String> p) {
    String _elvis = null;
    String _property = DimeProperties.getInstance().getProperty(p.getKey());
    if (_property != null) {
      _elvis = _property;
    } else {
      String _value = p.getValue();
      _elvis = _value;
    }
    return _elvis;
  }
  
  private static Integer getIntValue(final Pair<String, ?> p) {
    int _xblockexpression = (int) 0;
    {
      final String value = DimeProperties.getInstance().getProperty(p.getKey());
      int _xifexpression = (int) 0;
      if ((value != null)) {
        _xifexpression = Integer.parseInt(value);
      } else {
        Object _value = p.getValue();
        String _string = null;
        if (_value!=null) {
          _string=_value.toString();
        }
        _xifexpression = Integer.parseInt(_string);
      }
      _xblockexpression = _xifexpression;
    }
    return Integer.valueOf(_xblockexpression);
  }
}
