/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.profile.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import graphmodel.Node;
import info.scce.dime.profile.api.ProfileRuntimeBaseClass;
import info.scce.dime.profile.profile.BlueprintSIB;
import info.scce.dime.profile.profile.Branch;
import info.scce.dime.profile.profile.BranchReplacement;
import info.scce.dime.profile.profile.InputPort;
import info.scce.dime.profile.profile.OutputPort;
import info.scce.dime.profile.profile.ReplacementBranch;
import info.scce.dime.profile.profile.ReplacementCondition;
import info.scce.dime.profile.profile.ReplacementSIB;
import info.scce.dime.profile.profile.SIB;
import info.scce.dime.profile.profile.SIBReplacement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class ReplacementStrategy extends ProfileRuntimeBaseClass {
  public Node getInferredReplacement(final SIB sib) {
    final Function1<Node, Boolean> _function = new Function1<Node, Boolean>() {
      @Override
      public Boolean apply(final Node it) {
        return Boolean.valueOf(ReplacementStrategy.this.getReplacementConditionsFulfilled(it));
      }
    };
    return IterableExtensions.<Node>findFirst(this.getReplacementPath(sib), _function);
  }
  
  public boolean isInferredReplacement(final Node sib) {
    final Function1<BlueprintSIB, Boolean> _function = new Function1<BlueprintSIB, Boolean>() {
      @Override
      public Boolean apply(final BlueprintSIB blueSib) {
        return Boolean.valueOf((ReplacementStrategy.this.getReplacementConditionsFulfilled(blueSib) && ReplacementStrategy.this._graphModelExtension.operator_equals(ReplacementStrategy.this.getInferredReplacement(blueSib), sib)));
      }
    };
    return IterableExtensions.<BlueprintSIB>exists(Iterables.<BlueprintSIB>filter(this._graphModelExtension.findPredecessorsVia(sib, SIBReplacement.class), BlueprintSIB.class), _function);
  }
  
  public Node getReplacement(final Node node) {
    return this._graphModelExtension.<SIBReplacement>findTargetOf(node, SIBReplacement.class);
  }
  
  public ArrayList<Node> getReplacementPath(final SIB sib) {
    final ArrayList<Node> path = CollectionLiterals.<Node>newArrayList();
    Node replSib = this.getReplacement(sib);
    while ((replSib != null)) {
      {
        boolean _contains = path.contains(replSib);
        if (_contains) {
          return path;
        } else {
          path.add(replSib);
        }
        replSib = this.getReplacement(replSib);
      }
    }
    return path;
  }
  
  protected boolean _getReplacementConditionsFulfilled(final Node node) {
    return true;
  }
  
  protected boolean _getReplacementConditionsFulfilled(final SIB sib) {
    return (((!this._profileExtension.hasInvalidPrimeReference(sib)) && (!this.hasCycleInReplacementConditions(sib))) && (ObjectExtensions.<Boolean>operator_doubleArrow(Boolean.valueOf(IterableExtensions.<ReplacementCondition>forall(sib.getOutgoingReplacementConditions(), 
      new Function1<ReplacementCondition, Boolean>() {
        @Override
        public Boolean apply(final ReplacementCondition it) {
          boolean _xifexpression = false;
          boolean _isNegate = it.isNegate();
          if (_isNegate) {
            boolean _isInferredReplacement = ReplacementStrategy.this.isInferredReplacement(it.getTargetElement());
            _xifexpression = (!_isInferredReplacement);
          } else {
            _xifexpression = ReplacementStrategy.this.isInferredReplacement(it.getTargetElement());
          }
          return Boolean.valueOf(_xifexpression);
        }
      })), new Procedure1<Boolean>() {
      @Override
      public void apply(final Boolean it) {
        String _name = null;
        if (sib!=null) {
          _name=ReplacementStrategy.this._profileExtension.getName(sib);
        }
        String _plus = ("Replacement conditions for " + _name);
        String _plus_1 = (_plus + " fulfilled? ");
        String _plus_2 = (_plus_1 + it);
        InputOutput.<String>println(_plus_2);
      }
    })).booleanValue());
  }
  
  public boolean hasCycleInReplacementConditions(final SIB sib) {
    Set<Node> _findCycleInReplacementConditions = this.findCycleInReplacementConditions(sib);
    return (_findCycleInReplacementConditions != null);
  }
  
  public Set<Node> findCycleInReplacementConditions(final Node sib) {
    return this.findCycleInReplacementConditions_recurse(sib, CollectionLiterals.<Node>newLinkedHashSet());
  }
  
  private Set<Node> findCycleInReplacementConditions_recurse(final Node node, final Set<Node> visited) {
    Set<Node> _xblockexpression = null;
    {
      boolean _add = visited.add(node);
      boolean _not = (!_add);
      if (_not) {
        return visited;
      }
      Set<Node> _elvis = null;
      final Function1<ReplacementCondition, Set<Node>> _function = new Function1<ReplacementCondition, Set<Node>>() {
        @Override
        public Set<Node> apply(final ReplacementCondition it) {
          ReplacementSIB _targetElement = it.getTargetElement();
          LinkedHashSet<Node> _newLinkedHashSet = CollectionLiterals.<Node>newLinkedHashSet();
          final Procedure1<LinkedHashSet<Node>> _function = new Procedure1<LinkedHashSet<Node>>() {
            @Override
            public void apply(final LinkedHashSet<Node> it) {
              it.addAll(visited);
            }
          };
          LinkedHashSet<Node> _doubleArrow = ObjectExtensions.<LinkedHashSet<Node>>operator_doubleArrow(_newLinkedHashSet, _function);
          return ReplacementStrategy.this.findCycleInReplacementConditions_recurse(_targetElement, _doubleArrow);
        }
      };
      final Function1<Set<Node>, Boolean> _function_1 = new Function1<Set<Node>, Boolean>() {
        @Override
        public Boolean apply(final Set<Node> it) {
          boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(it);
          return Boolean.valueOf((!_isNullOrEmpty));
        }
      };
      Set<Node> _findFirst = IterableExtensions.<Set<Node>>findFirst(ListExtensions.<ReplacementCondition, Set<Node>>map(node.<ReplacementCondition>getOutgoing(ReplacementCondition.class), _function), _function_1);
      if (_findFirst != null) {
        _elvis = _findFirst;
      } else {
        _elvis = null;
      }
      _xblockexpression = _elvis;
    }
    return _xblockexpression;
  }
  
  public InputPort getInferredReplacement(final InputPort port) {
    InputPort _xblockexpression = null;
    {
      final Node sibReplacement = this.getInferredReplacement(this._profileExtension.getSib(port));
      InputPort _xifexpression = null;
      if ((sibReplacement instanceof ReplacementSIB)) {
        InputPort _inferredReplacement = this.getInferredReplacement(port, ((ReplacementSIB)sibReplacement));
        final Procedure1<InputPort> _function = new Procedure1<InputPort>() {
          @Override
          public void apply(final InputPort it) {
            String _name = null;
            if (port!=null) {
              _name=ReplacementStrategy.this._profileExtension.getName(port);
            }
            String _plus = ("Inferred replacement for " + _name);
            String _plus_1 = (_plus + " of (");
            String _name_1 = ReplacementStrategy.this._profileExtension.getName(ReplacementStrategy.this._profileExtension.getSib(port));
            String _plus_2 = (_plus_1 + _name_1);
            String _plus_3 = (_plus_2 + " -> ");
            String _name_2 = null;
            if (((SIB)sibReplacement)!=null) {
              _name_2=ReplacementStrategy.this._profileExtension.getName(((SIB)sibReplacement));
            }
            String _plus_4 = (_plus_3 + _name_2);
            String _plus_5 = (_plus_4 + ") => ");
            String _cachedReferencedObjectName = null;
            if (it!=null) {
              _cachedReferencedObjectName=it.getCachedReferencedObjectName();
            }
            String _plus_6 = (_plus_5 + _cachedReferencedObjectName);
            InputOutput.<String>println(_plus_6);
          }
        };
        _xifexpression = ObjectExtensions.<InputPort>operator_doubleArrow(_inferredReplacement, _function);
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  public InputPort getInferredReplacement(final InputPort port, final ReplacementSIB replSib) {
    InputPort _elvis = null;
    InputPort _replacementByEdge = this.getReplacementByEdge(port, replSib);
    if (_replacementByEdge != null) {
      _elvis = _replacementByEdge;
    } else {
      InputPort _replacementByPath = this.getReplacementByPath(port, replSib);
      _elvis = _replacementByPath;
    }
    final Procedure1<InputPort> _function = new Procedure1<InputPort>() {
      @Override
      public void apply(final InputPort it) {
        String _name = null;
        if (port!=null) {
          _name=ReplacementStrategy.this._profileExtension.getName(port);
        }
        String _plus = ("Inferred replacement for " + _name);
        String _plus_1 = (_plus + " of (");
        String _name_1 = ReplacementStrategy.this._profileExtension.getName(ReplacementStrategy.this._profileExtension.getSib(port));
        String _plus_2 = (_plus_1 + _name_1);
        String _plus_3 = (_plus_2 + " -> ");
        String _name_2 = null;
        if (replSib!=null) {
          _name_2=ReplacementStrategy.this._profileExtension.getName(replSib);
        }
        String _plus_4 = (_plus_3 + _name_2);
        String _plus_5 = (_plus_4 + ") => ");
        String _cachedReferencedObjectName = null;
        if (it!=null) {
          _cachedReferencedObjectName=it.getCachedReferencedObjectName();
        }
        String _plus_6 = (_plus_5 + _cachedReferencedObjectName);
        InputOutput.<String>println(_plus_6);
      }
    };
    return ObjectExtensions.<InputPort>operator_doubleArrow(_elvis, _function);
  }
  
  public InputPort getReplacement(final InputPort port) {
    InputPort _xblockexpression = null;
    {
      final Node replSib = this.getReplacement(this._profileExtension.getSib(port));
      InputPort _xifexpression = null;
      if ((replSib instanceof ReplacementSIB)) {
        InputPort _elvis = null;
        InputPort _replacementByEdge = this.getReplacementByEdge(port, ((ReplacementSIB)replSib));
        if (_replacementByEdge != null) {
          _elvis = _replacementByEdge;
        } else {
          InputPort _replacementByName = this.getReplacementByName(port, ((ReplacementSIB)replSib));
          _elvis = _replacementByName;
        }
        _xifexpression = _elvis;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  public InputPort getReplacementByEdge(final InputPort port, final ReplacementSIB replSib) {
    final Function1<InputPort, Boolean> _function = new Function1<InputPort, Boolean>() {
      @Override
      public Boolean apply(final InputPort it) {
        SIB _sib = ReplacementStrategy.this._profileExtension.getSib(it);
        return Boolean.valueOf(ReplacementStrategy.this._graphModelExtension.operator_equals(_sib, replSib));
      }
    };
    InputPort _head = IterableExtensions.<InputPort>head(IterableExtensions.<InputPort>filter(this._profileExtension.getTargetedPorts(port), _function));
    return ((InputPort) _head);
  }
  
  public InputPort getReplacementByName(final InputPort port, final ReplacementSIB replSib) {
    final Function1<InputPort, Boolean> _function = new Function1<InputPort, Boolean>() {
      @Override
      public Boolean apply(final InputPort it) {
        String _name = ReplacementStrategy.this._profileExtension.getName(it);
        String _name_1 = ReplacementStrategy.this._profileExtension.getName(port);
        return Boolean.valueOf(Objects.equal(_name, _name_1));
      }
    };
    InputPort _head = IterableExtensions.<InputPort>head(IterableExtensions.<InputPort>filter(this._graphModelExtension.<InputPort>find(replSib, InputPort.class), _function));
    return ((InputPort) _head);
  }
  
  public InputPort getReplacementByPath(final InputPort port, final ReplacementSIB replSib) {
    final ArrayList<Node> path = this.getReplacementPath(this._profileExtension.getSib(port));
    boolean _contains = path.contains(replSib);
    if (_contains) {
      InputPort currPort = port;
      int _size = path.size();
      ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
      for (final Integer i : _doubleDotLessThan) {
        {
          Node _get = path.get((i).intValue());
          final ReplacementSIB currSib = ((ReplacementSIB) _get);
          InputPort _elvis = null;
          InputPort _replacementByEdge = this.getReplacementByEdge(currPort, currSib);
          if (_replacementByEdge != null) {
            _elvis = _replacementByEdge;
          } else {
            InputPort _replacementByName = this.getReplacementByName(currPort, currSib);
            _elvis = _replacementByName;
          }
          currPort = _elvis;
          if ((this._graphModelExtension.operator_equals(currSib, replSib) || (currPort == null))) {
            return ((InputPort) currPort);
          }
        }
      }
    }
    return null;
  }
  
  public ReplacementBranch getInferredReplacement(final Branch branch) {
    ReplacementBranch _xblockexpression = null;
    {
      final Node sibReplacement = this.getInferredReplacement(this._profileExtension.getSib(branch));
      ReplacementBranch _xifexpression = null;
      if ((sibReplacement instanceof ReplacementSIB)) {
        _xifexpression = this.getInferredReplacement(branch, ((ReplacementSIB)sibReplacement));
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  public ReplacementBranch getInferredReplacement(final Branch branch, final ReplacementSIB replSib) {
    ReplacementBranch _elvis = null;
    ReplacementBranch _replacementByEdge = this.getReplacementByEdge(branch, replSib);
    if (_replacementByEdge != null) {
      _elvis = _replacementByEdge;
    } else {
      ReplacementBranch _replacementByPath = this.getReplacementByPath(branch, replSib);
      _elvis = _replacementByPath;
    }
    return _elvis;
  }
  
  public ReplacementBranch getReplacement(final Branch branch) {
    ReplacementBranch _xblockexpression = null;
    {
      final Node replSib = this.getReplacement(this._profileExtension.getSib(branch));
      ReplacementBranch _xifexpression = null;
      if ((replSib instanceof ReplacementSIB)) {
        ReplacementBranch _elvis = null;
        ReplacementBranch _replacementByEdge = this.getReplacementByEdge(branch, ((ReplacementSIB)replSib));
        if (_replacementByEdge != null) {
          _elvis = _replacementByEdge;
        } else {
          ReplacementBranch _replacementByName = this.getReplacementByName(branch, ((ReplacementSIB)replSib));
          _elvis = _replacementByName;
        }
        _xifexpression = _elvis;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  public ReplacementBranch getReplacementByEdge(final Branch branch, final ReplacementSIB replSib) {
    final Function1<BranchReplacement, ReplacementBranch> _function = new Function1<BranchReplacement, ReplacementBranch>() {
      @Override
      public ReplacementBranch apply(final BranchReplacement it) {
        return it.getTargetElement();
      }
    };
    final Function1<ReplacementBranch, Boolean> _function_1 = new Function1<ReplacementBranch, Boolean>() {
      @Override
      public Boolean apply(final ReplacementBranch it) {
        SIB _sib = ReplacementStrategy.this._profileExtension.getSib(it);
        return Boolean.valueOf(ReplacementStrategy.this._graphModelExtension.operator_equals(_sib, replSib));
      }
    };
    ReplacementBranch _head = IterableExtensions.<ReplacementBranch>head(IterableExtensions.<ReplacementBranch>filter(ListExtensions.<BranchReplacement, ReplacementBranch>map(branch.<BranchReplacement>getOutgoing(BranchReplacement.class), _function), _function_1));
    return ((ReplacementBranch) _head);
  }
  
  public ReplacementBranch getReplacementByName(final Branch branch, final ReplacementSIB replSib) {
    final Function1<Branch, Boolean> _function = new Function1<Branch, Boolean>() {
      @Override
      public Boolean apply(final Branch it) {
        String _name = ReplacementStrategy.this._profileExtension.getName(it);
        String _name_1 = ReplacementStrategy.this._profileExtension.getName(branch);
        return Boolean.valueOf(Objects.equal(_name, _name_1));
      }
    };
    Branch _head = IterableExtensions.<Branch>head(IterableExtensions.<Branch>filter(this._graphModelExtension.<Branch>find(replSib, Branch.class), _function));
    return ((ReplacementBranch) _head);
  }
  
  public ReplacementBranch getReplacementByPath(final Branch branch, final ReplacementSIB replSib) {
    final ArrayList<Node> path = this.getReplacementPath(this._profileExtension.getSib(branch));
    boolean _contains = path.contains(replSib);
    if (_contains) {
      Branch currBranch = branch;
      int _size = path.size();
      ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
      for (final Integer i : _doubleDotLessThan) {
        {
          Node _get = path.get((i).intValue());
          final ReplacementSIB currSib = ((ReplacementSIB) _get);
          ReplacementBranch _elvis = null;
          ReplacementBranch _replacementByEdge = this.getReplacementByEdge(currBranch, currSib);
          if (_replacementByEdge != null) {
            _elvis = _replacementByEdge;
          } else {
            ReplacementBranch _replacementByName = this.getReplacementByName(currBranch, currSib);
            _elvis = _replacementByName;
          }
          currBranch = _elvis;
          if ((this._graphModelExtension.operator_equals(currSib, replSib) || (currBranch == null))) {
            return ((ReplacementBranch) currBranch);
          }
        }
      }
    }
    return null;
  }
  
  public Iterable<OutputPort> getReplacements(final Iterable<OutputPort> it) {
    final Function1<OutputPort, List<OutputPort>> _function = new Function1<OutputPort, List<OutputPort>>() {
      @Override
      public List<OutputPort> apply(final OutputPort it) {
        return ReplacementStrategy.this._profileExtension.getTargetedPorts(it);
      }
    };
    return Iterables.<OutputPort>concat(IterableExtensions.<OutputPort, List<OutputPort>>map(it, _function));
  }
  
  public OutputPort getInferredReplacement(final OutputPort port) {
    OutputPort _xblockexpression = null;
    {
      final Node sibReplacement = this.getInferredReplacement(this._profileExtension.getSib(this._profileExtension.getBranch(port)));
      OutputPort _xifexpression = null;
      if ((sibReplacement instanceof ReplacementSIB)) {
        _xifexpression = this.getInferredReplacement(port, ((ReplacementSIB)sibReplacement));
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  public OutputPort getInferredReplacement(final OutputPort port, final ReplacementSIB replSib) {
    OutputPort _elvis = null;
    OutputPort _replacementByEdge = this.getReplacementByEdge(port, replSib);
    if (_replacementByEdge != null) {
      _elvis = _replacementByEdge;
    } else {
      OutputPort _replacementByPath = this.getReplacementByPath(port, replSib);
      _elvis = _replacementByPath;
    }
    final Procedure1<OutputPort> _function = new Procedure1<OutputPort>() {
      @Override
      public void apply(final OutputPort it) {
        String _name = ReplacementStrategy.this._profileExtension.getName(port);
        String _plus = ("Inferred replacement for " + _name);
        String _plus_1 = (_plus + " of branch ");
        String _name_1 = ReplacementStrategy.this._profileExtension.getName(ReplacementStrategy.this._profileExtension.getBranch(port));
        String _plus_2 = (_plus_1 + _name_1);
        String _plus_3 = (_plus_2 + " of (");
        String _name_2 = ReplacementStrategy.this._profileExtension.getName(ReplacementStrategy.this._profileExtension.getSib(ReplacementStrategy.this._profileExtension.getBranch(port)));
        String _plus_4 = (_plus_3 + _name_2);
        String _plus_5 = (_plus_4 + " -> ");
        String _name_3 = null;
        if (replSib!=null) {
          _name_3=ReplacementStrategy.this._profileExtension.getName(replSib);
        }
        String _plus_6 = (_plus_5 + _name_3);
        String _plus_7 = (_plus_6 + ") => ");
        String _cachedReferencedObjectName = null;
        if (it!=null) {
          _cachedReferencedObjectName=it.getCachedReferencedObjectName();
        }
        String _plus_8 = (_plus_7 + _cachedReferencedObjectName);
        InputOutput.<String>println(_plus_8);
      }
    };
    return ObjectExtensions.<OutputPort>operator_doubleArrow(_elvis, _function);
  }
  
  public OutputPort getReplacement(final OutputPort port) {
    OutputPort _xblockexpression = null;
    {
      final Node replSib = this.getReplacement(this._profileExtension.getSib(this._profileExtension.getBranch(port)));
      OutputPort _xifexpression = null;
      if ((replSib instanceof ReplacementSIB)) {
        OutputPort _elvis = null;
        OutputPort _replacementByEdge = this.getReplacementByEdge(port, ((ReplacementSIB)replSib));
        if (_replacementByEdge != null) {
          _elvis = _replacementByEdge;
        } else {
          OutputPort _replacementByName = this.getReplacementByName(port, ((ReplacementSIB)replSib));
          _elvis = _replacementByName;
        }
        _xifexpression = _elvis;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  public OutputPort getReplacementByEdge(final OutputPort port, final ReplacementSIB replSib) {
    final Function1<OutputPort, Boolean> _function = new Function1<OutputPort, Boolean>() {
      @Override
      public Boolean apply(final OutputPort it) {
        SIB _sib = ReplacementStrategy.this._profileExtension.getSib(ReplacementStrategy.this._profileExtension.getBranch(it));
        return Boolean.valueOf(ReplacementStrategy.this._graphModelExtension.operator_equals(_sib, replSib));
      }
    };
    OutputPort _head = IterableExtensions.<OutputPort>head(IterableExtensions.<OutputPort>filter(this._profileExtension.getTargetedPorts(port), _function));
    return ((OutputPort) _head);
  }
  
  public OutputPort getReplacementByName(final OutputPort port, final ReplacementSIB replSib) {
    final Function1<OutputPort, Boolean> _function = new Function1<OutputPort, Boolean>() {
      @Override
      public Boolean apply(final OutputPort it) {
        String _name = ReplacementStrategy.this._profileExtension.getName(it);
        String _name_1 = ReplacementStrategy.this._profileExtension.getName(port);
        return Boolean.valueOf(Objects.equal(_name, _name_1));
      }
    };
    OutputPort _head = IterableExtensions.<OutputPort>head(IterableExtensions.<OutputPort>filter(this._graphModelExtension.<OutputPort>find(this.getInferredReplacement(this._profileExtension.getBranch(port), replSib), OutputPort.class), _function));
    return ((OutputPort) _head);
  }
  
  public OutputPort getReplacementByPath(final OutputPort port, final ReplacementSIB replSib) {
    final ArrayList<Node> path = this.getReplacementPath(this._profileExtension.getSib(this._profileExtension.getBranch(port)));
    boolean _contains = path.contains(replSib);
    if (_contains) {
      OutputPort currPort = port;
      int _size = path.size();
      ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
      for (final Integer i : _doubleDotLessThan) {
        {
          Node _get = path.get((i).intValue());
          final ReplacementSIB currSib = ((ReplacementSIB) _get);
          OutputPort _elvis = null;
          OutputPort _replacementByEdge = this.getReplacementByEdge(currPort, currSib);
          if (_replacementByEdge != null) {
            _elvis = _replacementByEdge;
          } else {
            OutputPort _replacementByName = this.getReplacementByName(currPort, currSib);
            _elvis = _replacementByName;
          }
          currPort = _elvis;
          if ((this._graphModelExtension.operator_equals(currSib, replSib) || (currPort == null))) {
            return ((OutputPort) currPort);
          }
        }
      }
    }
    return null;
  }
  
  public boolean getReplacementConditionsFulfilled(final Node sib) {
    if (sib instanceof SIB) {
      return _getReplacementConditionsFulfilled((SIB)sib);
    } else if (sib != null) {
      return _getReplacementConditionsFulfilled(sib);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(sib).toString());
    }
  }
}
