/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.profile.util;

import com.google.common.base.Objects;
import graphmodel.Node;
import info.scce.dime.gUIPlugin.Output;
import info.scce.dime.gui.gui.Branch;
import info.scce.dime.gui.gui.Button;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.process.process.BranchBlueprint;
import info.scce.dime.process.process.EndSIB;
import info.scce.dime.process.process.SIB;
import info.scce.dime.profile.api.ProfileExtension;
import info.scce.dime.profile.profile.BlueprintBranch;
import info.scce.dime.profile.profile.BlueprintSIB;
import info.scce.dime.profile.profile.BranchReferencingBranch;
import info.scce.dime.profile.profile.ButtonReferencingBranch;
import info.scce.dime.profile.profile.EndSIBReferencingBranch;
import info.scce.dime.profile.profile.GUIBlueprintSIB;
import info.scce.dime.profile.profile.GUISIB;
import info.scce.dime.profile.profile.IO;
import info.scce.dime.profile.profile.OutputReferencingBranch;
import info.scce.dime.profile.profile.ProcessBlueprintSIB;
import info.scce.dime.profile.profile.ProcessSIB;
import info.scce.dime.profile.profile.ReplacementSIB;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class PrimeNameCacher {
  @Extension
  private ProfileExtension _profileExtension = new ProfileExtension();
  
  protected boolean _cacheNames(final Node node) {
    return true;
  }
  
  protected boolean _cacheNames(final GUISIB sib) {
    GUI _referencedGUI = sib.getReferencedGUI();
    final GUI obj = ((GUI) _referencedGUI);
    String _title = null;
    if (obj!=null) {
      _title=obj.getTitle();
    }
    this.cacheName(sib, _title);
    return (obj != null);
  }
  
  protected boolean _cacheNames(final ProcessSIB sib) {
    info.scce.dime.process.process.Process _referencedProcess = sib.getReferencedProcess();
    final info.scce.dime.process.process.Process obj = ((info.scce.dime.process.process.Process) _referencedProcess);
    String _modelName = null;
    if (obj!=null) {
      _modelName=obj.getModelName();
    }
    this.cacheName(sib, _modelName);
    return (obj != null);
  }
  
  protected boolean _cacheNames(final ProcessBlueprintSIB sib) {
    info.scce.dime.process.process.ProcessBlueprintSIB _referencedProcessBlueprintSIB = sib.getReferencedProcessBlueprintSIB();
    final SIB obj = ((SIB) _referencedProcessBlueprintSIB);
    this.cacheNames(sib, obj);
    return (obj != null);
  }
  
  protected boolean _cacheNames(final GUIBlueprintSIB sib) {
    info.scce.dime.process.process.GUIBlueprintSIB _referencedGUIBlueprintSIB = sib.getReferencedGUIBlueprintSIB();
    final SIB obj = ((SIB) _referencedGUIBlueprintSIB);
    this.cacheNames(sib, obj);
    return (obj != null);
  }
  
  public void cacheNames(final BlueprintSIB sib, final SIB refSib) {
    if ((refSib != null)) {
      info.scce.dime.process.process.Process _rootElement = refSib.getRootElement();
      String _modelName = null;
      if (_rootElement!=null) {
        _modelName=_rootElement.getModelName();
      }
      final String refModelName = _modelName;
      if (((!StringExtensions.isNullOrEmpty(refModelName)) && (!Objects.equal(sib.getCachedReferencedBlueprintSIBsModelName(), refModelName)))) {
        sib.setCachedReferencedBlueprintSIBsModelName(refModelName);
      }
      final String refSibLabel = refSib.getLabel();
      if (((!StringExtensions.isNullOrEmpty(refSibLabel)) && (!Objects.equal(sib.getCachedReferencedBlueprintSIBLabel(), refSibLabel)))) {
        sib.setCachedReferencedBlueprintSIBLabel(refSibLabel);
      }
    }
  }
  
  public void cacheName(final ReplacementSIB sib, final String name) {
    if (((!StringExtensions.isNullOrEmpty(name)) && (!Objects.equal(sib.getCachedReferencedObjectName(), name)))) {
      sib.setCachedReferencedObjectName(name);
    }
  }
  
  protected boolean _cacheNames(final BranchReferencingBranch branch) {
    Branch _referencedBranch = branch.getReferencedBranch();
    final Branch obj = ((Branch) _referencedBranch);
    String _name = null;
    if (obj!=null) {
      _name=obj.getName();
    }
    this.cacheName(branch, _name);
    return (obj != null);
  }
  
  protected boolean _cacheNames(final ButtonReferencingBranch branch) {
    Button _referencedButton = branch.getReferencedButton();
    final Button obj = ((Button) _referencedButton);
    String _label = null;
    if (obj!=null) {
      _label=obj.getLabel();
    }
    this.cacheName(branch, _label);
    return (obj != null);
  }
  
  protected boolean _cacheNames(final EndSIBReferencingBranch branch) {
    EndSIB _referencedEndSIB = branch.getReferencedEndSIB();
    final EndSIB obj = ((EndSIB) _referencedEndSIB);
    String _branchName = null;
    if (obj!=null) {
      _branchName=obj.getBranchName();
    }
    this.cacheName(branch, _branchName);
    return (obj != null);
  }
  
  protected boolean _cacheNames(final OutputReferencingBranch branch) {
    EObject _referencedOutput = branch.getReferencedOutput();
    final Output obj = ((Output) _referencedOutput);
    String _outputName = null;
    if (obj!=null) {
      _outputName=obj.getOutputName();
    }
    this.cacheName(branch, _outputName);
    return (obj != null);
  }
  
  protected boolean _cacheNames(final BlueprintBranch branch) {
    BranchBlueprint _referencedBranch = branch.getReferencedBranch();
    final BranchBlueprint obj = ((BranchBlueprint) _referencedBranch);
    String _name = null;
    if (obj!=null) {
      _name=obj.getName();
    }
    this.cacheName(branch, _name);
    return (obj != null);
  }
  
  public void cacheName(final info.scce.dime.profile.profile.Branch branch, final String name) {
    if (((!StringExtensions.isNullOrEmpty(name)) && (!Objects.equal(branch.getCachedReferencedObjectName(), name)))) {
      branch.setCachedReferencedObjectName(name);
    }
  }
  
  protected boolean _cacheNames(final IO port) {
    final EObject refPort = this._profileExtension.getReferencedObject(port);
    if ((refPort != null)) {
      final String refPortName = this._profileExtension.getReferencedObjectName(port);
      if (((!StringExtensions.isNullOrEmpty(refPortName)) && (!Objects.equal(port.getCachedReferencedObjectName(), refPortName)))) {
        port.setCachedReferencedObjectName(refPortName);
      }
      String refPortDataTypeName = this._profileExtension.getReferencedObjectDataTypeName(port);
      if ((refPortDataTypeName != null)) {
        boolean _isReferencedObjectList = this._profileExtension.isReferencedObjectList(port);
        if (_isReferencedObjectList) {
          refPortDataTypeName = (("[" + refPortDataTypeName) + "]");
        }
        String _cachedReferencedObjectDataTypeName = port.getCachedReferencedObjectDataTypeName();
        boolean _notEquals = (!Objects.equal(_cachedReferencedObjectDataTypeName, refPortDataTypeName));
        if (_notEquals) {
          port.setCachedReferencedObjectDataTypeName(refPortDataTypeName);
        }
      }
    }
    return (refPort != null);
  }
  
  public boolean cacheNames(final Node branch) {
    if (branch instanceof BranchReferencingBranch) {
      return _cacheNames((BranchReferencingBranch)branch);
    } else if (branch instanceof ButtonReferencingBranch) {
      return _cacheNames((ButtonReferencingBranch)branch);
    } else if (branch instanceof EndSIBReferencingBranch) {
      return _cacheNames((EndSIBReferencingBranch)branch);
    } else if (branch instanceof GUIBlueprintSIB) {
      return _cacheNames((GUIBlueprintSIB)branch);
    } else if (branch instanceof GUISIB) {
      return _cacheNames((GUISIB)branch);
    } else if (branch instanceof OutputReferencingBranch) {
      return _cacheNames((OutputReferencingBranch)branch);
    } else if (branch instanceof ProcessBlueprintSIB) {
      return _cacheNames((ProcessBlueprintSIB)branch);
    } else if (branch instanceof ProcessSIB) {
      return _cacheNames((ProcessSIB)branch);
    } else if (branch instanceof BlueprintBranch) {
      return _cacheNames((BlueprintBranch)branch);
    } else if (branch instanceof IO) {
      return _cacheNames((IO)branch);
    } else if (branch != null) {
      return _cacheNames(branch);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(branch).toString());
    }
  }
}
