/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.profile.layout;

import de.jabc.cinco.meta.runtime.layout.LayoutConfiguration;
import de.jabc.cinco.meta.runtime.layout.ListLayouter;
import graphmodel.Container;
import graphmodel.Node;
import info.scce.dime.profile.profile.BlueprintSIB;
import info.scce.dime.profile.profile.Branch;
import info.scce.dime.profile.profile.InputPort;
import info.scce.dime.profile.profile.OutputPort;
import info.scce.dime.profile.profile.SIB;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;

@SuppressWarnings("all")
public class Layouter extends ListLayouter {
  private static Layouter _instance;
  
  public static Layouter getInstance() {
    Layouter _elvis = null;
    if (Layouter._instance != null) {
      _elvis = Layouter._instance;
    } else {
      Layouter _layouter = new Layouter();
      Layouter __instance = (Layouter._instance = _layouter);
      _elvis = __instance;
    }
    return _elvis;
  }
  
  protected Map<LayoutConfiguration, ?> _getLayoutConfiguration(final SIB sib) {
    Pair<LayoutConfiguration, Integer> _mappedTo = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.PADDING_TOP, Integer.valueOf(30));
    return Collections.<LayoutConfiguration, Integer>unmodifiableMap(CollectionLiterals.<LayoutConfiguration, Integer>newHashMap(_mappedTo));
  }
  
  protected Map<LayoutConfiguration, ?> _getLayoutConfiguration(final Branch container) {
    Pair<LayoutConfiguration, Integer> _mappedTo = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.MIN_WIDTH, Integer.valueOf(100));
    Pair<LayoutConfiguration, Integer> _mappedTo_1 = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.MIN_HEIGHT, Integer.valueOf(20));
    Pair<LayoutConfiguration, Integer> _mappedTo_2 = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.PADDING_TOP, Integer.valueOf(24));
    return Collections.<LayoutConfiguration, Integer>unmodifiableMap(CollectionLiterals.<LayoutConfiguration, Integer>newHashMap(_mappedTo, _mappedTo_1, _mappedTo_2));
  }
  
  protected Map<LayoutConfiguration, ?> _getLayoutConfiguration(final InputPort container) {
    Pair<LayoutConfiguration, Integer> _mappedTo = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.MIN_HEIGHT, Integer.valueOf(18));
    Pair<LayoutConfiguration, Integer> _mappedTo_1 = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.PADDING_TOP, Integer.valueOf(24));
    Pair<LayoutConfiguration, Integer> _mappedTo_2 = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.PADDING_BOTTOM, Integer.valueOf(5));
    return Collections.<LayoutConfiguration, Integer>unmodifiableMap(CollectionLiterals.<LayoutConfiguration, Integer>newHashMap(_mappedTo, _mappedTo_1, _mappedTo_2));
  }
  
  protected Map<LayoutConfiguration, ?> _getLayoutConfiguration(final OutputPort container) {
    Pair<LayoutConfiguration, Integer> _mappedTo = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.MIN_HEIGHT, Integer.valueOf(18));
    Pair<LayoutConfiguration, Integer> _mappedTo_1 = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.PADDING_TOP, Integer.valueOf(24));
    return Collections.<LayoutConfiguration, Integer>unmodifiableMap(CollectionLiterals.<LayoutConfiguration, Integer>newHashMap(_mappedTo, _mappedTo_1));
  }
  
  protected Map<LayoutConfiguration, ?> _getLayoutConfiguration(final BlueprintSIB sib) {
    Pair<LayoutConfiguration, Integer> _mappedTo = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.MIN_HEIGHT, Integer.valueOf(34));
    Pair<LayoutConfiguration, Integer> _mappedTo_1 = Pair.<LayoutConfiguration, Integer>of(LayoutConfiguration.PADDING_TOP, Integer.valueOf(38));
    return Collections.<LayoutConfiguration, Integer>unmodifiableMap(CollectionLiterals.<LayoutConfiguration, Integer>newHashMap(_mappedTo, _mappedTo_1));
  }
  
  protected List<? extends Class<? extends Node>> _getInnerOrder(final SIB sib) {
    return Collections.<Class<? extends Node>>unmodifiableList(CollectionLiterals.<Class<? extends Node>>newArrayList(InputPort.class, Branch.class));
  }
  
  public Map<LayoutConfiguration, ?> getLayoutConfiguration(final Container sib) {
    if (sib instanceof BlueprintSIB) {
      return _getLayoutConfiguration((BlueprintSIB)sib);
    } else if (sib instanceof InputPort) {
      return _getLayoutConfiguration((InputPort)sib);
    } else if (sib instanceof OutputPort) {
      return _getLayoutConfiguration((OutputPort)sib);
    } else if (sib instanceof Branch) {
      return _getLayoutConfiguration((Branch)sib);
    } else if (sib instanceof SIB) {
      return _getLayoutConfiguration((SIB)sib);
    } else if (sib != null) {
      return _getLayoutConfiguration(sib);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(sib).toString());
    }
  }
  
  public List<? extends Class<? extends Node>> getInnerOrder(final Container sib) {
    if (sib instanceof SIB) {
      return _getInnerOrder((SIB)sib);
    } else if (sib != null) {
      return _getInnerOrder(sib);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(sib).toString());
    }
  }
}
