/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.profile.hooks;

import graphmodel.Container;
import info.scce.dime.api.DIMEPostCreateHook;
import info.scce.dime.profile.build.GUIBlueprintSIBBuild;
import info.scce.dime.profile.build.GUISIBBuild;
import info.scce.dime.profile.build.PrimeSIBBuild;
import info.scce.dime.profile.build.ProcessBlueprintSIBBuild;
import info.scce.dime.profile.build.ProcessSIBBuild;
import info.scce.dime.profile.profile.Branch;
import info.scce.dime.profile.profile.GUIBlueprintSIB;
import info.scce.dime.profile.profile.GUISIB;
import info.scce.dime.profile.profile.InputPort;
import info.scce.dime.profile.profile.OutputPort;
import info.scce.dime.profile.profile.ProcessBlueprintSIB;
import info.scce.dime.profile.profile.ProcessSIB;
import info.scce.dime.profile.profile.SIB;
import info.scce.dime.profile.util.PrimeNameCacher;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class PostCreateSIB extends DIMEPostCreateHook<SIB> {
  @Extension
  private PrimeNameCacher _primeNameCacher = new PrimeNameCacher();
  
  @Override
  public void postCreate(final SIB sib) {
    PrimeSIBBuild<? extends SIB, InputPort, ? extends Container, ? extends Branch, ? extends EObject, ? extends OutputPort, ? extends EObject> _switchResult = null;
    boolean _matched = false;
    if (sib instanceof GUISIB) {
      _matched=true;
      _switchResult = new GUISIBBuild(((GUISIB)sib));
    }
    if (!_matched) {
      if (sib instanceof ProcessSIB) {
        _matched=true;
        _switchResult = new ProcessSIBBuild(((ProcessSIB)sib));
      }
    }
    if (!_matched) {
      if (sib instanceof GUIBlueprintSIB) {
        _matched=true;
        _switchResult = new GUIBlueprintSIBBuild(((GUIBlueprintSIB)sib));
      }
    }
    if (!_matched) {
      if (sib instanceof ProcessBlueprintSIB) {
        _matched=true;
        _switchResult = new ProcessBlueprintSIBBuild(((ProcessBlueprintSIB)sib));
      }
    }
    if (_switchResult!=null) {
      _switchResult.initialize();
    }
    this._primeNameCacher.cacheNames(sib);
  }
}
