package info.scce.dime.profile.factory;

import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import graphmodel.Type;
import graphmodel.internal.InternalEdge;
import graphmodel.internal.InternalGraphModel;
import graphmodel.internal.InternalIdentifiableElement;
import graphmodel.internal.InternalModelElement;
import graphmodel.internal.InternalModelElementContainer;
import graphmodel.internal.InternalNode;
import graphmodel.internal.InternalType;
import info.scce.dime.profile.adapter.AbstractParameterReferencingOutputPortEContentAdapter;
import info.scce.dime.profile.adapter.AddToSubmissionReferencingOutputPortEContentAdapter;
import info.scce.dime.profile.adapter.BlueprintBranchEContentAdapter;
import info.scce.dime.profile.adapter.BranchReferencingBranchEContentAdapter;
import info.scce.dime.profile.adapter.BranchReplacementEContentAdapter;
import info.scce.dime.profile.adapter.ButtonReferencingBranchEContentAdapter;
import info.scce.dime.profile.adapter.ComplexAttributeReferencingOutputPortEContentAdapter;
import info.scce.dime.profile.adapter.ComplexInputPortReferencingInputPortEContentAdapter;
import info.scce.dime.profile.adapter.ComplexInputPortReferencingOutputPortEContentAdapter;
import info.scce.dime.profile.adapter.ComplexOutputPortReferencingInputPortEContentAdapter;
import info.scce.dime.profile.adapter.ComplexOutputPortReferencingOutputPortEContentAdapter;
import info.scce.dime.profile.adapter.ComplexVariableReferencingInputPortEContentAdapter;
import info.scce.dime.profile.adapter.ComplexVariableReferencingOutputPortEContentAdapter;
import info.scce.dime.profile.adapter.DoNotReplaceEContentAdapter;
import info.scce.dime.profile.adapter.EndSIBReferencingBranchEContentAdapter;
import info.scce.dime.profile.adapter.GUIBlueprintSIBEContentAdapter;
import info.scce.dime.profile.adapter.GUIComplexInputPortReferencingOutputPortEContentAdapter;
import info.scce.dime.profile.adapter.GUIComplexOutputPortReferencingOutputPortEContentAdapter;
import info.scce.dime.profile.adapter.GUIPrimitiveInputPortReferencingOutputPortEContentAdapter;
import info.scce.dime.profile.adapter.GUIPrimitiveOutputPortReferencingOutputPortEContentAdapter;
import info.scce.dime.profile.adapter.GUISIBEContentAdapter;
import info.scce.dime.profile.adapter.InputPortMappingEContentAdapter;
import info.scce.dime.profile.adapter.OutputGenericReferencingOutputPortEContentAdapter;
import info.scce.dime.profile.adapter.OutputPortMappingEContentAdapter;
import info.scce.dime.profile.adapter.OutputReferencingBranchEContentAdapter;
import info.scce.dime.profile.adapter.PrimitiveAttributeReferencingOutputPortEContentAdapter;
import info.scce.dime.profile.adapter.PrimitiveInputPortReferencingInputPortEContentAdapter;
import info.scce.dime.profile.adapter.PrimitiveInputPortReferencingOutputPortEContentAdapter;
import info.scce.dime.profile.adapter.PrimitiveOutputPortReferencingInputPortEContentAdapter;
import info.scce.dime.profile.adapter.PrimitiveOutputPortReferencingOutputPortEContentAdapter;
import info.scce.dime.profile.adapter.PrimitiveVariableReferencingInputPortEContentAdapter;
import info.scce.dime.profile.adapter.PrimitiveVariableReferencingOutputPortEContentAdapter;
import info.scce.dime.profile.adapter.ProcessBlueprintSIBEContentAdapter;
import info.scce.dime.profile.adapter.ProcessSIBEContentAdapter;
import info.scce.dime.profile.adapter.ProfileEContentAdapter;
import info.scce.dime.profile.adapter.ReplacementConditionEContentAdapter;
import info.scce.dime.profile.adapter.SIBReplacementEContentAdapter;
import info.scce.dime.profile.hooks.PostCreateProfile;
import info.scce.dime.profile.hooks.PostCreateSIB;
import info.scce.dime.profile.profile.AbstractParameterReferencingOutputPort;
import info.scce.dime.profile.profile.AddToSubmissionReferencingOutputPort;
import info.scce.dime.profile.profile.BlueprintBranch;
import info.scce.dime.profile.profile.BranchReferencingBranch;
import info.scce.dime.profile.profile.BranchReplacement;
import info.scce.dime.profile.profile.ButtonReferencingBranch;
import info.scce.dime.profile.profile.ComplexAttributeReferencingOutputPort;
import info.scce.dime.profile.profile.ComplexInputPortReferencingInputPort;
import info.scce.dime.profile.profile.ComplexInputPortReferencingOutputPort;
import info.scce.dime.profile.profile.ComplexOutputPortReferencingInputPort;
import info.scce.dime.profile.profile.ComplexOutputPortReferencingOutputPort;
import info.scce.dime.profile.profile.ComplexVariableReferencingInputPort;
import info.scce.dime.profile.profile.ComplexVariableReferencingOutputPort;
import info.scce.dime.profile.profile.DoNotReplace;
import info.scce.dime.profile.profile.EndSIBReferencingBranch;
import info.scce.dime.profile.profile.GUIBlueprintSIB;
import info.scce.dime.profile.profile.GUIComplexInputPortReferencingOutputPort;
import info.scce.dime.profile.profile.GUIComplexOutputPortReferencingOutputPort;
import info.scce.dime.profile.profile.GUIPrimitiveInputPortReferencingOutputPort;
import info.scce.dime.profile.profile.GUIPrimitiveOutputPortReferencingOutputPort;
import info.scce.dime.profile.profile.GUISIB;
import info.scce.dime.profile.profile.InputPortMapping;
import info.scce.dime.profile.profile.OutputGenericReferencingOutputPort;
import info.scce.dime.profile.profile.OutputPortMapping;
import info.scce.dime.profile.profile.OutputReferencingBranch;
import info.scce.dime.profile.profile.PrimitiveAttributeReferencingOutputPort;
import info.scce.dime.profile.profile.PrimitiveInputPortReferencingInputPort;
import info.scce.dime.profile.profile.PrimitiveInputPortReferencingOutputPort;
import info.scce.dime.profile.profile.PrimitiveOutputPortReferencingInputPort;
import info.scce.dime.profile.profile.PrimitiveOutputPortReferencingOutputPort;
import info.scce.dime.profile.profile.PrimitiveVariableReferencingInputPort;
import info.scce.dime.profile.profile.PrimitiveVariableReferencingOutputPort;
import info.scce.dime.profile.profile.ProcessBlueprintSIB;
import info.scce.dime.profile.profile.ProcessSIB;
import info.scce.dime.profile.profile.Profile;
import info.scce.dime.profile.profile.ProfilePackage;
import info.scce.dime.profile.profile.ReplacementCondition;
import info.scce.dime.profile.profile.SIBReplacement;
import info.scce.dime.profile.profile.impl.ProfileFactoryImpl;
import info.scce.dime.profile.profile.internal.InternalAbstractParameterReferencingOutputPort;
import info.scce.dime.profile.profile.internal.InternalAddToSubmissionReferencingOutputPort;
import info.scce.dime.profile.profile.internal.InternalBlueprintBranch;
import info.scce.dime.profile.profile.internal.InternalBranchReferencingBranch;
import info.scce.dime.profile.profile.internal.InternalBranchReplacement;
import info.scce.dime.profile.profile.internal.InternalButtonReferencingBranch;
import info.scce.dime.profile.profile.internal.InternalComplexAttributeReferencingOutputPort;
import info.scce.dime.profile.profile.internal.InternalComplexInputPortReferencingInputPort;
import info.scce.dime.profile.profile.internal.InternalComplexInputPortReferencingOutputPort;
import info.scce.dime.profile.profile.internal.InternalComplexOutputPortReferencingInputPort;
import info.scce.dime.profile.profile.internal.InternalComplexOutputPortReferencingOutputPort;
import info.scce.dime.profile.profile.internal.InternalComplexVariableReferencingInputPort;
import info.scce.dime.profile.profile.internal.InternalComplexVariableReferencingOutputPort;
import info.scce.dime.profile.profile.internal.InternalDoNotReplace;
import info.scce.dime.profile.profile.internal.InternalEndSIBReferencingBranch;
import info.scce.dime.profile.profile.internal.InternalFactory;
import info.scce.dime.profile.profile.internal.InternalGUIBlueprintSIB;
import info.scce.dime.profile.profile.internal.InternalGUIComplexInputPortReferencingOutputPort;
import info.scce.dime.profile.profile.internal.InternalGUIComplexOutputPortReferencingOutputPort;
import info.scce.dime.profile.profile.internal.InternalGUIPrimitiveInputPortReferencingOutputPort;
import info.scce.dime.profile.profile.internal.InternalGUIPrimitiveOutputPortReferencingOutputPort;
import info.scce.dime.profile.profile.internal.InternalGUISIB;
import info.scce.dime.profile.profile.internal.InternalInputPortMapping;
import info.scce.dime.profile.profile.internal.InternalOutputGenericReferencingOutputPort;
import info.scce.dime.profile.profile.internal.InternalOutputPortMapping;
import info.scce.dime.profile.profile.internal.InternalOutputReferencingBranch;
import info.scce.dime.profile.profile.internal.InternalPrimitiveAttributeReferencingOutputPort;
import info.scce.dime.profile.profile.internal.InternalPrimitiveInputPortReferencingInputPort;
import info.scce.dime.profile.profile.internal.InternalPrimitiveInputPortReferencingOutputPort;
import info.scce.dime.profile.profile.internal.InternalPrimitiveOutputPortReferencingInputPort;
import info.scce.dime.profile.profile.internal.InternalPrimitiveOutputPortReferencingOutputPort;
import info.scce.dime.profile.profile.internal.InternalPrimitiveVariableReferencingInputPort;
import info.scce.dime.profile.profile.internal.InternalPrimitiveVariableReferencingOutputPort;
import info.scce.dime.profile.profile.internal.InternalProcessBlueprintSIB;
import info.scce.dime.profile.profile.internal.InternalProcessSIB;
import info.scce.dime.profile.profile.internal.InternalProfile;
import info.scce.dime.profile.profile.internal.InternalReplacementCondition;
import info.scce.dime.profile.profile.internal.InternalSIBReplacement;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class ProfileFactory extends ProfileFactoryImpl {
  @Extension
  private final InternalFactory _internalFactory = InternalFactory.eINSTANCE;
  
  public static ProfileFactory eINSTANCE = ProfileFactory.init();
  
  @Extension
  private WorkbenchExtension _workbenchExtension = new WorkbenchExtension();
  
  public static ProfileFactory init() {
    ProfileFactory _xblockexpression = null;
    {
      try {
        EFactory _eFactory = EPackage.Registry.INSTANCE.getEFactory(ProfilePackage.eNS_URI);
        final ProfileFactory fct = ((ProfileFactory) _eFactory);
        if ((fct != null)) {
          return ((ProfileFactory) fct);
        }
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception exception = (Exception)_t;
          EcorePlugin.INSTANCE.log(exception);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
      _xblockexpression = new ProfileFactory();
    }
    return _xblockexpression;
  }
  
  /**
   * This method creates an OutputGenericReferencingOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public OutputGenericReferencingOutputPort createOutputGenericReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    OutputGenericReferencingOutputPort _createOutputGenericReferencingOutputPort = super.createOutputGenericReferencingOutputPort();
    final Procedure1<OutputGenericReferencingOutputPort> _function = new Procedure1<OutputGenericReferencingOutputPort>() {
      @Override
      public void apply(final OutputGenericReferencingOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalOutputGenericReferencingOutputPort _createInternalOutputGenericReferencingOutputPort = ProfileFactory.this._internalFactory.createInternalOutputGenericReferencingOutputPort();
          _elvis = _createInternalOutputGenericReferencingOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            OutputGenericReferencingOutputPortEContentAdapter _outputGenericReferencingOutputPortEContentAdapter = new OutputGenericReferencingOutputPortEContentAdapter();
            _eAdapters.add(_outputGenericReferencingOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<OutputGenericReferencingOutputPort>operator_doubleArrow(_createOutputGenericReferencingOutputPort, _function);
  }
  
  /**
   * This method creates an OutputGenericReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public OutputGenericReferencingOutputPort createOutputGenericReferencingOutputPort(final String ID) {
    return this.createOutputGenericReferencingOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an OutputGenericReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public OutputGenericReferencingOutputPort createOutputGenericReferencingOutputPort(final InternalModelElementContainer parent) {
    return this.createOutputGenericReferencingOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an OutputGenericReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public OutputGenericReferencingOutputPort createOutputGenericReferencingOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createOutputGenericReferencingOutputPort(ID, null, parent, true);
  }
  
  public OutputGenericReferencingOutputPort createOutputGenericReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createOutputGenericReferencingOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an OutputGenericReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public OutputGenericReferencingOutputPort createOutputGenericReferencingOutputPort(final InternalModelElement ime) {
    return this.createOutputGenericReferencingOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public OutputGenericReferencingOutputPort createOutputGenericReferencingOutputPort() {
    return this.createOutputGenericReferencingOutputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexOutputPortReferencingInputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexOutputPortReferencingInputPort createComplexOutputPortReferencingInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexOutputPortReferencingInputPort _createComplexOutputPortReferencingInputPort = super.createComplexOutputPortReferencingInputPort();
    final Procedure1<ComplexOutputPortReferencingInputPort> _function = new Procedure1<ComplexOutputPortReferencingInputPort>() {
      @Override
      public void apply(final ComplexOutputPortReferencingInputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexOutputPortReferencingInputPort _createInternalComplexOutputPortReferencingInputPort = ProfileFactory.this._internalFactory.createInternalComplexOutputPortReferencingInputPort();
          _elvis = _createInternalComplexOutputPortReferencingInputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexOutputPortReferencingInputPortEContentAdapter _complexOutputPortReferencingInputPortEContentAdapter = new ComplexOutputPortReferencingInputPortEContentAdapter();
            _eAdapters.add(_complexOutputPortReferencingInputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ComplexOutputPortReferencingInputPort>operator_doubleArrow(_createComplexOutputPortReferencingInputPort, _function);
  }
  
  /**
   * This method creates an ComplexOutputPortReferencingInputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexOutputPortReferencingInputPort createComplexOutputPortReferencingInputPort(final String ID) {
    return this.createComplexOutputPortReferencingInputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexOutputPortReferencingInputPort with the given id. Post create hook will be triggered.
   */
  public ComplexOutputPortReferencingInputPort createComplexOutputPortReferencingInputPort(final InternalModelElementContainer parent) {
    return this.createComplexOutputPortReferencingInputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexOutputPortReferencingInputPort with the given id. Post create hook will be triggered.
   */
  public ComplexOutputPortReferencingInputPort createComplexOutputPortReferencingInputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexOutputPortReferencingInputPort(ID, null, parent, true);
  }
  
  public ComplexOutputPortReferencingInputPort createComplexOutputPortReferencingInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexOutputPortReferencingInputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexOutputPortReferencingInputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexOutputPortReferencingInputPort createComplexOutputPortReferencingInputPort(final InternalModelElement ime) {
    return this.createComplexOutputPortReferencingInputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexOutputPortReferencingInputPort createComplexOutputPortReferencingInputPort() {
    return this.createComplexOutputPortReferencingInputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an GUIComplexOutputPortReferencingOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public GUIComplexOutputPortReferencingOutputPort createGUIComplexOutputPortReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    GUIComplexOutputPortReferencingOutputPort _createGUIComplexOutputPortReferencingOutputPort = super.createGUIComplexOutputPortReferencingOutputPort();
    final Procedure1<GUIComplexOutputPortReferencingOutputPort> _function = new Procedure1<GUIComplexOutputPortReferencingOutputPort>() {
      @Override
      public void apply(final GUIComplexOutputPortReferencingOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalGUIComplexOutputPortReferencingOutputPort _createInternalGUIComplexOutputPortReferencingOutputPort = ProfileFactory.this._internalFactory.createInternalGUIComplexOutputPortReferencingOutputPort();
          _elvis = _createInternalGUIComplexOutputPortReferencingOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            GUIComplexOutputPortReferencingOutputPortEContentAdapter _gUIComplexOutputPortReferencingOutputPortEContentAdapter = new GUIComplexOutputPortReferencingOutputPortEContentAdapter();
            _eAdapters.add(_gUIComplexOutputPortReferencingOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<GUIComplexOutputPortReferencingOutputPort>operator_doubleArrow(_createGUIComplexOutputPortReferencingOutputPort, _function);
  }
  
  /**
   * This method creates an GUIComplexOutputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public GUIComplexOutputPortReferencingOutputPort createGUIComplexOutputPortReferencingOutputPort(final String ID) {
    return this.createGUIComplexOutputPortReferencingOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an GUIComplexOutputPortReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public GUIComplexOutputPortReferencingOutputPort createGUIComplexOutputPortReferencingOutputPort(final InternalModelElementContainer parent) {
    return this.createGUIComplexOutputPortReferencingOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an GUIComplexOutputPortReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public GUIComplexOutputPortReferencingOutputPort createGUIComplexOutputPortReferencingOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createGUIComplexOutputPortReferencingOutputPort(ID, null, parent, true);
  }
  
  public GUIComplexOutputPortReferencingOutputPort createGUIComplexOutputPortReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createGUIComplexOutputPortReferencingOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an GUIComplexOutputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public GUIComplexOutputPortReferencingOutputPort createGUIComplexOutputPortReferencingOutputPort(final InternalModelElement ime) {
    return this.createGUIComplexOutputPortReferencingOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public GUIComplexOutputPortReferencingOutputPort createGUIComplexOutputPortReferencingOutputPort() {
    return this.createGUIComplexOutputPortReferencingOutputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveInputPortReferencingInputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveInputPortReferencingInputPort createPrimitiveInputPortReferencingInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveInputPortReferencingInputPort _createPrimitiveInputPortReferencingInputPort = super.createPrimitiveInputPortReferencingInputPort();
    final Procedure1<PrimitiveInputPortReferencingInputPort> _function = new Procedure1<PrimitiveInputPortReferencingInputPort>() {
      @Override
      public void apply(final PrimitiveInputPortReferencingInputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveInputPortReferencingInputPort _createInternalPrimitiveInputPortReferencingInputPort = ProfileFactory.this._internalFactory.createInternalPrimitiveInputPortReferencingInputPort();
          _elvis = _createInternalPrimitiveInputPortReferencingInputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveInputPortReferencingInputPortEContentAdapter _primitiveInputPortReferencingInputPortEContentAdapter = new PrimitiveInputPortReferencingInputPortEContentAdapter();
            _eAdapters.add(_primitiveInputPortReferencingInputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<PrimitiveInputPortReferencingInputPort>operator_doubleArrow(_createPrimitiveInputPortReferencingInputPort, _function);
  }
  
  /**
   * This method creates an PrimitiveInputPortReferencingInputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveInputPortReferencingInputPort createPrimitiveInputPortReferencingInputPort(final String ID) {
    return this.createPrimitiveInputPortReferencingInputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveInputPortReferencingInputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveInputPortReferencingInputPort createPrimitiveInputPortReferencingInputPort(final InternalModelElementContainer parent) {
    return this.createPrimitiveInputPortReferencingInputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveInputPortReferencingInputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveInputPortReferencingInputPort createPrimitiveInputPortReferencingInputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveInputPortReferencingInputPort(ID, null, parent, true);
  }
  
  public PrimitiveInputPortReferencingInputPort createPrimitiveInputPortReferencingInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveInputPortReferencingInputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveInputPortReferencingInputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveInputPortReferencingInputPort createPrimitiveInputPortReferencingInputPort(final InternalModelElement ime) {
    return this.createPrimitiveInputPortReferencingInputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveInputPortReferencingInputPort createPrimitiveInputPortReferencingInputPort() {
    return this.createPrimitiveInputPortReferencingInputPort(EcoreUtil.generateUUID());
  }
  
  public OutputPortMapping createOutputPortMapping(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    OutputPortMapping _createOutputPortMapping = super.createOutputPortMapping();
    final Procedure1<OutputPortMapping> _function = new Procedure1<OutputPortMapping>() {
      @Override
      public void apply(final OutputPortMapping it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalOutputPortMapping _createInternalOutputPortMapping = ProfileFactory.this._internalFactory.createInternalOutputPortMapping();
          _elvis = _createInternalOutputPortMapping;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            OutputPortMappingEContentAdapter _outputPortMappingEContentAdapter = new OutputPortMappingEContentAdapter();
            _eAdapters.add(_outputPortMappingEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<OutputPortMapping>operator_doubleArrow(_createOutputPortMapping, _function);
  }
  
  /**
   * This method creates an OutputPortMapping with the given id. Post create hook will be triggered.
   */
  public OutputPortMapping createOutputPortMapping(final String ID, final InternalNode source, final InternalNode target) {
    return this.createOutputPortMapping(ID, null, source, target, true);
  }
  
  /**
   * This method creates an OutputPortMapping with generated id. Post create hook will be triggered.
   */
  public OutputPortMapping createOutputPortMapping(final InternalNode source, final InternalNode target) {
    return this.createOutputPortMapping(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an OutputPortMapping with the given id. Post create hook won't be triggered.
   */
  public OutputPortMapping createOutputPortMapping(final String ID) {
    return this.createOutputPortMapping(ID, null, null, null, false);
  }
  
  /**
   * This method creates an OutputPortMapping with a generated id. Post create hook won't be triggered.
   */
  @Override
  public OutputPortMapping createOutputPortMapping() {
    return this.createOutputPortMapping(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexVariableReferencingOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexVariableReferencingOutputPort createComplexVariableReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexVariableReferencingOutputPort _createComplexVariableReferencingOutputPort = super.createComplexVariableReferencingOutputPort();
    final Procedure1<ComplexVariableReferencingOutputPort> _function = new Procedure1<ComplexVariableReferencingOutputPort>() {
      @Override
      public void apply(final ComplexVariableReferencingOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexVariableReferencingOutputPort _createInternalComplexVariableReferencingOutputPort = ProfileFactory.this._internalFactory.createInternalComplexVariableReferencingOutputPort();
          _elvis = _createInternalComplexVariableReferencingOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexVariableReferencingOutputPortEContentAdapter _complexVariableReferencingOutputPortEContentAdapter = new ComplexVariableReferencingOutputPortEContentAdapter();
            _eAdapters.add(_complexVariableReferencingOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ComplexVariableReferencingOutputPort>operator_doubleArrow(_createComplexVariableReferencingOutputPort, _function);
  }
  
  /**
   * This method creates an ComplexVariableReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexVariableReferencingOutputPort createComplexVariableReferencingOutputPort(final String ID) {
    return this.createComplexVariableReferencingOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexVariableReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public ComplexVariableReferencingOutputPort createComplexVariableReferencingOutputPort(final InternalModelElementContainer parent) {
    return this.createComplexVariableReferencingOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexVariableReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public ComplexVariableReferencingOutputPort createComplexVariableReferencingOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexVariableReferencingOutputPort(ID, null, parent, true);
  }
  
  public ComplexVariableReferencingOutputPort createComplexVariableReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexVariableReferencingOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexVariableReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexVariableReferencingOutputPort createComplexVariableReferencingOutputPort(final InternalModelElement ime) {
    return this.createComplexVariableReferencingOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexVariableReferencingOutputPort createComplexVariableReferencingOutputPort() {
    return this.createComplexVariableReferencingOutputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ProcessSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ProcessSIB createProcessSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ProcessSIB _createProcessSIB = super.createProcessSIB();
    final Procedure1<ProcessSIB> _function = new Procedure1<ProcessSIB>() {
      @Override
      public void apply(final ProcessSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalProcessSIB _createInternalProcessSIB = ProfileFactory.this._internalFactory.createInternalProcessSIB();
          _elvis = _createInternalProcessSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ProcessSIBEContentAdapter _processSIBEContentAdapter = new ProcessSIBEContentAdapter();
            _eAdapters.add(_processSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProfileFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ProcessSIB>operator_doubleArrow(_createProcessSIB, _function);
  }
  
  /**
   * This method creates an ProcessSIB with the given id. Post create hook won't be triggered.
   */
  public ProcessSIB createProcessSIB(final String ID) {
    return this.createProcessSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an ProcessSIB with the given id. Post create hook will be triggered.
   */
  public ProcessSIB createProcessSIB(final InternalModelElementContainer parent) {
    return this.createProcessSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ProcessSIB with the given id. Post create hook will be triggered.
   */
  public ProcessSIB createProcessSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createProcessSIB(ID, null, parent, true);
  }
  
  public ProcessSIB createProcessSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createProcessSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ProcessSIB with the given id. Post create hook won't be triggered.
   */
  public ProcessSIB createProcessSIB(final InternalModelElement ime) {
    return this.createProcessSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ProcessSIB createProcessSIB() {
    return this.createProcessSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an AddToSubmissionReferencingOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public AddToSubmissionReferencingOutputPort createAddToSubmissionReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    AddToSubmissionReferencingOutputPort _createAddToSubmissionReferencingOutputPort = super.createAddToSubmissionReferencingOutputPort();
    final Procedure1<AddToSubmissionReferencingOutputPort> _function = new Procedure1<AddToSubmissionReferencingOutputPort>() {
      @Override
      public void apply(final AddToSubmissionReferencingOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalAddToSubmissionReferencingOutputPort _createInternalAddToSubmissionReferencingOutputPort = ProfileFactory.this._internalFactory.createInternalAddToSubmissionReferencingOutputPort();
          _elvis = _createInternalAddToSubmissionReferencingOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            AddToSubmissionReferencingOutputPortEContentAdapter _addToSubmissionReferencingOutputPortEContentAdapter = new AddToSubmissionReferencingOutputPortEContentAdapter();
            _eAdapters.add(_addToSubmissionReferencingOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<AddToSubmissionReferencingOutputPort>operator_doubleArrow(_createAddToSubmissionReferencingOutputPort, _function);
  }
  
  /**
   * This method creates an AddToSubmissionReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public AddToSubmissionReferencingOutputPort createAddToSubmissionReferencingOutputPort(final String ID) {
    return this.createAddToSubmissionReferencingOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an AddToSubmissionReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public AddToSubmissionReferencingOutputPort createAddToSubmissionReferencingOutputPort(final InternalModelElementContainer parent) {
    return this.createAddToSubmissionReferencingOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an AddToSubmissionReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public AddToSubmissionReferencingOutputPort createAddToSubmissionReferencingOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createAddToSubmissionReferencingOutputPort(ID, null, parent, true);
  }
  
  public AddToSubmissionReferencingOutputPort createAddToSubmissionReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createAddToSubmissionReferencingOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an AddToSubmissionReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public AddToSubmissionReferencingOutputPort createAddToSubmissionReferencingOutputPort(final InternalModelElement ime) {
    return this.createAddToSubmissionReferencingOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public AddToSubmissionReferencingOutputPort createAddToSubmissionReferencingOutputPort() {
    return this.createAddToSubmissionReferencingOutputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexInputPortReferencingOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexInputPortReferencingOutputPort createComplexInputPortReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexInputPortReferencingOutputPort _createComplexInputPortReferencingOutputPort = super.createComplexInputPortReferencingOutputPort();
    final Procedure1<ComplexInputPortReferencingOutputPort> _function = new Procedure1<ComplexInputPortReferencingOutputPort>() {
      @Override
      public void apply(final ComplexInputPortReferencingOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexInputPortReferencingOutputPort _createInternalComplexInputPortReferencingOutputPort = ProfileFactory.this._internalFactory.createInternalComplexInputPortReferencingOutputPort();
          _elvis = _createInternalComplexInputPortReferencingOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexInputPortReferencingOutputPortEContentAdapter _complexInputPortReferencingOutputPortEContentAdapter = new ComplexInputPortReferencingOutputPortEContentAdapter();
            _eAdapters.add(_complexInputPortReferencingOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ComplexInputPortReferencingOutputPort>operator_doubleArrow(_createComplexInputPortReferencingOutputPort, _function);
  }
  
  /**
   * This method creates an ComplexInputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexInputPortReferencingOutputPort createComplexInputPortReferencingOutputPort(final String ID) {
    return this.createComplexInputPortReferencingOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexInputPortReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public ComplexInputPortReferencingOutputPort createComplexInputPortReferencingOutputPort(final InternalModelElementContainer parent) {
    return this.createComplexInputPortReferencingOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexInputPortReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public ComplexInputPortReferencingOutputPort createComplexInputPortReferencingOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexInputPortReferencingOutputPort(ID, null, parent, true);
  }
  
  public ComplexInputPortReferencingOutputPort createComplexInputPortReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexInputPortReferencingOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexInputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexInputPortReferencingOutputPort createComplexInputPortReferencingOutputPort(final InternalModelElement ime) {
    return this.createComplexInputPortReferencingOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexInputPortReferencingOutputPort createComplexInputPortReferencingOutputPort() {
    return this.createComplexInputPortReferencingOutputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an OutputReferencingBranch with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public OutputReferencingBranch createOutputReferencingBranch(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    OutputReferencingBranch _createOutputReferencingBranch = super.createOutputReferencingBranch();
    final Procedure1<OutputReferencingBranch> _function = new Procedure1<OutputReferencingBranch>() {
      @Override
      public void apply(final OutputReferencingBranch it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalOutputReferencingBranch _createInternalOutputReferencingBranch = ProfileFactory.this._internalFactory.createInternalOutputReferencingBranch();
          _elvis = _createInternalOutputReferencingBranch;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            OutputReferencingBranchEContentAdapter _outputReferencingBranchEContentAdapter = new OutputReferencingBranchEContentAdapter();
            _eAdapters.add(_outputReferencingBranchEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<OutputReferencingBranch>operator_doubleArrow(_createOutputReferencingBranch, _function);
  }
  
  /**
   * This method creates an OutputReferencingBranch with the given id. Post create hook won't be triggered.
   */
  public OutputReferencingBranch createOutputReferencingBranch(final String ID) {
    return this.createOutputReferencingBranch(ID, null, null, false);
  }
  
  /**
   * This method creates an OutputReferencingBranch with the given id. Post create hook will be triggered.
   */
  public OutputReferencingBranch createOutputReferencingBranch(final InternalModelElementContainer parent) {
    return this.createOutputReferencingBranch(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an OutputReferencingBranch with the given id. Post create hook will be triggered.
   */
  public OutputReferencingBranch createOutputReferencingBranch(final String ID, final InternalModelElementContainer parent) {
    return this.createOutputReferencingBranch(ID, null, parent, true);
  }
  
  public OutputReferencingBranch createOutputReferencingBranch(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createOutputReferencingBranch(ID, ime, parent, true);
  }
  
  /**
   * This method creates an OutputReferencingBranch with the given id. Post create hook won't be triggered.
   */
  public OutputReferencingBranch createOutputReferencingBranch(final InternalModelElement ime) {
    return this.createOutputReferencingBranch(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public OutputReferencingBranch createOutputReferencingBranch() {
    return this.createOutputReferencingBranch(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an GUIPrimitiveOutputPortReferencingOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public GUIPrimitiveOutputPortReferencingOutputPort createGUIPrimitiveOutputPortReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    GUIPrimitiveOutputPortReferencingOutputPort _createGUIPrimitiveOutputPortReferencingOutputPort = super.createGUIPrimitiveOutputPortReferencingOutputPort();
    final Procedure1<GUIPrimitiveOutputPortReferencingOutputPort> _function = new Procedure1<GUIPrimitiveOutputPortReferencingOutputPort>() {
      @Override
      public void apply(final GUIPrimitiveOutputPortReferencingOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalGUIPrimitiveOutputPortReferencingOutputPort _createInternalGUIPrimitiveOutputPortReferencingOutputPort = ProfileFactory.this._internalFactory.createInternalGUIPrimitiveOutputPortReferencingOutputPort();
          _elvis = _createInternalGUIPrimitiveOutputPortReferencingOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            GUIPrimitiveOutputPortReferencingOutputPortEContentAdapter _gUIPrimitiveOutputPortReferencingOutputPortEContentAdapter = new GUIPrimitiveOutputPortReferencingOutputPortEContentAdapter();
            _eAdapters.add(_gUIPrimitiveOutputPortReferencingOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<GUIPrimitiveOutputPortReferencingOutputPort>operator_doubleArrow(_createGUIPrimitiveOutputPortReferencingOutputPort, _function);
  }
  
  /**
   * This method creates an GUIPrimitiveOutputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public GUIPrimitiveOutputPortReferencingOutputPort createGUIPrimitiveOutputPortReferencingOutputPort(final String ID) {
    return this.createGUIPrimitiveOutputPortReferencingOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an GUIPrimitiveOutputPortReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public GUIPrimitiveOutputPortReferencingOutputPort createGUIPrimitiveOutputPortReferencingOutputPort(final InternalModelElementContainer parent) {
    return this.createGUIPrimitiveOutputPortReferencingOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an GUIPrimitiveOutputPortReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public GUIPrimitiveOutputPortReferencingOutputPort createGUIPrimitiveOutputPortReferencingOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createGUIPrimitiveOutputPortReferencingOutputPort(ID, null, parent, true);
  }
  
  public GUIPrimitiveOutputPortReferencingOutputPort createGUIPrimitiveOutputPortReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createGUIPrimitiveOutputPortReferencingOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an GUIPrimitiveOutputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public GUIPrimitiveOutputPortReferencingOutputPort createGUIPrimitiveOutputPortReferencingOutputPort(final InternalModelElement ime) {
    return this.createGUIPrimitiveOutputPortReferencingOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public GUIPrimitiveOutputPortReferencingOutputPort createGUIPrimitiveOutputPortReferencingOutputPort() {
    return this.createGUIPrimitiveOutputPortReferencingOutputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an Profile with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public Profile createProfile(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    Profile _createProfile = super.createProfile();
    final Procedure1<Profile> _function = new Procedure1<Profile>() {
      @Override
      public void apply(final Profile it) {
        EcoreUtil.setID(it, ID);
        InternalIdentifiableElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalProfile _createInternalProfile = ProfileFactory.this._internalFactory.createInternalProfile();
          _elvis = _createInternalProfile;
        }
        final Procedure1<InternalIdentifiableElement> _function = new Procedure1<InternalIdentifiableElement>() {
          @Override
          public void apply(final InternalIdentifiableElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            ProfileEContentAdapter _profileEContentAdapter = new ProfileEContentAdapter();
            _eAdapters.add(_profileEContentAdapter);
          }
        };
        InternalIdentifiableElement _doubleArrow = ObjectExtensions.<InternalIdentifiableElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProfileFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<Profile>operator_doubleArrow(_createProfile, _function);
  }
  
  /**
   * This method creates an Profile with the given id. Post create hook won't be triggered.
   */
  public Profile createProfile(final String ID) {
    return this.createProfile(ID, null, null, false);
  }
  
  /**
   * This method creates an Profile with the given id. Post create hook will be triggered.
   */
  public Profile createProfile(final InternalModelElementContainer parent) {
    return this.createProfile(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an Profile with the given id. Post create hook will be triggered.
   */
  public Profile createProfile(final String ID, final InternalModelElementContainer parent) {
    return this.createProfile(ID, null, parent, true);
  }
  
  public Profile createProfile(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createProfile(ID, ime, parent, true);
  }
  
  /**
   * This method creates an Profile with the given id. Post create hook won't be triggered.
   */
  public Profile createProfile(final InternalModelElement ime) {
    return this.createProfile(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public Profile createProfile() {
    return this.createProfile(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an AbstractParameterReferencingOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public AbstractParameterReferencingOutputPort createAbstractParameterReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    AbstractParameterReferencingOutputPort _createAbstractParameterReferencingOutputPort = super.createAbstractParameterReferencingOutputPort();
    final Procedure1<AbstractParameterReferencingOutputPort> _function = new Procedure1<AbstractParameterReferencingOutputPort>() {
      @Override
      public void apply(final AbstractParameterReferencingOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalAbstractParameterReferencingOutputPort _createInternalAbstractParameterReferencingOutputPort = ProfileFactory.this._internalFactory.createInternalAbstractParameterReferencingOutputPort();
          _elvis = _createInternalAbstractParameterReferencingOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            AbstractParameterReferencingOutputPortEContentAdapter _abstractParameterReferencingOutputPortEContentAdapter = new AbstractParameterReferencingOutputPortEContentAdapter();
            _eAdapters.add(_abstractParameterReferencingOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<AbstractParameterReferencingOutputPort>operator_doubleArrow(_createAbstractParameterReferencingOutputPort, _function);
  }
  
  /**
   * This method creates an AbstractParameterReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public AbstractParameterReferencingOutputPort createAbstractParameterReferencingOutputPort(final String ID) {
    return this.createAbstractParameterReferencingOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an AbstractParameterReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public AbstractParameterReferencingOutputPort createAbstractParameterReferencingOutputPort(final InternalModelElementContainer parent) {
    return this.createAbstractParameterReferencingOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an AbstractParameterReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public AbstractParameterReferencingOutputPort createAbstractParameterReferencingOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createAbstractParameterReferencingOutputPort(ID, null, parent, true);
  }
  
  public AbstractParameterReferencingOutputPort createAbstractParameterReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createAbstractParameterReferencingOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an AbstractParameterReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public AbstractParameterReferencingOutputPort createAbstractParameterReferencingOutputPort(final InternalModelElement ime) {
    return this.createAbstractParameterReferencingOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public AbstractParameterReferencingOutputPort createAbstractParameterReferencingOutputPort() {
    return this.createAbstractParameterReferencingOutputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ButtonReferencingBranch with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ButtonReferencingBranch createButtonReferencingBranch(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ButtonReferencingBranch _createButtonReferencingBranch = super.createButtonReferencingBranch();
    final Procedure1<ButtonReferencingBranch> _function = new Procedure1<ButtonReferencingBranch>() {
      @Override
      public void apply(final ButtonReferencingBranch it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalButtonReferencingBranch _createInternalButtonReferencingBranch = ProfileFactory.this._internalFactory.createInternalButtonReferencingBranch();
          _elvis = _createInternalButtonReferencingBranch;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ButtonReferencingBranchEContentAdapter _buttonReferencingBranchEContentAdapter = new ButtonReferencingBranchEContentAdapter();
            _eAdapters.add(_buttonReferencingBranchEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ButtonReferencingBranch>operator_doubleArrow(_createButtonReferencingBranch, _function);
  }
  
  /**
   * This method creates an ButtonReferencingBranch with the given id. Post create hook won't be triggered.
   */
  public ButtonReferencingBranch createButtonReferencingBranch(final String ID) {
    return this.createButtonReferencingBranch(ID, null, null, false);
  }
  
  /**
   * This method creates an ButtonReferencingBranch with the given id. Post create hook will be triggered.
   */
  public ButtonReferencingBranch createButtonReferencingBranch(final InternalModelElementContainer parent) {
    return this.createButtonReferencingBranch(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ButtonReferencingBranch with the given id. Post create hook will be triggered.
   */
  public ButtonReferencingBranch createButtonReferencingBranch(final String ID, final InternalModelElementContainer parent) {
    return this.createButtonReferencingBranch(ID, null, parent, true);
  }
  
  public ButtonReferencingBranch createButtonReferencingBranch(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createButtonReferencingBranch(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ButtonReferencingBranch with the given id. Post create hook won't be triggered.
   */
  public ButtonReferencingBranch createButtonReferencingBranch(final InternalModelElement ime) {
    return this.createButtonReferencingBranch(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ButtonReferencingBranch createButtonReferencingBranch() {
    return this.createButtonReferencingBranch(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveVariableReferencingOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveVariableReferencingOutputPort createPrimitiveVariableReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveVariableReferencingOutputPort _createPrimitiveVariableReferencingOutputPort = super.createPrimitiveVariableReferencingOutputPort();
    final Procedure1<PrimitiveVariableReferencingOutputPort> _function = new Procedure1<PrimitiveVariableReferencingOutputPort>() {
      @Override
      public void apply(final PrimitiveVariableReferencingOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveVariableReferencingOutputPort _createInternalPrimitiveVariableReferencingOutputPort = ProfileFactory.this._internalFactory.createInternalPrimitiveVariableReferencingOutputPort();
          _elvis = _createInternalPrimitiveVariableReferencingOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveVariableReferencingOutputPortEContentAdapter _primitiveVariableReferencingOutputPortEContentAdapter = new PrimitiveVariableReferencingOutputPortEContentAdapter();
            _eAdapters.add(_primitiveVariableReferencingOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<PrimitiveVariableReferencingOutputPort>operator_doubleArrow(_createPrimitiveVariableReferencingOutputPort, _function);
  }
  
  /**
   * This method creates an PrimitiveVariableReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveVariableReferencingOutputPort createPrimitiveVariableReferencingOutputPort(final String ID) {
    return this.createPrimitiveVariableReferencingOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveVariableReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveVariableReferencingOutputPort createPrimitiveVariableReferencingOutputPort(final InternalModelElementContainer parent) {
    return this.createPrimitiveVariableReferencingOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveVariableReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveVariableReferencingOutputPort createPrimitiveVariableReferencingOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveVariableReferencingOutputPort(ID, null, parent, true);
  }
  
  public PrimitiveVariableReferencingOutputPort createPrimitiveVariableReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveVariableReferencingOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveVariableReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveVariableReferencingOutputPort createPrimitiveVariableReferencingOutputPort(final InternalModelElement ime) {
    return this.createPrimitiveVariableReferencingOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveVariableReferencingOutputPort createPrimitiveVariableReferencingOutputPort() {
    return this.createPrimitiveVariableReferencingOutputPort(EcoreUtil.generateUUID());
  }
  
  public ReplacementCondition createReplacementCondition(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    ReplacementCondition _createReplacementCondition = super.createReplacementCondition();
    final Procedure1<ReplacementCondition> _function = new Procedure1<ReplacementCondition>() {
      @Override
      public void apply(final ReplacementCondition it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalReplacementCondition _createInternalReplacementCondition = ProfileFactory.this._internalFactory.createInternalReplacementCondition();
          _elvis = _createInternalReplacementCondition;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            ReplacementConditionEContentAdapter _replacementConditionEContentAdapter = new ReplacementConditionEContentAdapter();
            _eAdapters.add(_replacementConditionEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ReplacementCondition>operator_doubleArrow(_createReplacementCondition, _function);
  }
  
  /**
   * This method creates an ReplacementCondition with the given id. Post create hook will be triggered.
   */
  public ReplacementCondition createReplacementCondition(final String ID, final InternalNode source, final InternalNode target) {
    return this.createReplacementCondition(ID, null, source, target, true);
  }
  
  /**
   * This method creates an ReplacementCondition with generated id. Post create hook will be triggered.
   */
  public ReplacementCondition createReplacementCondition(final InternalNode source, final InternalNode target) {
    return this.createReplacementCondition(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an ReplacementCondition with the given id. Post create hook won't be triggered.
   */
  public ReplacementCondition createReplacementCondition(final String ID) {
    return this.createReplacementCondition(ID, null, null, null, false);
  }
  
  /**
   * This method creates an ReplacementCondition with a generated id. Post create hook won't be triggered.
   */
  @Override
  public ReplacementCondition createReplacementCondition() {
    return this.createReplacementCondition(EcoreUtil.generateUUID());
  }
  
  public InputPortMapping createInputPortMapping(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    InputPortMapping _createInputPortMapping = super.createInputPortMapping();
    final Procedure1<InputPortMapping> _function = new Procedure1<InputPortMapping>() {
      @Override
      public void apply(final InputPortMapping it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalInputPortMapping _createInternalInputPortMapping = ProfileFactory.this._internalFactory.createInternalInputPortMapping();
          _elvis = _createInternalInputPortMapping;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            InputPortMappingEContentAdapter _inputPortMappingEContentAdapter = new InputPortMappingEContentAdapter();
            _eAdapters.add(_inputPortMappingEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<InputPortMapping>operator_doubleArrow(_createInputPortMapping, _function);
  }
  
  /**
   * This method creates an InputPortMapping with the given id. Post create hook will be triggered.
   */
  public InputPortMapping createInputPortMapping(final String ID, final InternalNode source, final InternalNode target) {
    return this.createInputPortMapping(ID, null, source, target, true);
  }
  
  /**
   * This method creates an InputPortMapping with generated id. Post create hook will be triggered.
   */
  public InputPortMapping createInputPortMapping(final InternalNode source, final InternalNode target) {
    return this.createInputPortMapping(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an InputPortMapping with the given id. Post create hook won't be triggered.
   */
  public InputPortMapping createInputPortMapping(final String ID) {
    return this.createInputPortMapping(ID, null, null, null, false);
  }
  
  /**
   * This method creates an InputPortMapping with a generated id. Post create hook won't be triggered.
   */
  @Override
  public InputPortMapping createInputPortMapping() {
    return this.createInputPortMapping(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveInputPortReferencingOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveInputPortReferencingOutputPort createPrimitiveInputPortReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveInputPortReferencingOutputPort _createPrimitiveInputPortReferencingOutputPort = super.createPrimitiveInputPortReferencingOutputPort();
    final Procedure1<PrimitiveInputPortReferencingOutputPort> _function = new Procedure1<PrimitiveInputPortReferencingOutputPort>() {
      @Override
      public void apply(final PrimitiveInputPortReferencingOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveInputPortReferencingOutputPort _createInternalPrimitiveInputPortReferencingOutputPort = ProfileFactory.this._internalFactory.createInternalPrimitiveInputPortReferencingOutputPort();
          _elvis = _createInternalPrimitiveInputPortReferencingOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveInputPortReferencingOutputPortEContentAdapter _primitiveInputPortReferencingOutputPortEContentAdapter = new PrimitiveInputPortReferencingOutputPortEContentAdapter();
            _eAdapters.add(_primitiveInputPortReferencingOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<PrimitiveInputPortReferencingOutputPort>operator_doubleArrow(_createPrimitiveInputPortReferencingOutputPort, _function);
  }
  
  /**
   * This method creates an PrimitiveInputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveInputPortReferencingOutputPort createPrimitiveInputPortReferencingOutputPort(final String ID) {
    return this.createPrimitiveInputPortReferencingOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveInputPortReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveInputPortReferencingOutputPort createPrimitiveInputPortReferencingOutputPort(final InternalModelElementContainer parent) {
    return this.createPrimitiveInputPortReferencingOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveInputPortReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveInputPortReferencingOutputPort createPrimitiveInputPortReferencingOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveInputPortReferencingOutputPort(ID, null, parent, true);
  }
  
  public PrimitiveInputPortReferencingOutputPort createPrimitiveInputPortReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveInputPortReferencingOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveInputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveInputPortReferencingOutputPort createPrimitiveInputPortReferencingOutputPort(final InternalModelElement ime) {
    return this.createPrimitiveInputPortReferencingOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveInputPortReferencingOutputPort createPrimitiveInputPortReferencingOutputPort() {
    return this.createPrimitiveInputPortReferencingOutputPort(EcoreUtil.generateUUID());
  }
  
  public SIBReplacement createSIBReplacement(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    SIBReplacement _createSIBReplacement = super.createSIBReplacement();
    final Procedure1<SIBReplacement> _function = new Procedure1<SIBReplacement>() {
      @Override
      public void apply(final SIBReplacement it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalSIBReplacement _createInternalSIBReplacement = ProfileFactory.this._internalFactory.createInternalSIBReplacement();
          _elvis = _createInternalSIBReplacement;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            SIBReplacementEContentAdapter _sIBReplacementEContentAdapter = new SIBReplacementEContentAdapter();
            _eAdapters.add(_sIBReplacementEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<SIBReplacement>operator_doubleArrow(_createSIBReplacement, _function);
  }
  
  /**
   * This method creates an SIBReplacement with the given id. Post create hook will be triggered.
   */
  public SIBReplacement createSIBReplacement(final String ID, final InternalNode source, final InternalNode target) {
    return this.createSIBReplacement(ID, null, source, target, true);
  }
  
  /**
   * This method creates an SIBReplacement with generated id. Post create hook will be triggered.
   */
  public SIBReplacement createSIBReplacement(final InternalNode source, final InternalNode target) {
    return this.createSIBReplacement(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an SIBReplacement with the given id. Post create hook won't be triggered.
   */
  public SIBReplacement createSIBReplacement(final String ID) {
    return this.createSIBReplacement(ID, null, null, null, false);
  }
  
  /**
   * This method creates an SIBReplacement with a generated id. Post create hook won't be triggered.
   */
  @Override
  public SIBReplacement createSIBReplacement() {
    return this.createSIBReplacement(EcoreUtil.generateUUID());
  }
  
  public BranchReplacement createBranchReplacement(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    BranchReplacement _createBranchReplacement = super.createBranchReplacement();
    final Procedure1<BranchReplacement> _function = new Procedure1<BranchReplacement>() {
      @Override
      public void apply(final BranchReplacement it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalBranchReplacement _createInternalBranchReplacement = ProfileFactory.this._internalFactory.createInternalBranchReplacement();
          _elvis = _createInternalBranchReplacement;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            BranchReplacementEContentAdapter _branchReplacementEContentAdapter = new BranchReplacementEContentAdapter();
            _eAdapters.add(_branchReplacementEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<BranchReplacement>operator_doubleArrow(_createBranchReplacement, _function);
  }
  
  /**
   * This method creates an BranchReplacement with the given id. Post create hook will be triggered.
   */
  public BranchReplacement createBranchReplacement(final String ID, final InternalNode source, final InternalNode target) {
    return this.createBranchReplacement(ID, null, source, target, true);
  }
  
  /**
   * This method creates an BranchReplacement with generated id. Post create hook will be triggered.
   */
  public BranchReplacement createBranchReplacement(final InternalNode source, final InternalNode target) {
    return this.createBranchReplacement(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an BranchReplacement with the given id. Post create hook won't be triggered.
   */
  public BranchReplacement createBranchReplacement(final String ID) {
    return this.createBranchReplacement(ID, null, null, null, false);
  }
  
  /**
   * This method creates an BranchReplacement with a generated id. Post create hook won't be triggered.
   */
  @Override
  public BranchReplacement createBranchReplacement() {
    return this.createBranchReplacement(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an BranchReferencingBranch with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public BranchReferencingBranch createBranchReferencingBranch(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    BranchReferencingBranch _createBranchReferencingBranch = super.createBranchReferencingBranch();
    final Procedure1<BranchReferencingBranch> _function = new Procedure1<BranchReferencingBranch>() {
      @Override
      public void apply(final BranchReferencingBranch it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalBranchReferencingBranch _createInternalBranchReferencingBranch = ProfileFactory.this._internalFactory.createInternalBranchReferencingBranch();
          _elvis = _createInternalBranchReferencingBranch;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            BranchReferencingBranchEContentAdapter _branchReferencingBranchEContentAdapter = new BranchReferencingBranchEContentAdapter();
            _eAdapters.add(_branchReferencingBranchEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<BranchReferencingBranch>operator_doubleArrow(_createBranchReferencingBranch, _function);
  }
  
  /**
   * This method creates an BranchReferencingBranch with the given id. Post create hook won't be triggered.
   */
  public BranchReferencingBranch createBranchReferencingBranch(final String ID) {
    return this.createBranchReferencingBranch(ID, null, null, false);
  }
  
  /**
   * This method creates an BranchReferencingBranch with the given id. Post create hook will be triggered.
   */
  public BranchReferencingBranch createBranchReferencingBranch(final InternalModelElementContainer parent) {
    return this.createBranchReferencingBranch(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an BranchReferencingBranch with the given id. Post create hook will be triggered.
   */
  public BranchReferencingBranch createBranchReferencingBranch(final String ID, final InternalModelElementContainer parent) {
    return this.createBranchReferencingBranch(ID, null, parent, true);
  }
  
  public BranchReferencingBranch createBranchReferencingBranch(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createBranchReferencingBranch(ID, ime, parent, true);
  }
  
  /**
   * This method creates an BranchReferencingBranch with the given id. Post create hook won't be triggered.
   */
  public BranchReferencingBranch createBranchReferencingBranch(final InternalModelElement ime) {
    return this.createBranchReferencingBranch(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public BranchReferencingBranch createBranchReferencingBranch() {
    return this.createBranchReferencingBranch(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexInputPortReferencingInputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexInputPortReferencingInputPort createComplexInputPortReferencingInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexInputPortReferencingInputPort _createComplexInputPortReferencingInputPort = super.createComplexInputPortReferencingInputPort();
    final Procedure1<ComplexInputPortReferencingInputPort> _function = new Procedure1<ComplexInputPortReferencingInputPort>() {
      @Override
      public void apply(final ComplexInputPortReferencingInputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexInputPortReferencingInputPort _createInternalComplexInputPortReferencingInputPort = ProfileFactory.this._internalFactory.createInternalComplexInputPortReferencingInputPort();
          _elvis = _createInternalComplexInputPortReferencingInputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexInputPortReferencingInputPortEContentAdapter _complexInputPortReferencingInputPortEContentAdapter = new ComplexInputPortReferencingInputPortEContentAdapter();
            _eAdapters.add(_complexInputPortReferencingInputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ComplexInputPortReferencingInputPort>operator_doubleArrow(_createComplexInputPortReferencingInputPort, _function);
  }
  
  /**
   * This method creates an ComplexInputPortReferencingInputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexInputPortReferencingInputPort createComplexInputPortReferencingInputPort(final String ID) {
    return this.createComplexInputPortReferencingInputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexInputPortReferencingInputPort with the given id. Post create hook will be triggered.
   */
  public ComplexInputPortReferencingInputPort createComplexInputPortReferencingInputPort(final InternalModelElementContainer parent) {
    return this.createComplexInputPortReferencingInputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexInputPortReferencingInputPort with the given id. Post create hook will be triggered.
   */
  public ComplexInputPortReferencingInputPort createComplexInputPortReferencingInputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexInputPortReferencingInputPort(ID, null, parent, true);
  }
  
  public ComplexInputPortReferencingInputPort createComplexInputPortReferencingInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexInputPortReferencingInputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexInputPortReferencingInputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexInputPortReferencingInputPort createComplexInputPortReferencingInputPort(final InternalModelElement ime) {
    return this.createComplexInputPortReferencingInputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexInputPortReferencingInputPort createComplexInputPortReferencingInputPort() {
    return this.createComplexInputPortReferencingInputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexVariableReferencingInputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexVariableReferencingInputPort createComplexVariableReferencingInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexVariableReferencingInputPort _createComplexVariableReferencingInputPort = super.createComplexVariableReferencingInputPort();
    final Procedure1<ComplexVariableReferencingInputPort> _function = new Procedure1<ComplexVariableReferencingInputPort>() {
      @Override
      public void apply(final ComplexVariableReferencingInputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexVariableReferencingInputPort _createInternalComplexVariableReferencingInputPort = ProfileFactory.this._internalFactory.createInternalComplexVariableReferencingInputPort();
          _elvis = _createInternalComplexVariableReferencingInputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexVariableReferencingInputPortEContentAdapter _complexVariableReferencingInputPortEContentAdapter = new ComplexVariableReferencingInputPortEContentAdapter();
            _eAdapters.add(_complexVariableReferencingInputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ComplexVariableReferencingInputPort>operator_doubleArrow(_createComplexVariableReferencingInputPort, _function);
  }
  
  /**
   * This method creates an ComplexVariableReferencingInputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexVariableReferencingInputPort createComplexVariableReferencingInputPort(final String ID) {
    return this.createComplexVariableReferencingInputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexVariableReferencingInputPort with the given id. Post create hook will be triggered.
   */
  public ComplexVariableReferencingInputPort createComplexVariableReferencingInputPort(final InternalModelElementContainer parent) {
    return this.createComplexVariableReferencingInputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexVariableReferencingInputPort with the given id. Post create hook will be triggered.
   */
  public ComplexVariableReferencingInputPort createComplexVariableReferencingInputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexVariableReferencingInputPort(ID, null, parent, true);
  }
  
  public ComplexVariableReferencingInputPort createComplexVariableReferencingInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexVariableReferencingInputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexVariableReferencingInputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexVariableReferencingInputPort createComplexVariableReferencingInputPort(final InternalModelElement ime) {
    return this.createComplexVariableReferencingInputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexVariableReferencingInputPort createComplexVariableReferencingInputPort() {
    return this.createComplexVariableReferencingInputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ProcessBlueprintSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ProcessBlueprintSIB createProcessBlueprintSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ProcessBlueprintSIB _createProcessBlueprintSIB = super.createProcessBlueprintSIB();
    final Procedure1<ProcessBlueprintSIB> _function = new Procedure1<ProcessBlueprintSIB>() {
      @Override
      public void apply(final ProcessBlueprintSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalProcessBlueprintSIB _createInternalProcessBlueprintSIB = ProfileFactory.this._internalFactory.createInternalProcessBlueprintSIB();
          _elvis = _createInternalProcessBlueprintSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ProcessBlueprintSIBEContentAdapter _processBlueprintSIBEContentAdapter = new ProcessBlueprintSIBEContentAdapter();
            _eAdapters.add(_processBlueprintSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProfileFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ProcessBlueprintSIB>operator_doubleArrow(_createProcessBlueprintSIB, _function);
  }
  
  /**
   * This method creates an ProcessBlueprintSIB with the given id. Post create hook won't be triggered.
   */
  public ProcessBlueprintSIB createProcessBlueprintSIB(final String ID) {
    return this.createProcessBlueprintSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an ProcessBlueprintSIB with the given id. Post create hook will be triggered.
   */
  public ProcessBlueprintSIB createProcessBlueprintSIB(final InternalModelElementContainer parent) {
    return this.createProcessBlueprintSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ProcessBlueprintSIB with the given id. Post create hook will be triggered.
   */
  public ProcessBlueprintSIB createProcessBlueprintSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createProcessBlueprintSIB(ID, null, parent, true);
  }
  
  public ProcessBlueprintSIB createProcessBlueprintSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createProcessBlueprintSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ProcessBlueprintSIB with the given id. Post create hook won't be triggered.
   */
  public ProcessBlueprintSIB createProcessBlueprintSIB(final InternalModelElement ime) {
    return this.createProcessBlueprintSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ProcessBlueprintSIB createProcessBlueprintSIB() {
    return this.createProcessBlueprintSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveOutputPortReferencingOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveOutputPortReferencingOutputPort createPrimitiveOutputPortReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveOutputPortReferencingOutputPort _createPrimitiveOutputPortReferencingOutputPort = super.createPrimitiveOutputPortReferencingOutputPort();
    final Procedure1<PrimitiveOutputPortReferencingOutputPort> _function = new Procedure1<PrimitiveOutputPortReferencingOutputPort>() {
      @Override
      public void apply(final PrimitiveOutputPortReferencingOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveOutputPortReferencingOutputPort _createInternalPrimitiveOutputPortReferencingOutputPort = ProfileFactory.this._internalFactory.createInternalPrimitiveOutputPortReferencingOutputPort();
          _elvis = _createInternalPrimitiveOutputPortReferencingOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveOutputPortReferencingOutputPortEContentAdapter _primitiveOutputPortReferencingOutputPortEContentAdapter = new PrimitiveOutputPortReferencingOutputPortEContentAdapter();
            _eAdapters.add(_primitiveOutputPortReferencingOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<PrimitiveOutputPortReferencingOutputPort>operator_doubleArrow(_createPrimitiveOutputPortReferencingOutputPort, _function);
  }
  
  /**
   * This method creates an PrimitiveOutputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveOutputPortReferencingOutputPort createPrimitiveOutputPortReferencingOutputPort(final String ID) {
    return this.createPrimitiveOutputPortReferencingOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveOutputPortReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveOutputPortReferencingOutputPort createPrimitiveOutputPortReferencingOutputPort(final InternalModelElementContainer parent) {
    return this.createPrimitiveOutputPortReferencingOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveOutputPortReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveOutputPortReferencingOutputPort createPrimitiveOutputPortReferencingOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveOutputPortReferencingOutputPort(ID, null, parent, true);
  }
  
  public PrimitiveOutputPortReferencingOutputPort createPrimitiveOutputPortReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveOutputPortReferencingOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveOutputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveOutputPortReferencingOutputPort createPrimitiveOutputPortReferencingOutputPort(final InternalModelElement ime) {
    return this.createPrimitiveOutputPortReferencingOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveOutputPortReferencingOutputPort createPrimitiveOutputPortReferencingOutputPort() {
    return this.createPrimitiveOutputPortReferencingOutputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an GUISIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public GUISIB createGUISIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    GUISIB _createGUISIB = super.createGUISIB();
    final Procedure1<GUISIB> _function = new Procedure1<GUISIB>() {
      @Override
      public void apply(final GUISIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalGUISIB _createInternalGUISIB = ProfileFactory.this._internalFactory.createInternalGUISIB();
          _elvis = _createInternalGUISIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            GUISIBEContentAdapter _gUISIBEContentAdapter = new GUISIBEContentAdapter();
            _eAdapters.add(_gUISIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProfileFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<GUISIB>operator_doubleArrow(_createGUISIB, _function);
  }
  
  /**
   * This method creates an GUISIB with the given id. Post create hook won't be triggered.
   */
  public GUISIB createGUISIB(final String ID) {
    return this.createGUISIB(ID, null, null, false);
  }
  
  /**
   * This method creates an GUISIB with the given id. Post create hook will be triggered.
   */
  public GUISIB createGUISIB(final InternalModelElementContainer parent) {
    return this.createGUISIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an GUISIB with the given id. Post create hook will be triggered.
   */
  public GUISIB createGUISIB(final String ID, final InternalModelElementContainer parent) {
    return this.createGUISIB(ID, null, parent, true);
  }
  
  public GUISIB createGUISIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createGUISIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an GUISIB with the given id. Post create hook won't be triggered.
   */
  public GUISIB createGUISIB(final InternalModelElement ime) {
    return this.createGUISIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public GUISIB createGUISIB() {
    return this.createGUISIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexOutputPortReferencingOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexOutputPortReferencingOutputPort createComplexOutputPortReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexOutputPortReferencingOutputPort _createComplexOutputPortReferencingOutputPort = super.createComplexOutputPortReferencingOutputPort();
    final Procedure1<ComplexOutputPortReferencingOutputPort> _function = new Procedure1<ComplexOutputPortReferencingOutputPort>() {
      @Override
      public void apply(final ComplexOutputPortReferencingOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexOutputPortReferencingOutputPort _createInternalComplexOutputPortReferencingOutputPort = ProfileFactory.this._internalFactory.createInternalComplexOutputPortReferencingOutputPort();
          _elvis = _createInternalComplexOutputPortReferencingOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexOutputPortReferencingOutputPortEContentAdapter _complexOutputPortReferencingOutputPortEContentAdapter = new ComplexOutputPortReferencingOutputPortEContentAdapter();
            _eAdapters.add(_complexOutputPortReferencingOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ComplexOutputPortReferencingOutputPort>operator_doubleArrow(_createComplexOutputPortReferencingOutputPort, _function);
  }
  
  /**
   * This method creates an ComplexOutputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexOutputPortReferencingOutputPort createComplexOutputPortReferencingOutputPort(final String ID) {
    return this.createComplexOutputPortReferencingOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexOutputPortReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public ComplexOutputPortReferencingOutputPort createComplexOutputPortReferencingOutputPort(final InternalModelElementContainer parent) {
    return this.createComplexOutputPortReferencingOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexOutputPortReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public ComplexOutputPortReferencingOutputPort createComplexOutputPortReferencingOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexOutputPortReferencingOutputPort(ID, null, parent, true);
  }
  
  public ComplexOutputPortReferencingOutputPort createComplexOutputPortReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexOutputPortReferencingOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexOutputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexOutputPortReferencingOutputPort createComplexOutputPortReferencingOutputPort(final InternalModelElement ime) {
    return this.createComplexOutputPortReferencingOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexOutputPortReferencingOutputPort createComplexOutputPortReferencingOutputPort() {
    return this.createComplexOutputPortReferencingOutputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveVariableReferencingInputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveVariableReferencingInputPort createPrimitiveVariableReferencingInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveVariableReferencingInputPort _createPrimitiveVariableReferencingInputPort = super.createPrimitiveVariableReferencingInputPort();
    final Procedure1<PrimitiveVariableReferencingInputPort> _function = new Procedure1<PrimitiveVariableReferencingInputPort>() {
      @Override
      public void apply(final PrimitiveVariableReferencingInputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveVariableReferencingInputPort _createInternalPrimitiveVariableReferencingInputPort = ProfileFactory.this._internalFactory.createInternalPrimitiveVariableReferencingInputPort();
          _elvis = _createInternalPrimitiveVariableReferencingInputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveVariableReferencingInputPortEContentAdapter _primitiveVariableReferencingInputPortEContentAdapter = new PrimitiveVariableReferencingInputPortEContentAdapter();
            _eAdapters.add(_primitiveVariableReferencingInputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<PrimitiveVariableReferencingInputPort>operator_doubleArrow(_createPrimitiveVariableReferencingInputPort, _function);
  }
  
  /**
   * This method creates an PrimitiveVariableReferencingInputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveVariableReferencingInputPort createPrimitiveVariableReferencingInputPort(final String ID) {
    return this.createPrimitiveVariableReferencingInputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveVariableReferencingInputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveVariableReferencingInputPort createPrimitiveVariableReferencingInputPort(final InternalModelElementContainer parent) {
    return this.createPrimitiveVariableReferencingInputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveVariableReferencingInputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveVariableReferencingInputPort createPrimitiveVariableReferencingInputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveVariableReferencingInputPort(ID, null, parent, true);
  }
  
  public PrimitiveVariableReferencingInputPort createPrimitiveVariableReferencingInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveVariableReferencingInputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveVariableReferencingInputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveVariableReferencingInputPort createPrimitiveVariableReferencingInputPort(final InternalModelElement ime) {
    return this.createPrimitiveVariableReferencingInputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveVariableReferencingInputPort createPrimitiveVariableReferencingInputPort() {
    return this.createPrimitiveVariableReferencingInputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an BlueprintBranch with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public BlueprintBranch createBlueprintBranch(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    BlueprintBranch _createBlueprintBranch = super.createBlueprintBranch();
    final Procedure1<BlueprintBranch> _function = new Procedure1<BlueprintBranch>() {
      @Override
      public void apply(final BlueprintBranch it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalBlueprintBranch _createInternalBlueprintBranch = ProfileFactory.this._internalFactory.createInternalBlueprintBranch();
          _elvis = _createInternalBlueprintBranch;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            BlueprintBranchEContentAdapter _blueprintBranchEContentAdapter = new BlueprintBranchEContentAdapter();
            _eAdapters.add(_blueprintBranchEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<BlueprintBranch>operator_doubleArrow(_createBlueprintBranch, _function);
  }
  
  /**
   * This method creates an BlueprintBranch with the given id. Post create hook won't be triggered.
   */
  public BlueprintBranch createBlueprintBranch(final String ID) {
    return this.createBlueprintBranch(ID, null, null, false);
  }
  
  /**
   * This method creates an BlueprintBranch with the given id. Post create hook will be triggered.
   */
  public BlueprintBranch createBlueprintBranch(final InternalModelElementContainer parent) {
    return this.createBlueprintBranch(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an BlueprintBranch with the given id. Post create hook will be triggered.
   */
  public BlueprintBranch createBlueprintBranch(final String ID, final InternalModelElementContainer parent) {
    return this.createBlueprintBranch(ID, null, parent, true);
  }
  
  public BlueprintBranch createBlueprintBranch(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createBlueprintBranch(ID, ime, parent, true);
  }
  
  /**
   * This method creates an BlueprintBranch with the given id. Post create hook won't be triggered.
   */
  public BlueprintBranch createBlueprintBranch(final InternalModelElement ime) {
    return this.createBlueprintBranch(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public BlueprintBranch createBlueprintBranch() {
    return this.createBlueprintBranch(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an GUIBlueprintSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public GUIBlueprintSIB createGUIBlueprintSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    GUIBlueprintSIB _createGUIBlueprintSIB = super.createGUIBlueprintSIB();
    final Procedure1<GUIBlueprintSIB> _function = new Procedure1<GUIBlueprintSIB>() {
      @Override
      public void apply(final GUIBlueprintSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalGUIBlueprintSIB _createInternalGUIBlueprintSIB = ProfileFactory.this._internalFactory.createInternalGUIBlueprintSIB();
          _elvis = _createInternalGUIBlueprintSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            GUIBlueprintSIBEContentAdapter _gUIBlueprintSIBEContentAdapter = new GUIBlueprintSIBEContentAdapter();
            _eAdapters.add(_gUIBlueprintSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProfileFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<GUIBlueprintSIB>operator_doubleArrow(_createGUIBlueprintSIB, _function);
  }
  
  /**
   * This method creates an GUIBlueprintSIB with the given id. Post create hook won't be triggered.
   */
  public GUIBlueprintSIB createGUIBlueprintSIB(final String ID) {
    return this.createGUIBlueprintSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an GUIBlueprintSIB with the given id. Post create hook will be triggered.
   */
  public GUIBlueprintSIB createGUIBlueprintSIB(final InternalModelElementContainer parent) {
    return this.createGUIBlueprintSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an GUIBlueprintSIB with the given id. Post create hook will be triggered.
   */
  public GUIBlueprintSIB createGUIBlueprintSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createGUIBlueprintSIB(ID, null, parent, true);
  }
  
  public GUIBlueprintSIB createGUIBlueprintSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createGUIBlueprintSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an GUIBlueprintSIB with the given id. Post create hook won't be triggered.
   */
  public GUIBlueprintSIB createGUIBlueprintSIB(final InternalModelElement ime) {
    return this.createGUIBlueprintSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public GUIBlueprintSIB createGUIBlueprintSIB() {
    return this.createGUIBlueprintSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveOutputPortReferencingInputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveOutputPortReferencingInputPort createPrimitiveOutputPortReferencingInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveOutputPortReferencingInputPort _createPrimitiveOutputPortReferencingInputPort = super.createPrimitiveOutputPortReferencingInputPort();
    final Procedure1<PrimitiveOutputPortReferencingInputPort> _function = new Procedure1<PrimitiveOutputPortReferencingInputPort>() {
      @Override
      public void apply(final PrimitiveOutputPortReferencingInputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveOutputPortReferencingInputPort _createInternalPrimitiveOutputPortReferencingInputPort = ProfileFactory.this._internalFactory.createInternalPrimitiveOutputPortReferencingInputPort();
          _elvis = _createInternalPrimitiveOutputPortReferencingInputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveOutputPortReferencingInputPortEContentAdapter _primitiveOutputPortReferencingInputPortEContentAdapter = new PrimitiveOutputPortReferencingInputPortEContentAdapter();
            _eAdapters.add(_primitiveOutputPortReferencingInputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<PrimitiveOutputPortReferencingInputPort>operator_doubleArrow(_createPrimitiveOutputPortReferencingInputPort, _function);
  }
  
  /**
   * This method creates an PrimitiveOutputPortReferencingInputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveOutputPortReferencingInputPort createPrimitiveOutputPortReferencingInputPort(final String ID) {
    return this.createPrimitiveOutputPortReferencingInputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveOutputPortReferencingInputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveOutputPortReferencingInputPort createPrimitiveOutputPortReferencingInputPort(final InternalModelElementContainer parent) {
    return this.createPrimitiveOutputPortReferencingInputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveOutputPortReferencingInputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveOutputPortReferencingInputPort createPrimitiveOutputPortReferencingInputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveOutputPortReferencingInputPort(ID, null, parent, true);
  }
  
  public PrimitiveOutputPortReferencingInputPort createPrimitiveOutputPortReferencingInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveOutputPortReferencingInputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveOutputPortReferencingInputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveOutputPortReferencingInputPort createPrimitiveOutputPortReferencingInputPort(final InternalModelElement ime) {
    return this.createPrimitiveOutputPortReferencingInputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveOutputPortReferencingInputPort createPrimitiveOutputPortReferencingInputPort() {
    return this.createPrimitiveOutputPortReferencingInputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexAttributeReferencingOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexAttributeReferencingOutputPort createComplexAttributeReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexAttributeReferencingOutputPort _createComplexAttributeReferencingOutputPort = super.createComplexAttributeReferencingOutputPort();
    final Procedure1<ComplexAttributeReferencingOutputPort> _function = new Procedure1<ComplexAttributeReferencingOutputPort>() {
      @Override
      public void apply(final ComplexAttributeReferencingOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexAttributeReferencingOutputPort _createInternalComplexAttributeReferencingOutputPort = ProfileFactory.this._internalFactory.createInternalComplexAttributeReferencingOutputPort();
          _elvis = _createInternalComplexAttributeReferencingOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexAttributeReferencingOutputPortEContentAdapter _complexAttributeReferencingOutputPortEContentAdapter = new ComplexAttributeReferencingOutputPortEContentAdapter();
            _eAdapters.add(_complexAttributeReferencingOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ComplexAttributeReferencingOutputPort>operator_doubleArrow(_createComplexAttributeReferencingOutputPort, _function);
  }
  
  /**
   * This method creates an ComplexAttributeReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexAttributeReferencingOutputPort createComplexAttributeReferencingOutputPort(final String ID) {
    return this.createComplexAttributeReferencingOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexAttributeReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public ComplexAttributeReferencingOutputPort createComplexAttributeReferencingOutputPort(final InternalModelElementContainer parent) {
    return this.createComplexAttributeReferencingOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexAttributeReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public ComplexAttributeReferencingOutputPort createComplexAttributeReferencingOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexAttributeReferencingOutputPort(ID, null, parent, true);
  }
  
  public ComplexAttributeReferencingOutputPort createComplexAttributeReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexAttributeReferencingOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexAttributeReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexAttributeReferencingOutputPort createComplexAttributeReferencingOutputPort(final InternalModelElement ime) {
    return this.createComplexAttributeReferencingOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexAttributeReferencingOutputPort createComplexAttributeReferencingOutputPort() {
    return this.createComplexAttributeReferencingOutputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an DoNotReplace with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public DoNotReplace createDoNotReplace(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    DoNotReplace _createDoNotReplace = super.createDoNotReplace();
    final Procedure1<DoNotReplace> _function = new Procedure1<DoNotReplace>() {
      @Override
      public void apply(final DoNotReplace it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalDoNotReplace _createInternalDoNotReplace = ProfileFactory.this._internalFactory.createInternalDoNotReplace();
          _elvis = _createInternalDoNotReplace;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            DoNotReplaceEContentAdapter _doNotReplaceEContentAdapter = new DoNotReplaceEContentAdapter();
            _eAdapters.add(_doNotReplaceEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<DoNotReplace>operator_doubleArrow(_createDoNotReplace, _function);
  }
  
  /**
   * This method creates an DoNotReplace with the given id. Post create hook won't be triggered.
   */
  public DoNotReplace createDoNotReplace(final String ID) {
    return this.createDoNotReplace(ID, null, null, false);
  }
  
  /**
   * This method creates an DoNotReplace with the given id. Post create hook will be triggered.
   */
  public DoNotReplace createDoNotReplace(final InternalModelElementContainer parent) {
    return this.createDoNotReplace(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an DoNotReplace with the given id. Post create hook will be triggered.
   */
  public DoNotReplace createDoNotReplace(final String ID, final InternalModelElementContainer parent) {
    return this.createDoNotReplace(ID, null, parent, true);
  }
  
  public DoNotReplace createDoNotReplace(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createDoNotReplace(ID, ime, parent, true);
  }
  
  /**
   * This method creates an DoNotReplace with the given id. Post create hook won't be triggered.
   */
  public DoNotReplace createDoNotReplace(final InternalModelElement ime) {
    return this.createDoNotReplace(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public DoNotReplace createDoNotReplace() {
    return this.createDoNotReplace(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an GUIPrimitiveInputPortReferencingOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public GUIPrimitiveInputPortReferencingOutputPort createGUIPrimitiveInputPortReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    GUIPrimitiveInputPortReferencingOutputPort _createGUIPrimitiveInputPortReferencingOutputPort = super.createGUIPrimitiveInputPortReferencingOutputPort();
    final Procedure1<GUIPrimitiveInputPortReferencingOutputPort> _function = new Procedure1<GUIPrimitiveInputPortReferencingOutputPort>() {
      @Override
      public void apply(final GUIPrimitiveInputPortReferencingOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalGUIPrimitiveInputPortReferencingOutputPort _createInternalGUIPrimitiveInputPortReferencingOutputPort = ProfileFactory.this._internalFactory.createInternalGUIPrimitiveInputPortReferencingOutputPort();
          _elvis = _createInternalGUIPrimitiveInputPortReferencingOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            GUIPrimitiveInputPortReferencingOutputPortEContentAdapter _gUIPrimitiveInputPortReferencingOutputPortEContentAdapter = new GUIPrimitiveInputPortReferencingOutputPortEContentAdapter();
            _eAdapters.add(_gUIPrimitiveInputPortReferencingOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<GUIPrimitiveInputPortReferencingOutputPort>operator_doubleArrow(_createGUIPrimitiveInputPortReferencingOutputPort, _function);
  }
  
  /**
   * This method creates an GUIPrimitiveInputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public GUIPrimitiveInputPortReferencingOutputPort createGUIPrimitiveInputPortReferencingOutputPort(final String ID) {
    return this.createGUIPrimitiveInputPortReferencingOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an GUIPrimitiveInputPortReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public GUIPrimitiveInputPortReferencingOutputPort createGUIPrimitiveInputPortReferencingOutputPort(final InternalModelElementContainer parent) {
    return this.createGUIPrimitiveInputPortReferencingOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an GUIPrimitiveInputPortReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public GUIPrimitiveInputPortReferencingOutputPort createGUIPrimitiveInputPortReferencingOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createGUIPrimitiveInputPortReferencingOutputPort(ID, null, parent, true);
  }
  
  public GUIPrimitiveInputPortReferencingOutputPort createGUIPrimitiveInputPortReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createGUIPrimitiveInputPortReferencingOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an GUIPrimitiveInputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public GUIPrimitiveInputPortReferencingOutputPort createGUIPrimitiveInputPortReferencingOutputPort(final InternalModelElement ime) {
    return this.createGUIPrimitiveInputPortReferencingOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public GUIPrimitiveInputPortReferencingOutputPort createGUIPrimitiveInputPortReferencingOutputPort() {
    return this.createGUIPrimitiveInputPortReferencingOutputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an GUIComplexInputPortReferencingOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public GUIComplexInputPortReferencingOutputPort createGUIComplexInputPortReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    GUIComplexInputPortReferencingOutputPort _createGUIComplexInputPortReferencingOutputPort = super.createGUIComplexInputPortReferencingOutputPort();
    final Procedure1<GUIComplexInputPortReferencingOutputPort> _function = new Procedure1<GUIComplexInputPortReferencingOutputPort>() {
      @Override
      public void apply(final GUIComplexInputPortReferencingOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalGUIComplexInputPortReferencingOutputPort _createInternalGUIComplexInputPortReferencingOutputPort = ProfileFactory.this._internalFactory.createInternalGUIComplexInputPortReferencingOutputPort();
          _elvis = _createInternalGUIComplexInputPortReferencingOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            GUIComplexInputPortReferencingOutputPortEContentAdapter _gUIComplexInputPortReferencingOutputPortEContentAdapter = new GUIComplexInputPortReferencingOutputPortEContentAdapter();
            _eAdapters.add(_gUIComplexInputPortReferencingOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<GUIComplexInputPortReferencingOutputPort>operator_doubleArrow(_createGUIComplexInputPortReferencingOutputPort, _function);
  }
  
  /**
   * This method creates an GUIComplexInputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public GUIComplexInputPortReferencingOutputPort createGUIComplexInputPortReferencingOutputPort(final String ID) {
    return this.createGUIComplexInputPortReferencingOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an GUIComplexInputPortReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public GUIComplexInputPortReferencingOutputPort createGUIComplexInputPortReferencingOutputPort(final InternalModelElementContainer parent) {
    return this.createGUIComplexInputPortReferencingOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an GUIComplexInputPortReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public GUIComplexInputPortReferencingOutputPort createGUIComplexInputPortReferencingOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createGUIComplexInputPortReferencingOutputPort(ID, null, parent, true);
  }
  
  public GUIComplexInputPortReferencingOutputPort createGUIComplexInputPortReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createGUIComplexInputPortReferencingOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an GUIComplexInputPortReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public GUIComplexInputPortReferencingOutputPort createGUIComplexInputPortReferencingOutputPort(final InternalModelElement ime) {
    return this.createGUIComplexInputPortReferencingOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public GUIComplexInputPortReferencingOutputPort createGUIComplexInputPortReferencingOutputPort() {
    return this.createGUIComplexInputPortReferencingOutputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an EndSIBReferencingBranch with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public EndSIBReferencingBranch createEndSIBReferencingBranch(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    EndSIBReferencingBranch _createEndSIBReferencingBranch = super.createEndSIBReferencingBranch();
    final Procedure1<EndSIBReferencingBranch> _function = new Procedure1<EndSIBReferencingBranch>() {
      @Override
      public void apply(final EndSIBReferencingBranch it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalEndSIBReferencingBranch _createInternalEndSIBReferencingBranch = ProfileFactory.this._internalFactory.createInternalEndSIBReferencingBranch();
          _elvis = _createInternalEndSIBReferencingBranch;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            EndSIBReferencingBranchEContentAdapter _endSIBReferencingBranchEContentAdapter = new EndSIBReferencingBranchEContentAdapter();
            _eAdapters.add(_endSIBReferencingBranchEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<EndSIBReferencingBranch>operator_doubleArrow(_createEndSIBReferencingBranch, _function);
  }
  
  /**
   * This method creates an EndSIBReferencingBranch with the given id. Post create hook won't be triggered.
   */
  public EndSIBReferencingBranch createEndSIBReferencingBranch(final String ID) {
    return this.createEndSIBReferencingBranch(ID, null, null, false);
  }
  
  /**
   * This method creates an EndSIBReferencingBranch with the given id. Post create hook will be triggered.
   */
  public EndSIBReferencingBranch createEndSIBReferencingBranch(final InternalModelElementContainer parent) {
    return this.createEndSIBReferencingBranch(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an EndSIBReferencingBranch with the given id. Post create hook will be triggered.
   */
  public EndSIBReferencingBranch createEndSIBReferencingBranch(final String ID, final InternalModelElementContainer parent) {
    return this.createEndSIBReferencingBranch(ID, null, parent, true);
  }
  
  public EndSIBReferencingBranch createEndSIBReferencingBranch(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createEndSIBReferencingBranch(ID, ime, parent, true);
  }
  
  /**
   * This method creates an EndSIBReferencingBranch with the given id. Post create hook won't be triggered.
   */
  public EndSIBReferencingBranch createEndSIBReferencingBranch(final InternalModelElement ime) {
    return this.createEndSIBReferencingBranch(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public EndSIBReferencingBranch createEndSIBReferencingBranch() {
    return this.createEndSIBReferencingBranch(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveAttributeReferencingOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveAttributeReferencingOutputPort createPrimitiveAttributeReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveAttributeReferencingOutputPort _createPrimitiveAttributeReferencingOutputPort = super.createPrimitiveAttributeReferencingOutputPort();
    final Procedure1<PrimitiveAttributeReferencingOutputPort> _function = new Procedure1<PrimitiveAttributeReferencingOutputPort>() {
      @Override
      public void apply(final PrimitiveAttributeReferencingOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveAttributeReferencingOutputPort _createInternalPrimitiveAttributeReferencingOutputPort = ProfileFactory.this._internalFactory.createInternalPrimitiveAttributeReferencingOutputPort();
          _elvis = _createInternalPrimitiveAttributeReferencingOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveAttributeReferencingOutputPortEContentAdapter _primitiveAttributeReferencingOutputPortEContentAdapter = new PrimitiveAttributeReferencingOutputPortEContentAdapter();
            _eAdapters.add(_primitiveAttributeReferencingOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProfileFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<PrimitiveAttributeReferencingOutputPort>operator_doubleArrow(_createPrimitiveAttributeReferencingOutputPort, _function);
  }
  
  /**
   * This method creates an PrimitiveAttributeReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveAttributeReferencingOutputPort createPrimitiveAttributeReferencingOutputPort(final String ID) {
    return this.createPrimitiveAttributeReferencingOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveAttributeReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveAttributeReferencingOutputPort createPrimitiveAttributeReferencingOutputPort(final InternalModelElementContainer parent) {
    return this.createPrimitiveAttributeReferencingOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveAttributeReferencingOutputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveAttributeReferencingOutputPort createPrimitiveAttributeReferencingOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveAttributeReferencingOutputPort(ID, null, parent, true);
  }
  
  public PrimitiveAttributeReferencingOutputPort createPrimitiveAttributeReferencingOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveAttributeReferencingOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveAttributeReferencingOutputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveAttributeReferencingOutputPort createPrimitiveAttributeReferencingOutputPort(final InternalModelElement ime) {
    return this.createPrimitiveAttributeReferencingOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveAttributeReferencingOutputPort createPrimitiveAttributeReferencingOutputPort() {
    return this.createPrimitiveAttributeReferencingOutputPort(EcoreUtil.generateUUID());
  }
  
  private <T extends IdentifiableElement> T setInternal(final T elm, final InternalIdentifiableElement internal) {
    final Procedure1<T> _function = new Procedure1<T>() {
      @Override
      public void apply(final T it) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(it.getId());
        if (_isNullOrEmpty) {
          EcoreUtil.setID(it, EcoreUtil.generateUUID());
        }
        boolean _matched = false;
        if (elm instanceof GraphModel) {
          _matched=true;
          ((GraphModel)elm).setInternalElement_(((InternalGraphModel) internal));
        }
        if (!_matched) {
          if (elm instanceof ModelElement) {
            _matched=true;
            ((ModelElement)elm).setInternalElement_(((InternalModelElement) internal));
          }
        }
        if (!_matched) {
          if (elm instanceof Type) {
            _matched=true;
            ((Type)elm).setInternalElement_(((InternalType) internal));
          }
        }
      }
    };
    return ObjectExtensions.<T>operator_doubleArrow(elm, _function);
  }
  
  /**
   * This method creates a new Profile object with an underlying org.eclipse.emf.ecore.resource.Resource. Thus you can
   * simply call the Profile's save method to save your changes.
   */
  public Profile createProfile(final String path, final String fileName) {
    IPath filePath = new Path(path).append(fileName).addFileExtension("profile");
    URI uri = URI.createPlatformResourceURI(filePath.toOSString(), true);
    Resource res = new ResourceSetImpl().createResource(uri);
    Profile graph = ProfileFactory.eINSTANCE.createProfile();
    EcoreUtil.setID(graph, EcoreUtil.generateUUID());
    res.getContents().add(graph.getInternalElement_());
    this.postCreates(graph);
    try {
      res.save(null);
    } catch (final Throwable _t) {
      if (_t instanceof IOException) {
        final IOException e = (IOException)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    return graph;
  }
  
  public void postCreates(final GUISIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new PostCreateSIB().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ProcessSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new PostCreateSIB().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ProcessBlueprintSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new PostCreateSIB().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final GUIBlueprintSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new PostCreateSIB().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final Profile me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new PostCreateProfile().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
}
