/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.profile.build;

import com.google.common.base.Objects;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.ComplexOutputPort;
import info.scce.dime.process.process.EndSIB;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.Output;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.dime.process.process.PrimitiveOutputPort;
import info.scce.dime.process.process.StartSIB;
import info.scce.dime.profile.api.ProfileExtension;
import info.scce.dime.profile.build.PrimeSIBBuild;
import info.scce.dime.profile.layout.Layouter;
import info.scce.dime.profile.profile.EndSIBReferencingBranch;
import info.scce.dime.profile.profile.InputPort;
import info.scce.dime.profile.profile.InputPortReferencingOutputPort;
import info.scce.dime.profile.profile.OutputPortReferencingInputPort;
import info.scce.dime.profile.profile.ProcessSIB;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class ProcessSIBBuild extends PrimeSIBBuild<ProcessSIB, InputPort, Output, EndSIBReferencingBranch, EndSIB, InputPortReferencingOutputPort, Input> {
  @Extension
  private ProfileExtension _profileExtension = new ProfileExtension();
  
  @Extension
  private Layouter layouter = Layouter.getInstance();
  
  public static boolean initialize(final ProcessSIB sib) {
    return new ProcessSIBBuild(sib).initialize();
  }
  
  public static void update(final ProcessSIB sib) {
    new ProcessSIBBuild(sib).update();
  }
  
  public ProcessSIBBuild(final ProcessSIB sib) {
    super(sib);
  }
  
  @Override
  public EObject getSIBReference(final ProcessSIB sib) {
    return sib.getReferencedProcess();
  }
  
  @Override
  public void layout(final ProcessSIB sib) {
    this.layouter.layout(sib);
  }
  
  @Override
  public Iterable<InputPort> getSIBPorts(final ProcessSIB sib) {
    return sib.getInputPorts();
  }
  
  @Override
  public Iterable<Output> getSIBPortReferences(final ProcessSIB sib) {
    List<Output> _xblockexpression = null;
    {
      final List<Output> references = CollectionLiterals.<Output>newArrayList();
      info.scce.dime.process.process.Process _referencedProcess = sib.getReferencedProcess();
      final StartSIB startSIB = this.getStartSIB(((info.scce.dime.process.process.Process) _referencedProcess));
      InputOutput.<String>println(("StartSIB: " + startSIB));
      final Procedure1<List<Output>> _function = new Procedure1<List<Output>>() {
        @Override
        public void apply(final List<Output> it) {
          List<Output> _elvis = null;
          EList<Output> _outputs = null;
          if (startSIB!=null) {
            _outputs=startSIB.getOutputs();
          }
          if (_outputs != null) {
            _elvis = _outputs;
          } else {
            _elvis = Collections.<Output>unmodifiableList(CollectionLiterals.<Output>newArrayList());
          }
          it.addAll(_elvis);
          final Consumer<Output> _function = new Consumer<Output>() {
            @Override
            public void accept(final Output it) {
              InputOutput.<String>println(("StartSIB.output: " + it));
            }
          };
          it.forEach(_function);
        }
      };
      _xblockexpression = ObjectExtensions.<List<Output>>operator_doubleArrow(references, _function);
    }
    return _xblockexpression;
  }
  
  @Override
  public boolean isSIBPortReference(final InputPort sibPort, final Output portRef) {
    EObject _referencedObject = this._profileExtension.getReferencedObject(sibPort);
    return Objects.equal(portRef, _referencedObject);
  }
  
  @Override
  public InputPort addSIBPort(final Output ref) {
    OutputPortReferencingInputPort _xblockexpression = null;
    {
      InputOutput.<String>println(("Add input for: " + ref));
      OutputPortReferencingInputPort _switchResult = null;
      final Output it = ref;
      boolean _matched = false;
      if (it instanceof PrimitiveOutputPort) {
        _matched=true;
        int _height = this.sib.getHeight();
        int _minus = (_height - 1);
        _switchResult = this.sib.newPrimitiveOutputPortReferencingInputPort(it, 1, _minus);
      }
      if (!_matched) {
        if (it instanceof ComplexOutputPort) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = this.sib.newComplexOutputPortReferencingInputPort(it, 1, _minus);
        }
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
  
  @Override
  public Iterable<EndSIBReferencingBranch> getBranches(final ProcessSIB sib) {
    return sib.getEndSIBReferencingBranchs();
  }
  
  @Override
  public Iterable<EndSIB> getBranchReferences(final ProcessSIB sib) {
    info.scce.dime.process.process.Process _referencedProcess = sib.getReferencedProcess();
    final info.scce.dime.process.process.Process referencedProcess = ((info.scce.dime.process.process.Process) _referencedProcess);
    String _modelName = null;
    if (referencedProcess!=null) {
      _modelName=referencedProcess.getModelName();
    }
    String _plus = ("Process: " + _modelName);
    InputOutput.<String>println(_plus);
    final EList<EndSIB> endSIBs = referencedProcess.getEndSIBs();
    List<String> _map = null;
    if (endSIBs!=null) {
      final Function1<EndSIB, String> _function = new Function1<EndSIB, String>() {
        @Override
        public String apply(final EndSIB it) {
          return it.getBranchName();
        }
      };
      _map=ListExtensions.<EndSIB, String>map(endSIBs, _function);
    }
    String _join = null;
    if (_map!=null) {
      _join=IterableExtensions.join(_map, ", ");
    }
    String _plus_1 = ("EndSIBs: " + _join);
    InputOutput.<String>println(_plus_1);
    return endSIBs;
  }
  
  @Override
  public boolean isBranchReference(final EndSIBReferencingBranch branch, final EndSIB endSib) {
    EObject _referencedObject = this._profileExtension.getReferencedObject(branch);
    return Objects.equal(endSib, _referencedObject);
  }
  
  @Override
  public EndSIBReferencingBranch addBranch(final EndSIB ref) {
    EndSIBReferencingBranch _xblockexpression = null;
    {
      InputOutput.<String>println(("BranchRef: " + EndSIB.class));
      int _height = this.sib.getHeight();
      int _minus = (_height - 1);
      _xblockexpression = this.sib.newEndSIBReferencingBranch(ref, 1, _minus);
    }
    return _xblockexpression;
  }
  
  @Override
  public void layout(final EndSIBReferencingBranch branch) {
    this.layouter.layout(branch);
  }
  
  @Override
  public Iterable<InputPortReferencingOutputPort> getBranchPorts(final EndSIBReferencingBranch sib) {
    return sib.getInputPortReferencingOutputPorts();
  }
  
  @Override
  public Iterable<Input> getBranchPortReferences(final EndSIB endSib) {
    return endSib.getInputs();
  }
  
  @Override
  public boolean isBranchPortReference(final InputPortReferencingOutputPort port, final Input portRef) {
    EObject _referencedObject = this._profileExtension.getReferencedObject(port);
    return Objects.equal(portRef, _referencedObject);
  }
  
  @Override
  public InputPortReferencingOutputPort addBranchPort(final EndSIBReferencingBranch branch, final Input ref) {
    InputPortReferencingOutputPort _xblockexpression = null;
    {
      InputOutput.<String>println(("Add output for: " + ref));
      InputPortReferencingOutputPort _switchResult = null;
      final Input it = ref;
      boolean _matched = false;
      if (it instanceof PrimitiveInputPort) {
        _matched=true;
        int _height = this.sib.getHeight();
        int _minus = (_height - 1);
        _switchResult = branch.newPrimitiveInputPortReferencingOutputPort(it, 1, _minus);
      }
      if (!_matched) {
        if (it instanceof ComplexInputPort) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = branch.newComplexInputPortReferencingOutputPort(it, 1, _minus);
        }
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
  
  public StartSIB getStartSIB(final info.scce.dime.process.process.Process process) {
    StartSIB _xblockexpression = null;
    {
      boolean _isEmpty = process.getStartSIBs().isEmpty();
      if (_isEmpty) {
        this.showError("Referenced process model does not contain a Start SIB");
        return null;
      }
      int _size = process.getStartSIBs().size();
      boolean _greaterThan = (_size > 1);
      if (_greaterThan) {
        this.showError("Referenced process model contains multiple Start SIBs");
      }
      _xblockexpression = IterableExtensions.<StartSIB>head(process.getStartSIBs());
    }
    return _xblockexpression;
  }
}
