/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.profile.build;

import com.google.common.base.Objects;
import info.scce.dime.process.process.BranchBlueprint;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.ComplexOutputPort;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.dime.process.process.PrimitiveOutputPort;
import info.scce.dime.profile.api.ProfileExtension;
import info.scce.dime.profile.build.PrimeSIBBuild;
import info.scce.dime.profile.layout.Layouter;
import info.scce.dime.profile.profile.BlueprintBranch;
import info.scce.dime.profile.profile.InputPort;
import info.scce.dime.profile.profile.InputPortReferencingInputPort;
import info.scce.dime.profile.profile.OutputPort;
import info.scce.dime.profile.profile.OutputPortReferencingOutputPort;
import info.scce.dime.profile.profile.ProcessBlueprintSIB;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.InputOutput;

@SuppressWarnings("all")
public class ProcessBlueprintSIBBuild extends PrimeSIBBuild<ProcessBlueprintSIB, InputPort, info.scce.dime.process.process.InputPort, BlueprintBranch, BranchBlueprint, OutputPort, info.scce.dime.process.process.OutputPort> {
  @Extension
  private ProfileExtension _profileExtension = new ProfileExtension();
  
  @Extension
  private Layouter layouter = Layouter.getInstance();
  
  public static boolean initialize(final ProcessBlueprintSIB sib) {
    return new ProcessBlueprintSIBBuild(sib).initialize();
  }
  
  public static void update(final ProcessBlueprintSIB sib) {
    new ProcessBlueprintSIBBuild(sib).update();
  }
  
  public ProcessBlueprintSIBBuild(final ProcessBlueprintSIB sib) {
    super(sib);
  }
  
  @Override
  public info.scce.dime.process.process.ProcessBlueprintSIB getSIBReference(final ProcessBlueprintSIB sib) {
    info.scce.dime.process.process.ProcessBlueprintSIB _referencedProcessBlueprintSIB = sib.getReferencedProcessBlueprintSIB();
    return ((info.scce.dime.process.process.ProcessBlueprintSIB) _referencedProcessBlueprintSIB);
  }
  
  @Override
  public void layout(final ProcessBlueprintSIB sib) {
    this.layouter.layout(sib);
  }
  
  @Override
  public Iterable<InputPort> getSIBPorts(final ProcessBlueprintSIB sib) {
    return sib.getInputPorts();
  }
  
  @Override
  public Iterable<info.scce.dime.process.process.InputPort> getSIBPortReferences(final ProcessBlueprintSIB sib) {
    info.scce.dime.process.process.ProcessBlueprintSIB _sIBReference = this.getSIBReference(sib);
    EList<info.scce.dime.process.process.InputPort> _inputPorts = null;
    if (_sIBReference!=null) {
      _inputPorts=_sIBReference.getInputPorts();
    }
    return _inputPorts;
  }
  
  @Override
  public boolean isSIBPortReference(final InputPort sibPort, final info.scce.dime.process.process.InputPort portRef) {
    EObject _referencedObject = this._profileExtension.getReferencedObject(sibPort);
    return Objects.equal(portRef, _referencedObject);
  }
  
  @Override
  public InputPort addSIBPort(final info.scce.dime.process.process.InputPort portRef) {
    InputPortReferencingInputPort _xblockexpression = null;
    {
      InputOutput.<String>println(("Add input for: " + portRef));
      InputPortReferencingInputPort _switchResult = null;
      final info.scce.dime.process.process.InputPort it = portRef;
      boolean _matched = false;
      if (it instanceof PrimitiveInputPort) {
        _matched=true;
        int _height = this.sib.getHeight();
        int _minus = (_height - 1);
        _switchResult = this.sib.newPrimitiveInputPortReferencingInputPort(it, 1, _minus);
      }
      if (!_matched) {
        if (it instanceof ComplexInputPort) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = this.sib.newComplexInputPortReferencingInputPort(it, 1, _minus);
        }
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
  
  @Override
  public Iterable<BlueprintBranch> getBranches(final ProcessBlueprintSIB sib) {
    return sib.getBlueprintBranchs();
  }
  
  @Override
  public Iterable<BranchBlueprint> getBranchReferences(final ProcessBlueprintSIB sib) {
    return this.getSIBReference(sib).getBranchBlueprintSuccessors();
  }
  
  @Override
  public boolean isBranchReference(final BlueprintBranch branch, final BranchBlueprint branchRef) {
    EObject _referencedObject = this._profileExtension.getReferencedObject(branch);
    return Objects.equal(branchRef, _referencedObject);
  }
  
  @Override
  public BlueprintBranch addBranch(final BranchBlueprint branchRef) {
    BlueprintBranch _xblockexpression = null;
    {
      InputOutput.<String>println(("BranchRef: " + branchRef));
      int _height = this.sib.getHeight();
      int _minus = (_height - 1);
      _xblockexpression = this.sib.newBlueprintBranch(branchRef, 1, _minus);
    }
    return _xblockexpression;
  }
  
  @Override
  public void layout(final BlueprintBranch branch) {
    this.layouter.layout(branch);
  }
  
  @Override
  public Iterable<OutputPort> getBranchPorts(final BlueprintBranch branch) {
    return branch.getOutputPorts();
  }
  
  @Override
  public Iterable<info.scce.dime.process.process.OutputPort> getBranchPortReferences(final BranchBlueprint branchRef) {
    return branchRef.getOutputPorts();
  }
  
  @Override
  public boolean isBranchPortReference(final OutputPort port, final info.scce.dime.process.process.OutputPort portRef) {
    EObject _referencedObject = this._profileExtension.getReferencedObject(port);
    return Objects.equal(portRef, _referencedObject);
  }
  
  @Override
  public OutputPort addBranchPort(final BlueprintBranch branch, final info.scce.dime.process.process.OutputPort portRef) {
    OutputPortReferencingOutputPort _xblockexpression = null;
    {
      InputOutput.<String>println(("Add output for: " + portRef));
      OutputPortReferencingOutputPort _switchResult = null;
      final info.scce.dime.process.process.OutputPort it = portRef;
      boolean _matched = false;
      if (it instanceof PrimitiveOutputPort) {
        _matched=true;
        int _height = this.sib.getHeight();
        int _minus = (_height - 1);
        _switchResult = branch.newPrimitiveOutputPortReferencingOutputPort(it, 1, _minus);
      }
      if (!_matched) {
        if (it instanceof ComplexOutputPort) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = branch.newComplexOutputPortReferencingOutputPort(it, 1, _minus);
        }
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
}
