/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.profile.build;

import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.runtime.CincoRuntimeBaseClass;
import graphmodel.Container;
import graphmodel.Edge;
import graphmodel.GraphModel;
import graphmodel.Node;
import info.scce.dime.process.helper.PortUtils;
import info.scce.dime.process.mcam.adapter.ProcessAdapter;
import info.scce.dime.process.mcam.adapter.ProcessId;
import info.scce.dime.process.mcam.cli.ProcessExecution;
import info.scce.dime.profile.profile.SIB;
import info.scce.mcam.framework.processes.CheckProcess;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure2;

@SuppressWarnings("all")
public abstract class PrimeSIBBuild<SIBType extends SIB, SIBPortType extends Node, SIBPortRef extends Object, BranchType extends Node, BranchRef extends Object, BranchPortType extends Node, BranchPortRef extends Object> extends CincoRuntimeBaseClass {
  protected SIBType sib;
  
  public PrimeSIBBuild(final SIBType sib) {
    this.sib = sib;
  }
  
  public abstract EObject getSIBReference(final SIBType sib);
  
  public abstract Iterable<SIBPortType> getSIBPorts(final SIBType sib);
  
  public abstract Iterable<SIBPortRef> getSIBPortReferences(final SIBType sib);
  
  public abstract boolean isSIBPortReference(final SIBPortType port, final SIBPortRef portRef);
  
  public abstract SIBPortType addSIBPort(final SIBPortRef ref);
  
  public abstract Iterable<BranchType> getBranches(final SIBType sib);
  
  public abstract Iterable<BranchRef> getBranchReferences(final SIBType sib);
  
  public abstract boolean isBranchReference(final BranchType branch, final BranchRef branchRef);
  
  public abstract BranchType addBranch(final BranchRef ref);
  
  public abstract Iterable<BranchPortType> getBranchPorts(final BranchType sib);
  
  public abstract Iterable<BranchPortRef> getBranchPortReferences(final BranchRef branchRef);
  
  public abstract boolean isBranchPortReference(final BranchPortType branchPort, final BranchPortRef portRef);
  
  public abstract BranchPortType addBranchPort(final BranchType branch, final BranchPortRef ref);
  
  public void layout(final SIBType sib) {
  }
  
  public void layout(final BranchType branch) {
  }
  
  public boolean initialize() {
    boolean _xblockexpression = false;
    {
      boolean _initializeInternal = this.initializeInternal();
      if (_initializeInternal) {
        this.initializeSIBInternal();
        this.initializeBranchesInternal();
        this.layout(this.sib);
        return true;
      }
      _xblockexpression = false;
    }
    return _xblockexpression;
  }
  
  public boolean initializeSIB() {
    boolean _xblockexpression = false;
    {
      boolean _initializeInternal = this.initializeInternal();
      if (_initializeInternal) {
        this.initializeSIBInternal();
        this.layout(this.sib);
        return true;
      }
      _xblockexpression = false;
    }
    return _xblockexpression;
  }
  
  private boolean initializeInternal() {
    final String error = this.isValid();
    if ((error != null)) {
      String _elvis = null;
      if (error != null) {
        _elvis = error;
      } else {
        _elvis = "";
      }
      String _plus = (_elvis + "Continue anyway?");
      final boolean ok = this.letUserConfirm("Initialization failed.", _plus);
      if ((!ok)) {
        this.sib.delete();
        return false;
      }
    }
    return true;
  }
  
  public String isValid() {
    EObject _sIBReference = this.getSIBReference(this.sib);
    boolean _tripleEquals = (_sIBReference == null);
    if (_tripleEquals) {
      return "Referenced element is null.";
    }
    return null;
  }
  
  public void update() {
    final String error = this.isValid();
    if ((error != null)) {
      String _elvis = null;
      if (error != null) {
        _elvis = error;
      } else {
        _elvis = "";
      }
      String _plus = (_elvis + "Continue anyway?");
      final boolean ok = this.letUserConfirm("Initialization failed.", _plus);
      if ((!ok)) {
        return;
      }
    }
    this.updateSIB();
    this.updateBranches();
    this.layout(this.sib);
  }
  
  public ArrayList<String> validate() {
    final ArrayList<String> errors = CollectionLiterals.<String>newArrayList();
    final String error = this.isValid();
    if ((error != null)) {
      errors.add(error);
    } else {
      errors.addAll(this.validateSIBPorts());
      errors.addAll(this.validateBranches());
    }
    return errors;
  }
  
  private void initializeSIBInternal() {
    PortUtils.Sync<SIBPortType, SIBPortRef> _sync = new PortUtils.Sync<SIBPortType, SIBPortRef>();
    final Procedure1<PortUtils.Sync<SIBPortType, SIBPortRef>> _function = new Procedure1<PortUtils.Sync<SIBPortType, SIBPortRef>>() {
      @Override
      public void apply(final PortUtils.Sync<SIBPortType, SIBPortRef> it) {
        final Procedure1<SIBPortRef> _function = new Procedure1<SIBPortRef>() {
          @Override
          public void apply(final SIBPortRef ref) {
            PrimeSIBBuild.this.addSIBPort(ref);
          }
        };
        it.add = _function;
      }
    };
    final PortUtils.Sync<SIBPortType, SIBPortRef> sync = ObjectExtensions.<PortUtils.Sync<SIBPortType, SIBPortRef>>operator_doubleArrow(_sync, _function);
    sync.apply(this.getSIBPorts(this.sib), this.getSIBPortReferences(this.sib));
  }
  
  public void updateSIB() {
    PortUtils.Sync<SIBPortType, SIBPortRef> _sync = new PortUtils.Sync<SIBPortType, SIBPortRef>();
    final Procedure1<PortUtils.Sync<SIBPortType, SIBPortRef>> _function = new Procedure1<PortUtils.Sync<SIBPortType, SIBPortRef>>() {
      @Override
      public void apply(final PortUtils.Sync<SIBPortType, SIBPortRef> it) {
        final Function2<SIBPortType, SIBPortRef, Boolean> _function = new Function2<SIBPortType, SIBPortRef, Boolean>() {
          @Override
          public Boolean apply(final SIBPortType input, final SIBPortRef ref) {
            return Boolean.valueOf(PrimeSIBBuild.this.isSIBPortReference(input, ref));
          }
        };
        it.equals = _function;
        final Procedure1<SIBPortRef> _function_1 = new Procedure1<SIBPortRef>() {
          @Override
          public void apply(final SIBPortRef ref) {
            PrimeSIBBuild.this.addSIBPort(ref);
          }
        };
        it.add = _function_1;
        final Procedure2<SIBPortType, SIBPortRef> _function_2 = new Procedure2<SIBPortType, SIBPortRef>() {
          @Override
          public void apply(final SIBPortType input, final SIBPortRef ref) {
            PrimeSIBBuild.this.updateInPort(input, ref);
          }
        };
        it.update = _function_2;
        final Procedure1<SIBPortType> _function_3 = new Procedure1<SIBPortType>() {
          @Override
          public void apply(final SIBPortType input) {
            input.delete();
          }
        };
        it.delete = _function_3;
      }
    };
    final PortUtils.Sync<SIBPortType, SIBPortRef> sync = ObjectExtensions.<PortUtils.Sync<SIBPortType, SIBPortRef>>operator_doubleArrow(_sync, _function);
    sync.apply(this.getSIBPorts(this.sib), this.getSIBPortReferences(this.sib));
  }
  
  public ArrayList<String> validateSIBPorts() {
    final ArrayList<String> errors = CollectionLiterals.<String>newArrayList();
    PortUtils.Sync<SIBPortType, SIBPortRef> _sync = new PortUtils.Sync<SIBPortType, SIBPortRef>();
    final Procedure1<PortUtils.Sync<SIBPortType, SIBPortRef>> _function = new Procedure1<PortUtils.Sync<SIBPortType, SIBPortRef>>() {
      @Override
      public void apply(final PortUtils.Sync<SIBPortType, SIBPortRef> it) {
        final Function2<SIBPortType, SIBPortRef, Boolean> _function = new Function2<SIBPortType, SIBPortRef, Boolean>() {
          @Override
          public Boolean apply(final SIBPortType input, final SIBPortRef ref) {
            return Boolean.valueOf(PrimeSIBBuild.this.isSIBPortReference(input, ref));
          }
        };
        it.equals = _function;
        final Procedure1<SIBPortRef> _function_1 = new Procedure1<SIBPortRef>() {
          @Override
          public void apply(final SIBPortRef ref) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("SIB port missing for referenced element ");
            _builder.append(ref);
            errors.add(_builder.toString());
          }
        };
        it.add = _function_1;
        final Procedure1<SIBPortType> _function_2 = new Procedure1<SIBPortType>() {
          @Override
          public void apply(final SIBPortType input) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("SIB port ");
            _builder.append(input);
            _builder.append(" is obsolete");
            errors.add(_builder.toString());
          }
        };
        it.delete = _function_2;
      }
    };
    final PortUtils.Sync<SIBPortType, SIBPortRef> sync = ObjectExtensions.<PortUtils.Sync<SIBPortType, SIBPortRef>>operator_doubleArrow(_sync, _function);
    sync.apply(this.getSIBPorts(this.sib), this.getSIBPortReferences(this.sib));
    return errors;
  }
  
  public PortUtils.Sync<SIBPortType, SIBPortRef> getSIBPortSync() {
    PortUtils.Sync<SIBPortType, SIBPortRef> _sync = new PortUtils.Sync<SIBPortType, SIBPortRef>();
    final Procedure1<PortUtils.Sync<SIBPortType, SIBPortRef>> _function = new Procedure1<PortUtils.Sync<SIBPortType, SIBPortRef>>() {
      @Override
      public void apply(final PortUtils.Sync<SIBPortType, SIBPortRef> it) {
        final Function2<SIBPortType, SIBPortRef, Boolean> _function = new Function2<SIBPortType, SIBPortRef, Boolean>() {
          @Override
          public Boolean apply(final SIBPortType input, final SIBPortRef ref) {
            return Boolean.valueOf(PrimeSIBBuild.this.isSIBPortReference(input, ref));
          }
        };
        it.equals = _function;
      }
    };
    return ObjectExtensions.<PortUtils.Sync<SIBPortType, SIBPortRef>>operator_doubleArrow(_sync, _function);
  }
  
  public void updateInPort(final SIBPortType sibPort, final SIBPortRef ref) {
    final SIBPortType cInput = sibPort;
    final SIBPortType cInputNew = this.addSIBPort(ref);
    ArrayList<Edge> _newList = this.<Edge>toNewList(cInput.<Edge>getIncoming());
    for (final Edge cEdge : _newList) {
      cEdge.reconnectTarget(cInputNew);
    }
    cInput.delete();
    EcoreUtil.setID(cInputNew, sibPort.getId());
  }
  
  public void postProcessNewSIBPort(final SIBPortType port, final Object ref) {
  }
  
  void initializeBranchesInternal() {
    PortUtils.Sync<BranchType, BranchRef> _sync = new PortUtils.Sync<BranchType, BranchRef>();
    final Procedure1<PortUtils.Sync<BranchType, BranchRef>> _function = new Procedure1<PortUtils.Sync<BranchType, BranchRef>>() {
      @Override
      public void apply(final PortUtils.Sync<BranchType, BranchRef> it) {
        final Procedure1<BranchRef> _function = new Procedure1<BranchRef>() {
          @Override
          public void apply(final BranchRef ref) {
            PrimeSIBBuild.this.addAndUpdateBranch(ref);
          }
        };
        it.add = _function;
      }
    };
    final PortUtils.Sync<BranchType, BranchRef> sync = ObjectExtensions.<PortUtils.Sync<BranchType, BranchRef>>operator_doubleArrow(_sync, _function);
    sync.apply(this.getBranches(this.sib), this.getBranchReferences(this.sib));
  }
  
  public void updateBranches() {
    PortUtils.Sync<BranchType, BranchRef> _sync = new PortUtils.Sync<BranchType, BranchRef>();
    final Procedure1<PortUtils.Sync<BranchType, BranchRef>> _function = new Procedure1<PortUtils.Sync<BranchType, BranchRef>>() {
      @Override
      public void apply(final PortUtils.Sync<BranchType, BranchRef> it) {
        final Function2<BranchType, BranchRef, Boolean> _function = new Function2<BranchType, BranchRef, Boolean>() {
          @Override
          public Boolean apply(final BranchType branch, final BranchRef ref) {
            return Boolean.valueOf(PrimeSIBBuild.this.isBranchReference(branch, ref));
          }
        };
        it.equals = _function;
        final Procedure1<BranchRef> _function_1 = new Procedure1<BranchRef>() {
          @Override
          public void apply(final BranchRef ref) {
            PrimeSIBBuild.this.addAndUpdateBranch(ref);
          }
        };
        it.add = _function_1;
        final Procedure2<BranchType, BranchRef> _function_2 = new Procedure2<BranchType, BranchRef>() {
          @Override
          public void apply(final BranchType branch, final BranchRef ref) {
            PrimeSIBBuild.this.updateBranch(branch, ref);
          }
        };
        it.update = _function_2;
        final Procedure1<BranchType> _function_3 = new Procedure1<BranchType>() {
          @Override
          public void apply(final BranchType branch) {
            branch.delete();
          }
        };
        it.delete = _function_3;
      }
    };
    final PortUtils.Sync<BranchType, BranchRef> sync = ObjectExtensions.<PortUtils.Sync<BranchType, BranchRef>>operator_doubleArrow(_sync, _function);
    sync.apply(this.getBranches(this.sib), this.getBranchReferences(this.sib));
  }
  
  public PortUtils.Sync<BranchType, BranchRef> getBranchSync() {
    PortUtils.Sync<BranchType, BranchRef> _sync = new PortUtils.Sync<BranchType, BranchRef>();
    final Procedure1<PortUtils.Sync<BranchType, BranchRef>> _function = new Procedure1<PortUtils.Sync<BranchType, BranchRef>>() {
      @Override
      public void apply(final PortUtils.Sync<BranchType, BranchRef> it) {
        final Function2<BranchType, BranchRef, Boolean> _function = new Function2<BranchType, BranchRef, Boolean>() {
          @Override
          public Boolean apply(final BranchType branch, final BranchRef ref) {
            return Boolean.valueOf(PrimeSIBBuild.this.isBranchReference(branch, ref));
          }
        };
        it.equals = _function;
      }
    };
    return ObjectExtensions.<PortUtils.Sync<BranchType, BranchRef>>operator_doubleArrow(_sync, _function);
  }
  
  public ArrayList<String> validateBranches() {
    final ArrayList<String> errors = CollectionLiterals.<String>newArrayList();
    PortUtils.Sync<BranchType, BranchRef> _sync = new PortUtils.Sync<BranchType, BranchRef>();
    final Procedure1<PortUtils.Sync<BranchType, BranchRef>> _function = new Procedure1<PortUtils.Sync<BranchType, BranchRef>>() {
      @Override
      public void apply(final PortUtils.Sync<BranchType, BranchRef> it) {
        final Function2<BranchType, BranchRef, Boolean> _function = new Function2<BranchType, BranchRef, Boolean>() {
          @Override
          public Boolean apply(final BranchType branch, final BranchRef ref) {
            return Boolean.valueOf(PrimeSIBBuild.this.isBranchReference(branch, ref));
          }
        };
        it.equals = _function;
        final Procedure1<BranchRef> _function_1 = new Procedure1<BranchRef>() {
          @Override
          public void apply(final BranchRef ref) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Branch missing for referenced element ");
            _builder.append(ref);
            errors.add(_builder.toString());
          }
        };
        it.add = _function_1;
        final Procedure2<BranchType, BranchRef> _function_2 = new Procedure2<BranchType, BranchRef>() {
          @Override
          public void apply(final BranchType branch, final BranchRef ref) {
            errors.addAll(PrimeSIBBuild.this.validateBranchPorts(branch, ref));
          }
        };
        it.update = _function_2;
        final Procedure1<BranchType> _function_3 = new Procedure1<BranchType>() {
          @Override
          public void apply(final BranchType branch) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Branch ");
            _builder.append(branch);
            _builder.append(" is obsolete");
            errors.add(_builder.toString());
          }
        };
        it.delete = _function_3;
      }
    };
    final PortUtils.Sync<BranchType, BranchRef> sync = ObjectExtensions.<PortUtils.Sync<BranchType, BranchRef>>operator_doubleArrow(_sync, _function);
    sync.apply(this.getBranches(this.sib), this.getBranchReferences(this.sib));
    return errors;
  }
  
  public void addAndUpdateBranch(final BranchRef ref) {
    final BranchType newBranch = this.addBranch(ref);
    InputOutput.<String>println(("New branch: " + newBranch));
    this.updateBranch(newBranch, ref);
  }
  
  public void updateBranch(final BranchType branch, final BranchRef branchRef) {
    PortUtils.Sync<BranchPortType, BranchPortRef> _sync = new PortUtils.Sync<BranchPortType, BranchPortRef>();
    final Procedure1<PortUtils.Sync<BranchPortType, BranchPortRef>> _function = new Procedure1<PortUtils.Sync<BranchPortType, BranchPortRef>>() {
      @Override
      public void apply(final PortUtils.Sync<BranchPortType, BranchPortRef> it) {
        final Function2<BranchPortType, BranchPortRef, Boolean> _function = new Function2<BranchPortType, BranchPortRef, Boolean>() {
          @Override
          public Boolean apply(final BranchPortType port, final BranchPortRef ref) {
            return Boolean.valueOf(PrimeSIBBuild.this.isBranchPortReference(port, ref));
          }
        };
        it.equals = _function;
        final Procedure1<BranchPortRef> _function_1 = new Procedure1<BranchPortRef>() {
          @Override
          public void apply(final BranchPortRef ref) {
            PrimeSIBBuild.this.addBranchPort(branch, ref);
          }
        };
        it.add = _function_1;
        final Procedure2<BranchPortType, BranchPortRef> _function_2 = new Procedure2<BranchPortType, BranchPortRef>() {
          @Override
          public void apply(final BranchPortType port, final BranchPortRef ref) {
            PrimeSIBBuild.this.update(port, ref, branch);
          }
        };
        it.update = _function_2;
        final Procedure1<BranchPortType> _function_3 = new Procedure1<BranchPortType>() {
          @Override
          public void apply(final BranchPortType port) {
            port.delete();
          }
        };
        it.delete = _function_3;
      }
    };
    final PortUtils.Sync<BranchPortType, BranchPortRef> sync = ObjectExtensions.<PortUtils.Sync<BranchPortType, BranchPortRef>>operator_doubleArrow(_sync, _function);
    sync.apply(this.getBranchPorts(branch), this.getBranchPortReferences(branchRef));
    if ((branch instanceof Container)) {
      this.layout(branch);
    }
  }
  
  public ArrayList<String> validateBranchPorts(final BranchType branch, final BranchRef branchRef) {
    final ArrayList<String> errors = CollectionLiterals.<String>newArrayList();
    PortUtils.Sync<BranchPortType, BranchPortRef> _sync = new PortUtils.Sync<BranchPortType, BranchPortRef>();
    final Procedure1<PortUtils.Sync<BranchPortType, BranchPortRef>> _function = new Procedure1<PortUtils.Sync<BranchPortType, BranchPortRef>>() {
      @Override
      public void apply(final PortUtils.Sync<BranchPortType, BranchPortRef> it) {
        final Function2<BranchPortType, BranchPortRef, Boolean> _function = new Function2<BranchPortType, BranchPortRef, Boolean>() {
          @Override
          public Boolean apply(final BranchPortType port, final BranchPortRef ref) {
            return Boolean.valueOf(PrimeSIBBuild.this.isBranchPortReference(port, ref));
          }
        };
        it.equals = _function;
        final Procedure1<BranchPortRef> _function_1 = new Procedure1<BranchPortRef>() {
          @Override
          public void apply(final BranchPortRef ref) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Branch port missing for referenced element ");
            _builder.append(ref);
            errors.add(_builder.toString());
          }
        };
        it.add = _function_1;
        final Procedure1<BranchPortType> _function_2 = new Procedure1<BranchPortType>() {
          @Override
          public void apply(final BranchPortType port) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Branch port ");
            _builder.append(port);
            _builder.append(" is obsolete");
            errors.add(_builder.toString());
          }
        };
        it.delete = _function_2;
      }
    };
    final PortUtils.Sync<BranchPortType, BranchPortRef> sync = ObjectExtensions.<PortUtils.Sync<BranchPortType, BranchPortRef>>operator_doubleArrow(_sync, _function);
    sync.apply(this.getBranchPorts(branch), this.getBranchPortReferences(branchRef));
    return errors;
  }
  
  public PortUtils.Sync<BranchPortType, BranchPortRef> getBranchPortSync() {
    PortUtils.Sync<BranchPortType, BranchPortRef> _sync = new PortUtils.Sync<BranchPortType, BranchPortRef>();
    final Procedure1<PortUtils.Sync<BranchPortType, BranchPortRef>> _function = new Procedure1<PortUtils.Sync<BranchPortType, BranchPortRef>>() {
      @Override
      public void apply(final PortUtils.Sync<BranchPortType, BranchPortRef> it) {
        final Function2<BranchPortType, BranchPortRef, Boolean> _function = new Function2<BranchPortType, BranchPortRef, Boolean>() {
          @Override
          public Boolean apply(final BranchPortType port, final BranchPortRef ref) {
            return Boolean.valueOf(PrimeSIBBuild.this.isBranchPortReference(port, ref));
          }
        };
        it.equals = _function;
      }
    };
    return ObjectExtensions.<PortUtils.Sync<BranchPortType, BranchPortRef>>operator_doubleArrow(_sync, _function);
  }
  
  public Object update(final BranchPortType branchPort, final BranchPortRef portRef, final BranchType branch) {
    return null;
  }
  
  public boolean hasErrors(final GraphModel model) {
    final File file = this._resourceExtension.getFile(model.eResource()).getRawLocation().toFile();
    final ProcessExecution fe = new ProcessExecution();
    final ProcessAdapter adapter = fe.initApiAdapter(file);
    final CheckProcess<ProcessId, ProcessAdapter> check = fe.executeCheckPhase(adapter);
    if ((check.hasErrors() || check.hasWarnings())) {
      InputOutput.<CheckProcess<ProcessId, ProcessAdapter>>println(check);
    }
    return check.hasErrors();
  }
  
  public void letUserKnow(final String title, final String msg) {
    this._workbenchExtension.showInfoDialog(title, msg);
  }
  
  public boolean letUserConfirm(final String title, final String msg) {
    return this._workbenchExtension.showConfirmDialog(title, msg);
  }
  
  public <X extends Object> ArrayList<X> toNewList(final Iterable<X> list) {
    final ArrayList<X> newList = CollectionLiterals.<X>newArrayList();
    if ((list != null)) {
      Iterables.<X>addAll(newList, list);
    }
    return newList;
  }
  
  public void showError(final String message) {
    this._workbenchExtension.showErrorDialog("Operation canceled", message);
  }
}
