/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.profile.build;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import graphmodel.ModelElement;
import info.scce.dime.gUIPlugin.AbstractParameter;
import info.scce.dime.gUIPlugin.Output;
import info.scce.dime.gui.gui.Button;
import info.scce.dime.gui.gui.ComplexAttribute;
import info.scce.dime.gui.gui.ComplexAttributeConnector;
import info.scce.dime.gui.gui.ComplexListAttributeConnector;
import info.scce.dime.gui.gui.ComplexVariable;
import info.scce.dime.gui.gui.DataContext;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.OutputGeneric;
import info.scce.dime.gui.gui.PrimitiveAttribute;
import info.scce.dime.gui.gui.PrimitiveVariable;
import info.scce.dime.gui.gui.Variable;
import info.scce.dime.gui.helper.GUIBranch;
import info.scce.dime.gui.helper.GUIBranchPort;
import info.scce.dime.gui.helper.GUIExtension;
import info.scce.dime.process.helper.PortUtils;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.ComplexOutputPort;
import info.scce.dime.process.process.EndSIB;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.dime.process.process.PrimitiveOutputPort;
import info.scce.dime.profile.api.ProfileExtension;
import info.scce.dime.profile.build.PrimeSIBBuild;
import info.scce.dime.profile.layout.Layouter;
import info.scce.dime.profile.profile.Branch;
import info.scce.dime.profile.profile.GUISIB;
import info.scce.dime.profile.profile.InputPort;
import info.scce.dime.profile.profile.OutputPort;
import info.scce.dime.profile.profile.ReplacementBranch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class GUISIBBuild extends PrimeSIBBuild<GUISIB, InputPort, Variable, Branch, EObject, OutputPort, EObject> {
  @Extension
  protected ProfileExtension _profileExtension = new ProfileExtension();
  
  @Extension
  protected GUIExtension _gUIExtension = new GUIExtension();
  
  @Extension
  protected PortUtils _portUtils = new PortUtils();
  
  @Extension
  private Layouter layouter = Layouter.getInstance();
  
  public static boolean initialize(final GUISIB sib) {
    return new GUISIBBuild(sib).initialize();
  }
  
  public static void update(final GUISIB sib) {
    new GUISIBBuild(sib).update();
  }
  
  public static ArrayList<String> validate(final GUISIB sib) {
    return new GUISIBBuild(sib).validate();
  }
  
  public GUISIBBuild(final GUISIB sib) {
    super(sib);
  }
  
  @Override
  public GUI getSIBReference(final GUISIB sib) {
    GUI _referencedGUI = sib.getReferencedGUI();
    return ((GUI) _referencedGUI);
  }
  
  @Override
  public void layout(final GUISIB sib) {
    this.layouter.layout(sib);
  }
  
  @Override
  public Iterable<InputPort> getSIBPorts(final GUISIB sib) {
    return sib.getInputPorts();
  }
  
  @Override
  public Iterable<Variable> getSIBPortReferences(final GUISIB sib) {
    ArrayList<Variable> _newArrayList = CollectionLiterals.<Variable>newArrayList();
    final Procedure1<ArrayList<Variable>> _function = new Procedure1<ArrayList<Variable>>() {
      @Override
      public void apply(final ArrayList<Variable> it) {
        final Function1<DataContext, EList<Variable>> _function = new Function1<DataContext, EList<Variable>>() {
          @Override
          public EList<Variable> apply(final DataContext it) {
            return it.getVariables();
          }
        };
        final Function1<Variable, Boolean> _function_1 = new Function1<Variable, Boolean>() {
          @Override
          public Boolean apply(final Variable it) {
            return Boolean.valueOf(it.isIsInput());
          }
        };
        final Function1<Variable, Boolean> _function_2 = new Function1<Variable, Boolean>() {
          @Override
          public Boolean apply(final Variable it) {
            return Boolean.valueOf(it.<ComplexAttributeConnector>getIncoming(ComplexAttributeConnector.class).isEmpty());
          }
        };
        final Function1<Variable, Boolean> _function_3 = new Function1<Variable, Boolean>() {
          @Override
          public Boolean apply(final Variable it) {
            return Boolean.valueOf(it.<ComplexListAttributeConnector>getIncoming(ComplexListAttributeConnector.class).isEmpty());
          }
        };
        Iterables.<Variable>addAll(it, 
          IterableExtensions.<Variable>filter(IterableExtensions.<Variable>filter(IterableExtensions.<Variable>filter(Iterables.<Variable>concat(ListExtensions.<DataContext, EList<Variable>>map(GUISIBBuild.this.getSIBReference(sib).getDataContexts(), _function)), _function_1), _function_2), _function_3));
      }
    };
    return ObjectExtensions.<ArrayList<Variable>>operator_doubleArrow(_newArrayList, _function);
  }
  
  @Override
  public boolean isSIBPortReference(final InputPort sibPort, final Variable portRef) {
    EObject _referencedObject = this._profileExtension.getReferencedObject(sibPort);
    return Objects.equal(portRef, _referencedObject);
  }
  
  @Override
  public InputPort addSIBPort(final Variable ref) {
    InputPort _xblockexpression = null;
    {
      InputOutput.<String>println(("Add input for: " + ref));
      InputPort _switchResult = null;
      boolean _matched = false;
      if (ref instanceof PrimitiveVariable) {
        _matched=true;
        int _height = this.sib.getHeight();
        int _minus = (_height - 1);
        _switchResult = this.sib.newPrimitiveVariableReferencingInputPort(ref, 1, _minus);
      }
      if (!_matched) {
        if (ref instanceof ComplexVariable) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = this.sib.newComplexVariableReferencingInputPort(ref, 1, _minus);
        }
      }
      if (!_matched) {
        if (ref instanceof PrimitiveInputPort) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = this.sib.newPrimitiveInputPortReferencingInputPort(ref, 1, _minus);
        }
      }
      if (!_matched) {
        if (ref instanceof ComplexInputPort) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = this.sib.newComplexInputPortReferencingInputPort(ref, 1, _minus);
        }
      }
      if (!_matched) {
        if (ref instanceof PrimitiveOutputPort) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = this.sib.newPrimitiveOutputPortReferencingInputPort(ref, 1, _minus);
        }
      }
      if (!_matched) {
        if (ref instanceof ComplexOutputPort) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = this.sib.newComplexOutputPortReferencingInputPort(ref, 1, _minus);
        }
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
  
  @Override
  public Iterable<Branch> getBranches(final GUISIB sib) {
    return sib.getBranchs();
  }
  
  private Collection<GUIBranch> _branchElements;
  
  public Collection<GUIBranch> getBranchElements(final GUISIB sib) {
    Collection<GUIBranch> _elvis = null;
    if (this._branchElements != null) {
      _elvis = this._branchElements;
    } else {
      _elvis = (this._branchElements = this._gUIExtension.getGUIBranches(this.getSIBReference(sib), true));
    }
    return _elvis;
  }
  
  @Override
  public Iterable<EObject> getBranchReferences(final GUISIB sib) {
    final Function1<GUIBranch, EObject> _function = new Function1<GUIBranch, EObject>() {
      @Override
      public EObject apply(final GUIBranch it) {
        return it.getElement();
      }
    };
    return IterableExtensions.<GUIBranch, EObject>map(this.getBranchElements(sib), _function);
  }
  
  @Override
  public boolean isBranchReference(final Branch branch, final EObject ref) {
    boolean _xblockexpression = false;
    {
      InputOutput.<String>println(("Is BranchRef? " + ref));
      EObject _referencedObject = this._profileExtension.getReferencedObject(branch);
      _xblockexpression = Objects.equal(ref, _referencedObject);
    }
    return _xblockexpression;
  }
  
  @Override
  public Branch addBranch(final EObject ref) {
    ReplacementBranch _xblockexpression = null;
    {
      InputOutput.<String>println(("BranchRef: " + ref));
      ReplacementBranch _switchResult = null;
      boolean _matched = false;
      if (ref instanceof info.scce.dime.gui.gui.Branch) {
        _matched=true;
        int _height = this.sib.getHeight();
        int _minus = (_height - 1);
        _switchResult = this.sib.newBranchReferencingBranch(ref, 1, _minus);
      }
      if (!_matched) {
        if (ref instanceof Button) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = this.sib.newButtonReferencingBranch(ref, 1, _minus);
        }
      }
      if (!_matched) {
        if (ref instanceof EndSIB) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = this.sib.newEndSIBReferencingBranch(ref, 1, _minus);
        }
      }
      if (!_matched) {
        if (ref instanceof Output) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = this.sib.newOutputReferencingBranch(ref, 1, _minus);
        }
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
  
  @Override
  public void layout(final Branch branch) {
    this.layouter.layout(branch);
  }
  
  @Override
  public Iterable<OutputPort> getBranchPorts(final Branch branch) {
    EList<OutputPort> _xblockexpression = null;
    {
      InputOutput.<String>println(("getBranchPorts: " + branch));
      _xblockexpression = branch.getOutputPorts();
    }
    return _xblockexpression;
  }
  
  @Override
  public Iterable<EObject> getBranchPortReferences(final EObject branchRef) {
    final Function1<GUIBranch, Boolean> _function = new Function1<GUIBranch, Boolean>() {
      @Override
      public Boolean apply(final GUIBranch it) {
        ModelElement _element = it.getElement();
        return Boolean.valueOf(Objects.equal(_element, branchRef));
      }
    };
    final Function1<GUIBranch, List<GUIBranchPort>> _function_1 = new Function1<GUIBranch, List<GUIBranchPort>>() {
      @Override
      public List<GUIBranchPort> apply(final GUIBranch it) {
        return GUISIBBuild.this._gUIExtension.notEquallyNamedPorts(it.getPorts());
      }
    };
    final Function1<GUIBranchPort, EObject> _function_2 = new Function1<GUIBranchPort, EObject>() {
      @Override
      public EObject apply(final GUIBranchPort it) {
        return it.getPortNode();
      }
    };
    return IterableExtensions.<GUIBranchPort, EObject>map(IterableExtensions.<GUIBranch, GUIBranchPort>flatMap(IterableExtensions.<GUIBranch>filter(this.getBranchElements(this.sib), _function), _function_1), _function_2);
  }
  
  @Override
  public boolean isBranchPortReference(final OutputPort port, final EObject ref) {
    boolean _xblockexpression = false;
    {
      InputOutput.<String>println(("Is BranchRef? " + ref));
      EObject _referencedObject = this._profileExtension.getReferencedObject(port);
      _xblockexpression = Objects.equal(ref, _referencedObject);
    }
    return _xblockexpression;
  }
  
  @Override
  public OutputPort addBranchPort(final Branch branch, final EObject ref) {
    OutputPort _xblockexpression = null;
    {
      InputOutput.<String>println(("Add output for: " + ref));
      OutputPort _switchResult = null;
      boolean _matched = false;
      if (ref instanceof AbstractParameter) {
        _matched=true;
        int _height = this.sib.getHeight();
        int _minus = (_height - 1);
        _switchResult = branch.newAbstractParameterReferencingOutputPort(ref, 1, _minus);
      }
      if (!_matched) {
        if (ref instanceof PrimitiveAttribute) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = branch.newPrimitiveAttributeReferencingOutputPort(ref, 1, _minus);
        }
      }
      if (!_matched) {
        if (ref instanceof ComplexAttribute) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = branch.newComplexAttributeReferencingOutputPort(ref, 1, _minus);
        }
      }
      if (!_matched) {
        if (ref instanceof info.scce.dime.gui.gui.PrimitiveInputPort) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = branch.newGUIPrimitiveInputPortReferencingOutputPort(ref, 1, _minus);
        }
      }
      if (!_matched) {
        if (ref instanceof info.scce.dime.gui.gui.ComplexInputPort) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = branch.newGUIComplexInputPortReferencingOutputPort(ref, 1, _minus);
        }
      }
      if (!_matched) {
        if (ref instanceof info.scce.dime.gui.gui.PrimitiveOutputPort) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = branch.newGUIPrimitiveOutputPortReferencingOutputPort(ref, 1, _minus);
        }
      }
      if (!_matched) {
        if (ref instanceof info.scce.dime.gui.gui.ComplexOutputPort) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = branch.newGUIComplexOutputPortReferencingOutputPort(ref, 1, _minus);
        }
      }
      if (!_matched) {
        if (ref instanceof OutputGeneric) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = branch.newOutputGenericReferencingOutputPort(ref, 1, _minus);
        }
      }
      if (!_matched) {
        if (ref instanceof PrimitiveVariable) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = branch.newPrimitiveVariableReferencingOutputPort(ref, 1, _minus);
        }
      }
      if (!_matched) {
        if (ref instanceof ComplexVariable) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = branch.newComplexVariableReferencingOutputPort(ref, 1, _minus);
        }
      }
      if (!_matched) {
        if (ref instanceof PrimitiveInputPort) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = branch.newPrimitiveInputPortReferencingOutputPort(ref, 1, _minus);
        }
      }
      if (!_matched) {
        if (ref instanceof ComplexInputPort) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = branch.newComplexInputPortReferencingOutputPort(ref, 1, _minus);
        }
      }
      if (!_matched) {
        if (ref instanceof PrimitiveOutputPort) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = branch.newPrimitiveOutputPortReferencingOutputPort(ref, 1, _minus);
        }
      }
      if (!_matched) {
        if (ref instanceof ComplexOutputPort) {
          _matched=true;
          int _height = this.sib.getHeight();
          int _minus = (_height - 1);
          _switchResult = branch.newComplexOutputPortReferencingOutputPort(ref, 1, _minus);
        }
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
}
