/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.profile.appearance;

import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.appearance.StyleAppearanceProvider;
import graphmodel.Edge;
import graphmodel.Node;
import info.scce.dime.profile.api.ProfileRuntimeBaseClass;
import info.scce.dime.profile.profile.BlueprintSIB;
import info.scce.dime.profile.profile.SIBReplacement;
import info.scce.dime.profile.util.ReplacementStrategy;
import java.util.ArrayList;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import style.Appearance;
import style.StyleFactory;

@SuppressWarnings("all")
public class SIBReplacementAppearance<T extends Edge> extends ProfileRuntimeBaseClass implements StyleAppearanceProvider<T> {
  private static final StyleFactory factory = StyleFactory.eINSTANCE;
  
  private static final Appearance thickLineAppearance = ObjectExtensions.<Appearance>operator_doubleArrow(SIBReplacementAppearance.factory.createAppearance(), new Procedure1<Appearance>() {
    @Override
    public void apply(final Appearance it) {
      it.setLineWidth(3);
    }
  });
  
  @Extension
  private ReplacementStrategy _replacementStrategy = new ReplacementStrategy();
  
  @Override
  public Appearance getAppearance(final T edge, final String shapeId) {
    Object _xblockexpression = null;
    {
      final Node targetNode = edge.getTargetElement();
      final BlueprintSIB blueprintSIB = IterableExtensions.<BlueprintSIB>head(Iterables.<BlueprintSIB>filter(this._graphModelExtension.findPredecessorsVia(targetNode, SIBReplacement.class), BlueprintSIB.class));
      Object _xifexpression = null;
      if ((blueprintSIB != null)) {
        final ArrayList<Node> replacementPath = this._replacementStrategy.getReplacementPath(blueprintSIB);
        final Function1<Node, Boolean> _function = new Function1<Node, Boolean>() {
          @Override
          public Boolean apply(final Node it) {
            boolean _hasInvalidPrimeReference = SIBReplacementAppearance.this._profileExtension.hasInvalidPrimeReference(it);
            return Boolean.valueOf((!_hasInvalidPrimeReference));
          }
        };
        boolean _exists = IterableExtensions.<Node>exists(replacementPath, _function);
        boolean _not = (!_exists);
        if (_not) {
          return null;
        }
        for (final Node node : replacementPath) {
          {
            boolean _equals = this._graphModelExtension.operator_equals(node, targetNode);
            if (_equals) {
              return SIBReplacementAppearance.thickLineAppearance;
            }
            boolean _hasInvalidPrimeReference = this._profileExtension.hasInvalidPrimeReference(node);
            boolean _not_1 = (!_hasInvalidPrimeReference);
            if (_not_1) {
              return null;
            }
          }
        }
      }
      _xblockexpression = _xifexpression;
    }
    return ((Appearance)_xblockexpression);
  }
}
