/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.profile.appearance;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.appearance.StyleAppearanceProvider;
import graphmodel.Node;
import info.scce.dime.profile.api.ProfileRuntimeBaseClass;
import info.scce.dime.profile.util.PrimeNameCacher;
import java.util.HashMap;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import style.Appearance;
import style.Color;
import style.LineStyle;
import style.StyleFactory;

@SuppressWarnings("all")
public class SIBAppearance<T extends Node> extends ProfileRuntimeBaseClass implements StyleAppearanceProvider<T> {
  @Extension
  private PrimeNameCacher _primeNameCacher = new PrimeNameCacher();
  
  private static final StyleFactory factory = StyleFactory.eINSTANCE;
  
  private static final HashMap<Node, Appearance> appearances = CollectionLiterals.<Node, Appearance>newHashMap();
  
  @Override
  public Appearance getAppearance(final T node, final String shapeId) {
    boolean _equals = Objects.equal(shapeId, "rootShape");
    if (_equals) {
      final boolean isValid = this._primeNameCacher.cacheNames(node);
      if (isValid) {
      } else {
        boolean _hasInvalidPrimeReference = this._profileExtension.hasInvalidPrimeReference(node.getContainer());
        boolean _not = (!_hasInvalidPrimeReference);
        if (_not) {
          Appearance _createAppearance = SIBAppearance.factory.createAppearance();
          final Procedure1<Appearance> _function = new Procedure1<Appearance>() {
            @Override
            public void apply(final Appearance it) {
              Color _createColor = SIBAppearance.factory.createColor();
              final Procedure1<Color> _function = new Procedure1<Color>() {
                @Override
                public void apply(final Color it) {
                  it.setR(255);
                }
              };
              Color _doubleArrow = ObjectExtensions.<Color>operator_doubleArrow(_createColor, _function);
              it.setForeground(_doubleArrow);
              it.setLineStyle(LineStyle.DASH);
            }
          };
          Appearance _doubleArrow = ObjectExtensions.<Appearance>operator_doubleArrow(_createAppearance, _function);
          SIBAppearance.appearances.put(node, _doubleArrow);
        } else {
          SIBAppearance.appearances.remove(node);
        }
      }
    }
    return SIBAppearance.appearances.get(node);
  }
}
