/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.profile.api;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.runtime.CincoRuntimeBaseClass;
import graphmodel.Container;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElementContainer;
import info.scce.dime.data.data.Type;
import info.scce.dime.data.helper.DataExtension;
import info.scce.dime.gUIPlugin.AbstractParameter;
import info.scce.dime.gUIPlugin.ComplexParameter;
import info.scce.dime.gUIPlugin.GenericParameter;
import info.scce.dime.gUIPlugin.PrimitiveParameter;
import info.scce.dime.gui.gui.Attribute;
import info.scce.dime.gui.gui.ComplexAttribute;
import info.scce.dime.gui.gui.ComplexVariable;
import info.scce.dime.gui.gui.OutputGeneric;
import info.scce.dime.gui.gui.PrimitiveAttribute;
import info.scce.dime.gui.gui.PrimitiveVariable;
import info.scce.dime.gui.gui.Variable;
import info.scce.dime.gui.helper.GUIBranchPort;
import info.scce.dime.gui.helper.GUIExtension;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.ComplexOutputPort;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.dime.process.process.PrimitiveOutputPort;
import info.scce.dime.process.process.PrimitiveType;
import info.scce.dime.profile.build.GUIBlueprintSIBBuild;
import info.scce.dime.profile.build.GUISIBBuild;
import info.scce.dime.profile.build.PrimeSIBBuild;
import info.scce.dime.profile.build.ProcessBlueprintSIBBuild;
import info.scce.dime.profile.build.ProcessSIBBuild;
import info.scce.dime.profile.profile.AbstractParameterReferencingOutputPort;
import info.scce.dime.profile.profile.AddToSubmissionReferencingOutputPort;
import info.scce.dime.profile.profile.BlueprintBranch;
import info.scce.dime.profile.profile.BlueprintSIB;
import info.scce.dime.profile.profile.Branch;
import info.scce.dime.profile.profile.BranchReferencingBranch;
import info.scce.dime.profile.profile.ButtonReferencingBranch;
import info.scce.dime.profile.profile.ComplexAttributeReferencingOutputPort;
import info.scce.dime.profile.profile.ComplexInputPortReferencingInputPort;
import info.scce.dime.profile.profile.ComplexInputPortReferencingOutputPort;
import info.scce.dime.profile.profile.ComplexOutputPortReferencingInputPort;
import info.scce.dime.profile.profile.ComplexOutputPortReferencingOutputPort;
import info.scce.dime.profile.profile.ComplexVariableReferencingInputPort;
import info.scce.dime.profile.profile.ComplexVariableReferencingOutputPort;
import info.scce.dime.profile.profile.EndSIBReferencingBranch;
import info.scce.dime.profile.profile.GUIBlueprintSIB;
import info.scce.dime.profile.profile.GUIComplexInputPortReferencingOutputPort;
import info.scce.dime.profile.profile.GUIComplexOutputPortReferencingOutputPort;
import info.scce.dime.profile.profile.GUIPrimitiveInputPortReferencingOutputPort;
import info.scce.dime.profile.profile.GUIPrimitiveOutputPortReferencingOutputPort;
import info.scce.dime.profile.profile.GUISIB;
import info.scce.dime.profile.profile.IO;
import info.scce.dime.profile.profile.InputPort;
import info.scce.dime.profile.profile.InputPortMapping;
import info.scce.dime.profile.profile.OutputGenericReferencingOutputPort;
import info.scce.dime.profile.profile.OutputPort;
import info.scce.dime.profile.profile.OutputPortMapping;
import info.scce.dime.profile.profile.OutputReferencingBranch;
import info.scce.dime.profile.profile.PrimitiveAttributeReferencingOutputPort;
import info.scce.dime.profile.profile.PrimitiveInputPortReferencingInputPort;
import info.scce.dime.profile.profile.PrimitiveInputPortReferencingOutputPort;
import info.scce.dime.profile.profile.PrimitiveOutputPortReferencingInputPort;
import info.scce.dime.profile.profile.PrimitiveOutputPortReferencingOutputPort;
import info.scce.dime.profile.profile.PrimitiveVariableReferencingInputPort;
import info.scce.dime.profile.profile.PrimitiveVariableReferencingOutputPort;
import info.scce.dime.profile.profile.ProcessBlueprintSIB;
import info.scce.dime.profile.profile.ProcessSIB;
import info.scce.dime.profile.profile.ReplacementSIB;
import info.scce.dime.profile.profile.SIB;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class ProfileExtension extends CincoRuntimeBaseClass {
  @Extension
  private DataExtension _dataExtension = DataExtension.getInstance();
  
  @Extension
  private GUIExtension _gUIExtension = new GUIExtension();
  
  public String getName(final SIB it) {
    String _switchResult = null;
    boolean _matched = false;
    if (it instanceof BlueprintSIB) {
      _matched=true;
      _switchResult = ((BlueprintSIB)it).getCachedReferencedBlueprintSIBLabel();
    }
    if (!_matched) {
      if (it instanceof ReplacementSIB) {
        _matched=true;
        _switchResult = ((ReplacementSIB)it).getCachedReferencedObjectName();
      }
    }
    return _switchResult;
  }
  
  public PrimeSIBBuild<? extends SIB, InputPort, ? extends Container, ? extends Branch, ? extends EObject, ? extends OutputPort, ? extends EObject> getCompound(final SIB sib) {
    PrimeSIBBuild<? extends SIB, InputPort, ? extends Container, ? extends Branch, ? extends EObject, ? extends OutputPort, ? extends EObject> _switchResult = null;
    boolean _matched = false;
    if (sib instanceof ProcessSIB) {
      _matched=true;
      _switchResult = new ProcessSIBBuild(((ProcessSIB)sib));
    }
    if (!_matched) {
      if (sib instanceof ProcessBlueprintSIB) {
        _matched=true;
        _switchResult = new ProcessBlueprintSIBBuild(((ProcessBlueprintSIB)sib));
      }
    }
    if (!_matched) {
      if (sib instanceof GUISIB) {
        _matched=true;
        _switchResult = new GUISIBBuild(((GUISIB)sib));
      }
    }
    if (!_matched) {
      if (sib instanceof GUIBlueprintSIB) {
        _matched=true;
        _switchResult = new GUIBlueprintSIBBuild(((GUIBlueprintSIB)sib));
      }
    }
    return _switchResult;
  }
  
  public String getName(final Branch it) {
    return it.getCachedReferencedObjectName();
  }
  
  public SIB getSib(final Branch it) {
    return this._gUIExtension.<SIB>findFirstParent(it, SIB.class);
  }
  
  public String getName(final IO it) {
    return it.getCachedReferencedObjectName();
  }
  
  public Object getDataType(final IO it) {
    Object _switchResult = null;
    boolean _matched = false;
    if (it instanceof PrimitiveInputPortReferencingInputPort) {
      _matched=true;
      info.scce.dime.process.process.InputPort _referencedPrimitiveInputPort = ((PrimitiveInputPortReferencingInputPort)it).getReferencedPrimitiveInputPort();
      PrimitiveType _dataType = null;
      if (((PrimitiveInputPort) _referencedPrimitiveInputPort)!=null) {
        _dataType=((PrimitiveInputPort) _referencedPrimitiveInputPort).getDataType();
      }
      _switchResult = _dataType;
    }
    if (!_matched) {
      if (it instanceof ComplexInputPortReferencingInputPort) {
        _matched=true;
        info.scce.dime.process.process.InputPort _referencedComplexInputPort = ((ComplexInputPortReferencingInputPort)it).getReferencedComplexInputPort();
        Type _dataType = null;
        if (((ComplexInputPort) _referencedComplexInputPort)!=null) {
          _dataType=((ComplexInputPort) _referencedComplexInputPort).getDataType();
        }
        _switchResult = _dataType;
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveOutputPortReferencingInputPort) {
        _matched=true;
        info.scce.dime.process.process.OutputPort _referencedPrimitiveOutputPort = ((PrimitiveOutputPortReferencingInputPort)it).getReferencedPrimitiveOutputPort();
        PrimitiveType _dataType = null;
        if (((PrimitiveOutputPort) _referencedPrimitiveOutputPort)!=null) {
          _dataType=((PrimitiveOutputPort) _referencedPrimitiveOutputPort).getDataType();
        }
        _switchResult = _dataType;
      }
    }
    if (!_matched) {
      if (it instanceof ComplexOutputPortReferencingInputPort) {
        _matched=true;
        info.scce.dime.process.process.OutputPort _referencedComplexOutputPort = ((ComplexOutputPortReferencingInputPort)it).getReferencedComplexOutputPort();
        Type _dataType = null;
        if (((ComplexOutputPort) _referencedComplexOutputPort)!=null) {
          _dataType=((ComplexOutputPort) _referencedComplexOutputPort).getDataType();
        }
        _switchResult = _dataType;
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveOutputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.process.process.OutputPort _referencedPrimitiveOutputPort = ((PrimitiveOutputPortReferencingOutputPort)it).getReferencedPrimitiveOutputPort();
        PrimitiveType _dataType = null;
        if (((PrimitiveOutputPort) _referencedPrimitiveOutputPort)!=null) {
          _dataType=((PrimitiveOutputPort) _referencedPrimitiveOutputPort).getDataType();
        }
        _switchResult = _dataType;
      }
    }
    if (!_matched) {
      if (it instanceof ComplexOutputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.process.process.OutputPort _referencedComplexOutputPort = ((ComplexOutputPortReferencingOutputPort)it).getReferencedComplexOutputPort();
        Type _dataType = null;
        if (((ComplexOutputPort) _referencedComplexOutputPort)!=null) {
          _dataType=((ComplexOutputPort) _referencedComplexOutputPort).getDataType();
        }
        _switchResult = _dataType;
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveInputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.process.process.InputPort _referencedPrimitiveInputPort = ((PrimitiveInputPortReferencingOutputPort)it).getReferencedPrimitiveInputPort();
        PrimitiveType _dataType = null;
        if (((PrimitiveInputPort) _referencedPrimitiveInputPort)!=null) {
          _dataType=((PrimitiveInputPort) _referencedPrimitiveInputPort).getDataType();
        }
        _switchResult = _dataType;
      }
    }
    if (!_matched) {
      if (it instanceof ComplexInputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.process.process.InputPort _referencedComplexInputPort = ((ComplexInputPortReferencingOutputPort)it).getReferencedComplexInputPort();
        Type _dataType = null;
        if (((ComplexInputPort) _referencedComplexInputPort)!=null) {
          _dataType=((ComplexInputPort) _referencedComplexInputPort).getDataType();
        }
        _switchResult = _dataType;
      }
    }
    return _switchResult;
  }
  
  public boolean isTypeOf(final IO port, final IO other) {
    boolean _switchResult = false;
    Object _dataType = this.getDataType(port);
    final Object dataType = _dataType;
    boolean _matched = false;
    if (dataType instanceof PrimitiveType) {
      _matched=true;
      Object _dataType_1 = null;
      if (other!=null) {
        _dataType_1=this.getDataType(other);
      }
      _switchResult = Objects.equal(dataType, _dataType_1);
    }
    if (!_matched) {
      if (dataType instanceof Type) {
        _matched=true;
        boolean _switchResult_1 = false;
        Object _dataType_1 = null;
        if (other!=null) {
          _dataType_1=this.getDataType(other);
        }
        final Object otherType = _dataType_1;
        boolean _matched_1 = false;
        if (otherType instanceof Type) {
          _matched_1=true;
          _switchResult_1 = this._dataExtension.isTypeOf(((Type)dataType), ((Type)otherType));
        }
        if (!_matched_1) {
          _switchResult_1 = false;
        }
        _switchResult = _switchResult_1;
      }
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }
  
  public SIB getSib(final InputPort it) {
    return this._gUIExtension.<SIB>findFirstParent(it, SIB.class);
  }
  
  public List<InputPort> getTargetedPorts(final InputPort it) {
    EList<InputPortMapping> _outgoing = it.<InputPortMapping>getOutgoing(InputPortMapping.class);
    List<InputPort> _map = null;
    if (_outgoing!=null) {
      final Function1<InputPortMapping, InputPort> _function = new Function1<InputPortMapping, InputPort>() {
        @Override
        public InputPort apply(final InputPortMapping it) {
          return it.getTargetElement();
        }
      };
      _map=ListExtensions.<InputPortMapping, InputPort>map(_outgoing, _function);
    }
    return _map;
  }
  
  public Branch getBranch(final OutputPort it) {
    return this._gUIExtension.<Branch>findFirstParent(it, Branch.class);
  }
  
  public List<OutputPort> getTargetedPorts(final OutputPort it) {
    EList<OutputPortMapping> _outgoing = it.<OutputPortMapping>getOutgoing(OutputPortMapping.class);
    List<OutputPort> _map = null;
    if (_outgoing!=null) {
      final Function1<OutputPortMapping, OutputPort> _function = new Function1<OutputPortMapping, OutputPort>() {
        @Override
        public OutputPort apply(final OutputPortMapping it) {
          return it.getTargetElement();
        }
      };
      _map=ListExtensions.<OutputPortMapping, OutputPort>map(_outgoing, _function);
    }
    return _map;
  }
  
  public ModelElementContainer getReferencedObject(final SIB it) {
    ModelElementContainer _switchResult = null;
    boolean _matched = false;
    if (it instanceof ProcessSIB) {
      _matched=true;
      _switchResult = ((ProcessSIB)it).getReferencedProcess();
    }
    if (!_matched) {
      if (it instanceof GUISIB) {
        _matched=true;
        _switchResult = ((GUISIB)it).getReferencedGUI();
      }
    }
    if (!_matched) {
      if (it instanceof ProcessBlueprintSIB) {
        _matched=true;
        _switchResult = ((ProcessBlueprintSIB)it).getReferencedProcessBlueprintSIB();
      }
    }
    if (!_matched) {
      if (it instanceof GUIBlueprintSIB) {
        _matched=true;
        _switchResult = ((GUIBlueprintSIB)it).getReferencedGUIBlueprintSIB();
      }
    }
    return _switchResult;
  }
  
  public EObject getReferencedObject(final Branch it) {
    EObject _switchResult = null;
    boolean _matched = false;
    if (it instanceof BlueprintBranch) {
      _matched=true;
      _switchResult = ((BlueprintBranch)it).getReferencedBranch();
    }
    if (!_matched) {
      if (it instanceof BranchReferencingBranch) {
        _matched=true;
        _switchResult = ((BranchReferencingBranch)it).getReferencedBranch();
      }
    }
    if (!_matched) {
      if (it instanceof ButtonReferencingBranch) {
        _matched=true;
        _switchResult = ((ButtonReferencingBranch)it).getReferencedButton();
      }
    }
    if (!_matched) {
      if (it instanceof EndSIBReferencingBranch) {
        _matched=true;
        _switchResult = ((EndSIBReferencingBranch)it).getReferencedEndSIB();
      }
    }
    if (!_matched) {
      if (it instanceof OutputReferencingBranch) {
        _matched=true;
        _switchResult = ((OutputReferencingBranch)it).getReferencedOutput();
      }
    }
    return _switchResult;
  }
  
  public EObject getReferencedObject(final IO it) {
    EObject _switchResult = null;
    boolean _matched = false;
    if (it instanceof PrimitiveVariableReferencingInputPort) {
      _matched=true;
      _switchResult = ((PrimitiveVariableReferencingInputPort)it).getReferencedPrimitiveVariable();
    }
    if (!_matched) {
      if (it instanceof ComplexVariableReferencingInputPort) {
        _matched=true;
        _switchResult = ((ComplexVariableReferencingInputPort)it).getReferencedComplexVariable();
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveInputPortReferencingInputPort) {
        _matched=true;
        _switchResult = ((PrimitiveInputPortReferencingInputPort)it).getReferencedPrimitiveInputPort();
      }
    }
    if (!_matched) {
      if (it instanceof ComplexInputPortReferencingInputPort) {
        _matched=true;
        _switchResult = ((ComplexInputPortReferencingInputPort)it).getReferencedComplexInputPort();
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveOutputPortReferencingInputPort) {
        _matched=true;
        _switchResult = ((PrimitiveOutputPortReferencingInputPort)it).getReferencedPrimitiveOutputPort();
      }
    }
    if (!_matched) {
      if (it instanceof ComplexOutputPortReferencingInputPort) {
        _matched=true;
        _switchResult = ((ComplexOutputPortReferencingInputPort)it).getReferencedComplexOutputPort();
      }
    }
    if (!_matched) {
      if (it instanceof AbstractParameterReferencingOutputPort) {
        _matched=true;
        _switchResult = ((AbstractParameterReferencingOutputPort)it).getReferencedAbstractParameter();
      }
    }
    if (!_matched) {
      if (it instanceof AddToSubmissionReferencingOutputPort) {
        _matched=true;
        _switchResult = ((AddToSubmissionReferencingOutputPort)it).getReferencedAddToSubmission();
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveAttributeReferencingOutputPort) {
        _matched=true;
        _switchResult = ((PrimitiveAttributeReferencingOutputPort)it).getReferencedPrimitiveAttribute();
      }
    }
    if (!_matched) {
      if (it instanceof ComplexAttributeReferencingOutputPort) {
        _matched=true;
        _switchResult = ((ComplexAttributeReferencingOutputPort)it).getReferencedComplexAttribute();
      }
    }
    if (!_matched) {
      if (it instanceof GUIPrimitiveInputPortReferencingOutputPort) {
        _matched=true;
        _switchResult = ((GUIPrimitiveInputPortReferencingOutputPort)it).getReferencedPrimitiveInputPort();
      }
    }
    if (!_matched) {
      if (it instanceof GUIComplexInputPortReferencingOutputPort) {
        _matched=true;
        _switchResult = ((GUIComplexInputPortReferencingOutputPort)it).getReferencedComplexInputPort();
      }
    }
    if (!_matched) {
      if (it instanceof GUIPrimitiveOutputPortReferencingOutputPort) {
        _matched=true;
        _switchResult = ((GUIPrimitiveOutputPortReferencingOutputPort)it).getReferencedPrimitiveOutputPort();
      }
    }
    if (!_matched) {
      if (it instanceof GUIComplexOutputPortReferencingOutputPort) {
        _matched=true;
        _switchResult = ((GUIComplexOutputPortReferencingOutputPort)it).getReferencedComplexOutputPort();
      }
    }
    if (!_matched) {
      if (it instanceof OutputGenericReferencingOutputPort) {
        _matched=true;
        _switchResult = ((OutputGenericReferencingOutputPort)it).getReferencedOutputGeneric();
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveVariableReferencingOutputPort) {
        _matched=true;
        _switchResult = ((PrimitiveVariableReferencingOutputPort)it).getReferencedPrimitiveVariable();
      }
    }
    if (!_matched) {
      if (it instanceof ComplexVariableReferencingOutputPort) {
        _matched=true;
        _switchResult = ((ComplexVariableReferencingOutputPort)it).getReferencedComplexVariable();
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveInputPortReferencingOutputPort) {
        _matched=true;
        _switchResult = ((PrimitiveInputPortReferencingOutputPort)it).getReferencedPrimitiveInputPort();
      }
    }
    if (!_matched) {
      if (it instanceof ComplexInputPortReferencingOutputPort) {
        _matched=true;
        _switchResult = ((ComplexInputPortReferencingOutputPort)it).getReferencedComplexInputPort();
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveOutputPortReferencingOutputPort) {
        _matched=true;
        _switchResult = ((PrimitiveOutputPortReferencingOutputPort)it).getReferencedPrimitiveOutputPort();
      }
    }
    if (!_matched) {
      if (it instanceof ComplexOutputPortReferencingOutputPort) {
        _matched=true;
        _switchResult = ((ComplexOutputPortReferencingOutputPort)it).getReferencedComplexOutputPort();
      }
    }
    return _switchResult;
  }
  
  public boolean isReferencedObjectList(final IO it) {
    boolean _switchResult = false;
    boolean _matched = false;
    if (it instanceof PrimitiveVariableReferencingInputPort) {
      _matched=true;
      Variable _referencedPrimitiveVariable = ((PrimitiveVariableReferencingInputPort)it).getReferencedPrimitiveVariable();
      boolean _isIsList = false;
      if (((Variable) _referencedPrimitiveVariable)!=null) {
        _isIsList=((Variable) _referencedPrimitiveVariable).isIsList();
      }
      _switchResult = _isIsList;
    }
    if (!_matched) {
      if (it instanceof ComplexVariableReferencingInputPort) {
        _matched=true;
        Variable _referencedComplexVariable = ((ComplexVariableReferencingInputPort)it).getReferencedComplexVariable();
        boolean _isIsList = false;
        if (((Variable) _referencedComplexVariable)!=null) {
          _isIsList=((Variable) _referencedComplexVariable).isIsList();
        }
        _switchResult = _isIsList;
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveInputPortReferencingInputPort) {
        _matched=true;
        info.scce.dime.process.process.InputPort _referencedPrimitiveInputPort = ((PrimitiveInputPortReferencingInputPort)it).getReferencedPrimitiveInputPort();
        _switchResult = this.isList(((info.scce.dime.process.process.IO) _referencedPrimitiveInputPort));
      }
    }
    if (!_matched) {
      if (it instanceof ComplexInputPortReferencingInputPort) {
        _matched=true;
        info.scce.dime.process.process.InputPort _referencedComplexInputPort = ((ComplexInputPortReferencingInputPort)it).getReferencedComplexInputPort();
        _switchResult = this.isList(((info.scce.dime.process.process.IO) _referencedComplexInputPort));
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveOutputPortReferencingInputPort) {
        _matched=true;
        info.scce.dime.process.process.OutputPort _referencedPrimitiveOutputPort = ((PrimitiveOutputPortReferencingInputPort)it).getReferencedPrimitiveOutputPort();
        _switchResult = this.isList(((info.scce.dime.process.process.IO) _referencedPrimitiveOutputPort));
      }
    }
    if (!_matched) {
      if (it instanceof ComplexOutputPortReferencingInputPort) {
        _matched=true;
        info.scce.dime.process.process.OutputPort _referencedComplexOutputPort = ((ComplexOutputPortReferencingInputPort)it).getReferencedComplexOutputPort();
        _switchResult = this.isList(((info.scce.dime.process.process.IO) _referencedComplexOutputPort));
      }
    }
    if (!_matched) {
      if (it instanceof AbstractParameterReferencingOutputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.isList(((AbstractParameterReferencingOutputPort)it).getReferencedAbstractParameter());
      }
    }
    if (!_matched) {
      if (it instanceof AddToSubmissionReferencingOutputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.isList(((AddToSubmissionReferencingOutputPort)it).getReferencedAddToSubmission());
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveAttributeReferencingOutputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.isList(((PrimitiveAttributeReferencingOutputPort)it).getReferencedPrimitiveAttribute());
      }
    }
    if (!_matched) {
      if (it instanceof ComplexAttributeReferencingOutputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.isList(((ComplexAttributeReferencingOutputPort)it).getReferencedComplexAttribute());
      }
    }
    if (!_matched) {
      if (it instanceof GUIPrimitiveInputPortReferencingOutputPort) {
        _matched=true;
        _switchResult = ((GUIPrimitiveInputPortReferencingOutputPort)it).getReferencedPrimitiveInputPort().isIsList();
      }
    }
    if (!_matched) {
      if (it instanceof GUIComplexInputPortReferencingOutputPort) {
        _matched=true;
        _switchResult = ((GUIComplexInputPortReferencingOutputPort)it).getReferencedComplexInputPort().isIsList();
      }
    }
    if (!_matched) {
      if (it instanceof GUIPrimitiveOutputPortReferencingOutputPort) {
        _matched=true;
        _switchResult = ((GUIPrimitiveOutputPortReferencingOutputPort)it).getReferencedPrimitiveOutputPort().isIsList();
      }
    }
    if (!_matched) {
      if (it instanceof GUIComplexOutputPortReferencingOutputPort) {
        _matched=true;
        _switchResult = ((GUIComplexOutputPortReferencingOutputPort)it).getReferencedComplexOutputPort().isIsList();
      }
    }
    if (!_matched) {
      if (it instanceof OutputGenericReferencingOutputPort) {
        _matched=true;
        _switchResult = ((OutputGenericReferencingOutputPort)it).getReferencedOutputGeneric().isIsList();
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveVariableReferencingOutputPort) {
        _matched=true;
        _switchResult = ((PrimitiveVariableReferencingOutputPort)it).getReferencedPrimitiveVariable().isIsList();
      }
    }
    if (!_matched) {
      if (it instanceof ComplexVariableReferencingOutputPort) {
        _matched=true;
        _switchResult = ((ComplexVariableReferencingOutputPort)it).getReferencedComplexVariable().isIsList();
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveInputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.process.process.InputPort _referencedPrimitiveInputPort = ((PrimitiveInputPortReferencingOutputPort)it).getReferencedPrimitiveInputPort();
        _switchResult = this.isList(((info.scce.dime.process.process.IO) _referencedPrimitiveInputPort));
      }
    }
    if (!_matched) {
      if (it instanceof ComplexInputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.process.process.InputPort _referencedComplexInputPort = ((ComplexInputPortReferencingOutputPort)it).getReferencedComplexInputPort();
        _switchResult = this.isList(((info.scce.dime.process.process.IO) _referencedComplexInputPort));
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveOutputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.process.process.OutputPort _referencedPrimitiveOutputPort = ((PrimitiveOutputPortReferencingOutputPort)it).getReferencedPrimitiveOutputPort();
        _switchResult = this.isList(((info.scce.dime.process.process.IO) _referencedPrimitiveOutputPort));
      }
    }
    if (!_matched) {
      if (it instanceof ComplexOutputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.process.process.OutputPort _referencedComplexOutputPort = ((ComplexOutputPortReferencingOutputPort)it).getReferencedComplexOutputPort();
        _switchResult = this.isList(((info.scce.dime.process.process.IO) _referencedComplexOutputPort));
      }
    }
    return _switchResult;
  }
  
  public String getReferencedObjectName(final IO it) {
    String _switchResult = null;
    boolean _matched = false;
    if (it instanceof PrimitiveVariableReferencingInputPort) {
      _matched=true;
      Variable _referencedPrimitiveVariable = ((PrimitiveVariableReferencingInputPort)it).getReferencedPrimitiveVariable();
      String _name = null;
      if (((Variable) _referencedPrimitiveVariable)!=null) {
        _name=((Variable) _referencedPrimitiveVariable).getName();
      }
      _switchResult = _name;
    }
    if (!_matched) {
      if (it instanceof ComplexVariableReferencingInputPort) {
        _matched=true;
        Variable _referencedComplexVariable = ((ComplexVariableReferencingInputPort)it).getReferencedComplexVariable();
        String _name = null;
        if (((Variable) _referencedComplexVariable)!=null) {
          _name=((Variable) _referencedComplexVariable).getName();
        }
        _switchResult = _name;
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveInputPortReferencingInputPort) {
        _matched=true;
        info.scce.dime.process.process.InputPort _referencedPrimitiveInputPort = ((PrimitiveInputPortReferencingInputPort)it).getReferencedPrimitiveInputPort();
        String _name = null;
        if (((info.scce.dime.process.process.InputPort) _referencedPrimitiveInputPort)!=null) {
          _name=((info.scce.dime.process.process.InputPort) _referencedPrimitiveInputPort).getName();
        }
        _switchResult = _name;
      }
    }
    if (!_matched) {
      if (it instanceof ComplexInputPortReferencingInputPort) {
        _matched=true;
        info.scce.dime.process.process.InputPort _referencedComplexInputPort = ((ComplexInputPortReferencingInputPort)it).getReferencedComplexInputPort();
        String _name = null;
        if (((info.scce.dime.process.process.InputPort) _referencedComplexInputPort)!=null) {
          _name=((info.scce.dime.process.process.InputPort) _referencedComplexInputPort).getName();
        }
        _switchResult = _name;
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveOutputPortReferencingInputPort) {
        _matched=true;
        info.scce.dime.process.process.OutputPort _referencedPrimitiveOutputPort = ((PrimitiveOutputPortReferencingInputPort)it).getReferencedPrimitiveOutputPort();
        String _name = null;
        if (((info.scce.dime.process.process.OutputPort) _referencedPrimitiveOutputPort)!=null) {
          _name=((info.scce.dime.process.process.OutputPort) _referencedPrimitiveOutputPort).getName();
        }
        _switchResult = _name;
      }
    }
    if (!_matched) {
      if (it instanceof ComplexOutputPortReferencingInputPort) {
        _matched=true;
        info.scce.dime.process.process.OutputPort _referencedComplexOutputPort = ((ComplexOutputPortReferencingInputPort)it).getReferencedComplexOutputPort();
        String _name = null;
        if (((info.scce.dime.process.process.OutputPort) _referencedComplexOutputPort)!=null) {
          _name=((info.scce.dime.process.process.OutputPort) _referencedComplexOutputPort).getName();
        }
        _switchResult = _name;
      }
    }
    if (!_matched) {
      if (it instanceof AbstractParameterReferencingOutputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.getPortName(((AbstractParameterReferencingOutputPort)it).getReferencedAbstractParameter());
      }
    }
    if (!_matched) {
      if (it instanceof AddToSubmissionReferencingOutputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.getPortName(((AddToSubmissionReferencingOutputPort)it).getReferencedAddToSubmission());
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveAttributeReferencingOutputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.getPortName(((PrimitiveAttributeReferencingOutputPort)it).getReferencedPrimitiveAttribute());
      }
    }
    if (!_matched) {
      if (it instanceof ComplexAttributeReferencingOutputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.getPortName(((ComplexAttributeReferencingOutputPort)it).getReferencedComplexAttribute());
      }
    }
    if (!_matched) {
      if (it instanceof GUIPrimitiveInputPortReferencingOutputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.getPortName(((GUIPrimitiveInputPortReferencingOutputPort)it).getReferencedPrimitiveInputPort());
      }
    }
    if (!_matched) {
      if (it instanceof GUIComplexInputPortReferencingOutputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.getPortName(((GUIComplexInputPortReferencingOutputPort)it).getReferencedComplexInputPort());
      }
    }
    if (!_matched) {
      if (it instanceof GUIPrimitiveOutputPortReferencingOutputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.getPortName(((GUIPrimitiveOutputPortReferencingOutputPort)it).getReferencedPrimitiveOutputPort());
      }
    }
    if (!_matched) {
      if (it instanceof GUIComplexOutputPortReferencingOutputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.getPortName(((GUIComplexOutputPortReferencingOutputPort)it).getReferencedComplexOutputPort());
      }
    }
    if (!_matched) {
      if (it instanceof OutputGenericReferencingOutputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.getPortName(((OutputGenericReferencingOutputPort)it).getReferencedOutputGeneric());
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveVariableReferencingOutputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.getPortName(((PrimitiveVariableReferencingOutputPort)it).getReferencedPrimitiveVariable());
      }
    }
    if (!_matched) {
      if (it instanceof ComplexVariableReferencingOutputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.getPortName(((ComplexVariableReferencingOutputPort)it).getReferencedComplexVariable());
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveInputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.process.process.InputPort _referencedPrimitiveInputPort = ((PrimitiveInputPortReferencingOutputPort)it).getReferencedPrimitiveInputPort();
        _switchResult = this.getPortName(((info.scce.dime.process.process.IO) _referencedPrimitiveInputPort));
      }
    }
    if (!_matched) {
      if (it instanceof ComplexInputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.process.process.InputPort _referencedComplexInputPort = ((ComplexInputPortReferencingOutputPort)it).getReferencedComplexInputPort();
        _switchResult = this.getPortName(((info.scce.dime.process.process.IO) _referencedComplexInputPort));
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveOutputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.process.process.OutputPort _referencedPrimitiveOutputPort = ((PrimitiveOutputPortReferencingOutputPort)it).getReferencedPrimitiveOutputPort();
        _switchResult = this.getPortName(((info.scce.dime.process.process.IO) _referencedPrimitiveOutputPort));
      }
    }
    if (!_matched) {
      if (it instanceof ComplexOutputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.process.process.OutputPort _referencedComplexOutputPort = ((ComplexOutputPortReferencingOutputPort)it).getReferencedComplexOutputPort();
        _switchResult = this.getPortName(((info.scce.dime.process.process.IO) _referencedComplexOutputPort));
      }
    }
    return _switchResult;
  }
  
  public String getReferencedObjectDataTypeName(final IO it) {
    String _switchResult = null;
    boolean _matched = false;
    if (it instanceof PrimitiveVariableReferencingInputPort) {
      _matched=true;
      Variable _referencedPrimitiveVariable = ((PrimitiveVariableReferencingInputPort)it).getReferencedPrimitiveVariable();
      info.scce.dime.gui.gui.PrimitiveType _dataType = null;
      if (((PrimitiveVariable) _referencedPrimitiveVariable)!=null) {
        _dataType=((PrimitiveVariable) _referencedPrimitiveVariable).getDataType();
      }
      String _string = null;
      if (_dataType!=null) {
        _string=_dataType.toString();
      }
      _switchResult = _string;
    }
    if (!_matched) {
      if (it instanceof ComplexVariableReferencingInputPort) {
        _matched=true;
        Variable _referencedComplexVariable = ((ComplexVariableReferencingInputPort)it).getReferencedComplexVariable();
        Type _dataType = null;
        if (((ComplexVariable) _referencedComplexVariable)!=null) {
          _dataType=((ComplexVariable) _referencedComplexVariable).getDataType();
        }
        String _name = null;
        if (_dataType!=null) {
          _name=_dataType.getName();
        }
        _switchResult = _name;
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveInputPortReferencingInputPort) {
        _matched=true;
        info.scce.dime.process.process.InputPort _referencedPrimitiveInputPort = ((PrimitiveInputPortReferencingInputPort)it).getReferencedPrimitiveInputPort();
        String _dataTypeName = null;
        if (((info.scce.dime.process.process.IO) _referencedPrimitiveInputPort)!=null) {
          info.scce.dime.process.process.InputPort _referencedPrimitiveInputPort_1 = ((PrimitiveInputPortReferencingInputPort)it).getReferencedPrimitiveInputPort();
          _dataTypeName=this.getDataTypeName(((info.scce.dime.process.process.IO) _referencedPrimitiveInputPort_1));
        }
        _switchResult = _dataTypeName;
      }
    }
    if (!_matched) {
      if (it instanceof ComplexInputPortReferencingInputPort) {
        _matched=true;
        info.scce.dime.process.process.InputPort _referencedComplexInputPort = ((ComplexInputPortReferencingInputPort)it).getReferencedComplexInputPort();
        String _dataTypeName = null;
        if (((info.scce.dime.process.process.IO) _referencedComplexInputPort)!=null) {
          info.scce.dime.process.process.InputPort _referencedComplexInputPort_1 = ((ComplexInputPortReferencingInputPort)it).getReferencedComplexInputPort();
          _dataTypeName=this.getDataTypeName(((info.scce.dime.process.process.IO) _referencedComplexInputPort));
        }
        _switchResult = _dataTypeName;
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveOutputPortReferencingInputPort) {
        _matched=true;
        info.scce.dime.process.process.OutputPort _referencedPrimitiveOutputPort = ((PrimitiveOutputPortReferencingInputPort)it).getReferencedPrimitiveOutputPort();
        String _dataTypeName = null;
        if (((info.scce.dime.process.process.IO) _referencedPrimitiveOutputPort)!=null) {
          info.scce.dime.process.process.OutputPort _referencedPrimitiveOutputPort_1 = ((PrimitiveOutputPortReferencingInputPort)it).getReferencedPrimitiveOutputPort();
          _dataTypeName=this.getDataTypeName(((info.scce.dime.process.process.IO) _referencedPrimitiveOutputPort));
        }
        _switchResult = _dataTypeName;
      }
    }
    if (!_matched) {
      if (it instanceof ComplexOutputPortReferencingInputPort) {
        _matched=true;
        info.scce.dime.process.process.OutputPort _referencedComplexOutputPort = ((ComplexOutputPortReferencingInputPort)it).getReferencedComplexOutputPort();
        String _dataTypeName = null;
        if (((info.scce.dime.process.process.IO) _referencedComplexOutputPort)!=null) {
          info.scce.dime.process.process.OutputPort _referencedComplexOutputPort_1 = ((ComplexOutputPortReferencingInputPort)it).getReferencedComplexOutputPort();
          _dataTypeName=this.getDataTypeName(((info.scce.dime.process.process.IO) _referencedComplexOutputPort_1));
        }
        _switchResult = _dataTypeName;
      }
    }
    if (!_matched) {
      if (it instanceof AbstractParameterReferencingOutputPort) {
        _matched=true;
        String _switchResult_1 = null;
        EObject _referencedAbstractParameter = ((AbstractParameterReferencingOutputPort)it).getReferencedAbstractParameter();
        final AbstractParameter it_1 = ((AbstractParameter) _referencedAbstractParameter);
        boolean _matched_1 = false;
        if (it_1 instanceof ComplexParameter) {
          _matched_1=true;
          EObject _type = ((ComplexParameter)it_1).getType();
          String _name = null;
          if (((Type) _type)!=null) {
            _name=((Type) _type).getName();
          }
          _switchResult_1 = _name;
        }
        if (!_matched_1) {
          if (it_1 instanceof PrimitiveParameter) {
            _matched_1=true;
            info.scce.dime.gUIPlugin.PrimitiveType _type = ((PrimitiveParameter)it_1).getType();
            String _string = null;
            if (_type!=null) {
              _string=_type.toString();
            }
            _switchResult_1 = _string;
          }
        }
        if (!_matched_1) {
          if (it_1 instanceof GenericParameter) {
            _matched_1=true;
            _switchResult_1 = ((GenericParameter)it_1).getTypeParameterName();
          }
        }
        _switchResult = _switchResult_1;
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveAttributeReferencingOutputPort) {
        _matched=true;
        PrimitiveAttribute _referencedPrimitiveAttribute = ((PrimitiveAttributeReferencingOutputPort)it).getReferencedPrimitiveAttribute();
        String _dataTypeName = null;
        if (((Attribute) _referencedPrimitiveAttribute)!=null) {
          PrimitiveAttribute _referencedPrimitiveAttribute_1 = ((PrimitiveAttributeReferencingOutputPort)it).getReferencedPrimitiveAttribute();
          _dataTypeName=this.getDataTypeName(((Attribute) _referencedPrimitiveAttribute));
        }
        _switchResult = _dataTypeName;
      }
    }
    if (!_matched) {
      if (it instanceof ComplexAttributeReferencingOutputPort) {
        _matched=true;
        ComplexAttribute _referencedComplexAttribute = ((ComplexAttributeReferencingOutputPort)it).getReferencedComplexAttribute();
        String _dataTypeName = null;
        if (((Attribute) _referencedComplexAttribute)!=null) {
          ComplexAttribute _referencedComplexAttribute_1 = ((ComplexAttributeReferencingOutputPort)it).getReferencedComplexAttribute();
          _dataTypeName=this.getDataTypeName(((Attribute) _referencedComplexAttribute));
        }
        _switchResult = _dataTypeName;
      }
    }
    if (!_matched) {
      if (it instanceof GUIPrimitiveInputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.gui.gui.PrimitiveInputPort _referencedPrimitiveInputPort = ((GUIPrimitiveInputPortReferencingOutputPort)it).getReferencedPrimitiveInputPort();
        String _dataTypeName = null;
        if (((info.scce.dime.gui.gui.InputPort) _referencedPrimitiveInputPort)!=null) {
          info.scce.dime.gui.gui.PrimitiveInputPort _referencedPrimitiveInputPort_1 = ((GUIPrimitiveInputPortReferencingOutputPort)it).getReferencedPrimitiveInputPort();
          _dataTypeName=this.getDataTypeName(((info.scce.dime.gui.gui.InputPort) _referencedPrimitiveInputPort_1));
        }
        _switchResult = _dataTypeName;
      }
    }
    if (!_matched) {
      if (it instanceof GUIComplexInputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.gui.gui.ComplexInputPort _referencedComplexInputPort = ((GUIComplexInputPortReferencingOutputPort)it).getReferencedComplexInputPort();
        String _dataTypeName = null;
        if (((info.scce.dime.gui.gui.InputPort) _referencedComplexInputPort)!=null) {
          info.scce.dime.gui.gui.ComplexInputPort _referencedComplexInputPort_1 = ((GUIComplexInputPortReferencingOutputPort)it).getReferencedComplexInputPort();
          _dataTypeName=this.getDataTypeName(((info.scce.dime.gui.gui.InputPort) _referencedComplexInputPort));
        }
        _switchResult = _dataTypeName;
      }
    }
    if (!_matched) {
      if (it instanceof GUIPrimitiveOutputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.gui.gui.PrimitiveOutputPort _referencedPrimitiveOutputPort = ((GUIPrimitiveOutputPortReferencingOutputPort)it).getReferencedPrimitiveOutputPort();
        String _dataTypeName = null;
        if (((info.scce.dime.gui.gui.OutputPort) _referencedPrimitiveOutputPort)!=null) {
          info.scce.dime.gui.gui.PrimitiveOutputPort _referencedPrimitiveOutputPort_1 = ((GUIPrimitiveOutputPortReferencingOutputPort)it).getReferencedPrimitiveOutputPort();
          _dataTypeName=this.getDataTypeName(((info.scce.dime.gui.gui.OutputPort) _referencedPrimitiveOutputPort));
        }
        _switchResult = _dataTypeName;
      }
    }
    if (!_matched) {
      if (it instanceof GUIComplexOutputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.gui.gui.ComplexOutputPort _referencedComplexOutputPort = ((GUIComplexOutputPortReferencingOutputPort)it).getReferencedComplexOutputPort();
        String _dataTypeName = null;
        if (((info.scce.dime.gui.gui.OutputPort) _referencedComplexOutputPort)!=null) {
          info.scce.dime.gui.gui.ComplexOutputPort _referencedComplexOutputPort_1 = ((GUIComplexOutputPortReferencingOutputPort)it).getReferencedComplexOutputPort();
          _dataTypeName=this.getDataTypeName(((info.scce.dime.gui.gui.OutputPort) _referencedComplexOutputPort_1));
        }
        _switchResult = _dataTypeName;
      }
    }
    if (!_matched) {
      if (it instanceof OutputGenericReferencingOutputPort) {
        _matched=true;
        OutputGeneric _referencedOutputGeneric = ((OutputGenericReferencingOutputPort)it).getReferencedOutputGeneric();
        _switchResult = this.getDataTypeName(((info.scce.dime.gui.gui.OutputPort) _referencedOutputGeneric));
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveVariableReferencingOutputPort) {
        _matched=true;
        PrimitiveVariable _referencedPrimitiveVariable = ((PrimitiveVariableReferencingOutputPort)it).getReferencedPrimitiveVariable();
        _switchResult = this.getDataTypeName(((Variable) _referencedPrimitiveVariable));
      }
    }
    if (!_matched) {
      if (it instanceof ComplexVariableReferencingOutputPort) {
        _matched=true;
        ComplexVariable _referencedComplexVariable = ((ComplexVariableReferencingOutputPort)it).getReferencedComplexVariable();
        _switchResult = this.getDataTypeName(((Variable) _referencedComplexVariable));
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveInputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.process.process.InputPort _referencedPrimitiveInputPort = ((PrimitiveInputPortReferencingOutputPort)it).getReferencedPrimitiveInputPort();
        _switchResult = this.getPortName(((info.scce.dime.process.process.IO) _referencedPrimitiveInputPort));
      }
    }
    if (!_matched) {
      if (it instanceof ComplexInputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.process.process.InputPort _referencedComplexInputPort = ((ComplexInputPortReferencingOutputPort)it).getReferencedComplexInputPort();
        _switchResult = this.getPortName(((info.scce.dime.process.process.IO) _referencedComplexInputPort));
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveOutputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.process.process.OutputPort _referencedPrimitiveOutputPort = ((PrimitiveOutputPortReferencingOutputPort)it).getReferencedPrimitiveOutputPort();
        _switchResult = this.getPortName(((info.scce.dime.process.process.IO) _referencedPrimitiveOutputPort));
      }
    }
    if (!_matched) {
      if (it instanceof ComplexOutputPortReferencingOutputPort) {
        _matched=true;
        info.scce.dime.process.process.OutputPort _referencedComplexOutputPort = ((ComplexOutputPortReferencingOutputPort)it).getReferencedComplexOutputPort();
        _switchResult = this.getPortName(((info.scce.dime.process.process.IO) _referencedComplexOutputPort));
      }
    }
    return _switchResult;
  }
  
  public String getPortName(final info.scce.dime.process.process.IO it) {
    String _switchResult = null;
    boolean _matched = false;
    if (it instanceof info.scce.dime.process.process.InputPort) {
      _matched=true;
      _switchResult = ((info.scce.dime.process.process.InputPort)it).getName();
    }
    if (!_matched) {
      if (it instanceof info.scce.dime.process.process.OutputPort) {
        _matched=true;
        _switchResult = ((info.scce.dime.process.process.OutputPort)it).getName();
      }
    }
    return _switchResult;
  }
  
  public String getDataTypeName(final info.scce.dime.process.process.IO it) {
    String _switchResult = null;
    boolean _matched = false;
    if (it instanceof PrimitiveInputPort) {
      _matched=true;
      PrimitiveType _dataType = ((PrimitiveInputPort)it).getDataType();
      String _string = null;
      if (_dataType!=null) {
        _string=_dataType.toString();
      }
      _switchResult = _string;
    }
    if (!_matched) {
      if (it instanceof ComplexInputPort) {
        _matched=true;
        Type _dataType = ((ComplexInputPort)it).getDataType();
        String _name = null;
        if (_dataType!=null) {
          _name=_dataType.getName();
        }
        _switchResult = _name;
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveOutputPort) {
        _matched=true;
        PrimitiveType _dataType = ((PrimitiveOutputPort)it).getDataType();
        String _string = null;
        if (_dataType!=null) {
          _string=_dataType.toString();
        }
        _switchResult = _string;
      }
    }
    if (!_matched) {
      if (it instanceof ComplexOutputPort) {
        _matched=true;
        Type _dataType = ((ComplexOutputPort)it).getDataType();
        String _name = null;
        if (_dataType!=null) {
          _name=_dataType.getName();
        }
        _switchResult = _name;
      }
    }
    return _switchResult;
  }
  
  public String getDataTypeName(final info.scce.dime.gui.gui.InputPort it) {
    String _switchResult = null;
    boolean _matched = false;
    if (it instanceof info.scce.dime.gui.gui.PrimitiveInputPort) {
      _matched=true;
      info.scce.dime.gui.gui.PrimitiveType _dataType = ((info.scce.dime.gui.gui.PrimitiveInputPort)it).getDataType();
      String _string = null;
      if (_dataType!=null) {
        _string=_dataType.toString();
      }
      _switchResult = _string;
    }
    if (!_matched) {
      if (it instanceof info.scce.dime.gui.gui.ComplexInputPort) {
        _matched=true;
        Type _dataType = ((info.scce.dime.gui.gui.ComplexInputPort)it).getDataType();
        String _name = null;
        if (_dataType!=null) {
          _name=_dataType.getName();
        }
        _switchResult = _name;
      }
    }
    return _switchResult;
  }
  
  public String getDataTypeName(final info.scce.dime.gui.gui.OutputPort it) {
    String _switchResult = null;
    boolean _matched = false;
    if (it instanceof info.scce.dime.gui.gui.PrimitiveOutputPort) {
      _matched=true;
      info.scce.dime.gui.gui.PrimitiveType _dataType = ((info.scce.dime.gui.gui.PrimitiveOutputPort)it).getDataType();
      String _string = null;
      if (_dataType!=null) {
        _string=_dataType.toString();
      }
      _switchResult = _string;
    }
    if (!_matched) {
      if (it instanceof info.scce.dime.gui.gui.ComplexOutputPort) {
        _matched=true;
        Type _dataType = ((info.scce.dime.gui.gui.ComplexOutputPort)it).getDataType();
        String _name = null;
        if (_dataType!=null) {
          _name=_dataType.getName();
        }
        _switchResult = _name;
      }
    }
    if (!_matched) {
      if (it instanceof OutputGeneric) {
        _matched=true;
        _switchResult = ((OutputGeneric)it).getTypeParameter();
      }
    }
    return _switchResult;
  }
  
  public String getDataTypeName(final Variable it) {
    String _switchResult = null;
    boolean _matched = false;
    if (it instanceof PrimitiveVariable) {
      _matched=true;
      info.scce.dime.gui.gui.PrimitiveType _dataType = ((PrimitiveVariable)it).getDataType();
      String _string = null;
      if (_dataType!=null) {
        _string=_dataType.toString();
      }
      _switchResult = _string;
    }
    if (!_matched) {
      if (it instanceof ComplexVariable) {
        _matched=true;
        Type _dataType = ((ComplexVariable)it).getDataType();
        String _name = null;
        if (_dataType!=null) {
          _name=_dataType.getName();
        }
        _switchResult = _name;
      }
    }
    return _switchResult;
  }
  
  public String getDataTypeName(final Attribute it) {
    String _switchResult = null;
    boolean _matched = false;
    if (it instanceof PrimitiveAttribute) {
      _matched=true;
      info.scce.dime.data.data.PrimitiveAttribute _attribute = ((PrimitiveAttribute)it).getAttribute();
      info.scce.dime.data.data.PrimitiveType _dataType = null;
      if (_attribute!=null) {
        _dataType=_attribute.getDataType();
      }
      String _string = null;
      if (_dataType!=null) {
        _string=_dataType.toString();
      }
      _switchResult = _string;
    }
    if (!_matched) {
      if (it instanceof ComplexAttribute) {
        _matched=true;
        info.scce.dime.data.data.ComplexAttribute _attribute = ((ComplexAttribute)it).getAttribute();
        Type _dataType = null;
        if (_attribute!=null) {
          _dataType=_attribute.getDataType();
        }
        String _name = null;
        if (_dataType!=null) {
          _name=_dataType.getName();
        }
        _switchResult = _name;
      }
    }
    return _switchResult;
  }
  
  public boolean isList(final info.scce.dime.process.process.IO it) {
    boolean _switchResult = false;
    boolean _matched = false;
    if (it instanceof PrimitiveInputPort) {
      _matched=true;
      _switchResult = ((PrimitiveInputPort)it).isIsList();
    }
    if (!_matched) {
      if (it instanceof ComplexInputPort) {
        _matched=true;
        _switchResult = ((ComplexInputPort)it).isIsList();
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveOutputPort) {
        _matched=true;
        _switchResult = ((PrimitiveOutputPort)it).isIsList();
      }
    }
    if (!_matched) {
      if (it instanceof ComplexOutputPort) {
        _matched=true;
        _switchResult = ((ComplexOutputPort)it).isIsList();
      }
    }
    return _switchResult;
  }
  
  protected boolean _hasInvalidPrimeReference(final IdentifiableElement it) {
    return false;
  }
  
  protected boolean _hasInvalidPrimeReference(final SIB sib) {
    ModelElementContainer _referencedObject = this.getReferencedObject(sib);
    return (_referencedObject == null);
  }
  
  protected boolean _hasInvalidPrimeReference(final Branch branch) {
    EObject _referencedObject = this.getReferencedObject(branch);
    return (_referencedObject == null);
  }
  
  protected boolean _hasInvalidPrimeReference(final IO port) {
    EObject _referencedObject = this.getReferencedObject(port);
    return (_referencedObject == null);
  }
  
  public boolean hasInvalidPrimeReference(final IdentifiableElement branch) {
    if (branch instanceof Branch) {
      return _hasInvalidPrimeReference((Branch)branch);
    } else if (branch instanceof IO) {
      return _hasInvalidPrimeReference((IO)branch);
    } else if (branch instanceof SIB) {
      return _hasInvalidPrimeReference((SIB)branch);
    } else if (branch != null) {
      return _hasInvalidPrimeReference(branch);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(branch).toString());
    }
  }
}
