/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.profile.actions;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.util.xapi.CodingExtension;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.process.process.BlueprintSIB;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.BranchBlueprint;
import info.scce.dime.process.process.ControlFlow;
import info.scce.dime.process.process.DataFlow;
import info.scce.dime.process.process.GUIBlueprintSIB;
import info.scce.dime.process.process.ProcessBlueprintSIB;
import info.scce.dime.profile.api.ProfileExtension;
import info.scce.dime.profile.profile.BlueprintBranch;
import info.scce.dime.profile.profile.GUISIB;
import info.scce.dime.profile.profile.InputPort;
import info.scce.dime.profile.profile.OutputPort;
import info.scce.dime.profile.profile.ProcessSIB;
import info.scce.dime.profile.profile.ReplacementBranch;
import info.scce.dime.profile.profile.SIB;
import info.scce.dime.profile.util.ReplacementStrategy;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class Replace extends DIMECustomAction<SIB> {
  @Extension
  private ProfileExtension _profileExtension = new ProfileExtension();
  
  @Extension
  private ReplacementStrategy _replacementStrategy = new ReplacementStrategy();
  
  private boolean saveModel = false;
  
  private boolean success = false;
  
  @Override
  public String getName() {
    return "Perform Replacement";
  }
  
  @Override
  public boolean hasDoneChanges() {
    return false;
  }
  
  @Override
  public void execute(final SIB sib) {
    ModelElementContainer _referencedObject = this._profileExtension.getReferencedObject(sib);
    final BlueprintSIB refSib = ((BlueprintSIB) _referencedObject);
    if ((refSib != null)) {
      final info.scce.dime.process.process.Process model = refSib.getRootElement();
      this.saveModel = true;
      this.performReplacement(sib);
      if (this.success) {
        final boolean yes = this._workbenchExtension.showQuestionDialog("Replacement", "Replacement successful. Open model now?");
        if (yes) {
          final Function1<CodingExtension.FunctionArgumentsNotSupported, IEditorPart> _function = new Function1<CodingExtension.FunctionArgumentsNotSupported, IEditorPart>() {
            @Override
            public IEditorPart apply(final CodingExtension.FunctionArgumentsNotSupported it) {
              return Replace.this._workbenchExtension.openEditor(model);
            }
          };
          final Procedure1<Exception> _function_1 = new Procedure1<Exception>() {
            @Override
            public void apply(final Exception it) {
              Replace.this._workbenchExtension.showWarningDialog("Open Model", "Opening model failed, sorry.");
            }
          };
          this._codingExtension.<IEditorPart>onException(_function, _function_1);
        }
      } else {
        this._workbenchExtension.showWarningDialog("Replacement", "Replacement failed, sorry.");
      }
    }
  }
  
  public ProcessBlueprintSIB getReferencedElement(final info.scce.dime.profile.profile.ProcessBlueprintSIB sib) {
    ProcessBlueprintSIB _referencedProcessBlueprintSIB = sib.getReferencedProcessBlueprintSIB();
    return ((ProcessBlueprintSIB) _referencedProcessBlueprintSIB);
  }
  
  public GUIBlueprintSIB getReferencedElement(final info.scce.dime.profile.profile.GUIBlueprintSIB sib) {
    GUIBlueprintSIB _referencedGUIBlueprintSIB = sib.getReferencedGUIBlueprintSIB();
    return ((GUIBlueprintSIB) _referencedGUIBlueprintSIB);
  }
  
  protected Boolean _performReplacement(final GUISIB sib) {
    this._workbenchExtension.showWarningDialog("Replacement", "Only blueprints can be replaced.");
    return null;
  }
  
  protected Boolean _performReplacement(final ProcessSIB sib) {
    this._workbenchExtension.showWarningDialog("Replacement", "Only blueprints can be replaced.");
    return null;
  }
  
  protected Boolean _performReplacement(final info.scce.dime.profile.profile.GUIBlueprintSIB sib) {
    boolean _xblockexpression = false;
    {
      final GUIBlueprintSIB refSib = this.getReferencedElement(sib);
      boolean _xifexpression = false;
      if ((refSib != null)) {
        boolean _xblockexpression_1 = false;
        {
          final Node replSib = this._replacementStrategy.getInferredReplacement(sib);
          if ((!(replSib instanceof GUISIB))) {
            return null;
          }
          ModelElementContainer _referencedObject = null;
          if (((GUISIB) replSib)!=null) {
            _referencedObject=this._profileExtension.getReferencedObject(((GUISIB) replSib));
          }
          final ModelElementContainer replGUI = _referencedObject;
          _xblockexpression_1 = this.performReplacement(sib, ((GUI) replGUI));
        }
        _xifexpression = _xblockexpression_1;
      }
      _xblockexpression = _xifexpression;
    }
    return Boolean.valueOf(_xblockexpression);
  }
  
  public boolean performReplacement(final info.scce.dime.profile.profile.GUIBlueprintSIB sib, final GUI replGUI) {
    boolean _xblockexpression = false;
    {
      final GUIBlueprintSIB refSib = this.getReferencedElement(sib);
      boolean _xifexpression = false;
      if ((refSib != null)) {
        boolean _xblockexpression_1 = false;
        {
          final info.scce.dime.process.process.Process model = refSib.getRootElement();
          final Function1<info.scce.dime.process.process.SIB, Boolean> _function = new Function1<info.scce.dime.process.process.SIB, Boolean>() {
            @Override
            public Boolean apply(final info.scce.dime.process.process.SIB it) {
              return Boolean.valueOf(Replace.this._processExtension.hasDefaultContent(it, refSib));
            }
          };
          final Set<info.scce.dime.process.process.SIB> defaultContentSIBs = IterableExtensions.<info.scce.dime.process.process.SIB>toSet(IterableExtensions.<info.scce.dime.process.process.SIB>filter(this._gUIExtension.<info.scce.dime.process.process.SIB>find(model, info.scce.dime.process.process.SIB.class), _function));
          info.scce.dime.process.process.GUISIB _newGUISIB = model.newGUISIB(replGUI, refSib.getX(), refSib.getY(), refSib.getWidth(), refSib.getHeight());
          final Procedure1<info.scce.dime.process.process.GUISIB> _function_1 = new Procedure1<info.scce.dime.process.process.GUISIB>() {
            @Override
            public void apply(final info.scce.dime.process.process.GUISIB it) {
              it.setLabel(refSib.getLabel());
              it.setName(refSib.getName());
              it.setMajorBranch(refSib.getMajorBranch());
              it.setMajorPage(refSib.isMajorPage());
              it.setDefaultContent(refSib.getDefaultContent());
            }
          };
          final info.scce.dime.process.process.GUISIB newSib = ObjectExtensions.<info.scce.dime.process.process.GUISIB>operator_doubleArrow(_newGUISIB, _function_1);
          EList<? extends ControlFlow> _incoming = refSib.getIncoming();
          for (final ControlFlow edge : _incoming) {
            edge.reconnectTarget(newSib);
          }
          EList<InputPort> _inputPorts = sib.getInputPorts();
          for (final InputPort port : _inputPorts) {
            {
              final InputPort replPort = this._replacementStrategy.getInferredReplacement(port);
              if ((replPort != null)) {
                EObject _referencedObject = this._profileExtension.getReferencedObject(port);
                final info.scce.dime.process.process.InputPort refPort = ((info.scce.dime.process.process.InputPort) _referencedObject);
                final Function1<info.scce.dime.process.process.InputPort, Boolean> _function_2 = new Function1<info.scce.dime.process.process.InputPort, Boolean>() {
                  @Override
                  public Boolean apply(final info.scce.dime.process.process.InputPort it) {
                    String _name = it.getName();
                    String _referencedObjectName = Replace.this._profileExtension.getReferencedObjectName(replPort);
                    return Boolean.valueOf(Objects.equal(_name, _referencedObjectName));
                  }
                };
                final info.scce.dime.process.process.InputPort newPort = this._gUIExtension.<info.scce.dime.process.process.InputPort>findThe(newSib, info.scce.dime.process.process.InputPort.class, _function_2);
                EList<? extends DataFlow> _incoming_1 = refPort.getIncoming();
                for (final DataFlow edge_1 : _incoming_1) {
                  edge_1.reconnectTarget(newPort);
                }
              } else {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("InputPort \'");
                String _name = this._profileExtension.getName(port);
                _builder.append(_name);
                _builder.append("\' of SIB \'");
                String _name_1 = this._profileExtension.getName(sib);
                _builder.append(_name_1);
                _builder.append("\' has no replacement");
                this._codingExtension.warn(this, _builder);
              }
            }
          }
          EList<BlueprintBranch> _blueprintBranchs = sib.getBlueprintBranchs();
          for (final BlueprintBranch branch : _blueprintBranchs) {
            {
              final ReplacementBranch replBranch = this._replacementStrategy.getInferredReplacement(branch);
              if ((replBranch != null)) {
                BranchBlueprint _referencedBranch = branch.getReferencedBranch();
                final BranchBlueprint refBranch = ((BranchBlueprint) _referencedBranch);
                final Function1<info.scce.dime.process.process.SIB, Boolean> _function_2 = new Function1<info.scce.dime.process.process.SIB, Boolean>() {
                  @Override
                  public Boolean apply(final info.scce.dime.process.process.SIB it) {
                    return Boolean.valueOf(Replace.this._processExtension.hasMajorBranch(it, refBranch));
                  }
                };
                final Set<info.scce.dime.process.process.SIB> majorBranchSIBs = IterableExtensions.<info.scce.dime.process.process.SIB>toSet(IterableExtensions.<info.scce.dime.process.process.SIB>filter(this._gUIExtension.<info.scce.dime.process.process.SIB>find(model, info.scce.dime.process.process.SIB.class), _function_2));
                final String branchName = replBranch.getCachedReferencedObjectName();
                final Function1<Branch, Boolean> _function_3 = new Function1<Branch, Boolean>() {
                  @Override
                  public Boolean apply(final Branch it) {
                    String _name = it.getName();
                    return Boolean.valueOf(Objects.equal(_name, branchName));
                  }
                };
                final Branch newBranch = IterableExtensions.<Branch>head(IterableExtensions.<Branch>filter(newSib.getBranchSuccessors(), _function_3));
                newBranch.moveTo(newBranch.getContainer(), refBranch.getX(), refBranch.getY());
                EList<ControlFlow> _outgoingControlFlows = refBranch.getOutgoingControlFlows();
                for (final ControlFlow edge_1 : _outgoingControlFlows) {
                  edge_1.reconnectSource(newBranch);
                }
                EList<OutputPort> _outputPorts = branch.getOutputPorts();
                for (final OutputPort port_1 : _outputPorts) {
                  {
                    final OutputPort replPort = this._replacementStrategy.getInferredReplacement(port_1);
                    if ((replPort != null)) {
                      EObject _referencedObject = this._profileExtension.getReferencedObject(port_1);
                      final info.scce.dime.process.process.OutputPort refPort = ((info.scce.dime.process.process.OutputPort) _referencedObject);
                      final Function1<info.scce.dime.process.process.OutputPort, Boolean> _function_4 = new Function1<info.scce.dime.process.process.OutputPort, Boolean>() {
                        @Override
                        public Boolean apply(final info.scce.dime.process.process.OutputPort it) {
                          String _name = it.getName();
                          String _cachedReferencedObjectName = replPort.getCachedReferencedObjectName();
                          return Boolean.valueOf(Objects.equal(_name, _cachedReferencedObjectName));
                        }
                      };
                      final info.scce.dime.process.process.OutputPort newPort = this._gUIExtension.<info.scce.dime.process.process.OutputPort>findThe(newBranch, info.scce.dime.process.process.OutputPort.class, _function_4);
                      EList<? extends DataFlow> _outgoing = refPort.getOutgoing();
                      for (final DataFlow edge_2 : _outgoing) {
                        edge_2.reconnectSource(newPort);
                      }
                    } else {
                      StringConcatenation _builder = new StringConcatenation();
                      _builder.append("OutputPort \'");
                      String _name = this._profileExtension.getName(port_1);
                      _builder.append(_name);
                      _builder.append("\' of branch \'");
                      String _name_1 = this._profileExtension.getName(branch);
                      _builder.append(_name_1);
                      _builder.append("\' of SIB \'");
                      String _name_2 = this._profileExtension.getName(this._profileExtension.getSib(branch));
                      _builder.append(_name_2);
                      _builder.append("\' has no replacement");
                      this._codingExtension.warn(this, _builder);
                    }
                  }
                }
                final Consumer<info.scce.dime.process.process.SIB> _function_4 = new Consumer<info.scce.dime.process.process.SIB>() {
                  @Override
                  public void accept(final info.scce.dime.process.process.SIB it) {
                    Replace.this._processExtension.setMajorBranch(it, newBranch);
                  }
                };
                majorBranchSIBs.forEach(_function_4);
              } else {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Branch \'");
                String _name = this._profileExtension.getName(branch);
                _builder.append(_name);
                _builder.append("\' of SIB \'");
                String _name_1 = this._profileExtension.getName(this._profileExtension.getSib(branch));
                _builder.append(_name_1);
                _builder.append("\' has no replacement");
                this._codingExtension.warn(this, _builder);
              }
            }
          }
          final Consumer<info.scce.dime.process.process.SIB> _function_2 = new Consumer<info.scce.dime.process.process.SIB>() {
            @Override
            public void accept(final info.scce.dime.process.process.SIB it) {
              Replace.this._processExtension.setDefaultContent(it, newSib);
            }
          };
          defaultContentSIBs.forEach(_function_2);
          refSib.delete();
          if (this.saveModel) {
            model.save();
          }
          _xblockexpression_1 = this.success = true;
        }
        _xifexpression = _xblockexpression_1;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected Boolean _performReplacement(final info.scce.dime.profile.profile.ProcessBlueprintSIB sib) {
    boolean _xblockexpression = false;
    {
      final ProcessBlueprintSIB refSib = this.getReferencedElement(sib);
      boolean _xifexpression = false;
      if ((refSib != null)) {
        boolean _xblockexpression_1 = false;
        {
          final info.scce.dime.process.process.Process model = refSib.getRootElement();
          final Function1<info.scce.dime.process.process.SIB, Boolean> _function = new Function1<info.scce.dime.process.process.SIB, Boolean>() {
            @Override
            public Boolean apply(final info.scce.dime.process.process.SIB it) {
              return Boolean.valueOf(Replace.this._processExtension.hasDefaultContent(it, refSib));
            }
          };
          final Set<info.scce.dime.process.process.SIB> defaultContentSIBs = IterableExtensions.<info.scce.dime.process.process.SIB>toSet(IterableExtensions.<info.scce.dime.process.process.SIB>filter(this._gUIExtension.<info.scce.dime.process.process.SIB>find(model, info.scce.dime.process.process.SIB.class), _function));
          final Node replSib = this._replacementStrategy.getInferredReplacement(sib);
          if ((!(replSib instanceof ProcessSIB))) {
            return null;
          }
          ModelElementContainer _referencedObject = null;
          if (((ProcessSIB) replSib)!=null) {
            _referencedObject=this._profileExtension.getReferencedObject(((ProcessSIB) replSib));
          }
          final ModelElementContainer replProcess = _referencedObject;
          info.scce.dime.process.process.ProcessSIB _newProcessSIB = model.newProcessSIB(replProcess, refSib.getX(), refSib.getY(), refSib.getWidth(), refSib.getHeight());
          final Procedure1<info.scce.dime.process.process.ProcessSIB> _function_1 = new Procedure1<info.scce.dime.process.process.ProcessSIB>() {
            @Override
            public void apply(final info.scce.dime.process.process.ProcessSIB it) {
              it.setLabel(refSib.getLabel());
              it.setName(refSib.getName());
            }
          };
          final info.scce.dime.process.process.ProcessSIB newSib = ObjectExtensions.<info.scce.dime.process.process.ProcessSIB>operator_doubleArrow(_newProcessSIB, _function_1);
          EList<? extends ControlFlow> _incoming = refSib.getIncoming();
          for (final ControlFlow edge : _incoming) {
            edge.reconnectTarget(newSib);
          }
          EList<InputPort> _inputPorts = sib.getInputPorts();
          for (final InputPort port : _inputPorts) {
            {
              final InputPort replPort = this._replacementStrategy.getInferredReplacement(port);
              if ((replPort != null)) {
                EObject _referencedObject_1 = this._profileExtension.getReferencedObject(port);
                final info.scce.dime.process.process.InputPort refPort = ((info.scce.dime.process.process.InputPort) _referencedObject_1);
                final Function1<info.scce.dime.process.process.InputPort, Boolean> _function_2 = new Function1<info.scce.dime.process.process.InputPort, Boolean>() {
                  @Override
                  public Boolean apply(final info.scce.dime.process.process.InputPort it) {
                    String _name = it.getName();
                    String _referencedObjectName = Replace.this._profileExtension.getReferencedObjectName(replPort);
                    return Boolean.valueOf(Objects.equal(_name, _referencedObjectName));
                  }
                };
                final info.scce.dime.process.process.InputPort newPort = this._gUIExtension.<info.scce.dime.process.process.InputPort>findThe(newSib, info.scce.dime.process.process.InputPort.class, _function_2);
                EList<? extends DataFlow> _incoming_1 = refPort.getIncoming();
                for (final DataFlow edge_1 : _incoming_1) {
                  edge_1.reconnectTarget(newPort);
                }
              } else {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("InputPort \'");
                String _name = this._profileExtension.getName(port);
                _builder.append(_name);
                _builder.append("\' of SIB \'");
                String _name_1 = this._profileExtension.getName(sib);
                _builder.append(_name_1);
                _builder.append("\' has no replacement");
                this._codingExtension.warn(this, _builder);
              }
            }
          }
          EList<BlueprintBranch> _blueprintBranchs = sib.getBlueprintBranchs();
          for (final BlueprintBranch branch : _blueprintBranchs) {
            {
              final ReplacementBranch replBranch = this._replacementStrategy.getInferredReplacement(branch);
              if ((replBranch != null)) {
                BranchBlueprint _referencedBranch = branch.getReferencedBranch();
                final BranchBlueprint refBranch = ((BranchBlueprint) _referencedBranch);
                final Function1<info.scce.dime.process.process.SIB, Boolean> _function_2 = new Function1<info.scce.dime.process.process.SIB, Boolean>() {
                  @Override
                  public Boolean apply(final info.scce.dime.process.process.SIB it) {
                    return Boolean.valueOf(Replace.this._processExtension.hasMajorBranch(it, refBranch));
                  }
                };
                final Set<info.scce.dime.process.process.SIB> majorBranchSIBs = IterableExtensions.<info.scce.dime.process.process.SIB>toSet(IterableExtensions.<info.scce.dime.process.process.SIB>filter(this._gUIExtension.<info.scce.dime.process.process.SIB>find(model, info.scce.dime.process.process.SIB.class), _function_2));
                final String branchName = replBranch.getCachedReferencedObjectName();
                final Function1<Branch, Boolean> _function_3 = new Function1<Branch, Boolean>() {
                  @Override
                  public Boolean apply(final Branch it) {
                    String _name = it.getName();
                    return Boolean.valueOf(Objects.equal(_name, branchName));
                  }
                };
                final Branch newBranch = IterableExtensions.<Branch>head(IterableExtensions.<Branch>filter(newSib.getBranchSuccessors(), _function_3));
                newBranch.moveTo(newBranch.getContainer(), refBranch.getX(), refBranch.getY());
                EList<ControlFlow> _outgoingControlFlows = refBranch.getOutgoingControlFlows();
                for (final ControlFlow edge_1 : _outgoingControlFlows) {
                  edge_1.reconnectSource(newBranch);
                }
                EList<OutputPort> _outputPorts = branch.getOutputPorts();
                for (final OutputPort port_1 : _outputPorts) {
                  {
                    final OutputPort replPort = this._replacementStrategy.getInferredReplacement(port_1);
                    if ((replPort != null)) {
                      EObject _referencedObject_1 = this._profileExtension.getReferencedObject(port_1);
                      final info.scce.dime.process.process.OutputPort refPort = ((info.scce.dime.process.process.OutputPort) _referencedObject_1);
                      final Function1<info.scce.dime.process.process.OutputPort, Boolean> _function_4 = new Function1<info.scce.dime.process.process.OutputPort, Boolean>() {
                        @Override
                        public Boolean apply(final info.scce.dime.process.process.OutputPort it) {
                          String _name = it.getName();
                          String _cachedReferencedObjectName = replPort.getCachedReferencedObjectName();
                          return Boolean.valueOf(Objects.equal(_name, _cachedReferencedObjectName));
                        }
                      };
                      final info.scce.dime.process.process.OutputPort newPort = this._gUIExtension.<info.scce.dime.process.process.OutputPort>findThe(newBranch, info.scce.dime.process.process.OutputPort.class, _function_4);
                      EList<? extends DataFlow> _outgoing = refPort.getOutgoing();
                      for (final DataFlow edge_2 : _outgoing) {
                        edge_2.reconnectSource(newPort);
                      }
                    } else {
                      StringConcatenation _builder = new StringConcatenation();
                      _builder.append("OutputPort \'");
                      String _name = this._profileExtension.getName(port_1);
                      _builder.append(_name);
                      _builder.append("\' of branch \'");
                      String _name_1 = this._profileExtension.getName(branch);
                      _builder.append(_name_1);
                      _builder.append("\' of SIB \'");
                      String _name_2 = this._profileExtension.getName(this._profileExtension.getSib(branch));
                      _builder.append(_name_2);
                      _builder.append("\' has no replacement");
                      this._codingExtension.warn(this, _builder);
                    }
                  }
                }
                final Consumer<info.scce.dime.process.process.SIB> _function_4 = new Consumer<info.scce.dime.process.process.SIB>() {
                  @Override
                  public void accept(final info.scce.dime.process.process.SIB it) {
                    Replace.this._processExtension.setMajorBranch(it, newBranch);
                  }
                };
                majorBranchSIBs.forEach(_function_4);
              } else {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Branch \'");
                String _name = this._profileExtension.getName(branch);
                _builder.append(_name);
                _builder.append("\' of SIB \'");
                String _name_1 = this._profileExtension.getName(this._profileExtension.getSib(branch));
                _builder.append(_name_1);
                _builder.append("\' has no replacement");
                this._codingExtension.warn(this, _builder);
              }
            }
          }
          final Consumer<info.scce.dime.process.process.SIB> _function_2 = new Consumer<info.scce.dime.process.process.SIB>() {
            @Override
            public void accept(final info.scce.dime.process.process.SIB it) {
              Replace.this._processExtension.setDefaultContent(it, newSib);
            }
          };
          defaultContentSIBs.forEach(_function_2);
          refSib.delete();
          if (this.saveModel) {
            model.save();
          }
          _xblockexpression_1 = this.success = true;
        }
        _xifexpression = _xblockexpression_1;
      }
      _xblockexpression = _xifexpression;
    }
    return Boolean.valueOf(_xblockexpression);
  }
  
  public Boolean performReplacement(final SIB sib) {
    if (sib instanceof info.scce.dime.profile.profile.GUIBlueprintSIB) {
      return _performReplacement((info.scce.dime.profile.profile.GUIBlueprintSIB)sib);
    } else if (sib instanceof GUISIB) {
      return _performReplacement((GUISIB)sib);
    } else if (sib instanceof info.scce.dime.profile.profile.ProcessBlueprintSIB) {
      return _performReplacement((info.scce.dime.profile.profile.ProcessBlueprintSIB)sib);
    } else if (sib instanceof ProcessSIB) {
      return _performReplacement((ProcessSIB)sib);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(sib).toString());
    }
  }
}
