/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.profile.actions;

import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.referenceregistry.ReferenceRegistry;
import de.jabc.cinco.meta.plugin.dsl.ProjectDescription;
import de.jabc.cinco.meta.plugin.dsl.ProjectType;
import de.jabc.cinco.meta.runtime.action.CincoCustomAction;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElementContainer;
import info.scce.dime.dad.dad.DAD;
import info.scce.dime.dad.dad.FindLoginUserComponent;
import info.scce.dime.dad.dad.LoginComponent;
import info.scce.dime.dad.dad.ProcessComponent;
import info.scce.dime.gui.gui.ExtensionContext;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.GUISIB;
import info.scce.dime.gui.gui.GuardSIB;
import info.scce.dime.gui.gui.ProcessSIB;
import info.scce.dime.gui.gui.SecuritySIB;
import info.scce.dime.process.process.GuardProcessSIB;
import info.scce.dime.process.process.GuardedProcessSIB;
import info.scce.dime.profile.api.ProfileExtension;
import info.scce.dime.profile.profile.ReplacementSIB;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class RefactorModel extends CincoCustomAction<ReplacementSIB> {
  @Extension
  private ProfileExtension _profileExtension = new ProfileExtension();
  
  @Override
  public String getName() {
    return "Refactor Model";
  }
  
  @Override
  public void execute(final ReplacementSIB sib) {
    try {
      String _simpleName = this.getClass().getSimpleName();
      String _plus = ("[" + _simpleName);
      int _hashCode = this.hashCode();
      String _plus_1 = (_plus + Integer.valueOf(_hashCode));
      String _plus_2 = (_plus_1 + "] Collecting models...");
      InputOutput.<String>println(_plus_2);
      ModelElementContainer _referencedObject = this._profileExtension.getReferencedObject(sib);
      final GraphModel model = ((GraphModel) _referencedObject);
      final Set<GraphModel> modelDeepModels = this.findModelsDeeply(model);
      int _size = modelDeepModels.size();
      String _plus_3 = ("Model.deepModels: " + Integer.valueOf(_size));
      InputOutput.<String>println(_plus_3);
      final Function1<GraphModel, IFile> _function = new Function1<GraphModel, IFile>() {
        @Override
        public IFile apply(final GraphModel it) {
          return RefactorModel.this._workspaceExtension.getFile(it);
        }
      };
      final Consumer<IFile> _function_1 = new Consumer<IFile>() {
        @Override
        public void accept(final IFile it) {
        }
      };
      IterableExtensions.<GraphModel, IFile>map(modelDeepModels, _function).forEach(_function_1);
      final Function1<DAD, Set<GraphModel>> _function_2 = new Function1<DAD, Set<GraphModel>>() {
        @Override
        public Set<GraphModel> apply(final DAD it) {
          return RefactorModel.this.findModelsDeeply(it);
        }
      };
      final Set<GraphModel> usedModels = IterableExtensions.<GraphModel>toSet(IterableExtensions.<DAD, GraphModel>flatMap(this.<DAD>lookup(DAD.class), _function_2));
      int _size_1 = usedModels.size();
      String _plus_4 = ("DADs.usedModels: " + Integer.valueOf(_size_1));
      InputOutput.<String>println(_plus_4);
      final Function1<GraphModel, IFile> _function_3 = new Function1<GraphModel, IFile>() {
        @Override
        public IFile apply(final GraphModel it) {
          return RefactorModel.this._workspaceExtension.getFile(it);
        }
      };
      final Consumer<IFile> _function_4 = new Consumer<IFile>() {
        @Override
        public void accept(final IFile it) {
        }
      };
      IterableExtensions.<GraphModel, IFile>map(usedModels, _function_3).forEach(_function_4);
      final Function1<DAD, Set<GraphModel>> _function_5 = new Function1<DAD, Set<GraphModel>>() {
        @Override
        public Set<GraphModel> apply(final DAD it) {
          return RefactorModel.this.findModelsDeeply(it, model);
        }
      };
      final Set<GraphModel> usedModelsExceptModel = IterableExtensions.<GraphModel>toSet(IterableExtensions.<DAD, GraphModel>flatMap(this.<DAD>lookup(DAD.class), _function_5));
      final Function1<GraphModel, IFile> _function_6 = new Function1<GraphModel, IFile>() {
        @Override
        public IFile apply(final GraphModel it) {
          return RefactorModel.this._workspaceExtension.getFile(it);
        }
      };
      int _size_2 = IterableExtensions.size(IterableExtensions.<GraphModel, IFile>map(usedModelsExceptModel, _function_6));
      String _plus_5 = ("DADs.usedModels.exceptModel: " + Integer.valueOf(_size_2));
      InputOutput.<String>println(_plus_5);
      final Function1<GraphModel, IFile> _function_7 = new Function1<GraphModel, IFile>() {
        @Override
        public IFile apply(final GraphModel it) {
          return RefactorModel.this._workspaceExtension.getFile(it);
        }
      };
      final Consumer<IFile> _function_8 = new Consumer<IFile>() {
        @Override
        public void accept(final IFile it) {
        }
      };
      IterableExtensions.<GraphModel, IFile>map(usedModelsExceptModel, _function_7).forEach(_function_8);
      final Function1<GraphModel, Boolean> _function_9 = new Function1<GraphModel, Boolean>() {
        @Override
        public Boolean apply(final GraphModel it) {
          return Boolean.valueOf(usedModelsExceptModel.contains(it));
        }
      };
      final Set<GraphModel> modelOnlyModels = IterableExtensions.<GraphModel>toSet(this._collectionExtension.<GraphModel>drop(modelDeepModels, _function_9));
      int _size_3 = modelOnlyModels.size();
      String _plus_6 = ("Model-only models: " + Integer.valueOf(_size_3));
      InputOutput.<String>println(_plus_6);
      final Function1<GraphModel, IFile> _function_10 = new Function1<GraphModel, IFile>() {
        @Override
        public IFile apply(final GraphModel it) {
          return RefactorModel.this._workspaceExtension.getFile(it);
        }
      };
      final Consumer<IFile> _function_11 = new Consumer<IFile>() {
        @Override
        public void accept(final IFile it) {
        }
      };
      IterableExtensions.<GraphModel, IFile>map(modelOnlyModels, _function_10).forEach(_function_11);
      final Set<GraphModel> extendingModels = this.getAllExtendingModels();
      int _size_4 = extendingModels.size();
      String _plus_7 = ("All extending models: " + Integer.valueOf(_size_4));
      InputOutput.<String>println(_plus_7);
      final Function1<GraphModel, IFile> _function_12 = new Function1<GraphModel, IFile>() {
        @Override
        public IFile apply(final GraphModel it) {
          return RefactorModel.this._workspaceExtension.getFile(it);
        }
      };
      final Consumer<IFile> _function_13 = new Consumer<IFile>() {
        @Override
        public void accept(final IFile it) {
        }
      };
      IterableExtensions.<GraphModel, IFile>map(extendingModels, _function_12).forEach(_function_13);
      final Function1<GraphModel, Boolean> _function_14 = new Function1<GraphModel, Boolean>() {
        @Override
        public Boolean apply(final GraphModel it) {
          boolean _xblockexpression = false;
          {
            final List<GraphModel> superTypes = RefactorModel.this.getExtensionHierarchy(it);
            _xblockexpression = (RefactorModel.this.containsAnyOf(superTypes, modelOnlyModels) && (!RefactorModel.this.containsAnyOf(superTypes, usedModelsExceptModel)));
          }
          return Boolean.valueOf(_xblockexpression);
        }
      };
      final Set<GraphModel> modelOnlyExtendingModels = IterableExtensions.<GraphModel>toSet(IterableExtensions.<GraphModel>filter(extendingModels, _function_14));
      int _size_5 = modelOnlyExtendingModels.size();
      String _plus_8 = ("Models extending model-only models: " + Integer.valueOf(_size_5));
      InputOutput.<String>println(_plus_8);
      final Function1<GraphModel, IFile> _function_15 = new Function1<GraphModel, IFile>() {
        @Override
        public IFile apply(final GraphModel it) {
          return RefactorModel.this._workspaceExtension.getFile(it);
        }
      };
      final Consumer<IFile> _function_16 = new Consumer<IFile>() {
        @Override
        public void accept(final IFile it) {
        }
      };
      IterableExtensions.<GraphModel, IFile>map(modelOnlyExtendingModels, _function_15).forEach(_function_16);
      modelOnlyModels.addAll(modelOnlyExtendingModels);
      int _size_6 = modelOnlyModels.size();
      String _plus_9 = ("Model-only models now: " + Integer.valueOf(_size_6));
      InputOutput.<String>println(_plus_9);
      final Function1<GraphModel, Boolean> _function_17 = new Function1<GraphModel, Boolean>() {
        @Override
        public Boolean apply(final GraphModel it) {
          return Boolean.valueOf(usedModels.contains(it));
        }
      };
      final Function1<GraphModel, Boolean> _function_18 = new Function1<GraphModel, Boolean>() {
        @Override
        public Boolean apply(final GraphModel it) {
          return Boolean.valueOf(RefactorModel.this.containsAnyOf(RefactorModel.this.getExtensionHierarchy(it), usedModels));
        }
      };
      final Set<GraphModel> unusedModels = IterableExtensions.<GraphModel>toSet(this._collectionExtension.<GraphModel>drop(this._collectionExtension.<GraphModel>drop(this.<GraphModel>lookup(GraphModel.class), _function_17), _function_18));
      int _size_7 = unusedModels.size();
      String _plus_10 = ("Unused models: " + Integer.valueOf(_size_7));
      InputOutput.<String>println(_plus_10);
      final Function1<GraphModel, IFile> _function_19 = new Function1<GraphModel, IFile>() {
        @Override
        public IFile apply(final GraphModel it) {
          return RefactorModel.this._workspaceExtension.getFile(it);
        }
      };
      final Consumer<IFile> _function_20 = new Consumer<IFile>() {
        @Override
        public void accept(final IFile it) {
        }
      };
      IterableExtensions.<GraphModel, IFile>map(unusedModels, _function_19).forEach(_function_20);
      final Function1<GraphModel, Boolean> _function_21 = new Function1<GraphModel, Boolean>() {
        @Override
        public Boolean apply(final GraphModel it) {
          return Boolean.valueOf(RefactorModel.this.containsAnyOf(RefactorModel.this.findModelsDeeply(it), modelOnlyModels));
        }
      };
      final Set<GraphModel> unusedModelsReferencingModel = IterableExtensions.<GraphModel>toSet(IterableExtensions.<GraphModel>filter(unusedModels, _function_21));
      int _size_8 = unusedModelsReferencingModel.size();
      String _plus_11 = ("Unused models referencing model: " + Integer.valueOf(_size_8));
      InputOutput.<String>println(_plus_11);
      final Function1<GraphModel, IFile> _function_22 = new Function1<GraphModel, IFile>() {
        @Override
        public IFile apply(final GraphModel it) {
          return RefactorModel.this._workspaceExtension.getFile(it);
        }
      };
      final Consumer<IFile> _function_23 = new Consumer<IFile>() {
        @Override
        public void accept(final IFile it) {
        }
      };
      IterableExtensions.<GraphModel, IFile>map(unusedModelsReferencingModel, _function_22).forEach(_function_23);
      modelOnlyModels.addAll(unusedModelsReferencingModel);
      int _size_9 = modelOnlyModels.size();
      String _plus_12 = ("Model-only models now: " + Integer.valueOf(_size_9));
      InputOutput.<String>println(_plus_12);
      final String newProjectBaseName = sib.getCachedReferencedObjectName();
      String newProjectName = newProjectBaseName;
      int i = 2;
      while (this._workspaceExtension.getWorkspaceRoot().getProject(newProjectName).exists()) {
        int _plusPlus = i++;
        String _plus_13 = (newProjectBaseName + Integer.valueOf(_plusPlus));
        newProjectName = _plus_13;
      }
      InputOutput.<String>println(("Create project " + newProjectName));
      ProjectDescription _projectDescription = new ProjectDescription(newProjectName);
      final Procedure1<ProjectDescription> _function_24 = new Procedure1<ProjectDescription>() {
        @Override
        public void apply(final ProjectDescription it) {
          it.setType(ProjectType.JAVA);
        }
      };
      final IProject newProject = ObjectExtensions.<ProjectDescription>operator_doubleArrow(_projectDescription, _function_24).create();
      final Consumer<GUI> _function_25 = new Consumer<GUI>() {
        @Override
        public void accept(final GUI gui) {
          final Function1<String, Boolean> _function = new Function1<String, Boolean>() {
            @Override
            public Boolean apply(final String it) {
              return Boolean.valueOf(it.startsWith("http"));
            }
          };
          final Consumer<String> _function_1 = new Consumer<String>() {
            @Override
            public void accept(final String sheet) {
              try {
                IProject _project = RefactorModel.this._workspaceExtension.getProject(gui);
                Path _path = new Path(sheet);
                RefactorModel.this.copyTo(_project.getFile(_path), newProject);
              } catch (final Throwable _t) {
                if (_t instanceof Exception) {
                  final Exception e = (Exception)_t;
                  e.printStackTrace();
                } else {
                  throw Exceptions.sneakyThrow(_t);
                }
              }
            }
          };
          RefactorModel.this._collectionExtension.<String>drop(gui.getAdditionalStylesheets(), _function).forEach(_function_1);
        }
      };
      Iterables.<GUI>filter(modelOnlyModels, GUI.class).forEach(_function_25);
      final Function1<GraphModel, IFile> _function_26 = new Function1<GraphModel, IFile>() {
        @Override
        public IFile apply(final GraphModel it) {
          IFile _xblockexpression = null;
          {
            InputOutput.<String>println(("Model: " + it));
            _xblockexpression = RefactorModel.this._workspaceExtension.getFile(it);
          }
          return _xblockexpression;
        }
      };
      final Consumer<IFile> _function_27 = new Consumer<IFile>() {
        @Override
        public void accept(final IFile it) {
          RefactorModel.this.moveTo(it, newProject);
        }
      };
      IterableExtensions.<GraphModel, IFile>map(modelOnlyModels, _function_26).forEach(_function_27);
      IWorkspaceRoot _workspaceRoot = this._workspaceExtension.getWorkspaceRoot();
      NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
      _workspaceRoot.refreshLocal(IProject.DEPTH_INFINITE, _nullProgressMonitor);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public void copyTo(final IFile file, final IProject targetProject) {
    try {
      IPath _removeLastSegments = file.getProjectRelativePath().removeLastSegments(1);
      String _plus = ("Create folder " + _removeLastSegments);
      InputOutput.<String>println(_plus);
      this._workspaceExtension.createFolder(targetProject, file.getProjectRelativePath().removeLastSegments(1));
      final IPath targetPath = targetProject.getFullPath().append(file.getProjectRelativePath());
      InputOutput.<String>println(((("Copy file " + file) + " to ") + targetPath));
      NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
      file.copy(targetPath, true, _nullProgressMonitor);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public void moveTo(final IFile file, final IProject targetProject) {
    try {
      InputOutput.<String>println(("Move file " + file));
      IPath _removeLastSegments = file.getProjectRelativePath().removeLastSegments(1);
      String _plus = (" > create folder: " + _removeLastSegments);
      InputOutput.<String>println(_plus);
      this._workspaceExtension.createFolder(targetProject, file.getProjectRelativePath().removeLastSegments(1));
      final IPath targetPath = targetProject.getFullPath().append(file.getProjectRelativePath());
      InputOutput.<String>println((" > target path: " + targetPath));
      NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
      file.move(targetPath, true, _nullProgressMonitor);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public <T extends EObject> Set<T> lookup(final Class<T> clazz) {
    return ReferenceRegistry.getInstance().<T>lookup(clazz);
  }
  
  public Set<GraphModel> findModelsDeeply(final GraphModel model) {
    return IterableExtensions.<GraphModel>toSet(this._graphModelExtension.<GraphModel>findDeeply(model, GraphModel.class, this.primerefs()));
  }
  
  public Set<GraphModel> findModelsDeeply(final GraphModel model, final GraphModel except) {
    return IterableExtensions.<GraphModel>toSet(this._graphModelExtension.<GraphModel>findDeeply(model, GraphModel.class, this.primerefs(except)));
  }
  
  public Set<info.scce.dime.process.process.Process> findProcessesDeeply(final GraphModel model) {
    return IterableExtensions.<info.scce.dime.process.process.Process>toSet(this._graphModelExtension.<info.scce.dime.process.process.Process>findDeeply(model, info.scce.dime.process.process.Process.class, this.primerefs()));
  }
  
  public Set<info.scce.dime.process.process.Process> findProcessesDeeply(final GraphModel model, final GraphModel except) {
    return IterableExtensions.<info.scce.dime.process.process.Process>toSet(this._graphModelExtension.<info.scce.dime.process.process.Process>findDeeply(model, info.scce.dime.process.process.Process.class, this.primerefs(except)));
  }
  
  public Set<GUI> findGUIsDeeply(final GraphModel model) {
    return IterableExtensions.<GUI>toSet(this._graphModelExtension.<GUI>findDeeply(model, GUI.class, this.primerefs()));
  }
  
  public Set<GUI> findGUIsDeeply(final GraphModel model, final GraphModel except) {
    return IterableExtensions.<GUI>toSet(this._graphModelExtension.<GUI>findDeeply(model, GUI.class, this.primerefs(except)));
  }
  
  public Function1<? super IdentifiableElement, ? extends ModelElementContainer> primerefs() {
    return this.primerefs(null);
  }
  
  public Function1<? super IdentifiableElement, ? extends ModelElementContainer> primerefs(final GraphModel except) {
    final Function1<IdentifiableElement, ModelElementContainer> _function = new Function1<IdentifiableElement, ModelElementContainer>() {
      @Override
      public ModelElementContainer apply(final IdentifiableElement it) {
        GraphModel _switchResult = null;
        boolean _matched = false;
        if (it instanceof GUISIB) {
          _matched=true;
          _switchResult = ((GUISIB)it).getGui();
        }
        if (!_matched) {
          if (it instanceof ProcessSIB) {
            _matched=true;
            info.scce.dime.process.process.Process _proMod = ((ProcessSIB)it).getProMod();
            _switchResult = ((info.scce.dime.process.process.Process) _proMod);
          }
        }
        if (!_matched) {
          if (it instanceof SecuritySIB) {
            _matched=true;
            info.scce.dime.process.process.Process _proMod = ((SecuritySIB)it).getProMod();
            _switchResult = ((info.scce.dime.process.process.Process) _proMod);
          }
        }
        if (!_matched) {
          if (it instanceof GuardSIB) {
            _matched=true;
            info.scce.dime.process.process.Process _process = ((GuardSIB)it).getProcess();
            _switchResult = ((info.scce.dime.process.process.Process) _process);
          }
        }
        if (!_matched) {
          if (it instanceof info.scce.dime.process.process.GUISIB) {
            _matched=true;
            _switchResult = ((info.scce.dime.process.process.GUISIB)it).getGui();
          }
        }
        if (!_matched) {
          if (it instanceof info.scce.dime.process.process.ProcessSIB) {
            _matched=true;
            _switchResult = ((info.scce.dime.process.process.ProcessSIB)it).getProMod();
          }
        }
        if (!_matched) {
          if (it instanceof GuardedProcessSIB) {
            _matched=true;
            _switchResult = ((GuardedProcessSIB)it).getProMod();
          }
        }
        if (!_matched) {
          if (it instanceof GuardProcessSIB) {
            _matched=true;
            _switchResult = ((GuardProcessSIB)it).getSecurityProcess();
          }
        }
        if (!_matched) {
          if (it instanceof ProcessComponent) {
            _matched=true;
            _switchResult = ((ProcessComponent)it).getModel();
          }
        }
        if (!_matched) {
          if (it instanceof LoginComponent) {
            _matched=true;
            _switchResult = ((LoginComponent)it).getModel();
          }
        }
        if (!_matched) {
          if (it instanceof FindLoginUserComponent) {
            _matched=true;
            _switchResult = ((FindLoginUserComponent)it).getModel();
          }
        }
        GraphModel _ifNot = null;
        if (_switchResult!=null) {
          GraphModel _switchResult_1 = null;
          boolean _matched_1 = false;
          if (it instanceof GUISIB) {
            _matched_1=true;
            _switchResult_1 = ((GUISIB)it).getGui();
          }
          if (!_matched_1) {
            if (it instanceof ProcessSIB) {
              _matched_1=true;
              info.scce.dime.process.process.Process _proMod = ((ProcessSIB)it).getProMod();
              _switchResult_1 = ((info.scce.dime.process.process.Process) _proMod);
            }
          }
          if (!_matched_1) {
            if (it instanceof SecuritySIB) {
              _matched_1=true;
              info.scce.dime.process.process.Process _proMod = ((SecuritySIB)it).getProMod();
              _switchResult_1 = ((info.scce.dime.process.process.Process) _proMod);
            }
          }
          if (!_matched_1) {
            if (it instanceof GuardSIB) {
              _matched_1=true;
              info.scce.dime.process.process.Process _process = ((GuardSIB)it).getProcess();
              _switchResult_1 = ((info.scce.dime.process.process.Process) _process);
            }
          }
          if (!_matched_1) {
            if (it instanceof info.scce.dime.process.process.GUISIB) {
              _matched_1=true;
              _switchResult_1 = ((info.scce.dime.process.process.GUISIB)it).getGui();
            }
          }
          if (!_matched_1) {
            if (it instanceof info.scce.dime.process.process.ProcessSIB) {
              _matched_1=true;
              _switchResult_1 = ((info.scce.dime.process.process.ProcessSIB)it).getProMod();
            }
          }
          if (!_matched_1) {
            if (it instanceof GuardedProcessSIB) {
              _matched_1=true;
              _switchResult_1 = ((GuardedProcessSIB)it).getProMod();
            }
          }
          if (!_matched_1) {
            if (it instanceof GuardProcessSIB) {
              _matched_1=true;
              _switchResult_1 = ((GuardProcessSIB)it).getSecurityProcess();
            }
          }
          if (!_matched_1) {
            if (it instanceof ProcessComponent) {
              _matched_1=true;
              _switchResult_1 = ((ProcessComponent)it).getModel();
            }
          }
          if (!_matched_1) {
            if (it instanceof LoginComponent) {
              _matched_1=true;
              _switchResult_1 = ((LoginComponent)it).getModel();
            }
          }
          if (!_matched_1) {
            if (it instanceof FindLoginUserComponent) {
              _matched_1=true;
              _switchResult_1 = ((FindLoginUserComponent)it).getModel();
            }
          }
          _ifNot=RefactorModel.this.<GraphModel>ifNot(_switchResult, except);
        }
        return _ifNot;
      }
    };
    return _function;
  }
  
  public <T extends GraphModel> T ifNot(final T a, final GraphModel b) {
    T _xifexpression = null;
    boolean _notEquals = this._graphModelExtension.operator_notEquals(a, b);
    if (_notEquals) {
      _xifexpression = a;
    } else {
      _xifexpression = null;
    }
    return _xifexpression;
  }
  
  public boolean containsAnyOf(final Collection<?> c1, final Collection<?> c2) {
    boolean _disjoint = Collections.disjoint(c1, c2);
    return (!_disjoint);
  }
  
  public GUI getExtendedModel(final GraphModel it) {
    GUI _switchResult = null;
    boolean _matched = false;
    if (it instanceof GUI) {
      _matched=true;
      _switchResult = this.getExtendedGUI(((GUI)it));
    }
    return _switchResult;
  }
  
  public GUI getExtendedGUI(final GUI it) {
    EList<ExtensionContext> _extensionContexts = it.getExtensionContexts();
    Iterable<GUISIB> _flatMap = null;
    if (_extensionContexts!=null) {
      final Function1<ExtensionContext, Iterable<GUISIB>> _function = new Function1<ExtensionContext, Iterable<GUISIB>>() {
        @Override
        public Iterable<GUISIB> apply(final ExtensionContext it) {
          return RefactorModel.this._graphModelExtension.<GUISIB>find(it, GUISIB.class);
        }
      };
      _flatMap=IterableExtensions.<ExtensionContext, GUISIB>flatMap(_extensionContexts, _function);
    }
    GUISIB _head = null;
    if (_flatMap!=null) {
      _head=IterableExtensions.<GUISIB>head(_flatMap);
    }
    GUI _gui = null;
    if (_head!=null) {
      _gui=_head.getGui();
    }
    return _gui;
  }
  
  public Set<GUI> getExtendingGUIs(final GUI gui) {
    final Function1<GUI, Boolean> _function = new Function1<GUI, Boolean>() {
      @Override
      public Boolean apply(final GUI it) {
        GUI _extendedModel = RefactorModel.this.getExtendedModel(it);
        return Boolean.valueOf(RefactorModel.this._graphModelExtension.operator_equals(_extendedModel, gui));
      }
    };
    return IterableExtensions.<GUI>toSet(IterableExtensions.<GUI>filter(this.<GUI>lookup(GUI.class), _function));
  }
  
  public Set<GUI> getAllExtendingGUIs() {
    final Function1<GUI, Boolean> _function = new Function1<GUI, Boolean>() {
      @Override
      public Boolean apply(final GUI it) {
        GUI _extendedModel = RefactorModel.this.getExtendedModel(it);
        return Boolean.valueOf((_extendedModel != null));
      }
    };
    return IterableExtensions.<GUI>toSet(IterableExtensions.<GUI>filter(this.<GUI>lookup(GUI.class), _function));
  }
  
  public Set<info.scce.dime.process.process.Process> getExtendingProcesses(final info.scce.dime.process.process.Process process) {
    final Function1<info.scce.dime.process.process.Process, Boolean> _function = new Function1<info.scce.dime.process.process.Process, Boolean>() {
      @Override
      public Boolean apply(final info.scce.dime.process.process.Process it) {
        GUI _extendedModel = RefactorModel.this.getExtendedModel(it);
        return Boolean.valueOf(RefactorModel.this._graphModelExtension.operator_equals(_extendedModel, process));
      }
    };
    return IterableExtensions.<info.scce.dime.process.process.Process>toSet(IterableExtensions.<info.scce.dime.process.process.Process>filter(this.<info.scce.dime.process.process.Process>lookup(info.scce.dime.process.process.Process.class), _function));
  }
  
  public Set<info.scce.dime.process.process.Process> getAllExtendingProcesses() {
    final Function1<info.scce.dime.process.process.Process, Boolean> _function = new Function1<info.scce.dime.process.process.Process, Boolean>() {
      @Override
      public Boolean apply(final info.scce.dime.process.process.Process it) {
        GUI _extendedModel = RefactorModel.this.getExtendedModel(it);
        return Boolean.valueOf((_extendedModel != null));
      }
    };
    return IterableExtensions.<info.scce.dime.process.process.Process>toSet(IterableExtensions.<info.scce.dime.process.process.Process>filter(this.<info.scce.dime.process.process.Process>lookup(info.scce.dime.process.process.Process.class), _function));
  }
  
  public Set<GraphModel> getExtendingModels(final GraphModel model) {
    final Function1<GraphModel, Boolean> _function = new Function1<GraphModel, Boolean>() {
      @Override
      public Boolean apply(final GraphModel it) {
        GUI _extendedModel = RefactorModel.this.getExtendedModel(it);
        return Boolean.valueOf(RefactorModel.this._graphModelExtension.operator_equals(_extendedModel, model));
      }
    };
    return IterableExtensions.<GraphModel>toSet(IterableExtensions.<GraphModel>filter(this.<GraphModel>lookup(GraphModel.class), _function));
  }
  
  public Set<GraphModel> getAllExtendingModels() {
    final Function1<GraphModel, Boolean> _function = new Function1<GraphModel, Boolean>() {
      @Override
      public Boolean apply(final GraphModel it) {
        GUI _extendedModel = RefactorModel.this.getExtendedModel(it);
        return Boolean.valueOf((_extendedModel != null));
      }
    };
    return IterableExtensions.<GraphModel>toSet(IterableExtensions.<GraphModel>filter(this.<GraphModel>lookup(GraphModel.class), _function));
  }
  
  public List<GraphModel> getExtensionHierarchy(final GraphModel model) {
    Iterable<GUI> _elvis = null;
    GUI _extendedModel = this.getExtendedModel(model);
    Iterable<GUI> _extensionHierarchy = null;
    if (_extendedModel!=null) {
      _extensionHierarchy=this.getExtensionHierarchy(_extendedModel);
    }
    if (_extensionHierarchy != null) {
      _elvis = _extensionHierarchy;
    } else {
      _elvis = Collections.<GUI>unmodifiableList(CollectionLiterals.<GUI>newArrayList());
    }
    return IterableExtensions.<GraphModel>toList(Iterables.<GraphModel>concat(Collections.<GraphModel>unmodifiableList(CollectionLiterals.<GraphModel>newArrayList(model)), _elvis));
  }
  
  public Iterable<GUI> getExtensionHierarchy(final GUI gui) {
    Iterable<GUI> _elvis = null;
    GUI _extendedGUI = this.getExtendedGUI(gui);
    Iterable<GUI> _extensionHierarchy = null;
    if (_extendedGUI!=null) {
      _extensionHierarchy=this.getExtensionHierarchy(_extendedGUI);
    }
    if (_extensionHierarchy != null) {
      _elvis = _extensionHierarchy;
    } else {
      _elvis = Collections.<GUI>unmodifiableList(CollectionLiterals.<GUI>newArrayList());
    }
    return IterableExtensions.<GUI>toList(Iterables.<GUI>concat(Collections.<GUI>unmodifiableList(CollectionLiterals.<GUI>newArrayList(gui)), _elvis));
  }
  
  public Iterable<info.scce.dime.process.process.Process> getExtensionHierarchy(final info.scce.dime.process.process.Process process) {
    return IterableExtensions.<info.scce.dime.process.process.Process>toList(Collections.<info.scce.dime.process.process.Process>unmodifiableList(CollectionLiterals.<info.scce.dime.process.process.Process>newArrayList(process)));
  }
}
