/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.profile.actions;

import graphmodel.Node;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.profile.api.ProfileExtension;
import info.scce.dime.profile.profile.Branch;
import info.scce.dime.profile.profile.IO;
import info.scce.dime.profile.profile.SIB;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.InputOutput;

@SuppressWarnings("all")
public class OpenModel extends DIMECustomAction<Node> {
  @Extension
  private ProfileExtension _profileExtension = new ProfileExtension();
  
  @Override
  public void execute(final Node it) {
    String _name = it.eClass().getName();
    String _plus = ("Opening submodel for " + _name);
    InputOutput.<String>println(_plus);
    EObject _switchResult = null;
    boolean _matched = false;
    if (it instanceof SIB) {
      _matched=true;
      _switchResult = this._profileExtension.getReferencedObject(((SIB)it));
    }
    if (!_matched) {
      if (it instanceof Branch) {
        _matched=true;
        _switchResult = this._profileExtension.getReferencedObject(((Branch)it));
      }
    }
    if (!_matched) {
      if (it instanceof IO) {
        _matched=true;
        _switchResult = this._profileExtension.getReferencedObject(((IO)it));
      }
    }
    if (_switchResult!=null) {
      EObject _switchResult_1 = null;
      boolean _matched_1 = false;
      if (it instanceof SIB) {
        _matched_1=true;
        _switchResult_1 = this._profileExtension.getReferencedObject(((SIB)it));
      }
      if (!_matched_1) {
        if (it instanceof Branch) {
          _matched_1=true;
          _switchResult_1 = this._profileExtension.getReferencedObject(((Branch)it));
        }
      }
      if (!_matched_1) {
        if (it instanceof IO) {
          _matched_1=true;
          _switchResult_1 = this._profileExtension.getReferencedObject(((IO)it));
        }
      }
      this._workbenchExtension.openEditor(_switchResult);
    }
  }
  
  @Override
  public boolean hasDoneChanges() {
    return false;
  }
}
