/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.profile.actions;

import de.jabc.cinco.meta.core.referenceregistry.ReferenceRegistry;
import de.jabc.cinco.meta.runtime.action.CincoCustomAction;
import graphmodel.ModelElementContainer;
import info.scce.dime.profile.actions.Replace;
import info.scce.dime.profile.api.ProfileExtension;
import info.scce.dime.profile.profile.BlueprintSIB;
import info.scce.dime.profile.profile.Profile;
import info.scce.dime.profile.util.ReplacementStrategy;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.jooq.lambda.Seq;

@SuppressWarnings("all")
public class ApplyProfile extends CincoCustomAction<Profile> {
  @Extension
  private ProfileExtension _profileExtension = new ProfileExtension();
  
  @Extension
  private ReplacementStrategy _replacementStrategy = new ReplacementStrategy();
  
  private final HashSet<URI> replacementAffectedURIs = CollectionLiterals.<URI>newHashSet();
  
  @Override
  public String getName() {
    return "Apply Profile";
  }
  
  @Override
  public void execute(final Profile profile) {
    final Function1<BlueprintSIB, Boolean> _function = new Function1<BlueprintSIB, Boolean>() {
      @Override
      public Boolean apply(final BlueprintSIB it) {
        return Boolean.valueOf(ApplyProfile.this.isReplacable(it));
      }
    };
    final Procedure1<Seq<BlueprintSIB>> _function_1 = new Procedure1<Seq<BlueprintSIB>>() {
      @Override
      public void apply(final Seq<BlueprintSIB> it) {
        final Consumer<BlueprintSIB> _function = new Consumer<BlueprintSIB>() {
          @Override
          public void accept(final BlueprintSIB it) {
            ApplyProfile.this.replace(it);
          }
        };
        it.forEach(_function);
      }
    };
    final Procedure1<Seq<BlueprintSIB>> _function_2 = new Procedure1<Seq<BlueprintSIB>>() {
      @Override
      public void apply(final Seq<BlueprintSIB> it) {
        final Consumer<BlueprintSIB> _function = new Consumer<BlueprintSIB>() {
          @Override
          public void accept(final BlueprintSIB it) {
            String _name = null;
            if (it!=null) {
              _name=ApplyProfile.this._profileExtension.getName(it);
            }
            String _plus = ("Skipping replacement of Blueprint SIB " + _name);
            String _plus_1 = (_plus + " in Profile ");
            String _name_1 = profile.getName();
            String _plus_2 = (_plus_1 + _name_1);
            String _plus_3 = (_plus_2 + " (replacement conditions not fulfilled)");
            InputOutput.<String>println(_plus_3);
          }
        };
        it.forEach(_function);
      }
    };
    this._collectionExtension.<BlueprintSIB>nonMatching(this._collectionExtension.<BlueprintSIB>matching(this._collectionExtension.<BlueprintSIB>partition(profile.getBlueprintSIBs(), _function), _function_1), _function_2);
  }
  
  public boolean isReplacable(final BlueprintSIB it) {
    return this._replacementStrategy.getReplacementConditionsFulfilled(it);
  }
  
  public Boolean replace(final BlueprintSIB blueprintSIB) {
    Boolean _xblockexpression = null;
    {
      String _cachedReferencedBlueprintSIBLabel = blueprintSIB.getCachedReferencedBlueprintSIBLabel();
      String _plus = ("[INFO] Replacing " + _cachedReferencedBlueprintSIBLabel);
      InputOutput.<String>println(_plus);
      final ModelElementContainer refSib = this._profileExtension.getReferencedObject(blueprintSIB);
      Resource _eResource = null;
      if (refSib!=null) {
        _eResource=refSib.eResource();
      }
      URI _uRI = null;
      if (_eResource!=null) {
        _uRI=_eResource.getURI();
      }
      final URI uri = _uRI;
      if ((uri != null)) {
        this.replacementAffectedURIs.add(uri);
      }
      _xblockexpression = new Replace().performReplacement(blueprintSIB);
    }
    return _xblockexpression;
  }
  
  public void cleanupRegistry() {
    final Consumer<URI> _function = new Consumer<URI>() {
      @Override
      public void accept(final URI uri) {
        InputOutput.<String>println(("[INFO] Cleanup replacements of " + uri));
        final Set<String> ids = ReferenceRegistry.getInstance().unregister(uri);
        if (ids!=null) {
          final Consumer<String> _function = new Consumer<String>() {
            @Override
            public void accept(final String it) {
              ReferenceRegistry.getInstance().unregister(it);
            }
          };
          ids.forEach(_function);
        }
        ReferenceRegistry.getInstance().enqueue(uri);
      }
    };
    this.replacementAffectedURIs.forEach(_function);
  }
}
