/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.vp;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.runtime.provider.CincoValuesProvider;
import graphmodel.ModelElement;
import graphmodel.internal.InternalNode;
import info.scce.dime.gui.helper.GUIExtension;
import info.scce.dime.gui.helper.GUIExtensionProvider;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.IgnoreBranch;
import info.scce.dime.process.process.SIB;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class IgnoreBranchPossibleValuesProvider extends CincoValuesProvider<IgnoreBranch, String> {
  @Extension
  private GUIExtension _gUIExtension = GUIExtensionProvider.guiextension();
  
  @Override
  public Map<String, String> getPossibleValues(final IgnoreBranch ib) {
    EObject _eContainer = ib.eContainer();
    ModelElement _element = ((InternalNode) _eContainer).getElement();
    final SIB sib = ((SIB) _element);
    final Function<String, String> _function = new Function<String, String>() {
      @Override
      public String apply(final String it) {
        String _lowerCase = null;
        if (it!=null) {
          _lowerCase=it.toLowerCase();
        }
        return _lowerCase;
      }
    };
    final TreeMap<String, String> ignorableBranches = CollectionLiterals.<String, String>newTreeMap(Comparator.<String, String>comparing(_function));
    this._gUIExtension.getIgnorableBranches(sib, ignorableBranches);
    final Function1<IgnoreBranch, String> _function_1 = new Function1<IgnoreBranch, String>() {
      @Override
      public String apply(final IgnoreBranch it) {
        return it.getName();
      }
    };
    final Iterable<String> ignoredBranches = IterableExtensions.<String>filterNull(ListExtensions.<IgnoreBranch, String>map(sib.getIgnoredBranch(), _function_1));
    final Function1<Branch, String> _function_2 = new Function1<Branch, String>() {
      @Override
      public String apply(final Branch it) {
        return it.getName();
      }
    };
    final Iterable<String> usedBranches = IterableExtensions.<String>filterNull(ListExtensions.<Branch, String>map(sib.getBranchSuccessors(), _function_2));
    Iterable<String> _plus = Iterables.<String>concat(ignoredBranches, usedBranches);
    for (final String branch : _plus) {
      String _name = ib.getName();
      boolean _notEquals = (!Objects.equal(branch, _name));
      if (_notEquals) {
        ignorableBranches.remove(branch);
      }
    }
    return ignorableBranches;
  }
}
