/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.vp;

import de.jabc.cinco.meta.runtime.provider.CincoValuesProvider;
import graphmodel.ModelElement;
import graphmodel.internal.InternalNode;
import info.scce.dime.process.process.AbstractBranch;
import info.scce.dime.process.process.GUIBlueprintSIB;
import info.scce.dime.process.process.GUISIB;
import info.scce.dime.process.process.GUISIBOptions;
import info.scce.dime.process.process.GenericSIB;
import info.scce.dime.process.process.SIB;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class GenericMinorPageMajorBranchPossibleValuesProvider extends CincoValuesProvider<GUISIBOptions, AbstractBranch> {
  @Override
  public Map<AbstractBranch, String> getPossibleValues(final GUISIBOptions options) {
    Map<AbstractBranch, String> _xblockexpression = null;
    {
      EObject _eContainer = options.eContainer();
      ModelElement _element = ((InternalNode) _eContainer).getElement();
      final GenericSIB genericSIB = ((GenericSIB) _element);
      Map<AbstractBranch, String> _xifexpression = null;
      boolean _isMajorPage = options.isMajorPage();
      if (_isMajorPage) {
        _xifexpression = Collections.<AbstractBranch, String>unmodifiableMap(CollectionLiterals.<AbstractBranch, String>newHashMap());
      } else {
        final Function1<AbstractBranch, Boolean> _function = new Function1<AbstractBranch, Boolean>() {
          @Override
          public Boolean apply(final AbstractBranch it) {
            boolean _switchResult = false;
            SIB _head = IterableExtensions.<SIB>head(it.getSIBPredecessors());
            final SIB it_1 = _head;
            boolean _matched = false;
            if (it_1 instanceof GUISIB) {
              if ((((GUISIB)it_1).isMajorPage() && (((GUISIB)it_1).getDefaultContent() != null))) {
                _matched=true;
                _switchResult = true;
              }
            }
            if (!_matched) {
              if (it_1 instanceof GUIBlueprintSIB) {
                if ((((GUIBlueprintSIB)it_1).isMajorPage() && (((GUIBlueprintSIB)it_1).getDefaultContent() != null))) {
                  _matched=true;
                  _switchResult = true;
                }
              }
            }
            if (!_matched) {
              if (it_1 instanceof GenericSIB) {
                if ((((((GenericSIB)it_1).getGuiOptions() != null) && ((GenericSIB)it_1).getGuiOptions().isMajorPage()) && (((GenericSIB)it_1).getGuiOptions().getDefaultContent() != null))) {
                  _matched=true;
                  _switchResult = true;
                }
              }
            }
            if (!_matched) {
              _switchResult = false;
            }
            return Boolean.valueOf(_switchResult);
          }
        };
        final Function1<AbstractBranch, AbstractBranch> _function_1 = new Function1<AbstractBranch, AbstractBranch>() {
          @Override
          public AbstractBranch apply(final AbstractBranch it) {
            return it;
          }
        };
        final Function1<AbstractBranch, String> _function_2 = new Function1<AbstractBranch, String>() {
          @Override
          public String apply(final AbstractBranch it) {
            StringConcatenation _builder = new StringConcatenation();
            String _label = IterableExtensions.<SIB>head(it.getSIBPredecessors()).getLabel();
            _builder.append(_label);
            _builder.append(": ");
            String _name = it.getName();
            _builder.append(_name);
            return _builder.toString();
          }
        };
        _xifexpression = IterableExtensions.<AbstractBranch, AbstractBranch, String>toMap(IterableExtensions.<AbstractBranch>toSet(IterableExtensions.<AbstractBranch>filter(this._graphModelExtension.<AbstractBranch>find(genericSIB.getRootElement(), AbstractBranch.class), _function)), _function_1, _function_2);
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
}
