/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.vp;

import de.jabc.cinco.meta.runtime.provider.CincoValuesProvider;
import graphmodel.ModelElement;
import graphmodel.internal.InternalNode;
import info.scce.dime.process.helper.ProcessExtension;
import info.scce.dime.process.process.GUISIBOptions;
import info.scce.dime.process.process.GenericSIB;
import info.scce.dime.process.process.SIB;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class GenericMajorPageDefaultContentPossibleValuesProvider extends CincoValuesProvider<GUISIBOptions, SIB> {
  @Extension
  private ProcessExtension _processExtension = new ProcessExtension();
  
  @Override
  public Map<SIB, String> getPossibleValues(final GUISIBOptions options) {
    Map<SIB, String> _xblockexpression = null;
    {
      EObject _eContainer = options.eContainer();
      ModelElement _element = ((InternalNode) _eContainer).getElement();
      final GenericSIB genericSIB = ((GenericSIB) _element);
      Map<SIB, String> _xifexpression = null;
      boolean _isMajorPage = options.isMajorPage();
      boolean _not = (!_isMajorPage);
      if (_not) {
        _xifexpression = Collections.<SIB, String>unmodifiableMap(CollectionLiterals.<SIB, String>newHashMap());
      } else {
        final Function1<SIB, Boolean> _function = new Function1<SIB, Boolean>() {
          @Override
          public Boolean apply(final SIB it) {
            return Boolean.valueOf(GenericMajorPageDefaultContentPossibleValuesProvider.this._processExtension.isMinor(it));
          }
        };
        final Function1<SIB, SIB> _function_1 = new Function1<SIB, SIB>() {
          @Override
          public SIB apply(final SIB it) {
            return it;
          }
        };
        final Function1<SIB, String> _function_2 = new Function1<SIB, String>() {
          @Override
          public String apply(final SIB it) {
            return it.getLabel();
          }
        };
        _xifexpression = IterableExtensions.<SIB, SIB, String>toMap(IterableExtensions.<SIB>filter(genericSIB.getContainer().<SIB>getModelElements(SIB.class), _function), _function_1, _function_2);
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
}
