/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.hooks;

import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import graphmodel.Direction;
import graphmodel.GraphModel;
import graphmodel.ModelElement;
import graphmodel.Node;
import info.scce.dime.api.DIMEPostResizeHook;
import info.scce.dime.process.process.DataContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class ProcessNodePostResize<E extends ModelElement> extends DIMEPostResizeHook<E> {
  @Override
  public void postResize(final E node, final int oldWidth, final int oldHeight, final int oldX, final int oldY, final Direction direction) {
    if ((node instanceof Node)) {
      int _height = ((Node)node).getHeight();
      int _minus = (oldHeight - _height);
      this.updateDataContext(((Node) node), _minus);
    }
  }
  
  public void updateDataContext(final Node resizedNode, final int deltaHeight) {
    Display _display = new WorkbenchExtension().getDisplay();
    boolean _tripleEquals = (_display == null);
    if (_tripleEquals) {
      return;
    }
    final GraphModel model = resizedNode.getRootElement();
    final Iterable<Node> nodes = this._collectionExtension.<Node>drop(model.getAllNodes(), DataContext.class);
    boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(nodes);
    boolean _not = (!_isNullOrEmpty);
    if (_not) {
      final Function1<Node, Integer> _function = new Function1<Node, Integer>() {
        @Override
        public Integer apply(final Node it) {
          int _y = it.getY();
          int _height = it.getHeight();
          return Integer.valueOf((_y + _height));
        }
      };
      final Node botNode = IterableExtensions.<Node>head(ListExtensions.<Node>reverse(IterableExtensions.<Node, Integer>sortBy(nodes, _function)));
      Node _elvis = null;
      final Function1<Node, Boolean> _function_1 = new Function1<Node, Boolean>() {
        @Override
        public Boolean apply(final Node it) {
          return Boolean.valueOf(ProcessNodePostResize.this._dIMEGraphModelExtension.operator_notEquals(it, resizedNode));
        }
      };
      final Function1<Node, Integer> _function_2 = new Function1<Node, Integer>() {
        @Override
        public Integer apply(final Node it) {
          int _y = it.getY();
          int _height = it.getHeight();
          return Integer.valueOf((_y + _height));
        }
      };
      Node _head = IterableExtensions.<Node>head(ListExtensions.<Node>reverse(IterableExtensions.<Node, Integer>sortBy(IterableExtensions.<Node>filter(nodes, _function_1), _function_2)));
      if (_head != null) {
        _elvis = _head;
      } else {
        _elvis = botNode;
      }
      final Node scndBotNode = _elvis;
      int _y = resizedNode.getY();
      int _height = resizedNode.getHeight();
      int _plus = (_y + _height);
      int _minus = (_plus - deltaHeight);
      int _y_1 = scndBotNode.getY();
      int _height_1 = scndBotNode.getHeight();
      int _plus_1 = (_y_1 + _height_1);
      final int oldMax = Math.max(_minus, _plus_1);
      EList<DataContext> _nodes = model.<DataContext>getNodes(DataContext.class);
      for (final DataContext dataContext : _nodes) {
        {
          int _y_2 = dataContext.getY();
          int _height_2 = dataContext.getHeight();
          final int oldDataContextBot = (_y_2 + _height_2);
          Integer _elvis_1 = null;
          final Function1<Node, Integer> _function_3 = new Function1<Node, Integer>() {
            @Override
            public Integer apply(final Node it) {
              int _y = it.getY();
              int _height = it.getHeight();
              return Integer.valueOf((_y + _height));
            }
          };
          Integer _head_1 = IterableExtensions.<Integer>head(ListExtensions.<Integer>reverse(IterableExtensions.<Integer>sort(ListExtensions.<Node, Integer>map(dataContext.getAllNodes(), _function_3))));
          if (_head_1 != null) {
            _elvis_1 = _head_1;
          } else {
            _elvis_1 = Integer.valueOf(0);
          }
          final int minHeight = ((_elvis_1).intValue() + 17);
          if (((Math.abs((oldMax - oldDataContextBot)) < 2) || (dataContext.getHeight() == minHeight))) {
            int _y_3 = botNode.getY();
            int _height_3 = botNode.getHeight();
            int _plus_2 = (_y_3 + _height_3);
            int _y_4 = dataContext.getY();
            int _minus_1 = (_plus_2 - _y_4);
            int _height_4 = dataContext.getHeight();
            final int dY = (_minus_1 - _height_4);
            if ((dY != 0)) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("Resize data context height from ");
              int _height_5 = dataContext.getHeight();
              _builder.append(_height_5);
              _builder.append(" to ");
              int _y_5 = botNode.getY();
              int _height_6 = botNode.getHeight();
              int _plus_3 = (_y_5 + _height_6);
              int _y_6 = dataContext.getY();
              int _minus_2 = (_plus_3 - _y_6);
              _builder.append(_minus_2);
              _builder.append(" by dY=");
              _builder.append(dY);
              InputOutput.<String>println(_builder.toString());
              int _height_7 = dataContext.getHeight();
              int _plus_4 = (_height_7 + dY);
              dataContext.setHeight(Math.max(minHeight, _plus_4));
            }
          }
        }
      }
    }
  }
}
