/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.hooks;

import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import graphmodel.GraphModel;
import graphmodel.ModelElement;
import graphmodel.Node;
import info.scce.dime.api.DIMEPostDeleteHook;
import info.scce.dime.process.process.DataContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class ProcessNodePostDelete<E extends ModelElement> extends DIMEPostDeleteHook<E> {
  @Override
  public Runnable getPostDeleteFunction(final E node) {
    if ((node instanceof Node)) {
      final GraphModel model = node.getRootElement();
      final int delNodeY = ((Node)node).getY();
      final int delNodeHeight = ((Node)node).getHeight();
      final Runnable _function = new Runnable() {
        @Override
        public void run() {
          ProcessNodePostDelete.this.updateDataContext(model, delNodeY, delNodeHeight);
        }
      };
      return _function;
    }
    return null;
  }
  
  public void updateDataContext(final GraphModel model, final int delNodeY, final int delNodeHeight) {
    Display _display = new WorkbenchExtension().getDisplay();
    boolean _tripleEquals = (_display == null);
    if (_tripleEquals) {
      return;
    }
    final Iterable<Node> nodes = this._collectionExtension.<Node>drop(model.getAllNodes(), DataContext.class);
    boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(nodes);
    boolean _not = (!_isNullOrEmpty);
    if (_not) {
      final Function1<Node, Integer> _function = new Function1<Node, Integer>() {
        @Override
        public Integer apply(final Node it) {
          return Integer.valueOf(it.getY());
        }
      };
      final Node topNode = IterableExtensions.<Node>head(IterableExtensions.<Node, Integer>sortBy(nodes, _function));
      final int oldMin = Math.min(delNodeY, topNode.getY());
      final Function1<Node, Integer> _function_1 = new Function1<Node, Integer>() {
        @Override
        public Integer apply(final Node it) {
          int _y = it.getY();
          int _height = it.getHeight();
          return Integer.valueOf((_y + _height));
        }
      };
      final Node botNode = IterableExtensions.<Node>head(ListExtensions.<Node>reverse(IterableExtensions.<Node, Integer>sortBy(nodes, _function_1)));
      int _y = botNode.getY();
      int _height = botNode.getHeight();
      int _plus = (_y + _height);
      final int oldMax = Math.max((delNodeY + delNodeHeight), _plus);
      EList<DataContext> _nodes = model.<DataContext>getNodes(DataContext.class);
      for (final DataContext dataContext : _nodes) {
        {
          int _y_1 = dataContext.getY();
          int _height_1 = dataContext.getHeight();
          final int oldDataContextBot = (_y_1 + _height_1);
          int _y_2 = dataContext.getY();
          int _minus = (oldMin - _y_2);
          int _abs = Math.abs(_minus);
          boolean _lessThan = (_abs < 2);
          if (_lessThan) {
            int _y_3 = dataContext.getY();
            Integer _elvis = null;
            final Function1<Node, Integer> _function_2 = new Function1<Node, Integer>() {
              @Override
              public Integer apply(final Node it) {
                return Integer.valueOf(it.getY());
              }
            };
            Integer _head = IterableExtensions.<Integer>head(IterableExtensions.<Integer>sort(ListExtensions.<Node, Integer>map(dataContext.getAllNodes(), _function_2)));
            if (_head != null) {
              _elvis = _head;
            } else {
              _elvis = Integer.valueOf(0);
            }
            int _plus_1 = (_y_3 + (_elvis).intValue());
            final int maxY = (_plus_1 - 20);
            int _min = Math.min(maxY, topNode.getY());
            int _y_4 = dataContext.getY();
            final int dY = (_min - _y_4);
            if ((dY != 0)) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("Resize data context y/height from ");
              int _y_5 = dataContext.getY();
              _builder.append(_y_5);
              _builder.append("/");
              int _height_2 = dataContext.getHeight();
              _builder.append(_height_2);
              _builder.append(" to ");
              int _min_1 = Math.min(maxY, topNode.getY());
              _builder.append(_min_1);
              _builder.append("/");
              int _height_3 = dataContext.getHeight();
              int _minus_1 = (_height_3 - dY);
              _builder.append(_minus_1);
              _builder.append(" by dY=");
              _builder.append(dY);
              InputOutput.<String>println(_builder.toString());
              int _y_6 = dataContext.getY();
              int _plus_2 = (_y_6 + dY);
              dataContext.setY(_plus_2);
              EList<Node> _allNodes = dataContext.getAllNodes();
              for (final Node innerNode : _allNodes) {
                int _y_7 = innerNode.getY();
                int _minus_2 = (_y_7 - dY);
                innerNode.move(innerNode.getX(), Math.max(20, _minus_2));
              }
              int _height_4 = dataContext.getHeight();
              int _minus_3 = (_height_4 - dY);
              dataContext.setHeight(_minus_3);
            }
          }
          Integer _elvis_1 = null;
          final Function1<Node, Integer> _function_3 = new Function1<Node, Integer>() {
            @Override
            public Integer apply(final Node it) {
              int _y = it.getY();
              int _height = it.getHeight();
              return Integer.valueOf((_y + _height));
            }
          };
          Integer _head_1 = IterableExtensions.<Integer>head(ListExtensions.<Integer>reverse(IterableExtensions.<Integer>sort(ListExtensions.<Node, Integer>map(dataContext.getAllNodes(), _function_3))));
          if (_head_1 != null) {
            _elvis_1 = _head_1;
          } else {
            _elvis_1 = Integer.valueOf(0);
          }
          final int minHeight = ((_elvis_1).intValue() + 17);
          if (((Math.abs((oldMax - oldDataContextBot)) < 2) || (dataContext.getHeight() == minHeight))) {
            int _y_8 = botNode.getY();
            int _height_5 = botNode.getHeight();
            int _plus_3 = (_y_8 + _height_5);
            int _y_9 = dataContext.getY();
            int _minus_4 = (_plus_3 - _y_9);
            int _height_6 = dataContext.getHeight();
            final int dY2 = (_minus_4 - _height_6);
            if ((dY2 != 0)) {
              StringConcatenation _builder_1 = new StringConcatenation();
              _builder_1.append("Resize data context height from ");
              int _height_7 = dataContext.getHeight();
              _builder_1.append(_height_7);
              _builder_1.append(" to ");
              int _y_10 = botNode.getY();
              int _height_8 = botNode.getHeight();
              int _plus_4 = (_y_10 + _height_8);
              int _y_11 = dataContext.getY();
              int _minus_5 = (_plus_4 - _y_11);
              _builder_1.append(_minus_5);
              _builder_1.append(" by dY=");
              _builder_1.append(dY2);
              InputOutput.<String>println(_builder_1.toString());
              int _height_9 = dataContext.getHeight();
              int _plus_5 = (_height_9 + dY2);
              dataContext.setHeight(Math.max(minHeight, _plus_5));
            }
          }
        }
      }
    }
  }
}
