/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.hooks;

import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import graphmodel.GraphModel;
import graphmodel.ModelElement;
import graphmodel.Node;
import info.scce.dime.api.DIMEPostCreateHook;
import info.scce.dime.process.process.DataContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class ProcessNodePostCreate<E extends ModelElement> extends DIMEPostCreateHook<E> {
  @Override
  public void postCreate(final E node) {
    if ((node instanceof Node)) {
      this.updateDataContext(((Node) node));
    }
  }
  
  public void updateDataContext(final Node movedNode) {
    Display _display = new WorkbenchExtension().getDisplay();
    boolean _tripleEquals = (_display == null);
    if (_tripleEquals) {
      return;
    }
    final GraphModel model = movedNode.getRootElement();
    final Iterable<Node> nodes = this._collectionExtension.<Node>drop(model.getAllNodes(), DataContext.class);
    boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(nodes);
    boolean _not = (!_isNullOrEmpty);
    if (_not) {
      final Function1<Node, Integer> _function = new Function1<Node, Integer>() {
        @Override
        public Integer apply(final Node it) {
          return Integer.valueOf(it.getY());
        }
      };
      final Node topNode = IterableExtensions.<Node>head(IterableExtensions.<Node, Integer>sortBy(nodes, _function));
      Node _elvis = null;
      final Function1<Node, Boolean> _function_1 = new Function1<Node, Boolean>() {
        @Override
        public Boolean apply(final Node it) {
          return Boolean.valueOf(ProcessNodePostCreate.this._gUIExtension.operator_notEquals(it, movedNode));
        }
      };
      final Function1<Node, Integer> _function_2 = new Function1<Node, Integer>() {
        @Override
        public Integer apply(final Node it) {
          return Integer.valueOf(it.getY());
        }
      };
      Node _head = IterableExtensions.<Node>head(IterableExtensions.<Node, Integer>sortBy(IterableExtensions.<Node>filter(nodes, _function_1), _function_2));
      if (_head != null) {
        _elvis = _head;
      } else {
        _elvis = topNode;
      }
      final Node scndTopNode = _elvis;
      final int oldMin = scndTopNode.getY();
      final Function1<Node, Integer> _function_3 = new Function1<Node, Integer>() {
        @Override
        public Integer apply(final Node it) {
          int _y = it.getY();
          int _height = it.getHeight();
          return Integer.valueOf((_y + _height));
        }
      };
      final Node botNode = IterableExtensions.<Node>head(ListExtensions.<Node>reverse(IterableExtensions.<Node, Integer>sortBy(nodes, _function_3)));
      Node _elvis_1 = null;
      final Function1<Node, Boolean> _function_4 = new Function1<Node, Boolean>() {
        @Override
        public Boolean apply(final Node it) {
          return Boolean.valueOf(ProcessNodePostCreate.this._gUIExtension.operator_notEquals(it, movedNode));
        }
      };
      final Function1<Node, Integer> _function_5 = new Function1<Node, Integer>() {
        @Override
        public Integer apply(final Node it) {
          int _y = it.getY();
          int _height = it.getHeight();
          return Integer.valueOf((_y + _height));
        }
      };
      Node _head_1 = IterableExtensions.<Node>head(ListExtensions.<Node>reverse(IterableExtensions.<Node, Integer>sortBy(IterableExtensions.<Node>filter(nodes, _function_4), _function_5)));
      if (_head_1 != null) {
        _elvis_1 = _head_1;
      } else {
        _elvis_1 = botNode;
      }
      final Node scndBotNode = _elvis_1;
      int _y = scndBotNode.getY();
      int _height = scndBotNode.getHeight();
      final int oldMax = (_y + _height);
      EList<DataContext> _nodes = model.<DataContext>getNodes(DataContext.class);
      for (final DataContext dataContext : _nodes) {
        {
          int _y_1 = dataContext.getY();
          int _height_1 = dataContext.getHeight();
          final int oldDataContextBot = (_y_1 + _height_1);
          int _y_2 = dataContext.getY();
          int _minus = (oldMin - _y_2);
          int _abs = Math.abs(_minus);
          boolean _lessThan = (_abs < 2);
          if (_lessThan) {
            int _y_3 = topNode.getY();
            int _y_4 = dataContext.getY();
            final int dY = (_y_3 - _y_4);
            if ((dY != 0)) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("Resize data context y/height from ");
              int _y_5 = dataContext.getY();
              _builder.append(_y_5);
              _builder.append("/");
              int _height_2 = dataContext.getHeight();
              _builder.append(_height_2);
              _builder.append(" to ");
              int _y_6 = topNode.getY();
              _builder.append(_y_6);
              _builder.append("/");
              int _height_3 = dataContext.getHeight();
              int _minus_1 = (_height_3 - dY);
              _builder.append(_minus_1);
              _builder.append(" by dY=");
              _builder.append(dY);
              InputOutput.<String>println(_builder.toString());
              dataContext.setY(topNode.getY());
              EList<Node> _allNodes = dataContext.getAllNodes();
              for (final Node innerNode : _allNodes) {
                int _y_7 = innerNode.getY();
                int _minus_2 = (_y_7 - dY);
                innerNode.move(innerNode.getX(), Math.max(20, _minus_2));
              }
              int _height_4 = dataContext.getHeight();
              int _minus_3 = (_height_4 - dY);
              dataContext.setHeight(_minus_3);
            }
          }
          Integer _elvis_2 = null;
          final Function1<Node, Integer> _function_6 = new Function1<Node, Integer>() {
            @Override
            public Integer apply(final Node it) {
              int _y = it.getY();
              int _height = it.getHeight();
              return Integer.valueOf((_y + _height));
            }
          };
          Integer _head_2 = IterableExtensions.<Integer>head(ListExtensions.<Integer>reverse(IterableExtensions.<Integer>sort(ListExtensions.<Node, Integer>map(dataContext.getAllNodes(), _function_6))));
          if (_head_2 != null) {
            _elvis_2 = _head_2;
          } else {
            _elvis_2 = Integer.valueOf(0);
          }
          final int minHeight = ((_elvis_2).intValue() + 17);
          if (((Math.abs((oldMax - oldDataContextBot)) < 2) || (dataContext.getHeight() == minHeight))) {
            int _y_8 = botNode.getY();
            int _height_5 = botNode.getHeight();
            int _plus = (_y_8 + _height_5);
            int _y_9 = dataContext.getY();
            int _minus_4 = (_plus - _y_9);
            int _height_6 = dataContext.getHeight();
            final int dY2 = (_minus_4 - _height_6);
            if ((dY2 != 0)) {
              StringConcatenation _builder_1 = new StringConcatenation();
              _builder_1.append("Resize data context height from ");
              int _height_7 = dataContext.getHeight();
              _builder_1.append(_height_7);
              _builder_1.append(" to ");
              int _y_10 = botNode.getY();
              int _height_8 = botNode.getHeight();
              int _plus_1 = (_y_10 + _height_8);
              int _y_11 = dataContext.getY();
              int _minus_5 = (_plus_1 - _y_11);
              _builder_1.append(_minus_5);
              _builder_1.append(" by dY=");
              _builder_1.append(dY2);
              InputOutput.<String>println(_builder_1.toString());
              int _height_9 = dataContext.getHeight();
              int _plus_2 = (_height_9 + dY2);
              dataContext.setHeight(Math.max(minHeight, _plus_2));
            }
          }
        }
      }
    }
  }
}
