/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.hooks;

import graphmodel.ModelElementContainer;
import info.scce.dime.api.DIMEPostCreateHook;
import info.scce.dime.process.process.ProcessInputStatic;
import info.scce.dime.process.process.ProcessSIB;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class ProcessInputStaticHook extends DIMEPostCreateHook<ProcessInputStatic> {
  @Override
  public void postCreate(final ProcessInputStatic input) {
    ModelElementContainer _container = input.getContainer();
    boolean _tripleEquals = (Boolean.valueOf((_container instanceof ProcessInputStatic)) == Boolean.valueOf(false));
    if (_tripleEquals) {
      return;
    }
    ModelElementContainer _container_1 = input.getContainer();
    final ProcessInputStatic cParentInput = ((ProcessInputStatic) _container_1);
    ModelElementContainer _container_2 = cParentInput.getContainer();
    final ProcessSIB cSIB = ((ProcessSIB) _container_2);
    final Procedure1<ProcessInputStatic> _function = new Procedure1<ProcessInputStatic>() {
      @Override
      public void apply(final ProcessInputStatic it) {
        it.setName(cParentInput.getName());
        it.moveTo(cSIB, cParentInput.getX(), cParentInput.getY());
      }
    };
    ObjectExtensions.<ProcessInputStatic>operator_doubleArrow(input, _function);
    cParentInput.delete();
  }
}
