/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.hooks;

import graphmodel.ModelElementContainer;
import graphmodel.internal.InternalIdentifiableElement;
import graphmodel.internal.InternalModelElement;
import info.scce.dime.data.data.PrimitiveAttribute;
import info.scce.dime.data.data.Type;
import info.scce.dime.process.hooks.AbstractAttributePortHook;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.PrimitiveAttributePort;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.dime.process.process.SIB;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class PrimitiveAttributePortHook extends AbstractAttributePortHook<PrimitiveAttributePort> {
  /**
   * Replaces the {@link PrimitiveAttributePort} with a {@link PrimitiveInputPort}.
   */
  @Override
  public void postCreate(final PrimitiveAttributePort port) {
    final PrimitiveAttribute attr = port.getAttribute();
    Type _container = attr.getContainer();
    final Type type = ((Type) _container);
    ModelElementContainer _container_1 = port.getContainer();
    final SIB it = ((SIB) _container_1);
    InternalIdentifiableElement _internalElement_ = port.getInternalElement_();
    final InternalModelElement ime = ((InternalModelElement) _internalElement_);
    port.delete();
    port.setInternalElement_(ime);
    boolean _isTypeSIB = this.isTypeSIB(it);
    boolean _not = (!_isTypeSIB);
    if (_not) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("You may drop an attribute only on data SIBs (like create, retrieve, ...) and not on a sib of type \'");
      String _name = it.eClass().getName();
      _builder.append(_name);
      _builder.append("\'.");
      this.showError("Operation not Possible", _builder.toString());
      return;
    }
    final Function1<Type, Boolean> _function = new Function1<Type, Boolean>() {
      @Override
      public Boolean apply(final Type it) {
        return Boolean.valueOf(PrimitiveAttributePortHook.this._gUIExtension.operator_equals(it, type));
      }
    };
    boolean _exists = IterableExtensions.<Type>exists(this.getTypeHierarchy(it), _function);
    boolean _not_1 = (!_exists);
    if (_not_1) {
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("Inserting an attribute of type \'");
      String _elvis = null;
      String _name_1 = null;
      if (type!=null) {
        _name_1=type.getName();
      }
      if (_name_1 != null) {
        _elvis = _name_1;
      } else {
        _elvis = "null";
      }
      _builder_1.append(_elvis);
      _builder_1.append("\' into a sib for type \'");
      String _name_2 = type.getName();
      _builder_1.append(_name_2);
      _builder_1.append("\' is not allowed.");
      this.showError("Operation not Possible", _builder_1.toString());
      return;
    }
    final Function1<Input, String> _function_1 = new Function1<Input, String>() {
      @Override
      public String apply(final Input it) {
        return it.getName();
      }
    };
    boolean _contains = ListExtensions.<Input, String>map(it.getInputs(), _function_1).contains(attr.getName());
    if (_contains) {
      StringConcatenation _builder_2 = new StringConcatenation();
      _builder_2.append("The sib already contains an attribute with name \'");
      String _name_3 = attr.getName();
      _builder_2.append(_name_3);
      _builder_2.append("\'.");
      this.showError("Operation not Possible", _builder_2.toString());
      return;
    }
    PrimitiveInputPort _newPrimitiveInputPort = it.newPrimitiveInputPort(0, 0);
    final Procedure1<PrimitiveInputPort> _function_2 = new Procedure1<PrimitiveInputPort>() {
      @Override
      public void apply(final PrimitiveInputPort it) {
        it.setName(attr.getName());
        it.setDataType(PrimitiveAttributePortHook.this.toProcessPrimitive(attr.getDataType()));
        it.setIsList(attr.isIsList());
      }
    };
    ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_newPrimitiveInputPort, _function_2);
  }
}
