/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.hooks;

import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import info.scce.dime.data.data.Type;
import info.scce.dime.process.hooks.AbstractPostCreateSIBHook;
import info.scce.dime.process.process.IsOfTypeSIB;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class IsOfTypeSIBHook extends AbstractPostCreateSIBHook<IsOfTypeSIB> {
  @Extension
  private WorkbenchExtension _workbenchExtension = new WorkbenchExtension();
  
  @Override
  boolean initialize(final IsOfTypeSIB sib) {
    boolean _xblockexpression = false;
    {
      final Type checkedType = sib.getCheckedType();
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Is a ");
      String _name = checkedType.getName();
      _builder.append(_name);
      this.setLabel(_builder.toString());
      Type _xifexpression = null;
      int _size = IterableExtensions.size(this._dataExtension.getRootTypes(checkedType));
      boolean _equals = (_size == 1);
      if (_equals) {
        _xifexpression = IterableExtensions.<Type>head(this._dataExtension.getRootTypes(checkedType));
      } else {
        Type _xblockexpression_1 = null;
        {
          final List<Type> rootTypes = this._dataExtension.getRootTypes(checkedType).toList();
          final Function1<Type, String> _function = new Function1<Type, String>() {
            @Override
            public String apply(final Type it) {
              return it.getName();
            }
          };
          _xblockexpression_1 = rootTypes.get(
            this._workbenchExtension.showCustomQuestionDialog(
              "Please Choose", 
              "Choose a root type please...", 
              ((String[])Conversions.unwrapArray(ListExtensions.<Type, String>map(rootTypes, _function), String.class))));
        }
        _xifexpression = _xblockexpression_1;
      }
      final Type rootType = _xifexpression;
      this.addComplexInputPort("instance", rootType, false);
      this.addBranch("yes");
      this.addComplexOutputPort("casted", checkedType, false);
      this.addBranch("no");
      _xblockexpression = true;
    }
    return _xblockexpression;
  }
}
