/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.hooks;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.runtime.action.CincoCustomAction;
import info.scce.dime.data.data.EnumLiteral;
import info.scce.dime.process.build.EnumSwitchSIBBuild;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.EnumSwitchSIB;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class EnumSwitchResetBranches extends CincoCustomAction<EnumSwitchSIB> {
  @Override
  public void execute(final EnumSwitchSIB sib) {
    final Function1<Branch, Boolean> _function = new Function1<Branch, Boolean>() {
      @Override
      public Boolean apply(final Branch it) {
        String _name = it.getName();
        return Boolean.valueOf(Objects.equal(_name, "else"));
      }
    };
    IterableExtensions.<Branch>head(IterableExtensions.<Branch>filter(sib.getBranchSuccessors(), _function)).delete();
    final EnumSwitchSIBBuild eBuilder = new EnumSwitchSIBBuild(sib);
    ArrayList<String> missingBranches = this.findMissingBranches(sib);
    final Consumer<String> _function_1 = new Consumer<String>() {
      @Override
      public void accept(final String it) {
        eBuilder.addBranches(it);
      }
    };
    missingBranches.forEach(_function_1);
  }
  
  public ArrayList<String> findMissingBranches(final EnumSwitchSIB sib) {
    ArrayList<String> missingBranches = new ArrayList<String>();
    EList<EnumLiteral> _enumLiterals = sib.getSwitchedType().getEnumLiterals();
    for (final EnumLiteral literal : _enumLiterals) {
      final Function1<Branch, Boolean> _function = new Function1<Branch, Boolean>() {
        @Override
        public Boolean apply(final Branch it) {
          String _name = it.getName();
          String _name_1 = literal.getName();
          return Boolean.valueOf(Objects.equal(_name, _name_1));
        }
      };
      boolean _exists = IterableExtensions.<Branch>exists(sib.getBranchSuccessors(), _function);
      boolean _not = (!_exists);
      if (_not) {
        missingBranches.add(literal.getName());
      }
    }
    return missingBranches;
  }
  
  /**
   * Returns the name of the context menu entry
   */
  @Override
  public String getName() {
    return "Reset branches";
  }
}
