/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.hooks;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.runtime.hook.CincoPostDeleteHook;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.EnumSwitchSIB;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class EnumSwitchPostDelete extends CincoPostDeleteHook<EnumSwitchSIB> {
  @Override
  public Runnable getPostDeleteFunction(final EnumSwitchSIB sib) {
    final Function1<Branch, Boolean> _function = new Function1<Branch, Boolean>() {
      @Override
      public Boolean apply(final Branch it) {
        String _name = it.getName();
        return Boolean.valueOf(Objects.equal(_name, "else"));
      }
    };
    final Branch elseSib = IterableExtensions.<Branch>head(IterableExtensions.<Branch>filter(sib.getBranchSuccessors(), _function));
    final Runnable _function_1 = new Runnable() {
      @Override
      public void run() {
        if (elseSib!=null) {
          elseSib.delete();
        }
      }
    };
    return _function_1;
  }
}
