/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.hooks;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import graphmodel.Edge;
import graphmodel.Node;
import info.scce.dime.api.DIMEPostDeleteHook;
import info.scce.dime.data.data.ComplexAttribute;
import info.scce.dime.data.data.ExtensionAttribute;
import info.scce.dime.data.data.Type;
import info.scce.dime.process.helper.AttributeExpandUtils;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.ComplexVariable;
import info.scce.dime.process.process.DataContext;
import info.scce.dime.process.process.Input;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Deletes all expended attributes, which are complex variables connected
 * by complex (list) attribute connector edges in the data context
 * 
 * @author zweihoff
 */
@SuppressWarnings("all")
public class ComplexVariablePostDelete extends DIMEPostDeleteHook<ComplexVariable> {
  private final int OFFSET = 30;
  
  public void preDelete(final ComplexVariable cVar) {
    final EList<ComplexVariable> successors = cVar.getComplexVariableSuccessors();
    final Consumer<Edge> _function = new Consumer<Edge>() {
      @Override
      public void accept(final Edge it) {
        it.delete();
      }
    };
    cVar.getOutgoing().forEach(_function);
    final Consumer<ComplexVariable> _function_1 = new Consumer<ComplexVariable>() {
      @Override
      public void accept(final ComplexVariable it) {
        it.delete();
      }
    };
    successors.forEach(_function_1);
    final Function1<ComplexVariable, Boolean> _function_2 = new Function1<ComplexVariable, Boolean>() {
      @Override
      public Boolean apply(final ComplexVariable it) {
        return Boolean.valueOf(it.isExpanded());
      }
    };
    final Consumer<ComplexVariable> _function_3 = new Consumer<ComplexVariable>() {
      @Override
      public void accept(final ComplexVariable it) {
        final ComplexAttribute attr = ComplexVariablePostDelete.this.findComplexAttribute(it.getDataType(), cVar.getName());
        boolean _notEquals = ComplexVariablePostDelete.this._dIMEGraphModelExtension.operator_notEquals(attr, null);
        if (_notEquals) {
          it.newComplexAttribute(attr, 1, 1);
          AttributeExpandUtils.resizeAndLayout(it);
        } else {
          final ExtensionAttribute extAttr = ComplexVariablePostDelete.this.findExtensionAttribute(it.getDataType(), cVar.getName());
          boolean _notEquals_1 = ComplexVariablePostDelete.this._dIMEGraphModelExtension.operator_notEquals(extAttr, null);
          if (_notEquals_1) {
            info.scce.dime.process.process.Process _process = extAttr.getProcess();
            final info.scce.dime.process.process.Process process = ((info.scce.dime.process.process.Process) _process);
            Input _get = process.getEndSIBs().get(0).getInputs().get(0);
            if ((_get instanceof ComplexInputPort)) {
              it.newComplexExtensionAttribute(extAttr, 1, 1);
            } else {
              it.newPrimitiveExtensionAttribute(extAttr, 1, 1);
            }
            AttributeExpandUtils.resizeAndLayout(it);
          }
        }
      }
    };
    IterableExtensions.<ComplexVariable>filter(cVar.getComplexVariablePredecessors(), _function_2).forEach(_function_3);
  }
  
  public void layout(final DataContext dataContext) {
    int maxHeight = this.maxHeight(dataContext);
    dataContext.setHeight((maxHeight + this.OFFSET));
  }
  
  public int maxHeight(final DataContext context) {
    int maxLowerBound = 50;
    EList<? extends Node> _nodes = context.getNodes();
    for (final Node node : _nodes) {
      int _y = node.getY();
      int _height = node.getHeight();
      int _plus = (_y + _height);
      boolean _greaterThan = (_plus > maxLowerBound);
      if (_greaterThan) {
        int _y_1 = node.getY();
        int _height_1 = node.getHeight();
        int _plus_1 = (_y_1 + _height_1);
        maxLowerBound = _plus_1;
      }
    }
    return maxLowerBound;
  }
  
  public ComplexAttribute findComplexAttribute(final Type it, final String attrName) {
    final Function1<ComplexAttribute, Boolean> _function = new Function1<ComplexAttribute, Boolean>() {
      @Override
      public Boolean apply(final ComplexAttribute it) {
        String _name = it.getName();
        return Boolean.valueOf(Objects.equal(_name, attrName));
      }
    };
    return IterableExtensions.<ComplexAttribute>findFirst(Iterables.<ComplexAttribute>filter(this._dataExtension.getInheritedAttributes(it), ComplexAttribute.class), _function);
  }
  
  public ExtensionAttribute findExtensionAttribute(final Type it, final String attrName) {
    final Function1<ExtensionAttribute, Boolean> _function = new Function1<ExtensionAttribute, Boolean>() {
      @Override
      public Boolean apply(final ExtensionAttribute it) {
        String _name = it.getName();
        return Boolean.valueOf(Objects.equal(_name, attrName));
      }
    };
    return IterableExtensions.<ExtensionAttribute>findFirst(Iterables.<ExtensionAttribute>filter(this._dataExtension.getInheritedAttributes(it), ExtensionAttribute.class), _function);
  }
  
  @Override
  public Runnable getPostDeleteFunction(final ComplexVariable node) {
    this.preDelete(node);
    DataContext _container = node.getContainer();
    if ((_container instanceof DataContext)) {
      DataContext _container_1 = node.getContainer();
      final DataContext dataContext = ((DataContext) _container_1);
      final Runnable _function = new Runnable() {
        @Override
        public void run() {
          ComplexVariablePostDelete.this.layout(dataContext);
        }
      };
      return _function;
    }
    return null;
  }
}
